<?php
// build the pages that will be used by the widget MediaTabView to display the list of media that can be used as a source for building the playlist.
$pages = array( ); 
if (!isset($sources) )
    $sources = array();
foreach ($sources as $name2 => $content ) {
    if ( !($content===false) && count($content)>0 ) {
		$title=$desc=array();
        $title[] = Yii::t('app', "Tip Add Media");
        $desc[] = CHtml::encode( Yii::t('app', "Drag and drop Media items to the left window or click the Add icon to insert at the end of the list.") );
		$widget_content = $this->widget('MediaSelect',array('data' => $content, 'title'=>$title , 'desc'=>$desc ), true );
        $pages[$name2] =array( 'content' => $widget_content );                    
    }
}


$scheduling=true;
if ( !$options['validity'] && !$options['visible'] && !$options['dates'] )
    $scheduling=false;
 

echo CHtml::openTag("table", array('class'=>'edit') );
echo CHtml::openTag("tr", array('class'=>'edit_row') );

// The playlist zone

echo CHtml::openTag("td", array( "class"=>"edit_section media_view" ) );
LayoutHelper::openBorders();
echo CHtml::openTag("div", array( "class"=>"edit_section_inside", "id"=>"EditSection" ) );

if ($options['save'] ){
    if ( $scheduling ) {
        echo CHtml::button(   Yii::t('app',"Scheduling"),
                                            array('class'=>'simple_tabs top-button button need_item',
                                                  'onclick'=>'showSchedule()',
                                                  'title'=>Yii::t('app',"Scheduling"),
                                                  'alt'=>Yii::t('app',"Scheduling"),
                                                  )
                                        );
    } else if ( $options['settings'] ) {
        echo CHtml::button(   Yii::t('app',"Settings"),
                                            array('class'=>'simple_tabs top-button button need_item',
                                                  'onclick'=>'showSettings()',
                                                  'title'=>Yii::t('app',"Settings"),
                                                  'alt'=>Yii::t('app',"Settings") )
                                        );
    }
	echo CHtml::button(   Yii::t('app',"Apply"),
                                            array('class'=>'advanced_tabs top-button button',
                                                  'onclick'=>'showMedia()',
                                                  'title'=>Yii::t('app',"Back"),
                                                  'alt'=>Yii::t('app',"Back")
                                                  )
                                        );
}
$new_playlist = false;
$hasItem = count($playlistInfo->playlist)!=0;
if ( $playlistInfo->name=="" || $playlistInfo->getError('name')){
    $i =1;
    do {
        if ( $playlistInfo->type=='playlist' )
            $playlistInfo->name = Yii::t('app',"New Playlist ").$i;
        else
            $playlistInfo->name = Yii::t('app',"New Program ").$i;
        $i++;
    } while ( $playlistInfo->exist() );
    
    $new_playlist = true;
}

echo CHtml::form( "", "post", array('id'=>'main_form'))."\n";

if ( $options['settings'] ) {
    echo CHtml::openTag("div", array( "class"=>"settings" ) );
    
	echo CHtml::tag("h1", array(), 
        CHtml::tag("span", array('class'=>''), Yii::t('app',"Playlist Settings"))
    );
	
	echo CHtml::openTag("div", array( "class"=>"settings_header" ) );
	echo CHtml::tag("div", array( "class"=>"name" ), " " );
	echo CHtml::tag("span", array( "class"=>"inter" ), $playlistInfo->getAttributeLabel('interDur') );
	echo CHtml::tag("span", array( "class"=>"dur" ), $playlistInfo->getAttributeLabel('animDur') );
	echo CHtml::tag("span", array( "class"=>"type" ), $playlistInfo->getAttributeLabel('animPrefix') );
	echo CHtml::closeTag("div")."\n";
	
	echo CHtml::openTag("div", array( "class"=>"settings_content" ) );
	echo CHtml::tag("div", array( "class"=>"name" ), CHtml::tag("h2", array( ), Yii::t('app',"Transitions")) );
	echo CHtml::tag("span", array( "class"=>"inter" ), CHtml::activeTextField($playlistInfo,'interDur', array("class"=>"duration" )) );
	echo CHtml::tag("span", array( "class"=>"dur" ), CHtml::activeTextField($playlistInfo,'animDur', array("class"=>"duration" ) ) );
	echo CHtml::tag("span", array( "class"=>"type" ), CHtml::activeDropDownList($playlistInfo,'animPrefix', 
																							array(	"none"=>Yii::t('app',"No Transitions"), 
																									"fade"=>Yii::t('app',"Fade"), 
                                                                                                    "crossFade"=>Yii::t('app',"Crossfade"),
																									"slide"=>Yii::t('app',"Slide"), 
                                                                                                    "push"=>Yii::t('app',"Push"), 
																									"wipeBar"=>Yii::t('app',"Wipe"), 
                                                                                                    "cubeFace"=>Yii::t('app',"Cube"),
                                                                                                    "page"=>Yii::t('app',"Page"),
                                                                                                    "flip"=>Yii::t('app',"Flip"),
                                                                                                    "zoom"=>Yii::t('app',"Zoom"),
																									"random"=>Yii::t('app',"Random") 
																								),
																							array('class'=>'prefix')
																				) .
													  CHtml::activeDropDownList($playlistInfo,'animDir', 
																							array(	"left"=>Yii::t('app',"Right to Left"), 
																									"right"=>Yii::t('app',"Left to Right"), 
																									"top"=>Yii::t('app',"Bottom to Top"), 
																									"bottom"=>Yii::t('app',"Top to Bottom"),
																									"random"=>Yii::t('app',"Random") 
																								),
																							array('class'=>'dir')
																				)
					);	
	echo CHtml::closeTag("div")."\n";
	
    
	echo CHtml::openTag("div", array( "class"=>"settings_header" ) );
	echo CHtml::tag("div", array( "class"=>"name" ), " " );
	echo CHtml::tag("span", array( "class"=>"inter" ), $playlistInfo->getAttributeLabel('shuffle') );
	echo CHtml::tag("span", array( "class"=>"dur" ), $playlistInfo->getAttributeLabel('mediaFit') );
	echo CHtml::tag("span", array( "class"=>"type" ), $playlistInfo->getAttributeLabel('proofofplay') );
	echo CHtml::closeTag("div")."\n";
	
	echo CHtml::openTag("div", array( "class"=>"settings_content" ) );
	echo CHtml::tag("div", array( "class"=>"name" ), CHtml::tag("h2", array( ), Yii::t('app',"Options")) );
	echo CHtml::tag("span", array( "class"=>"inter" ), CHtml::activeDropDownList($playlistInfo,'shuffle', 
																							array(	"off"=>Yii::t('app',"Disabled"),
																									"on"=>Yii::t('app',"Enabled")
																								)																							
																				)
					);	
	echo CHtml::tag("span", array( "class"=>"dur" ), CHtml::activeDropDownList($playlistInfo,'mediaFit', 
																							array(	"meet"=>Yii::t('app',"Keep Aspect Ratio"), 
																									"slice"=>Yii::t('app',"Cut Media"),
																									"fill"=>Yii::t('app',"Zoom Media")
																								)																							
																				)
					);	
	echo CHtml::tag("span", array( "class"=>"type" ), CHtml::activeDropDownList($playlistInfo,'proofofplay', 
																							array(	"off"=>Yii::t('app',"Disabled"),
																									"on"=>Yii::t('app',"Enabled"), 
																								)																							
																				)
					);	
	echo CHtml::closeTag("div")."\n";
	
	
    echo CHtml::closeTag("div")."\n";
}


echo CHtml::openTag("div", array('class'=>'edit_playlist') );

if ($new_playlist){
    if ( $playlistInfo->type=='playlist' )
        $t = Yii::t('app',"New Playlist");
    else
        $t = Yii::t('app',"New Program");
    $names = explode(" ", $t, 2);
    if (count($names)==1 )
        echo CHtml::tag("h1", array(), CHtml::tag("span", array('class'=>''), str_replace("_"," ",$names[0])) );
    else
        echo CHtml::tag("h1", array(), CHtml::tag("span", array('class'=>''), str_replace("_"," ",$names[0])) ." ". CHtml::tag("span", array('class'=>'blue'), $names[1]) );
}else
    echo CHtml::tag("h1", array(), 
            CHtml::tag("span", array('class'=>''), $name." ") . 
            CHtml::tag("span", array('class'=>'blue'), $playlistInfo->name )       
    );
echo CHtml::openTag("div", array('class'=>'edit_header') );
if ( $scheduling )	{
	if ( count($playlistInfo->playlist)>0)
		$item = $playlistInfo->playlist[0];
	else
		$item = new PlaylistItem;
	echo Chtml::tag("span", array('class'=>'head_duration advanced_tabs'), $item->getAttributeLabel('dur'));
	echo Chtml::tag("span", array('class'=>'head_date advanced_tabs'), $item->getAttributeLabel('validity'));
	echo Chtml::tag("span", array('class'=>'head_time advanced_tabs'), $item->getAttributeLabel('time'));
	echo Chtml::tag("span", array('class'=>'head_days advanced_tabs'), $item->getAttributeLabel('validDates'));
}
echo CHtml::closeTag("div" ); //edit_header

echo CHtml::errorSummary( array_merge( array( $playlistInfo), $playlistInfo->playlist ) );

//echo CHtml::closeTag("div")."\n";

echo CHtml::openTag("table", array( 'class'=>"playlist", 'id'=>"sortable_".$this->id ));
if( $new_playlist ) {
	echo CHtml::openTag("tr", array('class'=>'no_item'));
	echo CHtml::openTag("td", array('colspan'=>'3'));
	$this->widget('application.components.Tip',array(   'title' => Yii::t('app', "Tip Getting Started"),
                                                         'desc' =>  CHtml::encode( Yii::t('app', "Add media from the list on the right using drag and drop or click the Add icon next to the media you want to add.") )
                                                ) );
	echo CHtml::closeTag("td");
	echo CHtml::closeTag("tr");
}
echo CHtml::closeTag("table");

if ( $options['duration'] && $options['save']) {
    echo CHtml::activeLabel($playlistInfo, 'defaultItemDur', array( "class"=>"duration default", ));
    echo CHtml::activeTextField($playlistInfo,'defaultItemDur', array(  "class"=>"duration default", 
                                                                        'id'=>'default_duration_id', 
                                                                        'title'=>$playlistInfo->getAttributeLabel('defaultItemDur') 
                                                                    )
                                ); 
}


echo CHtml::script($script)."\n";



echo CHtml::openTag("div", array('class'=>"edit_footer") );
    if ( $options['save'] ) {
        echo CHtml::openTag("div", array('class'=>"bottom-button") );
        echo CHtml::submitButton(Yii::t('app','Cancel'), array( "submit"=>"", 
                                                                "params"=>array("action"=>"Cancel"),
                                                                "class"=>"left-button button",
                                                                'title'=>Yii::t('app',"Cancel"),
                                                                'alt'=>Yii::t('app',"Cancel")
                                                            )
                                )." ";
                                
        if ( $new_playlist )
            echo CHtml::button(Yii::t('app', 'Save'), array(    "class"=>  "right-button button need_item save",
                                                        "onclick"=>"activateDialog()",
                                                            'title'=>Yii::t('app',"Save"),
                                                            'alt'=>Yii::t('app',"Save")
                                                    )
                                )." "; 
        else
            echo CHtml::submitButton(Yii::t('app', 'Save'), array("submit"=>"", 
                                                            "params"=>array("action"=>"Save"),
                                                            "class"=>"right-button button save",
                                                            'title'=>Yii::t('app',"Save"),
                                                            'alt'=>Yii::t('app',"Save")
                                                            )
                                    )." "; 
        
        echo CHtml::closeTag("div") ."\n"; //button_line
    

        if ( !$new_playlist && $options['saveas'] ) {
            echo CHtml::openTag("div", array('class'=>"bottom-button") );
            
            echo CHtml::button(Yii::t('app', 'Copy'), array(    "class"=>  "right-button button",
                                                            "onclick"=>"activateDialog()",
                                                            'title'=>Yii::t('app',"Copy"),
                                                            'alt'=>Yii::t('app',"Copy")
                                                        )
                                    )." "; 
            echo CHtml::closeTag("div") ."\n"; //button_line
        }    
    }
    if ( !$new_playlist)
        echo CHtml::activeHiddenField($playlistInfo,"id", array('class'=>'playlist-id'));

    echo CHtml::activeHiddenField( $playlistInfo, 'name', array('id'=>'new_name_target') );
    if ($new_playlist){
        echo CHtml::hiddenField("action","Create", array('disabled'=>'disabled', 'id'=>'new_name_enabled'));
    }else{
        echo CHtml::hiddenField("action","SaveAs", array('disabled'=>'disabled', 'id'=>'new_name_enabled'));
    }
echo CHtml::closeTag("div") ."\n"; //edit_footer

echo CHtml::closeTag("div") ."\n"; //edit_playlist

echo CHtml::closeTag("form");

echo CHtml::openTag("div", array( 'class'=>'need_item' ) );

$title=$title_s=$title_set=array();
$desc=$desc_s=$desc_set=array();

if ( $scheduling ){
    $title[] =  Yii::t('app', "Tip Scheduling");
    $desc[] =   CHtml::encode( Yii::t('app', "Scheduling lets you set validity period for each media item.") ) ."<br/>".
                CHtml::encode( Yii::t('app', "Use the Scheduling button at the top to set up the display rules.") );
} else {
    $title[] =  Yii::t('app', "Tip Transition Settings");
    $desc[] =   CHtml::encode( Yii::t('app', "The Settings button lets you control transition effects between media items.") );
}
                                                                
$title_s[]=$title[] =  Yii::t('app', "Tip Duration");
$desc_s[] =$desc[] =   CHtml::encode( Yii::t('app', "You can set the display duration of each media item.") ) ."<br/>".
            CHtml::encode( Yii::t('app', "If set to automatic, the duration of the media item will be used.") );


if (isset($options['hasslides']) && $options['hasslides']){
    $title_s[]=$title[] =  Yii::t('app', "Tip Slides Duration");
    $desc_s[] =$desc[] =CHtml::encode( Yii::t('app', "The duration of the slide depends on its content. For images it is equal to the default duration, otherwise it is equal to the duration of the media it contains.") );
}       

$title_s[]=$title[] = Yii::t('app', "Icon Description");
$d =  "";  
$d .= CHtml::image('images/x.gif', Yii::t('app','Delete'), array('class'=>'icon-desc') ) . " " .Yii::t('app','Delete'). " ";
$d .= CHtml::image('images/up.gif', Yii::t('app','Up'), array('class'=>'icon-desc') ) . " " .Yii::t('app','Up'). " ";
$d .= CHtml::image('images/down.gif', Yii::t('app','Down'), array('class'=>'icon-desc') ) . " " .Yii::t('app','Down'). " ";
$desc_s[] = $d;
$d .= CHtml::image('images/left.gif', Yii::t('app','Add'), array('class'=>'icon-desc') ) . " " .Yii::t('app','Add'). " ";
$d .= CHtml::image('images/view.gif', Yii::t('app','View'), array('class'=>'icon-desc') ) . " " .Yii::t('app','View'). " ";
$desc[] = $d;

$title_s[] =$title[] =  Yii::t('app', "Tip Media Order");
$desc_s[] = $desc[] =   CHtml::encode( Yii::t('app', "To change the media item display order, drag and drop the items up and down, or use the Up or Down icons.") ) ;
            
if ( $scheduling ){
    $title_s[]= Yii::t('app', "Tip Dates");
    $desc_s[] = CHtml::encode( Yii::t('app', "The Dates control the starting and ending dates at which media may be displayed.") ) ."<br/>".
                CHtml::encode( Yii::t('app', "Media will not be shown before the starting date, and will no longer be shown after the ending date.") );
                
    $title_s[]= Yii::t('app', "Tip Times");
    $desc_s[] = CHtml::encode( Yii::t('app', "The Times control when media may be displayed each day.") ) ."<br/>".
                CHtml::encode( Yii::t('app', "Media will not be shown before the starting time, and will no longer be shown after the ending time. Use the format HH:MM:SS in 24h.") );
                
    $title_s[]= Yii::t('app', "Tip Days");
    $desc_s[] = CHtml::encode( Yii::t('app', "The Days control the days of the week on which media may be displayed.") ) ."<br/>".
                CHtml::encode( Yii::t('app', "Media will not be shown on grayed days.") );
} else {
    $title_set[]= Yii::t('app', "Tip Intermediate Duration");
    $desc_set[] = CHtml::encode( Yii::t('app', "This setting lets you control the time between two media items in the playlist.") ) ;

    $title_set[]= Yii::t('app', "Tip Duration");
    $desc_set[] = CHtml::encode( Yii::t('app', "This setting lets you control the duration of the effect used to switch between media items.") )."<br/>".
                  CHtml::encode( Yii::t('app', "Note that a transition type different to None must be selected for this parameter to be used.") );

    $title_set[]= Yii::t('app', "Tip Type");
    $desc_set[] = CHtml::encode( Yii::t('app', "This setting lets you control the type of effect used to switch between media items.") );

}
echo CHtml::openTag("div", array( 'class'=>'simple_tabs') );
$this->widget('application.components.Tip',array(   'title' => $title, 'desc' =>  $desc  ) );                                                    
echo CHtml::closeTag("div");                                            

echo CHtml::openTag("div", array( 'class'=>'advanced_tabs' ) );
if ( $scheduling )
    $this->widget('application.components.Tip',array(   'title' => $title_s, 'desc' =>  $desc_s  ) );
else
    $this->widget('application.components.Tip',array(   'title' => $title_set, 'desc' =>  $desc_set  ) );
echo CHtml::closeTag("div");                                            

echo CHtml::closeTag("div");

echo CHtml::closeTag("div")."\n"; //edit_section_inside
LayoutHelper::closeBorders();

// the dialog for edit
if ( $options['save']  && $options['saveas'] ) {
    if ( $new_playlist ){
        $bname = Yii::t('app', 'Save');
        $tname2 = Yii::t('app', 'Please choose a name');
    }else{
        $bname = Yii::t('app', 'Copy');
        $tname2 = Yii::t('app', 'Create a copy');
    }
    echo CHtml::openTag("div", array(   'id'=>"copy_dialog", 
                                        'title'=>$tname2,
                                        'class'=>'hidden'
                                    )
                        );
    
    LayoutHelper::openBorders();
    echo CHtml::openTag("div", array('class'=>'dialog_inside') );
    if ( $new_playlist  ){
        if ( $playlistInfo->type=='playlist' )
            $t = Yii::t('app',"New Playlist");
        else
            $t = Yii::t('app',"New Program");
        echo CHtml::tag("h1", array(), $t); 
    }else
        echo CHtml::tag("h1", array(), Yii::t('app', 'Copy'). " ".$name); 
    echo CHtml::activeTextField( $playlistInfo, 'name', array('id'=>'new_name_dialog') );
    
    echo CHtml::openTag("div", array('class'=>'bottom-button') );
    echo CHtml::button(Yii::t('app','Cancel'), array(   "class"=>"left-button",
                                                        "onclick"=>"cancelDialog()"
                                                        )
                            )." ";
    echo CHtml::button($bname, array ("class"=>"save right-button",
                                                     "onclick"=>"saveDialog()"
                                                        )
                            )." "; 
    echo CHtml::closeTag("div");
    echo CHtml::closeTag("div");
    LayoutHelper::closeBorders();
	
    
    echo CHtml::closeTag("div");
}




echo CHtml::closeTag("td")."\n"; //edit_section

// The media files
echo CHtml::openTag("td", array(   "class"=>"media_files",
                                )
                    );

if ( count($pages)==0 && $options['save'] ) {
    LayoutHelper::openBorders();
    echo CHtml::openTag("div", array( "class"=>"edit_section_inside" ) );
    if ( !Yii::app()->user->checkAccess("file") ) {
        $this->widget('application.components.Tip',array(   'title' => Yii::t('app', "Tip No Media"),
                                                            'desc' =>   Yii::t('app', "There is currently no Media available.") .
                                                                        "<br/>" .
                                                                        Yii::t('app', "Login as a user with 'Creator' rights to upload Media into the system.")
                                                ) );
    } else {
        $this->widget('application.components.Tip',array(   'title' => Yii::t('app', "Tip No Media"),
                                                            'desc' =>   Yii::t('app', "There is currently no Media available.") .
                                                                        "<br/>" .
                                                                        Yii::t('app', "Go to the Media page to upload new Media files")
                                                ) );
    }
    echo CHtml::closeTag("td"); //"class"=>"edit_section_inside",
    LayoutHelper::closeBorders();
} else 
    $this->widget('CJuiTabsExt',array(
                                    'theme'=>'spxfusion',
                                    'tabs' => $pages,
                                    'id'=>'MediaFiles'
                                    )
                );
echo CHtml::closeTag("td"); //"class"=>"media_files",

echo CHtml::closeTag("tr" ); //edit
echo CHtml::closeTag("table" ); //edit
   
if ( $options['save'] ) {
    echo CHtml::script("$(function() {  showMedia(); });");
} else {
    if ( $scheduling )
        echo CHtml::script("$(function() {  showSchedule(); });");
    else
        echo CHtml::script("$(function() {  showMedia(); });"); //FIXME
}
?>
<script type="text/javascript">
/*<![CDATA[*/
	function showSchedule() {
        $(".simple_tabs").hide();
        $(".media_files").hide();
        $(".edit_section").removeClass("media_view").addClass('schedule_view');
        $(".advanced_tabs").show();
        
        
		$("#EditSection").height("auto");
	}
	function showMedia() {
        $(".simple_tabs").show();
        $(".media_files").show();
		$(".edit_playlist").show();
        $(".edit_section").removeClass("schedule_view").addClass('media_view');
        $(".advanced_tabs").hide();
		$(".settings").hide();
		fixHeights();
	}
	function showSettings() {
        $(".simple_tabs").hide();
        $(".media_files").hide();
        $(".edit_playlist").hide();
		$(".edit_section").removeClass("media_view").addClass('schedule_view');
		$(".advanced_tabs").show();
        $(".settings").show();
        
        $("#EditSection").height("auto");
        
	}
/*]]>*/
</script>    
<?php
if ( $options['save'] ) {
 
?>


<script type="text/javascript">
/*<![CDATA[*/
	var hasChange;
    window.onbeforeunload = popup;
    $('input[type=submit]').click( function() {
        hasChange = false;
    });
    function popup() {
        if ( hasChange ) {
            return "<?php echo Yii::t('app',"Some changes have not been saved."); ?>";
        }
    }
    function hasErrors() {
        alert("<?php echo Yii::t('app',"Please fix the errors before saving your changes"); ?>");
        return false;
    }
    function activateDialog() {
        //$('#copy_dialog').dialog('open');
        tb_show("Save", "#TB_inline?height=300&width=472&inlineId=copy_dialog");
    }
    function saveDialog() {
        $('#new_name_target').val( $('#new_name_dialog').val() );
        //$('#copy_dialog').dialog('close');
        tb_remove();
        if ( $('#new_name_dialog').val()=="" )
            return;
        $('#new_name_enabled').removeAttr('disabled');
        hasChange = false;
        $('#main_form').submit();
    }
    function cancelDialog() {
        tb_remove();
        //$('#copy_dialog').dialog('close');
    }
    var hasChange = false;
    
    function setChanges( val ) {
        if ( val && !hasChange ) {
            hasChange = true;
            var apply = $('#apply_button');
            if ( apply ) {
                apply.removeAttr('disabled');
            }
        } else if ( !val && hasChange ) {
            hasChange = false;
            var apply = $('#apply_button');
            if ( apply ) {
                apply.attr('disabled','disabled');
            }
        }
    }
    var nbErrors = 0;
    $(function() {
		$(".draggable").draggable({
            connectToSortable: '#sortable_<?php echo $this->id; ?>',
            cursor: "move",
            cursorAt: { top:8, left: 10 }, 
            helper: function( event, ui ) {
                        var meta = $(".meta-data", $(this)).text();
                        var data = meta.split(';');
                        //$(".slide_edit_section").append("<div class='ui-widget-header' id='marker' style='z-index:1000' >"+data[1]+"<\/div>" );
                        $(".edit_section").append("<div id='marker' style='z-index:1000;' ><div class='preview_normal drag'> <img class='preview_normal'  src='"+data[3]+"' /><\/div><\/div>" );
                        return $( "#marker" );
                    }, 
                    
            revert: 'invalid',
            start: function(event, ui) { $('.add_icon',ui.helper).hide(); }
            //stop: function(event, ui) { $('.add_icon').show(); }
		});

	
		$("#sortable_<?php echo $this->id; ?>").sortable({
            items: '.playlist_item',
            //axis: 'y',
            //revert: true, 
            stop: function(event, ui) { 
                // get meta data
                var meta = ui.item.children('.meta-data')
                if ( meta.length ) {
                    var txt = meta.text();
                    var data = txt.split(';');
                    
                    var table = $("#sortable_<?php echo $this->id; ?>");
                    var inpos = $('li', table);
                    
                    var idx = getIdx(inpos.prev());
                        
                    inpos.remove();
                    var item = new playlistItem( data[0], data[1], data[2], data[3], "", "", "", "", "", "1111111" );
                    if ( idx==-1 )
                        playlist_<?php echo $this->id; ?>.unshift(item)
                    else                
                        playlist_<?php echo $this->id; ?>.splice(idx, 0, item)
                    var row = addRow( item, idx+1, table );
                    
                    fixDefaultDuration(row);
                    
                }
                fixTable( table ); 
                fixHeights();
                hasChange = true;
            }, 
            receive: function(event, ui) { 
            } 
       });
        
        fixDefaultDuration( $('#sortable_<?php echo $this->id; ?>') );
        
		
		function showDirection() {
			$(".prefix option:selected").each( function() {
				if ($(this).val()=='slide' || $(this).val()=='push' || $(this).val()=='wipeBar' || $(this).val()=='cubeFace' )
					$(".dir").show();
				else
					$(".dir").hide();
			});
		}
		showDirection();
		$(".prefix").change( showDirection );
		
		$( "#MediaFiles" ).bind( "tabsshow", function(event, ui) {
		  fixHeights();
		});
		if ( <?php echo $hasItem?"0":"1"; ?>) {
			$('.need_item').hide();
		}
        $("#default_duration_id").blur( function() { fixDefaultDuration( $('#sortable_<?php echo $this->id; ?>') ); } );
	});
    
/*]]>*/
</script>
<?php
}
?>