<?php

include "SettingsController.php";

class BackupController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='view';
   
    public function filters()
    {
        return array(
            'accessControl',
        );
    }
    public function accessRules()
    {
        return array(
            array('allow',
                'actions'=>array(),
                'users'=>Yii::app()->user->addAllUsers(),
            ),
            array('allow',
                'actions'=>array('view', 'create', 'restore', 'upload', 'delete' ),
                'users'=> Yii::app()->user->addUserByRoles('admin'),
            ),
            array('deny'),

        );
    }

    
    public function actionCreate()
	{
        $file = new SystemBackup;
        if( isset( $_POST['SystemBackup'] ) ) {
            $file->scenario = "create";
            $file->attributes = $_POST['SystemBackup'];
            if ( $file->validate() ) {
                $file->createBackup();
                $file = new SystemBackup;
            } 
        } 
        $this->view( $file, true );
    }
    public function actionRestore()
	{
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
        if ( isset($_GET['id']) ) {
            $file = new SystemBackup( $_GET );
            
            if ( !$file->restoreBackup( ) ) {
                SettingsController::renderSettings( $this, 'backups', $file );
                return;
            }
            // Logout the current user, are we cannot be sure that he will still exist now that
            // we have restored a backup that have contain new users with new settings.
            Yii::app()->user->logout();
            $this->redirect( array("/users") );
        } 
        throw new CHttpException(500, Yii::t('app','No backup selected.') );
    }
    public function actionUpload()
	{
		
		$ajax = isset( $_POST['ajax'] ) || isset( $_GET['ajax'] ) || Yii::app()->request->isAjaxRequest;
		
        $file = new SystemBackup;
		if (isset($_GET['qqfile'])) {
            $file->file = new qqUploadedFileXhr();
        } elseif (isset($_FILES['qqfile'])) {
            $file->file = new qqUploadedFileForm();
        }
        if( $file->file!=null ) {
            $file->scenario = "backup";
            if ($file->validate() ) {
                $file->save();
				$reply['success'] = true;
				
				echo json_encode($reply);
                return;
            } else {
				if ( $ajax ){
					$reply['errors'] = Yii::t('app','Backup upload failed.' );
					echo json_encode($reply);
				} else
					throw new CHttpException(500, Yii::t('app','Backup upload failed.' ) );
            }            
        }
		if ( $ajax ){
			$reply['errors'] = Yii::t('app','No backup uploaded.' );
			 echo json_encode($reply);
		} else
			throw new CHttpException(500, Yii::t('app','No backup uploaded.') );
    }
    protected function view( $file, $update=false ) {
        $crit = new CDbCriteria;
        $crit->condition = "type=backup";
        $backups = FileItem::findAll($crit);
        if (Yii::app()->request->isAjaxRequest )
			$this->renderPartial('view', array( "file"=>$file, "backups"=>$backups, "update"=>$update ) );
		else
			$this->render('view', array( "file"=>$file, "backups"=>$backups) );
    }
    
    public function actionView()
	{
        $file = new SystemBackup;
        return $this->view( $file );
        
    }
    
    public function actionDelete()
	{
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
   		if ( isset($_GET['id']) ) {
            $file = new FileItem( $_GET );
            if ( !$file->delete() )
                throw new CHttpException(500, Yii::t('app','The requested backup does not exist or cannot be deleted.') );
            $this->redirect(Yii::app()->user->returnUrl);
        }
        
        throw new CHttpException(500, Yii::t('app','No backup selected.') );
        
        
	}
    
}