<?php




class FilesController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='list';
    
    public function filters()
    {
        return array(
            'accessControl',
        );
    }
    public function accessRules()
    {
        return array(
            array('allow',
                'actions'=>array('list', 'media'),
                'users'=>Yii::app()->user->addAllUsers(),
            ),
            array('allow',
                'actions'=>array('upload', 'delete'),
                'users'=> Yii::app()->user->addUserByRoles('file'),
            ),
            array('allow',
                'actions'=>array('upload', 'delete'),
                'users'=> Yii::app()->user->addUserByRoles('template'),
            ),
            
            array('deny'),
        );
    }
    
	public function actionList()
	{
        $this->render('list');
	}

    public function actionMedia( $type = false) {
        
        if ( $type===false ) $type = Yii::app()->request->getParam("type", false); 
        if ( $type==false ) throw new CHttpException(500, Yii::t('app', 'No type defined.'));
        $crit = new CDbCriteria;
        $crit->condition = "type=$type";
        $media = FileItem::findAll($crit);
        
		$meta = FileItem::getMeta();
		if ( count($media)>0 )
			$meta[$type] = count($media);
		else
			$meta[$type] = false;
		FileItem::putMeta( $meta );
		
        $title=array();
        $desc=array();
        if ( $type=='template' ) {
            if ( count($media)==0 && !Yii::app()->user->checkAccess("model") ) {
                $title[] = Yii::t('app', "Tip No Templates");
                $desc[]  = Yii::t('app', "There are currently no Templates in the system.") .
                        "<br/>" .
                        Yii::t('app', "Login as a user with 'Administrator' rights to upload Templates into the system.");
            }
            if ( Yii::app()->user->checkAccess("model") ) {
                $title[] = Yii::t('app', "Tip Upload Templates");
                $desc[]  = Yii::t('app', "Templates are needed to create Slides. They are the base for creating customizable scenes to be integrated into Programs.") .
                        "<br/>" .
                        Yii::t('app', "To upload new Templates, click on the Add button. Then select the 7-Zip file containing the Templates.");
            } 
            if ( count($media)>0 ) {
                $title[] = Yii::t('app', "Tip Create Slides");
                $desc[]  = Yii::t('app', "You can use Templates to create Slides using the Slides menu.");
            }
            $title[] =  Yii::t('app', "Tip Extend Fusion");
            $desc[] =   Yii::t('app', "More Templates (Slides) are available on {link}", array( "{link}"=>"<a href='http://spinetix.com/go/fusion/templates' target='_blank'>spinetix.com/go/fusion/templates</a>" ) );
        }
        $str = array ('image'=> Yii::t('app', "Tip No Images"), 'video'=> Yii::t('app', "Tip No Videos"), 'audio'=> Yii::t('app', "Tip No Audio"), 'project'=> Yii::t('app', "Tip No Hypermedia") );
        if ( isset($str[$type]) ) {
            $name = $str[$type];
            if ( count($media)==0 && !Yii::app()->user->checkAccess("file") ){
                $title[] = $name;
                $desc[]  =  Yii::t('app', "There are currently no files of this type available.") . "<br/>" .
                            Yii::t('app', "Login as a user with 'Creator' rights to upload Media into the system.");
            } else {
                if ( Yii::app()->user->checkAccess("file") ) {
                    if ($type=='video') {
                        $title[] = Yii::t('app', "Tip Video Thumbnail");
                        $desc2 = Yii::t('app', "To add a thumbnail for Video files, upload a 7-Zip file containing the video and a thumbnail.");
                        $desc2 .= "<br/>";
                        $desc2 .= Yii::t('app', "If the Video is called 'video.avi' the thumbnail must be called '.preview.video.avi.png'.");
                        $desc[] = $desc2; 
                    } else {
                        $title[] = Yii::t('app', "Tip Upload Media");
                        $desc2  = Yii::t('app', "To upload media files, click the Add button.") . "<br/>";
                        if ($type=='project') 
                            $desc2 .= Yii::t('app', "To upload a Hypermedia project, create a 7-Zip file with the content of your project.");
                        else
                            $desc2 .= Yii::t('app', "You can upload individual files, or a 7-Zip file containing multiple media files.");
                        $desc[] = $desc2;
                    }
                } 
                $title[] =Yii::t('app', "Icon Description");
                $d =  "";  
                if ( Yii::app()->user->checkAccess("file") )
                    $d .= " ". CHtml::image('images/x.gif', Yii::t('app','Delete'), array('class'=>'icon-desc') ) . " " .Yii::t('app','Delete'). " ";
                if ( $type!='project' )
                    $d .= CHtml::image('images/view.gif', Yii::t('app','View'), array('class'=>'icon-desc')) ." ". Yii::t('app','View'). " ";    
                $desc[] = $d;                
            }
        }
        if ( Yii::app()->user->checkAccess("program") && $type!='template' ) {
            if ( !$meta['program']  ) {
                $title[] = Yii::t('app','Tip Create Programs' );
                $desc[] = Yii::t('app','You need to create Programs to display your media.' ). "<br/>".
                          Yii::t('app', "Go to Programs menu to create and activate Programs.");
            } else {                          
                $title[] =  Yii::t('app', "Tip Display Media");
                $desc[] =   CHtml::encode( Yii::t('app', "Remenber to add the media to Programs, Playlists or Slides to display them on the screen.") );
            }
        }
        
        if ( $type=='template' && Yii::app()->user->checkAccess("model") )
            $atype ='del';
        else if ( Yii::app()->user->checkAccess("file") )
            $atype ='del';
        else
            $atype ='none';
		$this->widget('MediaSelect',array( 	'type' => $atype,
											'data' => $media,
                                            'title'=>$title,
                                            'desc'=>$desc) );
    }
	
    
    protected function upload( $scenario ) {
        // Adding jQuery to the view page.
        
		// updating last action to upload
		$meta = FileItem::getMeta();
        Yii::app()->user->setLastAction(array(  'action'=>'media'));
		
        $ajax = isset( $_POST['ajax'] ) || isset( $_GET['ajax'] ) || Yii::app()->request->isAjaxRequest;

        $MediaFiles = array(  );
        $uploadedFiles = array();
        $uploadedTypes = array();
        
        $Media = new FileItem;
        
        if (isset($_GET['qqfile'])) {
            $Media->file = new qqUploadedFileXhr();
        } elseif (isset($_FILES['qqfile'])) {
            $Media->file = new qqUploadedFileForm();
        } else {
            $this->redirect(array('list'));
            return;
        }
        $Media->setScenario( $scenario );
		$hasError=false;
        if ( $Media->save() ) {
            $uploadedFiles = array_merge( $uploadedFiles, $Media->uploaded);                        
        } else {
            $hasError=true;
            $err = $Media->getErrors('file');
            if ( count($err)!=0  ){
                $i=0;
                $reply['errors'] ="";
                foreach ( $err as $e ){
                    $reply['errors'] .= $e."\n";
                    if ( ++$i>2)
                        break;
                }
            } else
                $reply['errors'] = Yii::t('app', "File {filename} Cannot be saved", array( '{filename}'=>$Media->file->getName()) ); 
        }
        if ( !$hasError && count( $uploadedFiles )==0 ){
            $hasError = true;
            $reply['errors'] = Yii::t('app', "No valid files have been uploaded, please check that you are using the right format for your files." ); 
        }
        
        if ( $ajax ) {
            $reply['success'] = !$hasError;
            
            $i = 0;
            $meta['media'] = true; 
            foreach ($uploadedFiles as $file) {
                if (!isset($meta[$file->type]) || $meta[$file->type]===false )
                    $meta[$file->type] = true;
                    
                $reply[]=array("name"=>$file->name, "id"=>$file->id, "preview"=>$file->webpathPreview, "type"=>$file->type, 'path' => $file->webpath);
                $i++;
            }
            $reply['nbFiles'] = $i;
            echo json_encode($reply);
            
            FileItem::putMeta( $meta );
        } else if ( !$hasError )
            $this->redirect(array('list'));
		
    }
    public function actionUpload()
	{
        $this->upload( 'media');
	}
    
    public function actionDelete()
	{
        $ajax = isset( $_POST['ajax'] ) || Yii::app()->request->isAjaxRequest;
        
		if ( isset($_GET['id']) ) {
            $file = new FileItem( $_GET );
            
            if ( $file->type=="template" && !Yii::app()->user->checkAccess("model") )
                throw new CHttpException(500, Yii::t('app', "You don't have sufficient rights to delete this file") );
            if ( !$file->delete() )
                throw new CHttpException(500,Yii::t('app', 'The requested file does not exist or cannot be deleted.') );
        }
        if ($ajax) return;
        $this->redirect(array('list'));
	}
}