<?php

class PlayerController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='view';
   
    public function filters()
    {
        return array(
            'accessControl',
        );
    }
    public function accessRules()
    {
        return array(
            array('allow',
                'actions'=>array('view', 'restore', 'preview'),
                'users'=>Yii::app()->user->addAllUsers(),
            ),
            array('allow',
                'actions'=>array('edit', 'delete' ),
                'users'=> Yii::app()->user->addUserByRoles('program'),
            ),
            array('deny'),
        );
    }

    public function actionEdit()
	{
  
        if ( isset($_POST['action']) && $_POST['action']=='Cancel' ) {
            $this->redirect( Yii::app()->user->returnUrl );
            return;
        }
        
        $allOk=true;
        $meta = FileItem::getMeta();
			
			
        // if we have no ID, nor name we create a new program
        if ( ( isset($_POST['name']) && $_POST['name']!="" ) || ( isset($_POST['id']) && $_POST['id']!="" ) ){
            $player = new Program( $_POST );
        }elseif ( ( isset($_GET['name']) && $_GET['name']!="" ) || ( isset($_GET['id']) && $_GET['id']!="" ) ) {
            $player = new Program( $_GET );
        } else{
            Yii::app()->user->setLastAction(array(  'action'=>'program_create'));

            $player = new Program( );
		}
       //print_r( $player );
        if ( isset( $_POST['Program'] ) ) {
            $player->scenario = $_POST['action'];
            $player->attributes = $_POST['Program'];
            if ( isset( $_POST['rename'] ) )
                $player->name = $_POST['rename'];
                
            
            $allOk = $player->validate();
            
            if ( isset($_POST['PlaylistItem']) ) {   
                $playlist = array();
                foreach ( $_POST['PlaylistItem'] as $n=>$item ){
                    $media = new PlaylistItem;
                    
                    $media->attributes = $item;
                    $media->dur = $item['dur']; // need to be set at then end
                    if ( !$media->validate() ) $allOk=false;
                    
                    $playlist[]=$media;
                }
                $player->playlist = $playlist;
                
                //print_r( $player );
                
                if ( $allOk ) {
                    $player->save();
                    
                    $layout  = new LayoutItem();
		            if ( $layout->getProgramId()!=$player->id ) {
                        Yii::app()->user->setLastAction(array(  'action'=>'program_edit',
                                                            'id' => $player->id,
                                                            'name'=>$player->name
                                                        )
                                                    );
                    }
                    if ( !Yii::app()->request->isAjaxRequest && $_POST['action'] != "SaveAs" )
                        $this->redirectDefault();
					if ( $meta['program']===false )
						$meta['program']=true;
                }
                
                if (Yii::app()->request->isAjaxRequest) {
					return; // finish
				}
            }
        } 
        
        
        $crit = new CDbCriteria;
        $crit->condition = "type=:type";
        if ( Yii::app()->user->settings->slideshowAllowedImage ) {
            $crit->params = array( ":type"=>"image" );
            $images = FileItem::findAll($crit);
        }else $images = false;
        
        if ( Yii::app()->user->settings->slideshowAllowedVideo ) {
            $crit->params = array( ":type"=>"video" );
            $videos = FileItem::findAll($crit);
        } else $videos = false;
        
        if ( Yii::app()->user->settings->slideshowAllowedAudio ) {
            $crit->params = array( ":type"=>"audio" );
            $sounds = FileItem::findAll($crit);
        } else $sounds = false;
        
        if ( Yii::app()->user->settings->slideshowAllowedHypermedia ) {
            $crit->params = array( ":type"=>"project" );
            $projects = FileItem::findAll($crit);
        } else $projects = false;       
        
        if ( Yii::app()->user->settings->slideshowAllowedPlaylist ) {
            $playlists = Playlist::findAll( );
        } else $playlists = false;
        
        if ( Yii::app()->user->settings->slideshowAllowedSlide ) {
            $slides = SlideItem::findAll( );
        } else $slides = false;
        
        $this->render('edit', array(    'player' => $player, 
                                        "images" => $images, "videos" => $videos, "sounds" => $sounds,
                                        'playlists' => $playlists, 'slides' => $slides, 'projects' => $projects,
                                        ) );
										
		FileItem::putMeta( $meta );
	}

    protected function redirectDefault() {
        
        if (Yii::app()->request->isAjaxRequest) {
            $shows = Program::findAll( );
            $layout  = new LayoutItem();
            $current_id = $layout->getProgramId();
            
            if ( count($shows)>0 )
                $meta = $shows[0]->loadMeta();
            else
                $meta = array();
            
            $this->renderPartial('restore', array( 'shows' => $shows, 'program_id' => $current_id, 'previews' => $meta  ) );
            
            return true;
        } else
            $this->redirect(Yii::app()->user->returnUrl);
        /*
        if (Yii::app()->user->checkAccess("project") )
            $this->redirect(array('edit'));
        else
            $this->redirect(array('view'));
        */
    }
    
   	public function actionView()
	{        
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];        
        
        if ( isset($_GET['id']) ) {
            $current = new Program( array("id"=>$_GET['id']) );
        } else {
            $layout  = new LayoutItem();
            $current_id = $layout->getProgramId();
            $current = new Program( array('id'=>$current_id));
        }
        
        //$this->render('view', array( 'main' => $main, 'current' => $current, 'shows' => $shows ) );
		$this->render('view', array( 'player' => $current ) );
        
	}
	
	public function actionPreview()
	{
		$this->layout = 'partial';
		return $this->actionView();
	}
    
    public function actionRestore()
	{
        $status = FileItem::getMeta();
		
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
        if ( isset($_GET['id']) ) {
            $id = $_GET['id'] ;
            
            $layout  = new LayoutItem();
            
            if ( !$layout->changeProgramId( $id, false ) ) {
                throw new CHttpException(500, Yii::t('app','The requested program cannot be restored.') ); 
            } 
            if ( Yii::app()->user->returnUrl!=array('player/restore') )
                $this->redirectDefault();
				
			$status['activate'] = true;
            Yii::app()->user->setLastAction(array(  'action'=>'activate',
				                                        'id' => $id,
                                                    )
                                                );
        }
        
        Yii::app()->user->returnUrl = array('player/restore');

        $shows = Program::findAll( );
        $layout  = new LayoutItem();
		$current_id = $layout->getProgramId();
        if ( count($shows)>0 ) {
			$status['program'] = count($shows);
            $meta = $shows[0]->loadMeta();
        } else {
			$status['program'] = false;
            $meta = array();
		}
        
        $this->render('restore', array( 'shows' => $shows, 'program_id' => $current_id, 'previews' => $meta  ) );
        
		FileItem::putMeta( $status );
    }

    public function actionDelete()
	{
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
   		if ( isset($_GET['id']) ) {
            $file = new Program( $_GET );
            if ( !$file->delete() )
                throw new CHttpException(500, Yii::t('app','The requested program does not exist or cannot be deleted.') );
        }
        $this->redirectDefault();
	}
}