<?php

class PlaylistController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='list';
    
    public function filters()
    {
        return array(
            'accessControl',
        );
    }
    public function accessRules()
    {
        return array(
            array('allow',
                'actions'=>array('list', 'view'),
                'users'=>Yii::app()->user->addAllUsers(),
            ),
            array('allow',
                'actions'=>array( 'edit', 'delete' ),
                'users'=> Yii::app()->user->addUserByRoles('playlist'),
            ),
            array('deny'),

        );
    }
    
	public function actionList()
	{
        $playlists = Playlist::findAll();
        if ( count($playlists)>0 )
            $meta = $playlists[0]->loadMeta();
        else
            $meta = array();
            
        if ( Yii::app()->request->isAjaxRequest )
            $this->renderPartial('list', array( 'playlists' => $playlists, 'previews' => $meta  ));
        else {
            $this->render('list', array( 'playlists' => $playlists, 'previews' => $meta ));
            Yii::app()->user->returnUrl = array("playlist/list");
        }
        
	}
    
    public function actionView()
    {
    
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
        if ( isset($_GET['id']) ) {
            $file = new Playlist( $_GET );
            if ( isset($_GET['partial']) ) {
                 $this->layout = 'partial';
            } 
            $this->render( 'view', array( "file" => $file ) );    
        } 
    }
    public function actionEdit()
	{
        if ( isset($_POST['action']) && $_POST['action']=='Cancel' ) {
            $this->redirect( Yii::app()->user->returnUrl );
            return;
        }
            
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];

        $file = new Playlist( $_GET );
                
        if ( isset( $_POST['PlaylistItem'] ) ) {
            
            $file->scenario = $_POST['action'];
            $file->attributes = $_POST['Playlist'];
            if ( isset( $_POST['rename'] ) )
                $file->name = $_POST['rename'];
            //playlist do not loop
            $file->loop="off";
            $bAllOk = $file->validate();
            
            $playlist = array();
            
            foreach ( $_POST['PlaylistItem'] as $n=>$item ){
                //print_r($item);
                $media = new PlaylistItem;
                
                $media->attributes = $item;
                
                //print_r($media);
                
                $bAllOk &= $media->validate();
                
                $playlist[]=$media;
            }
            $file->playlist = $playlist;

            if ( $bAllOk ) {
                $saveok = $file->save();
                
                Yii::app()->user->setLastAction(array(  'action'=>'playlists', 'id' => $file->id, 'name'=>$file->name));
                
                if ( Yii::app()->request->isAjaxRequest ) {
                    if ($saveok) return; // finish) 
                    else throw new CHttpException(500, Yii::t('app','Cannot save playlist.'));
                }
                
                if ( $saveok ) {
                    if ( $_POST['action'] != "SaveAs" ) {
                        $this->redirect( Yii::app()->user->returnUrl );
                        return;
                    }
                }
            }
        } 
    
        $crit = new CDbCriteria;
        $crit->condition = "type=:type";
        
        if ( Yii::app()->user->settings->playlistAllowedImage ) {
            $crit->params = array( ":type"=>"image" );
            $images = FileItem::findAll($crit);
        }else $images = false;
        
        if ( Yii::app()->user->settings->playlistAllowedVideo ) {
            $crit->params = array( ":type"=>"video" );
            $videos = FileItem::findAll($crit);
        } else $videos = false;
        
        if ( Yii::app()->user->settings->playlistAllowedAudio ) {
            $crit->params = array( ":type"=>"audio" );
            $sounds = FileItem::findAll($crit);
        } else $sounds = false;
        
        if ( Yii::app()->user->settings->playlistAllowedHypermedia ) {
            $crit->params = array( ":type"=>"project" );
            $projects = FileItem::findAll($crit);
        } else $projects = false;       
        
        if ( Yii::app()->user->settings->playlistAllowedPlaylist ) {
            $crit->params = array( ":type"=>"playlist" );
            $playlists = FileItem::findAll($crit);
        } else $playlists = false;
        
        if ( Yii::app()->user->settings->playlistAllowedSlide ) {
            $crit->params = array( ":type"=>"slide" );
            $slides = FileItem::findAll($crit);
        } else $slides = false;
        
        $this->render( 'edit', array( "playlist" => $file, 
                                        "images" => $images, "videos" => $videos, "sounds" => $sounds,
                                        'playlists' => $playlists, 'slides' => $slides, 'projects' => $projects, 
                                    ) );    
	}
    
    public function actionDelete()
	{
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
   		if ( isset($_GET['id']) ) {
            $file = new Playlist( $_GET );
            if ( !$file->delete() )
                throw new CHttpException(500, Yii::t('app','The requested playlist does not exist or cannot be deleted.') );
            if ( Yii::app()->request->isAjaxRequest ) $this->actionList();
            else $this->redirect( Yii::app()->user->returnUrl );
        } 
	}

}