<?php

class SettingsController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='settings';

    public function filters()
    {
        return array(
            'accessControl',
        );
    }
	
    public function accessRules()
    {
        return array(
            array('allow',
                'actions'=>array( 'settings', 'enablenew'),
                'users'=>Yii::app()->user->addAllUsers(),
            ),
            array('deny'),

        );
    }

	/**
	 * Displays the login page
	 */
	public function actionSettings()
	{
		Yii::app()->user->returnUrl = array('settings/settings');

        if ( isset($_GET['page']) )
            $page = $_GET['page'];
        else
            $page = "";
            
		self::renderSettings( $this, $page );
		
	}
    public function actionEnablenew() {
        if ( !Yii::app()->user->isGuest ) {
            
            $username = Yii::app()->user->id;
            $user = User::find( $username );
            if ( $user==NULL )
                throw new CHttpException(500,Yii::t('app', 'The requested user does not exist.'));
                
            $user->setScenario( "update" );
            $user->shownews=true;
            $user->save();
        }        
        $this->redirect(Yii::app()->homeUrl);
    }
    
    static function renderSettings( $controller, $page="", $error=null ){
        $username = Yii::app()->user->id;
		
		$user = User::find( $username );
		$controller->render('/settings/settings', array(	'user'=>$user, 'page'=>$page, 'error'=>$error
										)
					);
    }
    
}