<?php

class Feeds extends FileItem
{
    
    protected $_entry = false;
    protected $_data = false;
    protected $_slides = false;
    function __construct($attributes=array ( ), $scenario='init') {
        $attributes["type"] = "feeds";
        parent::__construct( $attributes, $scenario );
        
    }
    
     public function rules() {
		$res = array(
    	);
        return array_merge($res, parent::rules() );
	}
   	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
		);
	}
    
    function getSlides() {
        
    }
    
    function getEntry() {
        if ( $this->filepath===false )
            return array();
        if ( $this->_entry===false ) {
            // load the file 
            if ( !file_exists($this->filepath) )
                return array();
            
            $data = file_get_contents( $this->filepath );
            if ( $data===false || $data=="" ) return array();
            
            $dom = new DOMDocument;
            if ( $dom->loadXML( $data )===false ) return array();
            
            $entries = $dom->getElementsByTagName("entry");
            $this->_entry = array();
            foreach( $entries as $entry ) {
                $res = new FeedsEntry;
                $res->name = $entry->getAttribute("name");
                $res->element = $entry->getAttribute("element");
				$res->position = $entry->getAttribute("position");
                if ( $res->name=="" ) $res->name = $res->element;
                if ( $res->element=="" ) $res->element = $res->name;
                
                $res->type = $entry->getAttribute("type");
                
                $this->_entry[] = $res;
            }
            
            
        }
        return $this->_entry;
    }
    
    function getData() {
        if ( $this->rssPath()===false )
            return array();
        if ( $this->_data===false ) {
        
            $entries = $this->getEntry();
            if ( count($entries)==0 ) 
                return array();
            
            // load the file 
            if ( !file_exists($this->rssPath()) )
                return array();
            
            $data = file_get_contents( $this->rssPath() );
            if ( $data===false || $data=="" ) return array();
            
            $dom = new DOMDocument;
            if ( $dom->loadXML( $data )===false ) return array();
            
            $items = $dom->getElementsByTagName("item");
            $this->_data = array();
            foreach( $items as $xmlitem ) {
                $item = array();
                foreach ($entries as $entry) {
                    $d = $xmlitem->getElementsByTagName($entry->element);
                    if ( $d->length==1 )
                        $item[$entry->element] = trim($d->item(0)->textContent);
                    else
                        $item[$entry->element] = "";
                }
                $this->_data[] = $item;
            }
        }
        return $this->_data;
    }
    
    function setEntry( $entry ) {
        $this->_entry = array();
        foreach ($entry as $item ) {
            $i = new FeedsEntry( );
            $i->setAttributes($item);
            $this->_entry[] = $i;
        }
    }
    function setData( $data ) {
        $this->_data = $data;
    }
    public function rssPath() {
        return self::folder().$this->linkpath;
    }
    // static function to get one user
    public static function find( $criteria=false ) {
        $files = FileItem::findAll( $criteria  );
        if ( count($files)>=1 )
            return $files[0];
        else return NULL;
    }
    
    // static function to get all users
    public static function findAll( $criteria=false, $countOnly=false ) {
        $files =  array();
        
        $options = array();
        
        $nameFilter = "";
        if ( !($criteria===false) && $criteria->condition!="") {
            // support only type=:type
            $conditions = explode("AND", $criteria->condition);
            
            foreach ($conditions as $con) {
                $c = explode("=", trim($con));
                if ( count($c)==2 ) {
                    $val = $criteria->params[$c[1]];
                    if ( $c[0]=="name" ) $nameFilter = $val;
                }
            }
        }
        
        if ( !file_exists( self::folder("feeds") ) )
            mkdir( self::folder("feeds") );
        $files = CFileHelper::findFiles( self::folder("feeds"), array( 'level'=>0, 'fileTypes'=>array('xml') ) );
        
        if ( !($criteria===false) )
            $files = array_slice( $files, $criteria->offset>=0?$criteria->offset:0, $criteria->limit>=0?$criteria->limit:count($files) );
        
        if ( $nameFilter!="" ) {
            $nameFilter = preg_replace("/*/", ".*", $nameFilter);
            $new_files = array();
            foreach ( $files as $file ) {
                if ( preg_match("/".$nameFilter."/", basename( $file ) ) ) 
                    $new_files[] = $file;
            }
            $files = $new_files;
        }
        $results = array();
        foreach ( $files as $file ) {
            $f = new Feeds( array('filepath'=>$file ) );
            $results[]=$f;
        }
        
        
        return $results;
    }
       
    // saving a file
    public function save() {

        //$fd = fopen("debug.log","w");
        //fwrite($fd, "Saving: ".($this->filepath)."\n");
        //fwrite($fd, print_r($this, true) );
         // check if we are renaming an allready uploaded file    
        parent::rename();
               
        // save the datafeed configuration
        if ( $this->_entry!==false || $this->_data===false ) {
            $dom = new DOMDocument;
            $feeds = $dom->appendChild( $dom->createElement("feeds") );
            $feeds->appendChild( $dom->createTextNode("\n") );
            
            // add the media
            
            if ( $this->_entry!==false )
                foreach( $this->_entry as $entry ) {
                    $entryitem = $feeds->appendChild( $dom->createElement("entry") );
                    $entryitem->setAttribute( "name", $entry->name );
                    $entryitem->setAttribute( "element", $entry->element );
                    $entryitem->setAttribute( "type", $entry->type );
					$entryitem->setAttribute( "position", $entry->position );
                    $feeds->appendChild( $dom->createTextNode("\n") );
                }
                
            
            if ( file_put_contents( $this->filepath, $dom->saveXML() )===false ) return false;
        }
        if ( $this->_data!==false ) {
            $dom = new DOMDocument;
            $rss = $dom->appendChild( $dom->createElement("rss") );
            $rss->appendChild( $dom->createTextNode("\n") );
            foreach($this->_data as $item ){
                 $xmlitem = $rss->appendChild( $dom->createElement("item") );
                 foreach( $item as $name=>$value ){
                    $name = $xmlitem->appendChild( $dom->createElement($name) );
                    $name->appendChild( $dom->createTextNode($value) );
                }
                $rss->appendChild( $dom->createTextNode("\n") );
            }
            if ( file_put_contents( $this->rssPath(), $dom->saveXML() )===false ) return false;
        }
        
        return true;
    }
    
    // delete a file
    public function delete() {
        if ( parent::delete()==false ) return false;
        if ( file_exists( $this->rssPath() ) )
            return unlink( $this->rssPath() );
        else return true;
    }
    
	public function copy() {
        // must also copy the rss data
        $path = $this->rssPath();
        $old = self::getDisplayName( $this->id );
        
        if ( parent::copy()==false ) return false;
        
        if ( $old!=$this->name ) {
            $new =  self::getPathToLink( $this->name, $this->type );
            if ( file_exists( $path ) )
                return copy( $path, self::folder("").$new );
        }
        return true;
    }

    public function rename() {
        // must also copy the rss data
        $path = $this->rssPath();
        $old = self::getDisplayName( $this->id );
        
        if ( parent::rename()==false ) return false;
        
        if ( $old!=$this->name ) {
            $new =  self::getPathToLink( $this->name, $this->type );
            if ( file_exists( $path ) )
                return rename( $path, self::folder("").$new );
        }
        return true;
    }
    public function createPreview( $sources ) {
        // create a preview of the datasource. Using only the first client:
        if ( count($sources)==0 ) {
            if ( file_exists($this->getFilepathPreview()) )
                unlink( $this->getFilepathPreview() );
            return;
        }
        
        $newImage = imagecreatetruecolor(160, 90);
        imagefill( $newImage , 0, 0, imagecolorallocate( $newImage, 255, 255, 255 ) );
        
        $max = 3;
        if ( $max>count($sources) ) $max = count($sources);
        for ($i=0; $i<$max; $i++ ) {
            $slideid = $sources[$i];
            if ( $slideid=="index" ) $slide = new LayoutItem();
            else $slide = new SlideItem( array( 'id'=> $slideid ) );
            
            $img = $slide->getFilepathPreview();
            $info = getimagesize( $img );
            $image = imagecreatefrompng( $img );
            if ( $image === false ) return;    
            $h = 90-18*($max-1);
            $width = $info[0]*$h/$info[1];
            imagecopyresampled( $newImage, $image, (160-$width)/2+($i-($max-1)/2)*32, $i*18, 0, 0, $width, $h, $info[0], $info[1] );
        }        
        
        // add the rss icon on top
        $img = self::folder("").FileItem::$previewPath."feedsadd.png";
        $info = getimagesize( $img );
        $image = imagecreatefrompng( $img );
        $width = $info[0]*45/$info[1];
        imagecopyresampled( $newImage, $image, 5 , 40, 0, 0, $width, 45, $info[0], $info[1] );
        if ( !imagepng( $newImage, $this->getFilepathPreview() ) ) return false;    
    
    }
}

    