<?php

class FileItem extends CFormModel
{
    
    public static $rootpath= "files/";
    
    // to access the files:
    public static $contentpath= "/srv/raperca/content/";
    public static $systemSourcePath= "protected/files/system/";
    
    // to link inside project
    
    protected $fusion_pass="/etc/raperca/fusion-pass";
    
    public static $base= "../"; // the media subfolder
    public static $baseTemplates= "../../"; // templates/templatename/
    public static $basePlaylist= "../"; // system/
	
    // to access from the web
    public static $webpath= "/content/";
    
    // relative link to the playlist and defaults previews
    public static $playlistPath = "system/new_playlist.svg";
    public static $previewPath = "system/";
    
    // relative link to the js theme
    public static $layoutThemePath = "scripts/layouttheme.js";
    
    public static $metadataName = "properties.meta";
    
    public static $ext = array(
        "image" => array("jpg", "png", "svg", "gif"),
        "audio" => array("mp3"),
        "video" => array("avi", "mov", "mp4", "wmv"),
        "playlist" => array("xml"),
        "project" => array("zip","7z"),
        "backup" => array("7z"),
        "template" => array("zip","7z"),
        );
    
    public static $paths = array(   "image" => "images/", 
                                    "video" => "videos/", 
                                    "audio" => "sounds/", 
                                    "project" => "projects/" , 
                                    "playlist" => "playlists/" ,
                                    "slideshow" => "slideshows/" ,
                                    "template" => "templates/",
                                    "layout" => "skins/",
                                    "slide" => "slides/",
                                    "feeds" => "feeds/",
                                    "backup" => "backups/",
                                    "script" => "scripts/",
                                    "index" => "index/",
									"media" => array ( "videos/", "images/", "sounds/" ), // also include the projects
                                    "all" => array ( "videos/", "images/", "playlists/" ) // also include the projects
                                    );
    public $name=false; // name tobe displayed to the user
    protected $_filepath=false; // path to the real file
    protected $_webpath=false; //path to use to show the file on the web browser
    protected $_linkpath=false; //path to use to display the file
    protected $_id=false; // unique way to identify this file
    
    protected $_datemod=false;
    protected $_size=false;
    protected $_mtime=false;
    
    public $file=null;
    public $type=false;
    
    public $uploaded = array();
    
    /**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
            "file" => Yii::t('app',"File"),
            "name" => Yii::t('app',"Name"),
            "modificationDate" => Yii::t('app',"Modification Date"),
            "size" => Yii::t('app',"Size"),
			"webpathPreview" => Yii::t('app',"Preview"),
		);
	}
    
    function __construct($attributes=array ( ), $scenario='init') {
        mb_internal_encoding("UTF-8");
        
        parent::__construct( $scenario );
        
        //parent::setAttributes( $attributes );
        if ( isset($attributes["id"]) ) $this->setId( $attributes['id'] );
        if ( isset($attributes["name"]) ) $this->name = $attributes["name"];
        if ( isset($attributes["type"]) ) $this->type = $attributes["type"];
        
        if ( isset($attributes["filepath"]) ) $this->_filepath=$attributes["filepath"];
        if ( isset($attributes["linkpath"]) ) $this->_linkpath=$attributes["linkpath"];
        
        $id = $this->getId(); // make sure we have an ID
        
        if ( !($id===false) && ( ($this->name===false) || ($this->type===false) ) )
            $this->setId( $id );
            
    }
    
    static function folder( $name="" ) {
        if ( $name=="" ) return self::$contentpath.self::$rootpath;
        if ( is_array( self::$paths[$name] ) ) return false;
        
        return self::$contentpath.self::$rootpath.self::$paths[$name];
    }
    static function webfolder( $name ) {
        if ( $name=="" ) return self::$webpath.self::$rootpath;
        if ( is_array( self::$paths[$name] ) ) return false;
        
        return self::$webpath.self::$rootpath.self::$paths[$name];
    }
    static function linkfolder( $name ) {
        if ( $name=="" ) return "";
        if ( is_array( self::$paths[$name] ) ) return false;
        
        return self::$paths[$name];
    }
    
    static function getTypeFomPath( $filepath ) {
        foreach ( self::$paths as $type => $path ) {
            if ( is_array($path) ) continue;
            if ( strpos($filepath, self::$contentpath.self::$rootpath.$path)===0 ) return $type;
        }
        return false;
    }
    static function getTypeFomLinkpath( $linkpath ) {
        $pos = strpos($linkpath, "?");  
        if ( !($pos===false) ) {
            $query = substr( $linkpath, $pos+1 );
            $vals = explode("&", $query);
            foreach ($vals as $val ){
                $it = explode("=", $val);
                if ( $it[0]=='configUri' ) {
                    $linkpath = rawurldecode($it[1]);
                    break;
                }
            }
        }
        foreach ( self::$paths as $type => $path ){
            if ( is_array($path) ) continue;
            if ( strpos($linkpath, $path)!==false ) return $type;
        }
        
        return false;
    }
    
    static function getIdfromName( $name, $type ) {
        if ( !isset(self::$paths[$type]) ) return false;
        return  $type.":".$name;
    }
   
    static function getPathToFile( $name, $type, $webpath=false ) {
    
        if ( $webpath ) {
            $base = self::webfolder($type);
            $name = rawurlencode( $name );
        } else
            $base = self::folder($type);
        if ($base===false) 
            return false;
    
        if ( $type=="image" || $type=="video" || $type=="audio" )
            return $base.$name;
        elseif ( $type=="project" )
            return  $base.$name."/index.svg";
        elseif ( $type=="template" || $type=="slide" )
            return  $base.$name."/template.svg";
        elseif ( $type=="layout" )
            return  $base.$name."/skin.svg";
        elseif ( $type=="playlist" || $type=="slideshow" || $type=="feeds")
            return  $base.$name.".xml";
        elseif ( $type=="backup" )
            return  $base.$name.".7z";
        else 
            return false;
    }
    
    static function getPathToLink( $name, $type ) {
        
        $base = self::linkfolder($type);
        if ($base===false) 
            return false;
    
        if ( $type=="image" || $type=="video" || $type=="audio" )
            return $base.rawurlencode($name);
        elseif ( $type=="project" )
            return  $base.rawurlencode($name)."/index.svg";
        elseif ( $type=="template" || $type=="slide" )
            return  $base.rawurlencode($name)."/template.svg";
        elseif ( $type=="layout" )
            return  $base.rawurlencode($name)."/skin.svg";
        elseif ( $type=="playlist" || $type=="slideshow" )
            return  self::$playlistPath."?configUri=".rawurlencode(self::$basePlaylist.$base.rawurlencode($name).".xml");
        elseif ( $type=="feeds" )
            return  $base.rawurlencode($name.".rss");
        elseif ( $type=="backup" )
            return  $base.rawurlencode($name.".7z");
        else 
            return false;
    }
    
    static function getTypeFomId( $id ) {
        if ( $id===false ) return false;
        $vals = split(":", $id );
        return $vals[0];
    }
    
    static function getDisplayName( $id ) {
        if ( $id===false ) return false;
        $vals = split(":", $id );
		if (count($vals)==2 )
			return $vals[1];
		else 
			return "";
    }

    
    static function basenamepath( $path, &$dir = "" ) {
        $slash = false;
        if ( strtoupper(substr(PHP_OS, 0, 3)) === 'WIN' ){
            $slash = mb_strrpos( $path, "\\", 0, 'UTF-8' );
        }
        if ( $slash===false )
            $slash = mb_strrpos( $path, "/", 0, 'UTF-8' );
        
        if ( $slash===false ){
            $dir = "";
            $file = $path;
        }else{
            $dir = mb_substr($path, 0, $slash, 'UTF-8' );
            $file = mb_substr($path, $slash+1, mb_strlen($path, 'UTF-8'), 'UTF-8' );
        }
        return $file;
    }
    static function getDisplayNameFromPath( $path, $type ) {
    $dir ="tesst";
        $file = self::basenamepath( $path, $dir );
        //$dir = dirname( $path );
        //$file = basename( $path );
                
        if ( $type=="image" || $type=="video" || $type=="audio" )
            return $file;
        elseif ( $type=="project" || $type=="template" || $type=="layout" || $type=="slide" ){
            return self::basenamepath( $dir, $dummy);
        } elseif ( $type=="playlist"  || $type=="slideshow" || $type=="backup" || $type=="feeds" ){
            $dot = mb_strrpos( $file, ".", 'UTF-8' );
            return mb_substr($file, 0, $dot, 'UTF-8' );
        } else 
            return false;
    }
    
     static function getDisplayNameFromLinkpath( $path, $type ) {
        if ( $type=="playlist" || $type=="slideshow" ) {
            $pos = strpos($path, "?");
            if ( $pos===false ) return false;
            $query = substr( $path, $pos+1 );
            $vals = explode("&", $query);
            foreach ($vals as $val ){
                $it = explode("=", $val);
                if ( $it[0]=='configUri' ) {
                    $url = rawurldecode( $it[1] );
                    return  rawurldecode( mb_substr( self::basenamepath( $url, $dummy ), 0, -4 ) );
                    //return pathinfo( urldecode($it[1]), PATHINFO_FILENAME );
                }
            }
            return false;
        } else {
            $file = self::basenamepath( rawurldecode($path), $dir );                  
            if ( $type=="image" || $type=="video" || $type=="audio" )
                return $file;
            elseif ( $type=="project" || $type=="template" || $type=="layout"  || $type=="slide" )
                return self::basenamepath( $dir, $dummy);
            elseif ( $type=="backup" || $type=="feeds"){
                return mb_substr($file, 0, -4);
                 //return pathinfo( $file, PATHINFO_FILENAME );
            } else 
                return false;
        }
    }
    /**
	 * @return array validation rules for model attributes.
	 */

    public function rules() {
		$ret = array(
            array('id', 'safe', 'on' => 'rename, create, init'),
            array('name, type', 'safe', 'on' => 'init'),
            
            array('name', 'required', 'on' => 'rename, create' ),
            array('name', 'match', 'pattern' =>'@^[^<>:"/\\\|\?\*,]*$@' ), 
            array('name', 'length', 'max'=>20, 'encoding'=>'UTF-8' ),
            );
        return $ret;
    }

	

    public function getId() {
        if ( $this->_id===false ) {
            // can we get an id from otehr params:
            if ( ($this->name===false) || ($this->type===false) ) {
                if ( !($this->_filepath===false) ) {
                    $this->type = self::getTypeFomPath( $this->_filepath );
                    $this->name = self::getDisplayNameFromPath( $this->_filepath, $this->type  );
                } elseif ( !($this->_linkpath===false) ) {
                    $this->type = self::getTypeFomLinkpath( $this->_linkpath );
                    $this->name = self::getDisplayNameFromLinkpath( $this->_linkpath, $this->type  );
                } 
            }
            if ( !($this->name===false) && !($this->type===false))
                $this->_id = self::getIdfromName( $this->name, $this->type);
            else if ( !($this->_id===false) )
                $this->setId( $this->_id ); // update the name and type
        }
        return $this->_id;
    }
    
    public function setId( $id ) {
        
        $this->_id = $id;
        $this->type = self::getTypeFomId( $this->_id );
        $this->name = self::getDisplayName( $this->id, $this->type );       
        $this->_webpath=self::getPathToFile( $this->name, $this->type, true);        
        $this->_linkpath=self::getPathToLink( $this->name, $this->type);
        $this->_filepath=self::getPathToFile( $this->name, $this->type);
    }
    
    public function getWebpath() {
        if ( $this->_webpath===false ) 
            $this->_webpath=self::getPathToFile( self::getDisplayName($this->id), self::getTypeFomId($this->id), true );
        return $this->_webpath;
    }
    public function getLinkpath() {
        if ( $this->_linkpath===false ) 
            $this->_linkpath=self::getPathToLink( self::getDisplayName($this->id), self::getTypeFomId($this->id) );
        return $this->_linkpath;
    }
    public function getLinkpathTemplate() {
        return self::$baseTemplates.$this->getLinkpath();
    }
    public function getFilepath() {
        if ( $this->_filepath===false ) 
            $this->_filepath=self::getPathToFile( self::getDisplayName($this->id), self::getTypeFomId($this->id) );
        return $this->_filepath;
    }
    
	static function getFileFromWeb( $web ) {
		$baseWeb = self::webfolder("");
        $baseFile = self::folder("");
		$path = str_replace($baseWeb, $baseFile, $web );
        $path = urldecode ( $path );
        $query = strpos($path, "?");
        if ($query!==false)
            $path = substr($path, 0, $query);
        return $path;
	}
    public function getFilepathPreview() {
        $base = self::basenamepath( $this->getFilepath(), $dir );
        
        $file = $dir."/.preview.".$base.".png";
        return $file;
    }
    
    public function getWebpathPreview() {
        if ( $this->type=='script')
            return self::getWebpathDefaultPreview();
        
        if (!$this->getFilepath())
            return $this->getWebpathDefaultPreview();
        $base = self::basenamepath( $this->getFilepath(), $dir );
        if ( file_exists( $dir."/.preview.".$base.".png" ) ){
            $ext='.png';
            if ( $this->type=='slide' || $this->type=='playlist' || $this->type=='layout'
                  || $this->type=='image')
                $ext.="?mod=".urlencode($this->getMTime());
            $base = self::basenamepath( $this->webpath, $dir );
            
            return $dir."/.preview.".$base.$ext;
        }else
            return $this->getWebpathDefaultPreview();
    }
    public function getWebpathDefaultPreview() {        
        return self::$webpath.self::$rootpath.self::$previewPath.$this->type.".png";
    }
    public function getFilepathDefaultPreview() {
        return self::$contentpath.self::$rootpath.self::$previewPath.$this->type.".png";
    }
    
    protected function getFileInfo() {
        $res = stat( $this->getFilepath() );
        $this->_datemod = date("d/m/y H:i", $res['mtime']);
        $this->_mtime =$res['mtime'];
        
        $units = array('B', 'KB', 'MB', 'GB', 'TB');
        $bytes = max($res['size'], 1);
        $pow = floor( ( log($bytes) ) / log(1024));
        $pow = min($pow, count($units) - 1);
        $bytes /= pow(1024, $pow);
        if ( $bytes<10 && $pow>1 ) {
            $bytes*=1024;
            $pow--;
        }
        $precision = 0;
        if ( $bytes<100 ) $precision = 1;
        $this->_size = round($bytes, $precision) . ' ' . $units[$pow]; 
            
    }
    public function getModificationDate() {
        if ( $this->_datemod===false ) $this->getFileInfo();
        
        return $this->_datemod;
    }
    public function getSize() {
        if ( $this->_size===false ) $this->getFileInfo();
        
        return $this->_size;
    }
    public function getMTime() {
        if ( $this->_mtime===false ) $this->getFileInfo();
        
        return $this->_mtime;
    }

    // static function to get one user
    public static function find( $criteria=false ) {
        $files = self::findAll( $criteria  );
        if ( count($files)>=1 )
            return $files[0];
        else return NULL;
    }
    
    // static function to count the number of users
    public static function count( $criteria=false ) {
        return count( self::findAll( $criteria, true ) );
    }
    
    public static function hasType( $type ) {
        if ( isset( self::$paths[$type] ) ){
            if ( !is_array(self::$paths[$type]) )
                $list = array(self::$paths[$type]);
            else
                $list = self::$paths[$type];
            foreach ($list as $path )
                if (count( scandir( self::$contentpath.self::$paths[$type] ) )>2 ) return true;
            return false;
        } else
            return false;
    }
    public static function createSystemFile() {
        if ( !file_exists(self::folder()) )
            mkdir (self::folder());
                
        if ( !file_exists(self::folder().self::$previewPath) )
            mkdir (self::folder().self::$previewPath);
            
        CFileHelper::copyDirectory( self::$systemSourcePath, self::folder().self::$previewPath );
        
    }
    // static function to get all users
    public static function findAll( $criteria=false, $countOnly=false) {
        $files =  array();
        
        $type="all"; // default
        $options = array();
        
        if ( $criteria!==false && $criteria->condition!="") {
            // support only type=:type
            $conditions = explode("AND", $criteria->condition);
            
            foreach ($conditions as $con) {
                $c = explode("=", trim($con));
                if ( count($c)==2 ) {
                    if ( $c[1][0]==":" ) 
                        $val = $criteria->params[$c[1]];
                    else
                        $val = $c[1];
                    if ( $c[0]=="type" ) $type = $val;
                    if ( $c[0]=="ext" ) $options['fileTypes'] = $val;
                    if ( $c[0]=="exclude" ) $options['exclude'][] = $val;
                }
            }
        }
        
        if ( $type=="project" || $type=="all" || $type=="media") {
            $subpaths = self::$paths["project"];
            if (!is_array($subpaths)) $subpaths = array($subpaths);
            
            foreach ( $subpaths as $subpath ) {
                $path = self::folder().$subpath;
                if ( !file_exists( $path ) ) continue;
                
                $projects = scandir( $path );
                foreach ($projects as $proj ){
                    if ( substr($proj,0,1)=="." ) continue;
                    $proj = $path.$proj;
                    if (is_dir($proj) /* && file_exists($proj."/index.svg") */  )
                        $files[] = $proj."/index.svg";
                }
            }
        }
        
        if ( $type=="template" || $type=="slide" || $type=="layout" ) {
            $subpaths = self::$paths[$type];
            $name = $type;
            if ( $type=="slide" ) $name = "template";
            if ( $type=="layout" ) $name = "skin";
            if (!is_array($subpaths)) $subpaths = array($subpaths);
            foreach ( $subpaths as $subpath ) {
                $path = self::folder().$subpath;
                if ( !file_exists( $path ) ) continue;
                
                $projects = scandir( $path );
                foreach ($projects as $proj ){
                    if ( $proj==".preview" || substr($proj,0,1)=="." ) continue;
                    $proj = $path.$proj;
                    if (is_dir($proj) /* && file_exists($proj."/".$name.".svg") */)
                        $files[] = $proj."/".$name.".svg";
                }
            }
        } elseif ( $type!="project" ) {
            if ( isset( self::$paths[$type] ) )
                $subpaths = self::$paths[$type];
            else 
                $subpaths = self::$paths["media"];
            $options['level']=0;
            if (!is_array($subpaths)) $subpaths = array($subpaths);
            
            foreach ( $subpaths as $subpath ){
                $path = self::folder().$subpath;
                if ( !file_exists( $path ) ) continue;
                $files = array_merge($files, CFileHelper::findFiles($path,  $options) );
            } 
        }
        
        if ( !($criteria===false) )
            $files = array_slice( $files, $criteria->offset>=0?$criteria->offset:0, $criteria->limit>=0?$criteria->limit:count($files) );
        foreach ( $files as $idx=>$file ) {
            // remove metadata fromthe list in case 
            if ( strpos( $file, self::$metadataName) !== false  )
                unset( $files[$idx] );
        }
        if ( $countOnly )
            return $files;
            
        $results = array();
        foreach ( $files as $file ) {
            $filename=self::basenamepath($file, $dummy);
            if ( $filename[0]!="." ){
                $f = new FileItem( array('filepath'=>$file) );
                $results[]=$f;
            }
        }

        return $results;
    }
    
    public function exist() {
        return file_exists( self::getPathToFile($this->name, $this->type) );
    }
    // saving a file
    public function save() {
        if ( $this->file!=null ) {
            $ext = mb_strtolower($this->file->getExtensionName(), 'UTF-8');
            if ( $this->scenario=="media" && $ext!="zip" && $ext!="7z" ) {
                $this->type =null;
                foreach ( self::$ext as $name => $extlist)
                    if ( in_array($ext, $extlist ) ) {
                        $this->type = $name;
                        break;
                    }
                if ( $this->type === null ){
                    $this->addError('file', Yii::t('app', "File format not supported") );
                    return false;
                }
                    
            } else {
                $this->type = $this->scenario;
            }
            if ( $this->type=="playlist" || $this->type=="slideshow" || 
                 $this->type=="slide" || $this->type=="feeds" ) return false; // cannot handle playlist or slide here
            
            if ( ($ext=="zip" || $ext=="7z") && $this->type!="backup"){
            
                $zip = new ZipHandler;
                $res = $zip->open( $this->file->getTempName(), $ext );
                if ( !$res ) {
                    $this->addError('file', $zip->error );
                    return false;
                }
                // step 1, extract it all to a temp folder
                $tmpBase = self::$contentpath.".tmp/zip/";
                mkdir( $tmpBase ) ; 
                if ( !$zip->extractFolderTo( $tmpBase, "" ) ) {
                    if ( $zip->error )
                        $this->addError('file', $zip->error );
                }
                
                // step 2 move files
                $gotindex=false;
                //file_put_contents("/var/log/fusion/debug.log", print_r($zip->folders, true). "\n", FILE_APPEND );
                $skipList = array();
                foreach ($zip->folders as $root ) {
                    $skipme = false;
                    foreach ($skipList as $skip ) {
                        if ( strpos( $root, $skip) !== false ) {
                            $skipme = true;
                            break;                            
                        }
                    }
                    if( $skipme )
                        continue;
                    
                    $dest = "";
                    $start = "";
                    if ( $root!="" )
                        $root .= DIRECTORY_SEPARATOR;
                    $create_fonts_link = false;
                    $check_access = true;
                    $files_only = false;
                    $newversion = true;
                    if ( in_array( $root."index.svg", $zip->content ) ) {
                        $dest = self::folder("project");
                        $start="index.svg";
                        $create_fonts_link = true;
                    } elseif ( in_array( $root."template.svg", $zip->content ) ) {
                        $dest = self::folder("template");
                        $start="template.svg";
                        $check_access = Yii::app()->user->checkAccess("model");
                    } elseif ( in_array( $root."skin.svg", $zip->content ) ) {
                        $dest = self::folder("layout");
                        $start="skin.svg";
                        $check_access = Yii::app()->user->checkAccess("model");
                    } elseif (  substr( $root, -8 ) == 'scripts'.DIRECTORY_SEPARATOR || 
                                substr( $root, -6 ) == 'skins'.DIRECTORY_SEPARATOR || 
                                substr( $root, -10) == 'templates'.DIRECTORY_SEPARATOR ) {
                        $dest = self::folder("");
                        $start=null;
                        $check_access = Yii::app()->user->checkAccess("model");
                        $files_only = true;
                    } elseif (  substr( $root, -6 )  == 'fonts'.DIRECTORY_SEPARATOR ) {
                        $dest = self::$contentpath;
                        $start=null;
                        $check_access = Yii::app()->user->checkAccess("model");
                        $files_only = true;
                        $newversion = false;
                    }
                    
                    //file_put_contents("/var/log/fusion/debug.log", "'".$root. "' => '" .$dest. "'\n", FILE_APPEND );
                    
                    if ( !$check_access ) {
                        $this->addError('file', Yii::t('app', "You don't have sufficient rights to upload this file")  );
                        continue;
                    }
                    if ( $dest!="" ) {
                        
                        $skipList[] = $root;
                        if ( !file_exists($dest) ) 
                            mkdir( $dest );
                        if ( $root=="" ) {
                            $n = $this->file->getName();
                            $dest .= substr( $n, 0, strpos($n, "." ) ) .DIRECTORY_SEPARATOR;
                        } else { 
                            $p = strrpos( $root, DIRECTORY_SEPARATOR, -2 );
                            if ( $p!==false )
                                $dest .= substr( $root, $p+1 );
                            else                            
                                $dest .= $root;
                        }                        
                        
                        $ok = false;
                        if ( $files_only  )  {
							if ( !file_exists($dest) ) 
                                mkdir( $dest );
                            $cnt = 0;
                            //file_put_contents("/var/log/fusion/debug.log", "rename(" .$tmpBase.$root. "(files), " .$dest. ")\n", FILE_APPEND );
                            if ( $handle = opendir( $tmpBase.$root ) ) {
                                while ( false !== ( $file = readdir($handle) ) ) {
                                    if ( in_array($file, array(".","..")) ) 
                                        continue;
                                    $f = $file;
                                    $fidx=1;
                                    while ( $newversion && file_exists($dest . $f) ) {
                                       $f = $file . " (".($fidx++).")";
                                    }
                                    $cnt++;
                                    if ( rename( $tmpBase.$root . $file, $dest . $f) )
                                        $ok = true;
                                    if ( !$ok ) {
                                        //file_put_contents("/var/log/fusion/debug.log", "error while rename(".$tmpBase.$root . $file.", ".$dest . $f.") \n", FILE_APPEND );
                                    }
                                }
                            } else
                                $ok = false;
                            if ( $cnt==0 ) {
                                //file_put_contents("/var/log/fusion/debug.log", "no files\n", FILE_APPEND );
                            }
                        } else {
                            
                            $f = $dest;
                            $fidx = 1;
                            while ( $newversion && file_exists($f) ) {
                               $f = substr( $dest,0, -1 ) . " (".($fidx++).")" . DIRECTORY_SEPARATOR;
                            }
                            //file_put_contents("/var/log/fusion/debug.log", "rename(" .$tmpBase.$root. ", " .$f. ")\n", FILE_APPEND );
                            $ok = rename( $tmpBase.$root, $f );
                            if ( !$ok ) {
                                //file_put_contents("/var/log/fusion/debug.log", "error\n", FILE_APPEND );
                            }
                        }
                        if ( $ok ) {
                            if ( $start!=null )
                                $this->uploaded[] = new FileItem( array("filepath"=>$dest.$root.$start ) );
                            else 
                                $this->uploaded[] = new FileItem( array('type'=>'script', 'name'=>$root) );
                            $gotindex=true;
                            if ( $create_fonts_link && file_exists($dest.$root.'fonts'.DIRECTORY_SEPARATOR) ) {
                                $d = substr( self::$contentpath."fonts".DIRECTORY_SEPARATOR.$root, 0, -1);
                                $this->saveSymlink($dest.$root.'fonts', $d);
                            }
                        } else {
                            if ( $zip->error )
                                $this->addError('file', $zip->error );
                        }
                    }
                }
                // step 3: cleanup
                $this->delTree( $tmpBase );
                
                if ( !$gotindex && !$this->hasErrors() ) {
                    // collection of media (we don't care about the strucutre in this case)
                    foreach ( self::$ext as $name => $extlist) {
                        $path=self::folder($name);
                        
                        $files = $zip->extractExtTo( $path, $extlist );
                        if ( $files===false ) {
                            $this->addError('file', $zip->error );
                        } else {
                            foreach ($files as $file ) {
                                $fileitem = new FileItem( array("filepath"=>$path.$file ) );
                                
                                if ( $fileitem->check() && $fileitem->resize() ) {
                                    $fileitem->preview();
                                    $this->uploaded[] = $fileitem;
                                } else {
                                    $fileitem->delete();
                                    $this->addError('file', $fileitem->name." : ".$fileitem->getError('file') );                                    
                                }
                            }
                        }
                    }
                }
                $zip->close();
                return count( $this->uploaded )>0 ;
            } else { 
                $this->setId(self::getIdfromName( self::getDisplayNameFromPath($this->file->getName(), $this->type), $this->type ) );
                $base = self::basenamepath( $this->getFilepath(), $path) ;
                if ( !file_exists($path) ) 
                    mkdir( $path ) ;
                $fidx = 1;
                $name = $this->file->getName();
                $posext = strrpos($name,'.');
                $basename = substr( $name, 0, $posext );
                $baseext = substr( $name, $posext );
                while ( file_exists( $this->getFilepath() ) ) {       
                    $name =  $basename . " (".($fidx++).")" . $baseext;                 
                    $this->setId(self::getIdfromName( self::getDisplayNameFromPath($name, $this->type), $this->type ) );
                }
                if ( !$this->file->saveAs( $this->getFilepath() ) ) 
                    return false;
                if ( !$this->check() ) {
                    $this->delete();
                    return false;
                }
                if ( $this->type=="image") {
                    if ( !$this->resize() ) {
                        $this->addError('file', Yii::t('app', "Image size is outside player specifications") );
                        $this->delete();
                        return false;
                    }
                    $this->preview();
                }
                $this->uploaded[] = $this;
                return true;
            }
        } else {
            return $this->rename();
        }
    }
    function saveSymlink($target, $link) {
        if ( isset($_ENV['OS']) && $_ENV['OS']=='Windows_NT' ) {
            if ($target[0]=='/')
                copy( $target, $link );
            else
                copy( dirname($link)."/".$target, $link );
            file_put_contents($link.".link", $target);
            return true;
        }
        if ( ! symlink($target, $link) ) {
            unlink($link);
            if ( ! symlink($target, $link) ) {
                return false;
            }
        }
        return true;
    }
    public function resize( $width=0, $height=0 ) {
        if ( $this->type!="image") return true; // nothing to do
        
        if (mb_substr($this->getFilepath(), -3)=="svg") 
            return true;
        $info = getimagesize($this->getFilepath());
        if ( $info===false ) 
            return true;
        
        if ( $width==0 || $height==0 ){
            if ( FileItem::getModel()=="Bonsai" ) {
                $width = $height = 2048;
            } else {
                $width = $height = 3072;
            }
        }
        //Yii::trace( print_r($info, true) );
        if ( $info['mime']=="image/png" || $info['mime']=="image/gif") {
            if ( $info[0]>$width ||$info[1]>$height || $info[0]*$info[1]>2048*2048 )// absolute hardware limits 
                return false;
            if ( filesize( $this->getFilepath() ) > 2*1024*1024 ) // 2M max file size
                return false;
            return true;               
        }
        if ( $info['mime']!="image/jpeg" )  {
            return true; // resize only jpeg
        }
        
        if ( $info[0]<=$width && $info[1]<=$height ) 
            return true;
        
        
        $base = self::basenamepath( $this->getFilepath(), $path  );
        
        $exe = "previewer";
        $base2 = "'" . str_replace("'", "'\\''", $base) . "'";
        $cmd = $exe." -r {$width}x{$height} -i {$path} -o {$path} ".$base2;
        
        exec( $cmd );
        if ( file_exists($path.DIRECTORY_SEPARATOR."resized_".$base) ) {
            if ( file_exists($path.DIRECTORY_SEPARATOR.$base) )
                unlink( $path.DIRECTORY_SEPARATOR.$base );
            return rename( $path.DIRECTORY_SEPARATOR."resized_".$base, $path.DIRECTORY_SEPARATOR.$base );
        }
        return false;
    }
    public function check( ) {
        if ( $this->type!="video") return true; // checking only video
        
        $base = self::basenamepath( $this->getFilepath(), $path  );
        
        $exe="cd /srv/raperca && raperca";
        if( PHP_OS == "WINNT" )
            $exe = "C:\\svn\\genesis\\trunk\\device\\debug\\raperca.exe";
        
        $myName = FileItem::getModelName();
        
        if ( $myName =="HMP200" ) {
            $model = 200;
        } elseif ( $myName =="HMP130" ) {
            $model = 130;
        } else
            $model = 100;
        
        if( PHP_OS != "WINNT" ) {
            $path = "'" . str_replace("'", "'\\''", $path) . "'"; // cannot use escapeshellarg() because UTF-8 encoding not supported
            $base = "'" . str_replace("'", "'\\''", $base) . "'";
        }
        $cmd = "$exe -mediacheck -t $model -d ".$path." ".$base;
        
        $output = array();
        exec( $cmd, $output, $ret );

        if ( $ret!=0 ) {
            $this->addError('file', Yii::t('app', 'An error occured while checking the format of the video.' ) );
            return false;
        }
        $result = json_decode( implode( "\n", $output ), FILE_APPEND );
        if ( $result === NULL )
            return true; // no check done
        if ( !isset( $result['ok'] ) ) { 
            $this->addError('file', Yii::t('app', 'An error occured while checking the format of the video.' ) );
            return false;
        } elseif ( $result['ok']==false ) {
            $this->addError('file', Yii::t('app', 'File format not supported' )." :\n".$result['error'] );
            return false;
        } elseif ( $result['ok']==true ) {
            // add the metadata for this file 
            $meta = $this->loadMeta();
            if ( !isset( $meta[ $this->name ] ) )
                $meta[ $this->name ] = array();
            $meta[ $this->name ]['description'] = $result['description'];
            $meta[ $this->name ]['dur'] = $result['dur'];
            $this->saveMeta( $meta );
        }
        return true;
    } 
    public function preview( ) {
        if ( $this->type!="image") return false; // no preview generated
        
		$base = self::basenamepath( $this->getFilepath(), $path  );
		
		if (mb_substr($base, -3)=="svg") { // svg
			$exe="cd /srv/raperca && raperca";
			if( PHP_OS == "WINNT" )
				$exe = "C:\\svn\\genesis\\trunk\\device\\debug\\raperca.exe";
            
            $base = mb_substr($path, strlen(self::$contentpath), mb_strlen($path, 'UTF-8'), 'UTF-8' )."/".$base ;
            $path = self::$contentpath;
			if( PHP_OS != "WINNT" ) {
                $path = "'" . str_replace("'", "'\\''", $path) . "'";// cannot use escapeshellarg() because UTF-8 encoding not supported
                $base = "'" . str_replace("'", "'\\''", $base) . "'";
            }
			$cmd = "$exe -preview -xh -d ".$path." -s 330x195 ".$base;
            
			exec( $cmd );
			
		} else {
			
			$exe = "previewer";
			if( PHP_OS != "WINNT" ) {
                $path = "'" . str_replace("'", "'\\''", $path) . "'";// cannot use escapeshellarg() because UTF-8 encoding not supported
                $base = "'" . str_replace("'", "'\\''", $base) . "'";
            }
			$cmd = $exe." -s 330x195 -xh -i {$path} -o {$path} ".$base;
			
			exec( $cmd );
		}
        return true;
        
    }
    
    protected function delTree($dir) {
        if (substr($dir,-1,1)=='/') $dir = substr($dir,0,-1);
        $alldel=true;
        if (!file_exists($dir)) 
            return true;
        if (!is_dir($dir) || is_link($dir)) 
            return unlink($dir);
        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '..' ) 
                continue;
            if ( $item == '.svn' ) {
                $alldel=false;    
                continue;
            }
            if (!$this->delTree($dir . "/" . $item)) 
                $alldel=false;    
        }
        if ( $alldel )
            return rmdir($dir);
        else 
            return $alldel; 
    } 
    
    // delete a file
    public function delete() {
        if ( $this->type=="project" || $this->type=="template" || $this->type=="layout" || $this->type=="slide" ) {
            
            if ( $this->type=="project" ){
                unlink( self::$contentpath."fonts".DIRECTORY_SEPARATOR.$this->name );
            }
            return $this->delTree( dirname($this->getFilepath()) );
        } else {
            if ( file_exists($this->getFilepathPreview()) ) 
                unlink( $this->getFilepathPreview() );
            $result;    
            if ( file_exists($this->getFilepath()) )
                $result = unlink( $this->getFilepath() );
            else 
                $result = true;
            if ( $result ){
                $meta = $this->loadMeta();
                if ( isset( $meta[ $this->name ] ) ) {
                    unset( $meta[ $this->name ] );
                    $this->saveMeta( $meta );
                }
            }
            return $result;
        }
    }
    
	public function copy() {
        if ( $this->name===false || $this->id===false ) return false;
        
        $path = $this->getFilepath();
        $old = self::getDisplayName( $this->id );
        
        if ( $old!=$this->name ) {
            if ( $this->type=="project" || $this->type=="template" || $this->type=="layout" || $this->type=="slide" ) {
				if ( !file_exists(dirname($path)) )
					return false;
                $new =  self::getPathToFile( $this->name, $this->type );
                CFileHelper::copyDirectory( dirname($path), dirname($new) );
                $id = self::getIdfromName( $this->name, $this->type );
                $this->setId( $id );
                return true;
            } else {
                $new =  self::getPathToFile( $this->name, $this->type );
                
                if ( file_exists($path) && copy( $path, $new ) ){
                    $oldPreview = $this->getFilepathPreview();
                    
                    $id = self::getIdfromName( $this->name, $this->type );
                    $this->setId( $id );
                    
                    if ( file_exists($oldPreview) ) copy( $oldPreview, $this->getFilepathPreview() );
                    
                    return true;
                } else
                    return false;
            }
        }
        return true;
    }

    public function rename() {
        if ( $this->name===false || $this->id===false ) return false;
            
        $path = $this->getFilepath();
        $old = self::getDisplayName( $this->id );
        
        if ( $old!=$this->name ) {
            if ( $this->type=="project" || $this->type=="template" || $this->type=="layout" || $this->type=="slide" ) {
                $new =  self::getPathToFile( $this->name, $this->type );
                if ( rename( dirname($path), dirname($new) ) ){
                    $id = self::getIdfromName( $this->name, $this->type );
                    $this->setId( $id );
                    return true;
                } else
                    return false;
            } else {
                $new =  self::getPathToFile( $this->name, $this->type );
                if ( file_exists($path) &&  rename( $path, $new ) ){
                    $oldPreview = $this->getFilepathPreview();

                    $id = self::getIdfromName( $this->name, $this->type );
                    $this->setId( $id );
                    
                    if ( file_exists($oldPreview) ) rename( $oldPreview, $this->getFilepathPreview() );
                    
                    return true;
                } else
                    return false;
            }
        }
        return true;
    }
    public function putMeta( $meta, $path=false ) {
		if ( $path===false )
			$path = self::folder();
			
		if ( substr($path, -1)!="/") $path.="/";
        
        //$fp=fopen("debug.log","a");
        //fwrite($fp, "save ".$path."\n" );
        //fwrite($fp, print_r($meta, true));
        if (!file_exists($path) )
			return false; // cannot save meta, folder do not exist.
        
        $dom = new DOMDocument;
        $main = $dom->appendChild( $dom->createElement("metadata") );
        $main->appendChild( $dom->createTextNode("\n") );
        
        //if ( !isset($meta['modified']) ) $meta['modified'] = false;
        
        foreach( $meta as $name=>$data ) {
            if ($data===false) $data="false";
            if ($data===true) $data="true";
            
            if ( is_array( $data ) ) {
                $node = $main->appendChild( $dom->createElement( "data" ) );
                $node->setAttribute("name", htmlspecialchars($name) );
                $node->setAttribute("type", "array" );
                foreach( $data as $n => $v){
                    $sub = $dom->createElement( "sub", htmlspecialchars($v) );
                    $sub->setAttribute("name", htmlspecialchars($n) );
                    $node->appendChild( $sub );
                }
            } else {
                $node = $main->appendChild( $dom->createElement( "data", htmlspecialchars($data) ) );
                $node->setAttribute("name", htmlspecialchars($name) );
                $node->setAttribute("type", "value" );
            }
            $main->appendChild( $dom->createTextNode( "\n" ) );
        }
        
        return file_put_contents( $path.self::$metadataName, $dom->saveXML() );   
	}
    public function saveMeta( $meta, $path=false ) {
        
        // meta data for the dest
        if ($path===false)
            $path = dirname( $this->getFilepath() )."/";
			
		self::putMeta( $meta, $path );
        
    }
    static function getMeta( $path=false ) {
		if ( $path===false )
			$path = self::folder();
		
		if ( substr($path, -1)!="/") $path.="/";
        
        $metadata = array();
        
        if ( !file_exists($path.self::$metadataName) ) return $metadata;
        
        $meta = file_get_contents( $path.self::$metadataName );
        if ( $meta===false || $meta=="" ) return $metadata;
        
        $dom = new DOMDocument;
        if ( $dom->loadXML( $meta )===false ) return $metadata;
        
        
        $list = $dom->documentElement->getElementsByTagName("data");
        for( $node=$dom->documentElement->firstChild; $node!=NULL ;$node=$node->nextSibling){
            //if ( $node->parentNode->localName=="metadata" )
            if ($node->nodeType!=XML_ELEMENT_NODE) continue;
            $subnodes=$node->getElementsByTagName("sub");
            if ( $subnodes->length==0 ){
                $val = trim($node->textContent);
                $name = trim(htmlspecialchars_decode($node->getAttribute('name')));
                if ( $val=="false") $val=false;
                if ( $val=="true") $val=true;
                $metadata[ $name ] = $val;
                
            }else foreach ( $subnodes as $subnode ) {
                $val = trim($subnode->textContent);
                $name = trim(htmlspecialchars_decode($node->getAttribute('name')));
                $name2 = trim(htmlspecialchars_decode($subnode->getAttribute('name')));
                if ( $val=="false") $val=false;
                if ( $val=="true") $val=true;

                $metadata[ $name ][ $name2 ] = $val;
            }
            
        }
        
        //$fp=fopen("debug.log","a");
        //fwrite($fp, "load ".$path."\n" );
        //fwrite($fp, print_r($metadata, true));
        
        return $metadata;
	}
    public function loadMeta( $path=false ) {
    
        if ($path===false)
            $path = dirname( $this->getFilepath() )."/";
        
		return self::getMeta( $path );
        
    }
    
    static function getModel() {
        $cpuinfo=file_get_contents("/proc/cpuinfo");
        $model = "Bonsai";
    	if (preg_match("/Hardware\W+:\s+(\w+)/",$cpuinfo,$match)){
            $model = $match[1];
        }
        return $model;
    }
    static function getModelName() {
        $branding_file="/usr/share/resources/default/interface/branding.php";
        if ( file_exists($branding_file) ){
	        include $branding_file;
            return $product;
        } else 
            return "HMP100";
    }
    static function getVersion() {
        $firmware = "x.x.x";
        $build = "x.x.x";
        if ( file_exists('/etc/spinetix-release') ) {
            $release = file_get_contents('/etc/spinetix-release');
            $vals=explode(" ", $release);
            if (count($vals)==6 ){
                $firmware = $vals[3];
                $build = $vals[5];
            }
            echo CHtml::tag("span", array('class'=>'firmware'), "v ".$firmware. " - ".$build);
        }
        return array( 'firmware'=>$firmware, 'build'=>$build  );
    }
    static function compareVersion( $f1, $f2) {
        $f1a = explode(".", $f1 );
        $f2a = explode(".", $f2 );
        $n = count($f1a);
        if ( $n<count($f2a) )        
            $n = count($f2a);
            
        for ( $i=0; $i<$n; $i++ ){
            if ( isset( $f1a[$i] ) )
                $f1a[$i] = intval($f1a[$i]);
            else
                $f1a[$i] = -1;
        }
       
        $f2a = explode(".", $f2 );
        for ( $i=0; $i<$n; $i++ ){
            if ( isset( $f2a[$i] ) )
                $f2a[$i] = intval($f2a[$i]);
            else
                $f2a[$i] = -1;
        }
        
        for ( $i=0; $i<$n; $i++ ){
            if ( $f1a[$i]<$f2a[$i] )
                return -1;            
            if ( $f1a[$i]>$f2a[$i] )
                return 1;            
        }
        return 0;
    }
}

class qqUploadedFileXhr {
    /**
     * Save the file to the specified path
     * @return boolean TRUE on success
     */
    protected $tempname = false;
    function saveAs($path) {
        if ( $this->tempname===false ){
            // direct
            $input = fopen("php://input", "r");
            $temp = fopen($path, "w");
			while ($data = fread($input, 8192))
				fwrite($temp, $data);
			
            fclose($input);
            fclose($temp);
        } else {
            rename($this->tempname, $path);
        }
        
        return true;
    }
    function getName() {
        return $_GET['qqfile'];
    }
    function getSize() {
        if (isset($_SERVER["CONTENT_LENGTH"])){
            return (int)$_SERVER["CONTENT_LENGTH"];            
        } else {
            return 0;
        }      
    }   
    function getExtensionName(){
        $name = $this->getName();
        $pos=mb_strrpos($name, '.', 'UTF-8' );
        if ( $pos===false )
            return "";
        return $ext = mb_substr($name, $pos+1, mb_strlen($name, 'UTF-8'), 'UTF-8' );
        
    }
    function getTempName() {
        if ( $this->tempname===false ) {
            if ( !file_exists("/var/tmp/fusion") )
                mkdir("/var/tmp/fusion");
            //$this->tempname="/var/tmp/fusion/".uniqid("ajx").".tmp";
            $name = "/var/tmp/fusion/test.zip";
            $this->saveAs($name);
            $this->tempname=$name;
        }
        return $this->tempname;
    }
}

/**
 * Handle file uploads via regular form post (uses the $_FILES array)
 */
class qqUploadedFileForm {  
    /**
     * Save the file to the specified path
     * @return boolean TRUE on success
     */
    function saveAs($path) {
        if(!move_uploaded_file($_FILES['qqfile']['tmp_name'], $path)){
            return false;
        }
        return true;
    }
    function getName() {
        return $_FILES['qqfile']['name'];
    }
    function getSize() {
        return $_FILES['qqfile']['size'];
    }
    function getExtensionName(){
        $name = $this->getName();
        $pos=mb_strrpos($name, '.', 'UTF-8' );
        if ( $pos===false )
            return "";
        return $ext = mb_substr($name, $pos+1, mb_strlen($name, 'UTF-8'), 'UTF-8' );
        
    }
    function getTempName() {
        return $_FILES['qqfile']['tmp_name'];
    }
}
