<?php
class BaseFiles{
    static function skin(){
        return <<<EOL
<?xml version="1.0" encoding="UTF-8"?>
<svg xmlns="http://www.w3.org/2000/svg" xmlns:spx="http://www.spinetix.com/namespace/1.0/spx" xmlns:xlink="http://www.w3.org/1999/xlink" dur="indefinite" >
 <spx:properties><spx:media name="Main media" positionable="yes" ui="main" xlink:href="#media"/></spx:properties>
 <animation preserveAspectRatio="xMidYMid" xml:id="media" xlink:href="/fusion.svg" repeatDur="indefinite"/>
 <script>
 function scale() {
    document.getElementById('media').setAttribute('width', document.documentElement.viewport.width);
    document.getElementById('media').setAttribute('height', document.documentElement.viewport.height);
 };
 document.documentElement.addEventListener( 'resize', scale, false );
 scale();
</script>
</svg>
EOL;
    }

    static function index( $href ) {
        return "<?xml version='1.0'?>
<svg xmlns='http://www.w3.org/2000/svg'>
<animation xmlns:xlink='http://www.w3.org/1999/xlink' xlink:href='$href' xml:id='media'/>
 <script>
 function scale() {
    document.getElementById('media').setAttribute('width', document.documentElement.viewport.width);
    document.getElementById('media').setAttribute('height', document.documentElement.viewport.height);
 };
 document.documentElement.addEventListener( 'resize', scale, false );
 scale();
</script>
</svg>";
    }

    static function theme() {
        return "// Javascript variables used in the slides templates
// title Main scheme setup
// Format: var name='value'; // type description
// type = 'color', 'text', 'textarea', 'image', 'animation'
";
    }

}
class LayoutItem extends SlideItem
{
    public static $layoutPath = "index/main/"; // must be the same structre as for the slides
    private static $builtinFullscreenId = "layout:built-in:fs";
    
    function __construct($attributes=array ( ), $scenario='init') {
        $attributes["type"] = "layout";
        parent::__construct($attributes, $scenario);
        if ( !isset( $attributes["id"] ) ) {
            $this->_id='index';
            $this->name='index';
            $this->_filepath= self::folder("").self::$layoutPath.'skin.svg';
            $this->_webpath= self::webfolder("").self::$layoutPath.'skin.svg';
            $this->_linkpath= self::$rootpath.self::$layoutPath.'skin.svg';
        }
        //$this->enablepreview = false;
    }
    
    function createBasefiles() {
        if ( !file_exists( self::folder().self::$layoutPath ) ) {
            if ( !file_exists( self::folder()."index" ) )
                mkdir( self::folder()."index");
            self::createBuiltIn( );
            
        }
        // need to create a theme layout if it doesn't exist
        $theme = self::folder().self::$layoutThemePath;
        if ( !file_exists( $theme ) ) {
            if ( !file_exists( dirname($theme) ) )
                mkdir( dirname($theme));
            file_put_contents( $theme, BaseFiles::theme() );            
        }
        // need to create the index file in all cases, because it cannot be modified by the user
        $href = self::$rootpath.self::$layoutPath.'skin.svg';
        
        file_put_contents( self::$contentpath."index.svg", BaseFiles::index($href) );
    }
    
    public function attributeLabels()
	{
		return array(
            'source'=>'Layout',
		);
	}
    
    public static function findAll( $criteria=false, $countOnly=false ) {
        $res = array();
        $res[] = new LayoutItem;
        return $res;
    }

    protected function pathToFolder() {
        return self::folder("").self::$layoutPath;
    }
    protected function pathToLinkFolder() {
        return self::$layoutPath;
    }
	public function setId( $id ) {
		if ($id=="index")
			$this->updateId();
		else return parent::setId( $id );
	}
    protected function updateId() {
        $this->_id='index';
        $this->name='index';
        $this->_filepath= self::folder("").self::$layoutPath.'skin.svg';
        $this->_webpath= self::webfolder("").self::$layoutPath.'skin.svg';
        $this->_linkpath= self::$rootpath.self::$layoutPath.'skin.svg';
    }
    public static function isBuiltIn( $id ) {
        return $id==self::$builtinFullscreenId ;
    }
    public function getLayoutList() {
        $crit = new CDbCriteria;
		$crit->condition = "type=:type";
		$crit->params = array( ":type"=>"layout" );
        $layouts = FileItem::findAll($crit);
    
        if ( count($layouts)>0 ) {
            // add a built-in fullscreen layout
            $fs = new FileItem( array( 'id' => self::$builtinFullscreenId, 'name' => Yii::t('app','Fullscreen') ) );
            array_unshift($layouts, $fs);
        }
        //Yii::trace( print_r($layouts, true) );
        return $layouts;
    }
    static function createBuiltIn() {
        $path = self::folder().self::$layoutPath;
        if ( !file_exists( $path  ) )
            mkdir( $path  );
        
        file_put_contents( $path."skin.svg", BaseFiles::skin() );
        
        self::putMeta( array( "source"=>array("id"=>self::$builtinFullscreenId, 
                                                "name"=> Yii::t('app','Fullscreen'), 
                                                "path"=> self::folder().self::$layoutPath,                                         
											)
							),
                            $path
                    );
    }
    public function create( $replace=true ) {
        if ( $this->id!=self::$builtinFullscreenId  ) 
            return parent::create( $replace );
            
        self::createBuiltIn();
        
        $this->updateId();
        
        return true;
    }
    public function getFields() {
        if ( $this->_fields===false )
            $process = true;
        else
            $process = false;
            
        parent::getFields();
        
        if ( $process ) {
            $hasTheme = false;
            $restitle = new TemplateEntry;
            $restitle->type='file';
            $restitle->id=self::$layoutThemePath;

            // add the theme setup
            $theme = file_get_contents( self::folder().self::$layoutThemePath );
            foreach (explode("\n", $theme) as $line ) {
                if ( preg_match("|^\s*//\s*title\s+(.*)|", $line, $matches) ){
                    $hasTheme = true;
                    $restitle->name = trim($matches[1]);
                    $this->_fields[]=$restitle;
                }
                if ( preg_match("|^\s*var\s+([^=]+)=([^;]+);\s*//\s*(\S+)\s+(.*)|", $line, $matches) ){
                    $res = new TemplateEntry;
                    $res->id ='_theme_js_';
                    $res->attrib = trim($matches[1]);
                    $res->name = trim($matches[4]);
                    $res->type = trim($matches[3]);
                    $res->value = trim($matches[2]);
                    if ( $res->value[0]=="'" || $res->value[0]=="\"" )
                        $res->value = substr($res->value, 1, -1);
                        
                    if ( $res->type=='animation' || $res->type=='image' || $res->type=='video' ){
                        $file = new FileItem(array("linkpath" => $res->value ) );
                        $res->value = $file->id;
                    }
                    if ( $res->type=="yesno" || $res->type=="yesnoinherit" || $res->type=="fonts" ) {
						$res->choice = $res->type;
						$res->type = "choice";
					}   
                    if (!$hasTheme) {
                        $hasTheme = true;
                        $restitle->name ="Theme default values";
                        $this->_fields[]=$restitle;
                    }
                    
                    $this->_fields[]=$res;
                }
            }
        }        
        
        return $this->_fields;
        
        
    }
    
    protected function saveFile( $name, $data ) {
		if ( strstr($name, self::$layoutThemePath) === false ) 
            return parent::saveFile( $name, $data );

        // get the old file
        $theme = file_get_contents( self::folder().self::$layoutThemePath );
        
        while ( count($data)>0 && $data[0]->type!='file' ){
            $item = array_shift( $data );
            if ( $item->type=='animation' || $item->type=='image' || $item->type=='video' ){
                $file = new FileItem( array('id'=>$item->value) );
                $val = self::$baseTemplates.$file->linkpath;
            }else 
                $val = $item->value;
            $theme = preg_replace("|var\s+".$item->attrib."[^=]*=[^;]+;|", "var ".$item->attrib." = '".$val."';", $theme);
        }
        
        file_put_contents( self::folder().self::$layoutThemePath, $theme );
    }
    
    public function saveSlide( $dom, $name ) {
        
        $meta = $this->loadMeta();
        if ( isset( $meta['program'] ) )
            $program_id = $meta['program'];
        else
            $program_id = "slideshow:main";
        
		// need to fix the main media to point to the main program
        $hasMedia = false;
        $params = $dom->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "properties");
		
        foreach( $params as $param ) {
            $medias = $param->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "media");
			
            foreach ($medias as $entry) {
				
                if ( $entry->getAttribute( "ui" )!="main" ) continue;
                $id = substr( $entry->getAttributeNS("http://www.w3.org/1999/xlink","href"), 1 );
                $dest = $dom->getElementById( $id );
                if ( $dest===null ) continue;
                $media = $dest;
                if ( $dest->localName=="g" ) { // resolving text with background
                    for ( $tmp=$dest->firstChild; $tmp!=null; $tmp=$tmp->nextSibling )
                        if ( $tmp->localName=="textArea" || $tmp->localName=="rect" ){
                            $media = $tmp;
                            break;
                        }
                }
                $keepThis = array( "width", "height", "x", "y", "transform", "preserveAspectRatio", "id", "xml:id" );
                
                $anim = $dom->createElement("animation");
                foreach ($keepThis as $attrib) {
                    if ( $dest->getAttribute( $attrib )!="" )
                        $anim->setAttribute( $attrib, $dest->getAttribute( $attrib ) );
                    elseif ( $media->getAttribute( $attrib )!="" )
                        $anim->setAttribute( $attrib, $media->getAttribute( $attrib ) );
                    
                }
                $dest->parentNode->replaceChild( $anim, $dest );
				
                $file = new FileItem(array("id" => $program_id) );
                $anim->setAttributeNS( "http://www.w3.org/1999/xlink", "xlink:href", self::$baseTemplates.$file->linkpath);
                
                $hasMedia = true;                
            }
        }
        
        return file_put_contents( $name, $dom->saveXML() );
        
    }    
    
    function getProgramId() {
        $meta = $this->loadMeta();
        if ( isset( $meta['program'] ) )
            $program_id = $meta['program'];
        else
            $program_id = "";
        return $program_id ;
    }
    
    function changeProgramId( $id, $preview=true ) {
        if ( !$preview )
            $this->enablepreview = false; // do not recompute the preview of the skin each time
        // update meta data first
        $meta = $this->loadMeta();
        $meta['program'] = $id;
        $this->saveMeta( $meta );
        
		
        /// load and save the layout
        $this->setFields( $this->getFields() );
		$ret = $this->save();
        if ( $ret )
            touch( self::$contentpath."index.svg" );
        return $ret;
    }
    
}