<?php

class Playlist extends FileItem
{
    protected $_playlist=false;
    
    public $defaultItemDur="00:00:10";
    public $maxItemDur="00:00:00";
    public $interDur="00:00:00";
    public $animDur="00:00:00";
    public $animPrefix="none";
    public $animDir=false;
    public $loop="on";
    public $shuffle="off";
	public $mediaFit="meet";
	public $proofofplay=false;
    public $info = false;
    public $control = false;
    
    static $config = array( 'animPrefix', 'animDir', 'loop', 'shuffle', 'mediaFit', 'proofofplay', 'info', 'control' );
    static $confdur = array('defaultItemDur', 'maxItemDur', 'interDur', 'animDur');
    function __construct($attributes=array ( ), $scenario='init') {
        if ( !isset($attributes["id"] ) && !isset($attributes["type"] ) )
            $attributes["type"] = "playlist";
        parent::__construct( $attributes, $scenario );
        
    }
    
     public function rules() {
		$res = array(
            array( implode(",", self::$config), 'safe', 'on'=>'load, Save, SaveAs, Create' ),
            array( implode(",", self::$confdur), 'safe', 'on'=>'load, Save, SaveAs, Create' ),
            array( "id", 'safe', 'on'=>'Save, SaveAs' ),
            //array( 'type', 'safe', 'on'=>'SaveAs' ),
            array( 'name', 'required', 'on'=>'SaveAs, Create' ),
            array('defaultItemDur', 'match', 'pattern' =>"/^[0-9]{2,}:[0-5][0-9]:[0-5][0-9]$/", 'on'=>'Save, SaveAs, Create' ),            
            array('defaultItemDur', 'safe', 'on'=>'load' ),            
    	);
        return array_merge($res, parent::rules() );
	}
   	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
            'defaultItemDur'=>Yii::t('app','Default Duration'),
            'maxItemDur'=>Yii::t('app','Max. Media Duration'),
            'interDur'=>Yii::t('app','Intermediate Duration'),
            'animDur'=>Yii::t('app','Duration'),
            'shuffle'=>Yii::t('app','Shuffle'),
			'mediaFit'=>Yii::t('app','Media Fit'),
			'proofofplay'=>Yii::t('app','Proof of Play'),
			'animPrefix'=>Yii::t('app','Type'),
            'animDir'=>Yii::t('app','Transition Direction'),
            'playlist' => Yii::t('app','Playlist Name')
		);
	}
    public function toSec( $dur ) {
        $val = explode(":", $dur);
        if (count($val)==1)
            return $val[0];
        elseif (count($val)==2)
            return $val[0]*3600+$val[1]*60;
        elseif (count($val)==3)
            return $val[0]*3600+$val[1]*60+$val[2];
    }
    public function toHMS( $dur ) {
        $s = intval($dur);
        $h = floor($s/3600);
        $s -= $h*3600;
        if ($h<10)
            $h = "0".$h;
        $m = floor($s/60);
        $s -= $m*60;
        if ($m<10)
            $m = "0".$m;
        if ($s<10)
            $s = "0".$s;
        
        return $h.":".$m.":".$s;
    }

    
    // static function to get one playlist
    public static function find( $criteria=false ) {
        $files = FileItem::findAll( $criteria  );
        if ( count($files)>=1 )
            return $files[0];
        else return NULL;
    }
    
    // static function to count the number of playlist
    public static function count( $criteria=false ) {
        return count( FileItem::findAll( $criteria  ) );
    }
    
    // static function to get all playlist
    public static function findAll( $criteria=false, $countOnly=false ) {
        $files =  array();
        
        $options = array();
        
        $type="playlist"; // default
        
        $nameFilter = "";
        if ( $criteria!==false && $criteria->condition!="") {
            // support only type=:type
            $conditions = explode("AND", $criteria->condition);
            
            foreach ($conditions as $con) {
                $c = explode("=", trim($con));
                if ( count($c)==2 ) {
                    if ( $c[1][0]==":" ) 
                        $val = $criteria->params[$c[1]];
                    else
                        $val = $c[1];
                    if ( $c[0]=="type" ) $type = $val;
                    if ( $c[0]=="exclude" ) $options['exclude'][] = $val;
                    if ( $c[0]=="name" ) $nameFilter = $val;
                }
            }
        }
        $options['level']=0;
        $options['fileTypes']=array('xml');
        if ( file_exists(self::folder($type)) )
            $files = CFileHelper::findFiles( self::folder($type), $options );
        else 
            $files = array();
        
        if ( $criteria!==false )
            $files = array_slice( $files, $criteria->offset>=0?$criteria->offset:0, $criteria->limit>=0?$criteria->limit:count($files) );
        
        if ( $nameFilter!="" ) {
            $nameFilter = preg_replace("/*/", ".*", $nameFilter);
            $new_files = array();
            foreach ( $files as $file ) {
                if ( preg_match("/".$nameFilter."/", basename( $file ) ) ) 
                    $new_files[] = $file;
            }
            $files = $new_files;
        }
        $results = array();
        foreach ( $files as $file ) {
            $f = new Playlist( array('filepath'=>$file ) );
            $results[]=$f;
        }
        
        
        return $results;
    }
    
    function getPlaylist() {
        if ( $this->filepath===false )
            return array();
        if ( $this->_playlist===false ) {
           
            
            if ( !file_exists($this->filepath) )
                return array();
                
            // load the playlist
            $data = file_get_contents( $this->filepath );
            if ( $data===false || $data=="" ) return array();
            
            $dom = new DOMDocument;
            if ( $dom->loadXML( $data )===false ) return array();
        
            $this->_playlist = array();
                
            for ( $row=$dom->documentElement->firstChild; $row!=null; $row=$row->nextSibling ) {
                if ( $row->localName=="item" ) {
                    $items = array();
                    for ( $col=$row->firstChild; $col!=null; $col=$col->nextSibling ) {
                        $items[$col->localName]=$col->textContent;
                    }
                    //$items['uri'] = urldecode($items['uri']);
                    if ( strpos( $items['uri'], FileItem::$basePlaylist )===0 )
                        $items['uri'] = substr( $items['uri'], strlen( FileItem::$basePlaylist ) );

                    //$plitem = new PlaylistItem( array("linkpath"=>trim($items['uri']), "svgdur" => trim($items['dur']) ) );
                    $plitem = new PlaylistItem( array("linkpath"=>trim($items['uri']) ) );
                    
                    $attribs = array();
                    if ( isset( $items['dur'] ) ) $attribs["svgdur"] = trim($items['dur']);
                    
                    if ( isset( $items['metaname'] ) ) $attribs["metaname"] = htmlspecialchars_decode($items['metaname']);
                    
                    if ( isset( $items['validity-start'] ) ) $attribs["validityStart"] = $items['validity-start'];
                    if ( isset( $items['validity-start'] ) ) $attribs["validityStart"] = $items['validity-start'];
                    if ( isset( $items['validity-end'] ) ) $attribs["validityEnd"] = $items['validity-end'];
                    if ( isset( $items['time-start'] ) ) $attribs["timeStart"] = $items['time-start'];
                    if ( isset( $items['time-end'] ) ) $attribs["timeEnd"] = $items['time-end'];
                    if ( isset( $items['valid-days'] ) ) $attribs["validDays"] = $items['valid-days'];
                    
                    $plitem->setAttributes( $attribs );
                    
                    $this->_playlist[] = $plitem;

                } else if ( $row->localName=="config" ) {
                    $params = array();
                    for ( $col=$row->firstChild; $col!=null; $col=$col->nextSibling )
                        $params[$col->localName]=$col->textContent;
                    foreach( self::$confdur as $name )
                        if (isset($params[$name ]) )
                            $params[$name ] = $this->toHMS($params[$name ]);
                    $this->setScenario( "load" );
                    $this->setAttributes( $params );
                }
            }
            
        } 
        return $this->_playlist;
    }
    
    function setPlaylist( $playlist ) {
        $this->_playlist = array();
        foreach ( $playlist as $item ) {
            if ( !($item->id===false) ) {
                $this->_playlist[] = $item;        
            }
        }
    }

    public function save( ) {

        if ( !file_exists( self::folder($this->type) ) )
            mkdir( self::folder($this->type) );
            
        // check if we are renaming an allready uploaded file    
        if ( $this->scenario!="SaveAs" ) 
            parent::rename();
        else
            parent::copy();
               
        $meta=$this->loadMeta();
        $meta[$this->id] = array();
        
        // save the new playlist
        $dom = new DOMDocument;
        $rss = $dom->appendChild( $dom->createElement("rss") );
        $rss->appendChild( $dom->createTextNode("\n") );
        
        // add the config
        $config = $rss->appendChild( $dom->createElement("config") );
        $config->appendChild( $dom->createTextNode("\n") );
        foreach ( self::$config as $name ){
            if ( $this->$name!==false ) {
                $config->appendChild( $dom->createElement($name, $this->$name) );
                $config->appendChild( $dom->createTextNode("\n") );
            }
        }
        foreach ( self::$confdur as $name ){
            if ( !($this->$name===false) ) {
                $config->appendChild( $dom->createElement($name, $this->toSec($this->$name)) );
                $config->appendChild( $dom->createTextNode("\n") );                
            }
        }
        if ( !($this->defaultItemDur===false) ) {
            
        }
        $rss->appendChild( $dom->createTextNode("\n") );
        // add the media
        
        if ( !($this->_playlist===false) ) {
            foreach ($this->_playlist as $n=>$item) {
            
                $meta[$this->id][] = $item->getWebpathPreview();
                
                $xmlitem = $rss->appendChild( $dom->createElement("item") );
                $xmlitem->appendChild( $dom->createElement("uri", FileItem::$basePlaylist.$item->linkpath ) );
                $xmlitem->appendChild( $dom->createElement("dur", $item->svgdur) );
                $xmlitem->appendChild( $dom->createElement("type", $item->type) );
                if ( $item->metaname!=Yii::t('app', "Media")." ".$n )
                    $xmlitem->appendChild( $dom->createElement("metaname", htmlspecialchars($item->metaname)) );
                if ( $item->validityStart!="" ) $xmlitem->appendChild( $dom->createElement("validity-start", $item->validityStart) );
                if ( $item->validityEnd!="" ) $xmlitem->appendChild( $dom->createElement("validity-end", $item->validityEnd) );
                if ( $item->timeStart!="" && $item->timeStart!="00:00:00" ) $xmlitem->appendChild( $dom->createElement("time-start", $item->timeStart) );
                if ( $item->timeEnd!="" && $item->timeEnd!="24:00:00" ) $xmlitem->appendChild( $dom->createElement("time-end", $item->timeEnd) );
                if ( $item->validDays!="" ) $xmlitem->appendChild( $dom->createElement("valid-days", $item->validDays) );
                $rss->appendChild( $dom->createTextNode("\n") );
            }
            
            if ( file_put_contents( $this->filepath, $dom->saveXML() )===false ) return false;
            // create a preview of the playlist:
            
            $newImage = imagecreatetruecolor(160, 90);
            imagefill( $newImage , 0, 0, imagecolorallocate( $newImage, 129, 129, 129 ) );
            //imagefilledrectangle  ( $newImage , 24, 13, 152, 85, imagecolorallocate( $newImage, 40, 40, 40 ) );
            //imagefilledrectangle  ( $newImage , 16, 9, 144, 81, imagecolorallocate( $newImage, 215, 215, 215 ) );
            //imagefilledrectangle  ( $newImage , 8, 4, 136, 76, imagecolorallocate( $newImage, 40, 40, 40 ) );
            //imagefilledrectangle  ( $newImage , 0, 0, 132, 72, imagecolorallocate( $newImage, 215, 215, 215 ) );
            if ( count($this->_playlist)>0 ) {
                $item = $this->_playlist[0];
                $img = $item->getFilepathPreview();
                if ( !file_exists( $img ) )
                    $img = $item->getFilepathDefaultPreview();
            } else
                $img = $item->getFilepathDefaultPreview();
            if ( file_exists( $img ) ) {
                $info = getimagesize( $img );
                $image = imagecreatefrompng( $img );
                if ( $image !== false ) {
                    $width = $info[0]*90/$info[1];
					if ( $width>160 ){
						$width=160;
						$height=$info[1]*160/$info[0];
					}else{
						$height=90;
					}
					
                    //imagecopyresampled( $newImage, $image, (160-$width)/2 , 0, 0, 0, $width-32, 72, $info[0], $info[1] );
					imagecopyresampled( $newImage, $image, (160-$width)/2, (90-$height)/2, 0, 0, $width, $height, $info[0], $info[1] );
                }
            }
            
            if ( !imagepng( $newImage, $this->getFilepathPreview() ) ) return false;
        }
        
        $this->saveMeta( $meta );
        
        return true;
    }
}