<?php

class SlideItem extends FileItem
{
    public $enablepreview = true;
    protected $_fields=false;
    protected $_source=false;
    protected $_sourcename=false;
	protected $_templatepreview=false;
    protected $newtype='slide';
    
    protected $docPosition = Array();
    public $itemPerPage=0;
	public $viewBox="";
    protected $currentViewBox;
    protected $filePosition;
	
	protected $previews=array();
    
	public $datafeedsentries=false;
	
    function __construct($attributes=array ( ), $scenario='init') {
        if ( !isset($attributes["type"]) &&  !isset($attributes["id"]) ) $attributes["type"] = "slide"; // might be overwritten if the Id says we are a template 
        parent::__construct($attributes, $scenario);
    }
    
    public function attributeLabels()
	{
		return array(
            'source'=>Yii::t('app','Template source'),
		);
	}
    
    /*
    public function getWebpathPreview() {
        if ($_source===false) return parent::getWebpathPreview();
        
        $filepath = FileItem::getPathToFile($this->_source, "template" );
        $path = FileItem::getPathToLink($this->_source, "template" );
        if ( file_exists( dirname($filepath)."/.preview.".basename($filepath).".png" ) )
            return dirname($path)."/.preview.".basename($path).".png";
        else
            return self::$previewPath.$this->type.".png";
    }
    */
    
    public static function findAll( $criteria=false, $countOnly=false ) {
        if ( $criteria===false ) {
            $criteria = new CDbCriteria;
            $criteria->condition = "type=:type";
            $criteria->params = array( ":type"=>"slide" );
        } else {
            if ( $criteria->condition && $criteria->condition!="" ) {
                $criteria->condition = $criteria->condition." AND type=:type";
                $criteria->params[":type"] = "slide";
            } else {
                $criteria->condition = "type=:type";
                $criteria->params = array( ":type"=>"slide" );
            }
        }
        return FileItem::findAll( $criteria ) ;
    }
    public function getDatafeedsEntries( $table, $dom ) {
		if ( $table->getAttribute( "ui" )!="datafeed" ) return false;
		// new data feeds for this table
		$entries = array();;
		for ( $item=$table->firstChild; $item!=null; $item=$item->nextSibling ) {
			if ( $item->nodeType==XML_ELEMENT_NODE ) {
				$entry = array();
				$entry['name'] = $item->getAttribute("name");
				$entry['element'] = $item->getAttribute("element");
				$entry['type'] = $item->getAttribute("ui-type");
				if ( $entry['type']=="" ) $entry['type']="text";
				if ( $entry['type']=='image' || $entry['type']=='video' || $entry['type']=='animation') {
					$medias = $dom->getElementsByTagName($entry['type'] );
					foreach ($medias as $media) {
						$href = $media->getAttributeNS("http://www.w3.org/1999/xlink","href");
						if ( strpos($href, "[SPX][".$entry['element']."]")!==false ){
							$entry['position'] = implode(" ",$this->getPostion($media));
							break;
						}
					}
				}
				$entries[] = $entry;
			}
		}
		return $entries;
	}
    protected function createFile( $name, $pathin, $pathout ) {
    
        $template = file_get_contents( $pathin.$name );
        if ( $template===false || $template=="" ) return false;
        
        $dom = new DOMDocument;
        if ( $dom->loadXML( $template )===false ) return false;
        // must fix the ids of the doc
        foreach ($dom->getElementsByTagName('*') as $element) {
            if ($element->hasAttribute('id')) {
                $element->setIdAttribute('id', true);
            }
        }

        // fixing the paths
        $destlink = self::$baseTemplates.$this->pathToLinkFolder();
        $dom->documentElement->setAttribute("xml:base", self::$baseTemplates.$this->linkpath);
        // saving all the default location for the media
        $tags = array("image", "video", "audio", "animation");
        foreach ($tags as $tag){
            $medias = $dom->getElementsByTagName( $tag );
            foreach ($medias as $media) {
                $href = $media->getAttributeNS("http://www.w3.org/1999/xlink","href");
				$media->setAttributeNS("http://www.spinetix.com/namespace/1.0/spx", "spx:default-href", $href );
                if ( strchr($href, "/")===false && pathinfo($href, PATHINFO_EXTENSION)=="svg" ){
                    // this svg will be moved, need to change the reference to the new path
                    $href = $destlink.$href;
                    $media->setAttributeNS("http://www.w3.org/1999/xlink","href", $href );
					$media->setAttributeNS("http://www.spinetix.com/namespace/1.0/spx", "spx:local", "true" );
                }
            }
        }
        // fixing the path for json based layout and playlist
        $tables = $dom->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "json-array");
        foreach ($tables as $entry ) {
            //file_put_contents("/var/log/fusion/debug.log", "Table\n", FILE_APPEND );
            $changed = false;
            $id = substr( $entry->getAttributeNS("http://www.w3.org/1999/xlink","href"), 1 );
            $table = $dom->getElementById( $id );
            if ( $table===null ) continue;
            $json = json_decode( $table->textContent, true );
            $idx = 0;
            foreach ($json as $media ) {
                //file_put_contents("/var/log/fusion/debug.log", $media['ctor'] . "\n", FILE_APPEND );
                if ( $media['ctor']=="media" || $media['ctor']=="animation" || $media['ctor']=="image" || $media['ctor']=="video" || $media['ctor']=="audio" ) {
                    $href = $media['args']['href'];
                    $json[$idx]['args']['defaultHref'] = $href;
                    $changed = true;
                    //file_put_contents("/var/log/fusion/debug.log", $href . "\n", FILE_APPEND );
                    if ( strchr($href, "/")===false && pathinfo($href, PATHINFO_EXTENSION)=="svg" ){
                        // this svg will be moved, need to change the reference to the new path
                        $href = $destlink.$href;
                        //file_put_contents("/var/log/fusion/debug.log", $href . "\n", FILE_APPEND );
                        $json[$idx]['args']['href'] = $href ;
                        $json[$idx]['args']['local'] = true;
                    }
                }
                if ( $media['ctor']=="animation" ) {
                    $json[$idx]['ctor'] = "media"; // using the more generic term to use the right type of media depending n the extension
                    $changed = true;
                }
                $idx++;
            }
            if ( $changed  ) {
                $table->nodeValue = "";
                $table->appendChild( $dom->createCDATASection ( json_encode($json) ) );
            }            
        }
        
        // create a datafeeds for the tables
        $tables = $dom->getElementsByTagNameNS( "http://www.spinetix.com/namespace/1.0/spx", "table" );
        foreach ($tables as $table) {
			$entries = $this->getDatafeedsEntries( $table, $dom );
            if ( $entries===false ) continue;
            
            // data ?
                
            $id = substr($table->getAttributeNS( "http://www.w3.org/1999/xlink", "href" ), 1);
            $itemElement = $table->getAttribute( "itemElement" );
            $datatable = $dom->getElementById( $id );
            if ( $datatable!=NULL ) {
                $data = array();
                for ( $item=$datatable->firstChild; $item!=null; $item=$item->nextSibling ) {
                    if ( $item->localName==$itemElement ) {
                        $dataItem = array();
                        for ( $elem=$item->firstChild; $elem!=null; $elem=$elem->nextSibling ) {
                            if ($elem->localName!="")
                                $dataItem[$elem->localName] = $elem->textContent;
                        }
                        $data[] = $dataItem ;
                    }
                }
            }
            if ( count($entries)>0 ) {
                $feeds = new Feeds();
                $feeds->name = uniqid( $this->name."_" );
                $feeds->entry = $entries;
                if ( count($data)>0 )
                    $feeds->setData( $data );
                
                $feeds->save();
                
                // need to find the link to the table
                $entrys = array();
                $texts = $dom->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "text");
                foreach ($texts as $text)
                    $entrys[] = $text;
                $choices = $dom->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "choice");
                foreach ($choices as $choice)
                    $entrys[] = $choice;
                foreach ( $entrys as $entry ) {
                    if ( $entry->getAttribute( "ui" )!="enabled" || $entry->getAttribute( "ui-href" )=="") continue;
                    
                    $href = substr( $entry->getAttribute("ui-href"), 1 );
                    $dest = $dom->getElementById( $href );
                    if ( $dest==null ) continue;
                    $value = trim($dest->textContent);
                    if ( $value != "XML-UI" ) continue;
                    $id = substr( $entry->getAttributeNS("http://www.w3.org/1999/xlink","href"), 1 );
                    $dest = $dom->getElementById( $id );
                    if ( $dest===null ) continue;
                    $attrib = $entry->getAttribute("targetAttribute");
                    $attribns = $entry->getAttribute("targetNamespace");
                    if ( $attrib=="" )
                        $dest->nodeValue = $feeds->linkpath;
                    else {
                        if ($attribns=="")
                            $dest->setAttribute($attrib, $feeds->linkpath );
                        else
                            $dest->setAttributeNS($attribns,  $attrib, $feeds->linkpath );
                    }
                    
                }
            }
            
        }
        
        if ( $this->saveSlide( $dom, $pathout.$name )==false ) return false;
        
        // copy the preview
        $preview = ".preview.".$name.".png" ;
        copy( $pathin.$preview , $pathout.$preview  );
        
        return true;
        
    }
    protected function pathToFolder() {
        $new = self::getPathToFile( $this->name, "slide" );
        return dirname( $new )."/";
    }
    protected function pathToLinkFolder() {
        $new = self::getPathToLink( $this->name, "slide" );
        return dirname( $new )."/";
    }
    protected function updateId() {
        // update the ID in case we use this object again.
        $this->setId( self::getIdfromName( $this->name, "slide" ) ) ;
    }
    public function create( $replace=true ) {
              
        if ( !file_exists( self::folder("slide") ) )
            mkdir( self::folder("slide") );
            
        $sourceid = $this->id;
        $sourcename = $this->name;
        if ( $this->type!="template" && $this->type!="layout" ) return false;        
        // need to open the template, modify the xml:base and save it under the new name

        $path = dirname( $this->filepath )."/";
        // get the list of all SVG file in this folder
        $files = CFileHelper::findFiles( $path,  array( 'fileTypes'=>array('svg'), 'level'=>0 ) );
        
        // create the destination folder
        if ( preg_match("/^\d+_(.*)/", $this->name, $match) )
            $basename = $match[1];
        else
            $basename = $this->name;
        
        
        for( $i=1; true; $i++ ) {
            $this->name = "Slide$i";
            $destpath = $this->pathToFolder();
            
            if ( !file_exists( $destpath ) ) {
                mkdir( $destpath );
                break;
            } elseif ( $replace ) {
                // clear the folder from all svg file
                $oldfiles = CFileHelper::findFiles( $destpath,  array( 'fileTypes'=>array('svg'), 'level'=>0 ) );
                foreach( $oldfiles as $file )
                    unlink( $file );
                break;
            }
            
            
        }
        
        foreach ( $files as $file ) {
            $this->createFile( basename($file), $path, $this->pathToFolder() );
        }
        
        $oldPreview = $this->getFilepathPreview();
		$oldPreviewLink = $this->getWebpathPreview();
        
        $this->updateId();
        // copy the preview.
        if ( file_exists($oldPreview) ) copy( $oldPreview, $this->getFilepathPreview() );
        
        $this->saveMeta( array( "source"=>array("id"=>$sourceid, 
												"name"=>$sourcename, 
												"path"=>$path, 
												"previewfile"=>$oldPreview,
												"preview"=>$oldPreviewLink,
											)
							) 
						);
        
        return true;
    }   
    
    public function saveSlide( $dom, $name ) {
        return file_put_contents( $name, $dom->saveXML() );
    }
    
    public function getSource() {
        if ( $this->_source===false ) {
            $meta = $this->loadMeta( );
            if ( isset($meta['source']) && isset($meta['source']['id'])) 
                $this->_source = $meta['source']['id'];
            else
                $this->_source = "";
            if ( isset($meta['source']) && isset($meta['source']['name'])) 
                $this->_sourcename = $meta['source']['name'];
            else
                $this->_sourcename = "";
        }
        
        return $this->_source;
    }
    public function getSourceName() {
        if ( $this->_sourcename===false ) {
            $this->getSource();
        }
        if ( preg_match("/^\d+_(.*)/", $this->_sourcename, $match) )
            return $match[1];
        else
            return $this->_sourcename;
    }
	protected function applyTransform( $v, $m ) {
	
		$x=$v[0];
		$y=$v[1];
		$r[0]=$x*$m[0]+$y*$m[1]+$m[4];
		$r[1]=$x*$m[2]+$y*$m[3]+$m[5];
		return $r;
	}
	protected function getPostionSub( $node, $pos ) {
		//transform
		list($x, $y, $width, $height) = $pos;
		
		$transform =  $node->getAttribute("transform");
		if ( substr( $transform, 0, 6) == 'matrix' ){
			$vals = explode(',',substr( $transform,7, -1 ));
			list($x,$y) = $this->applyTransform(array($x,$y), $vals);
			list($width,$height) = $this->applyTransform(array($width,$height), array($vals[0], $vals[1], $vals[2], $vals[3], 0,0) );
		}elseif ( substr( $transform, 0, 9) == 'translate' ){
			$vals = explode(',',substr( $transform,10, -1 ));
			list($x,$y) = $this->applyTransform(array($x,$y), array(1,0,0,1,$vals[0], $vals[1]));
		}elseif ( substr( $transform, 0, 5) == 'scale' ){
			$vals = explode(',',substr( $transform,6, -1 ));
			if (count($vals)==1)
				$vals[1]=$vals[0];
			list($x,$y) = $this->applyTransform(array($x,$y), array($vals[0], 0,0, $vals[1],0,0));
			list($width,$height) = $this->applyTransform(array($width,$height), array($vals[0], 0,0, $vals[1],0,0));
		}
		return array( $x, $y, $width, $height );
	}
    protected function getPostion( $node ) {
		
		$x =  $node->getAttribute("x");
		if ($x=="") $x=0;
		$y =  $node->getAttribute("y");
		if ($y=="") $y=0;
		$width =  $node->getAttribute("width");
		if ($width=="") $width=0;
		$height =  $node->getAttribute("height");
		if ($height=="") $height=0;
		$pos = array($x, $y, $width, $height);
		while ( $node!=null ) {
			$pos = $this->getPostionSub($node,$pos);
			if ( $node->nodeName=='svg' )
				break;
			$node = $node->parentNode;
			
		}
        
        return $this->fixPosition( $pos[0], $pos[1], $pos[2], $pos[3] );
		
	}
    protected function getPostionJSON( $args ) {
		
        if ( isset( $args["top"] ) )
		    $y =  $args["top"];
        else
            $y = 0;
		if ( isset( $args["left"] ) )
		    $x =  $args["left"];
        else
            $x = 0;
		if ( isset( $args["width"] ) )
		    $width =  $args["width"];
        else
            $width = 0;
		if ( isset( $args["height"] ) )
		    $height =  $args["height"];
        else
            $height = 0;
		
        return $this->fixPosition($x, $y, $width, $height);
		
	}
    protected function fixPosition( $x, $y, $width, $height ) {
        if ( $this->filePosition!=null ) {
            // need to fix the position because our viewbox is not equal to the main doc viewbox
            $fp = explode(" ", $this->filePosition);
            if ( $this->currentViewBox=="" ) {
                $x += $fp[0];
                $y += $fp[1];
            } else {            
                $vb = explode(" ", $this->currentViewBox);
                $x = $fp[0] + ((float)$x)*$fp[2]/$vb[2]; 
                $y = $fp[1] + ((float)$y)*$fp[3]/$vb[3]; 
                $width = ((float)$width)*$fp[2]/$vb[2]; 
                $height = ((float)$height)*$fp[3]/$vb[3]; 
            }
        }
        
        return array($x, $y, $width, $height);
    }
    
    protected function getMediaJSON( $media, $res=false ) {
        if ( !isset( $media["args"] ) )
            return false;
        if ( $res===false ) {
            if ( !isset( $media["name"] ) )
                return false;
            $ui_name = $media["name"];
            
            $res = new TemplateEntry;
            $res->scenario = "create";
            $res->name = $ui_name;
            // id and properties name and index will have to be given by the caller
        }
        if ( !isset( $media["ctor"] ) )
            return false;
        $ctor = $media["ctor"];
        if ( $ctor=="textArea" || $ctor=="fitTextArea" || $ctor=="pingPongTextArea" || $ctor=="headlineTextArea" || $ctor=="scrollingTextArea" ) {
            if ( !isset( $media["textContent"] ) ){
                $res->value = "";
                $res->property = "textContent";
            } else if ( !is_array( $media["textContent"] ) ) {
                $res->value = $media["textContent"];
                $res->property = "textContent";
            } else if ( isset( $media["textContent"]["text"] ) ){
                $res->value = $media["textContent"]["text"];
                $res->property = "textContent.text";
            } else {
                // get all the text, but formating will be lost
                $res->value = "";
                foreach( $media["textContent"] as $txt ) 
                    $res->value .= $txt["text"];
                $res->property = "textContent";
            }
            if ( $ctor=="textArea" )
                $res->type = "rich";
            elseif ( $ctor=="fitTextArea" || $ctor=="scrollingTextArea" )
                $res->type = "textarea";
            else 
				$res->type = "text";
            $res->position = implode(" ", $this->getPostionJSON( $media["args"] ) );
        } else if ( $ctor=="media" || $ctor=="animation" || $ctor=="image" || $ctor=="video" || $ctor=="audio" ) {
            if ( !isset( $media["args"] ) || !isset( $media["args"]["href"] ) )
                return false;
            $href = $media["args"]["href"];
            if ( !(strpos($href , self::$baseTemplates)===false) )
                $href  = substr( $href , strlen(self::$baseTemplates) );
            $file = new FileItem(array("linkpath" => $href ) );
            $res->value = $file->id;
            $res->type = $ctor;
            $res->property = "args";
            
            $res->position = implode(" ", $this->getPostionJSON( $media["args"] ) );
        } else 
            return false;
        
        return $res;
    }
    protected function getMedia( $dom, &$media, $res=false ) {
        while ( $media!=null && $media->localName=="g" ) { // resolving effects
            $target = $media->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx","effect-target-id");
            if ( $target=="" ) break;
            $media = $dom->getElementById( $target );
        }
        if ( $media!=null ) {
            if ( $res===false ) {
                $ui_name = $media->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx","name");
                if ( $ui_name=="" ) return false;
            }
                
            $base = $media;
            if ( $media->localName=="g" ) {
                for ( $text=$media->firstChild; $text!=null; $text=$text->nextSibling ) {
                    if ( $text->localName=="textArea" ) $media = $text; 
                }
            }
            if ( $res===false ) {
                $res = new TemplateEntry;
                $res->scenario = "create";
                $res->name = $ui_name;
                $res->id = $base->getAttribute("xml:id");
                if ( $res->id=="" )
                    $res->id = $base->getAttribute("id");
                if ( $res->id=="" ) return false;
                $res->attrib = "";
            }
            if ( $media->localName=="textArea" ) {
                $res->value ="";
                for ( $node=$media->firstChild; $node!=null; $node=$node->nextSibling ){
                    // we support one level but not more
                    if ( $node->nodeType==XML_TEXT_NODE )
                        $res->value .= str_replace("\n", "", $node->textContent);   
                    elseif ( $node->nodeType==XML_ELEMENT_NODE ) {
                        if ( $node->localName=='tbreak' )
                            $res->value .= "\n";
                        else if ( $node->localName=='tspan' ) {
                            // formatting ?
                            $res->value .= str_replace("\n", "", $node->textContent);
                        }
                    }
                }
				
                // cleanup HTML code
				$res->value = htmlspecialchars_decode( $res->value );
				$res->type = "textarea";
				
				$res->position = implode(" ", $this->getPostion( $media ) );
            } else if ( $media->localName=="animation" || $media->localName=="video" || $media->localName=="audio" || $media->localName=="image" ) {
                $href = $media->getAttributeNS("http://www.w3.org/1999/xlink","href");
                if ( !(strpos($href , self::$baseTemplates)===false) )
                    $href  = substr( $href , strlen(self::$baseTemplates) );
                $file = new FileItem(array("linkpath" => $href ) );
                $res->value = $file->id;
                $res->type = $media->localName;
				
				$res->position=implode(" ", $this->getPostion( $media ));
				
            }
        }
        return $res;
    }
    
    protected function getJSONProperty( $json, $property ) {
        $props = explode( ".",  $property );
        foreach ( $props as $p ) {
            if ( !isset($json[$p]) )
                return null;
            $json = $json[$p];
        }
        return $json;
    }
    protected function setJSONProperty( $json, $property, $value ) {
        $props = explode( ".",  $property );
        if ( count($props)==1 ) {
            $json[ $props[0] ] = $value;
        } elseif ( count($props)==2 ) {
            $json[ $props[0] ][ $props[1] ] = $value;
        }elseif ( count($props)==3 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ] = $value;
        }elseif ( count($props)==4 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ][ $props[3] ] = $value;
        }elseif ( count($props)==5 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ][ $props[3] ][ $props[4] ] = $value;
        }elseif ( count($props)==6 ) {
            $json[ $props[0] ][ $props[1] ][ $props[2] ][ $props[3] ][ $props[4] ][ $props[5] ] = $value;
        }
        return $json;
    }
    
    protected function loadFile( $name ) {
        if ( !file_exists( $name) ) return false;
            
        $slide = file_get_contents( $name );
        if ( $slide===false || $slide=="" ) return false;
        
        $dom = new DOMDocument;
        if ( $dom->loadXML( $slide )===false ) return false;        
        // must fix the ids of the doc
        foreach ($dom->getElementsByTagName('*') as $element) {
            if ($element->hasAttribute('id')) {
                $element->setIdAttribute('id', true);
            }
        }

        if ( $this->viewBox=="" )
		    $this->viewBox = $dom->documentElement->getAttribute('viewBox');			
		else
            $this->currentViewBox = $dom->documentElement->getAttribute('viewBox');
        
        // check if this file is inside another one
        $href = urlencode($this->basenamepath($name));
        if ( isset( $this->docPosition[ $href ] ) )
            $this->filePosition = $this->docPosition[ $href ];
        else
            $this->filePosition = null;
        //file_put_contents( "/var/log/fusion/debug.log", $href."\n".print_r( $this->docPosition, true ), FILE_APPEND );
        
        $restitle = new TemplateEntry;
        $title = $dom->getElementsByTagName("title");
        $hasname = false;
        $i=0;
        while( $title->length>$i && !$hasname ){
            if ( !empty($title->item($i)->textContent) ) {
                $first = substr( trim($title->item($i)->textContent), 0, 1 );
                if ( $first!="{" && $first!="[" ) {
                    $hasname = true;
                    $restitle->name = trim($title->item($i)->textContent);
                }
            }
            $i++;
        } 
        if ( !$hasname )
            $restitle->name ="";
        $restitle->type='file';
        $restitle->id=basename($name);
        $this->_fields[]=$restitle;
        $gotone=false;
        $params = $dom->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "properties");
        
        foreach( $params as $param ) {
            
            $entrys = array();
			for ( $item=$param->firstChild; $item!=null; $item=$item->nextSibling ) {
				if ( $item->nodeType==XML_ELEMENT_NODE ) {
                    if ( $item->localName=='group' ) {
                        for ( $item2=$item->firstChild; $item2!=null; $item2=$item2->nextSibling ) {
                            if ( $item2->nodeType==XML_ELEMENT_NODE && $item2->getAttribute( "ui" )=="enabled" ) 
                                $entrys[] = $item2;
                        }
                    } else if ( $item->localName!='table' && $item->getAttribute( "ui" )=="enabled" ) // handled latter
                        $entrys[] = $item;
				}
			}
        
                
            foreach ($entrys as $entry) {
                
                $res = new TemplateEntry;
                $res->scenario = "create";
                $res->name = $entry->getAttribute("name");
                $res->id = substr( $entry->getAttributeNS("http://www.w3.org/1999/xlink","href"), 1 );
                $res->attrib = $entry->getAttribute("targetAttribute");
                $res->attribns = $entry->getAttribute("targetNamespace");
                $res->choice = "";
                $dest = $dom->getElementById( $res->id );
                if ( $dest===null ) {
                    continue;
                }
                // we want the User to explicitly enable the ui settings
				
				if ( $entry->localName=="media" ) {
                    $res = $this->getMedia( $dom, $dest , $res );
                    if ( $res===false ) continue;
                } else if ( substr($entry->localName, 0, 4) =="json" ) {
                    $res->property = $entry->getAttribute("propertyName");    
                    $index = $entry->getAttribute("index");
                    if ( $index!=null && $index!="" )
                        $res->property = $index.".".$res->property;
                    $json = json_decode( $dest->textContent, true );
                    if ( $entry->localName=="json-layer"  ) {
                        $property = $res->property;
                        $media = $this->getJSONProperty( $json, $property );
                        if ( $media===false ) continue;
                        
                        $res = $this->getMediaJSON( $media, $res );
                        if ( $res===false ) continue;
                        $res->property = $property .".". $res->property;
                    } else if ( $entry->localName=="json-data"  ) {
                        $res->property .= ".src";
                        $res->value = $this->getJSONProperty( $json, $res->property );
                        if ( $res->value==null ) continue;
                        $res->type = "text";
                        
                    } else if ( $entry->localName=="json-text"  ) {
                        $txt = $this->getJSONProperty( $json, $res->property);
                        $res->type = "rich";
                        if ( !is_array( $txt ) ) {
                            $res->value = $txt;
                        } else if ( isset( $txt["text"] ) ){
                            $res->value = $txt["text"];
                            $res->property .= ".text";
                        } else {
                            // get all the text, but formating will be lost
                            $res->value = "";
                            foreach( $txt as $span ) 
                                $res->value .= $span["text"];
                        }
                    } else {
                        $res->value = $this->getJSONProperty( $json, $res->property);
                        if ( $res->value==null )
                            $res->value = "";
                        
                        if ( $entry->localName=="json-boolean" ) {
                            $res->type = "choice";
                            if ( $entry->getAttribute("true")!="" && $entry->getAttribute("false")!="" ) {
                                $res->choice.= "true"."~;;~".$entry->getAttribute("true") ."~;~". "false"."~;;~".$entry->getAttribute("false");
                                $res->value = $res->value?"true":"false";
                            } else {
                                $res->choice = "yesno";
                                $res->value = $res->value?"yes":"no";
                            }
                        } else if ( $entry->localName=="json-number" || $entry->localName=="json-string" || $entry->localName=="json-integer" ) {
                            $res->type = "text";
                        } else if ( $entry->localName=="json-choice"  ) {
                            $res->type = "choice";
                        }  else if ( $entry->localName=="json-color"  ) {
                            $res->type = "color";
                        } else
                            continue;
                    }
                } else {
                    if ( $res->attrib=="" )
                        $res->value = htmlspecialchars_decode($dest->textContent);
                    else {
                        if ($res->attribns=="")
                            $res->value = $dest->getAttribute($res->attrib );
                        else
                            $res->value = $dest->getAttributeNS($res->attribns,  $res->attrib );
                    }
                    $res->type = $entry->localName;
                }
				if ( $res->type=="choice" && $res->choice == "") {
					// get the choice
					for ($i=1; ;$i++ ) {
						$s = $i;
                        $val = $entry->getAttribute("choice-".$s);
						if ( $val==""  && $s<10) {
							$s = "0".$i;
						    $val = $entry->getAttribute("choice-".$s);
                        }
						if ( $val=="" )
							break;
                        else {
                            $cname = $entry->getAttribute("name-".$s);
                            if ( $cname=="" )
                                $cname = $val;
                        }
						if ($res->choice!="")
							$res->choice.="~;~";
						$res->choice.= $val."~;;~".$cname;
					};
				}	
				if ( $res->type=="yesno" || $res->type=="yesnoinherit" || $res->type=="fonts" ) {
					$res->choice = $res->type;
					$res->type = "choice";
				}
                if ( $entry->getAttribute( "ui-href" )!="" ) {
                    $href = substr( $entry->getAttribute("ui-href"), 1 );
                    $dest = $dom->getElementById( $href );
                    if ( $dest!=null ) {
                        $value = trim($dest->textContent);
                        if ( $value == "XML-UI" ) {
                            $res->type = 'datafeeds';
                            if ( trim($res->value)=="inline" ) {
                                $res->value = "";
                                if ($this->type=='template') {
									$tables = $dom->getElementsByTagNameNS( "http://www.spinetix.com/namespace/1.0/spx", "table" );
									foreach ( $tables as $table) {
										$this->datafeedsentries=$this->getDatafeedsEntries( $table, $dom );
										if ( $this->datafeedsentries!==false )
											break;
									}
								}
                            } else {
                                $file = new FileItem(array("linkpath" => $res->value ) );
                                $res->value = $file->id;
                            }
							$config =$dom->getElementById("rss_multi");
							if ( $config ) {
								$col=$config->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx","rss_num_col");
								$row=$config->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx","rss_num_row");
								$width=$config->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx","rss_x_offset");
								$height=$config->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx","rss_y_offset");
								$res->position="$col $row $width $height ";
								$this->itemPerPage=$col*$row;
							}else
								$this->itemPerPage=1; // don't know
                        }
                    }
                }
                $gotone=true;
                $this->_fields[]=$res;
            }
            
            $tables = $param->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "table");
            foreach ($tables as $entry){
                if ( $entry->getAttribute( "ui" )!="enabled" ) continue;
                
                $itemElement = $entry->getAttribute("itemElement");
                $tableElement = $entry->getAttribute("tableElement");
                $id = substr( $entry->getAttributeNS("http://www.w3.org/1999/xlink","href"), 1 );
                $table = $dom->getElementById( $id );
                if ( $table===null ) continue;
                $idx = 0;
                
                for ( $item=$table->firstChild; $item!=null; $item=$item->nextSibling ) if ( $item->localName==$itemElement ) {
                    for ( $tmp=$item->firstChild; $tmp!=null; $tmp=$tmp->nextSibling ) if ( $tmp->nodeType==XML_ELEMENT_NODE ) break;
                    if ( $tmp==null) continue;
                    for ( $media=$tmp->firstChild; $media!=null; $media=$media->nextSibling ) 
                        if ( $media->localName=="animation" || $media->localName=="image" || $media->localName=="video" || $media->localName=="textArea" || $media->localName=="audio" || $media->localName=="g" ) break;
                    
                    $res = $this->getMedia( $dom, $media );
                    if ( $res===false ) {
                        if ( $media!=null && ( $media->localName=="animation" || $media->localName=="image" ) ) {
                            $href = $media->getAttributeNS("http://www.w3.org/1999/xlink","href");
                            $dhref = $media->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx", "default-href");
                            if ( $dhref!="" )
                                $href = $dhref;
                            if ( strchr($href, "/")===false && pathinfo($href, PATHINFO_EXTENSION)=="svg" ) {
                                $this->docPosition[ $href ] = implode(" ", $this->getPostion( $media ));
                            }
                        } 
                        continue;
                    } 
                    $gotone=true;
                    $this->_fields[]=$res;
                }
            }
            
            $tablesJSON = $param->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "json-array");
            foreach ($tablesJSON as $entry){
                
                $id = substr( $entry->getAttributeNS("http://www.w3.org/1999/xlink","href"), 1 );
                $table = $dom->getElementById( $id );
                if ( $table===null ) continue;
                
                $json = json_decode( $table->textContent, true );
                    
                $idx = 0;
                foreach ($json  as $media ) {
                    $res = $this->getMediaJSON( $media );
                    if ( $res!==false ) {
                        $res->id = $id;
                        $res->property = $idx .".". $res->property;
                        $gotone=true;
                        $this->_fields[]=$res;
                    } else if ( isset( $media["ctor"] ) ) {
                        // not customisable media, maybe another configurable file:
                        if ( $media["ctor"]=="media" || $media["ctor"]=="animation" || $media["ctor"]=="image" || $media["ctor"]=="video" || $media["ctor"]=="audio" ) {
                            if ( !isset( $media["args"] ) || !isset( $media["args"]["href"] ) )
                                continue;
                            $href = $media["args"]["href"];
                            if ( isset( $media['args']['defaultHref'] ) )
                                $href = $media['args']['defaultHref'];
                            if ( strchr($href, "/")===false && pathinfo($href, PATHINFO_EXTENSION)=="svg" ) {
                                $this->docPosition[ $href ] = implode(" ", $this->getPostionJSON( $media["args"] ) );
                            }
                        } 
                    }
                    $idx++;
                }
            }
        }
        if ( !$gotone && count($this->_fields)>1 ) {
            array_pop( $this->_fields );
        }
    }
	
	public function getTemplatePreview() {
		if ( $this->type=='template' )
			return $this->getWebpathPreview();
		if ($this->_templatepreview===false) {
			$meta = $this->loadMeta();
			if (isset($meta['source']) && isset($meta['source']['preview']))
				$this->_templatepreview = $meta['source']['preview'];
			else
				$this->_templatepreview = "";
		}
		return $this->_templatepreview;
	}
	public function setPreviews( $prev ) {
		$this->previews = $prev;
	}
	
	public function getPreviews() {
		$meta = loadMeta();
		return $meta['preview'];
	}
    
    public function getFields() {
  
        if ( $this->_fields===false ) {
            
            $this->_fields = array( );
            
            $this->loadFile( $this->filepath );
            
            $path = dirname( $this->filepath )."/";
            // get the list of all SVG file in this folder
            $files = CFileHelper::findFiles( $path,  array( 'fileTypes'=>array('svg'), 'level'=>0 ) );
            foreach ( $files as $file ) {
                if ( basename($file)==basename($this->filepath) ) continue;
                $this->loadFile( $file );
            }
            //if ( count($this->_fields)>1 && $this->_fields[0]->type=="file" && $this->_fields[1]->type=="file" )
            //   array_shift( $this->_fields ); // because we always keep the first file. But if it was empty and the second file is not, then we remove it
            
        } 
            
        return $this->_fields;
    }
    
    public function setFields( $fields ) {
        $this->_fields = $fields;
		
    }
    
    protected function renameMedia(DOMElement $node, $name) {
        
        if ( $name==$node->localName )
            return $node;
        
        // we must fix the timings for the images nodes
        if ( $name=="image" || $node->localName=="image" ) {
            $timeAttr = array('begin', 'dur', 'repeatDur', 'repeatCount');
            $sync = null;
            if ( $node->localName=="image" ) {
                for( $c=$node->firstChild; $c!==null; $c=$c->nextSibling ){
                    if ( $c->nodeType==XML_ELEMENT_NODE 
                            && ( $c->localName=="set" || $c->localName=="animate" ) ){
                        if ( $c->getAttribute("attributeName")=="display" ){
                            $sync = $c;
                            break;
                        }
                    }
                }
            } else {
                $sync = $node;
            }
            if ( $sync!==null ) {
                // get timing attributes
                $timings = array();
                foreach( $timeAttr as $attr ) {
                    $val = $sync->getAttribute($attr);
                    if ( !empty($val) )
                        $timings[$attr] = $val;
                }
                if ( !isset($timings['dur']) )
                    $timings['dur']='media';

                if ( $name=="image" ) {
                    if ( count( $timings )>1 || $timings['dur']!='media' ) {
                        // more than just dur=media
                        $set = $node->ownerDocument->createElement("set");
                        $set->setAttribute("attributeName", "display");
                        $set->setAttribute("to", "inherit");
                        foreach( $timings as $attr => $val ) {
                            $node->removeAttribute($attr);
                            $set->setAttribute($attr, $val); 
                        }
                        $node->setAttribute("display", "none");
                        $node->appendChild( $set );
                    } else {
                        $node->removeAttribute('dur');
                    }
                } else {
                    foreach( $timings as $attr => $val ) {
                        $node->setAttribute($attr, $val);                    
                    }
                    $node->removeChild( $sync );
                    $node->removeAttribute("display");
                }
            }
        } else {
            // this was an image without timings
            $node->setAttribute('dur', 'media');
        }
         
        // renaming the node to mathc the type
        $renamed = $node->ownerDocument->createElement($name);

        foreach ($node->attributes as $attribute) {
            if ( $attribute->namespaceURI )
                $renamed->setAttributeNS($attribute->namespaceURI, $attribute->nodeName, $attribute->nodeValue);
            else
                $renamed->setAttribute( $attribute->nodeName, $attribute->nodeValue );
        }

        while ($node->firstChild) {
            $renamed->appendChild($node->firstChild);
        }
        if ( $node->parentNode->replaceChild($renamed, $node)===false )
                return false;
        return $renamed;
    }
    protected function saveFile( $name, $data ) {
        if ( !file_exists( $name ) ) return false;
        
        
        $feedsList = array();
            
        $slide = file_get_contents( $name );
        if ( $slide===false || $slide=="" ) return false;
        
        $dom = new DOMDocument;
        if ( $dom->loadXML( $slide )===false ) return false;
        
        // must fix the ids of the doc
        foreach ($dom->getElementsByTagName('*') as $element) {
            if ($element->hasAttribute('id')) {
                $element->setIdAttribute('id', true);
            }
        }

        while ( count($data)>0 && $data[0]->type!='file' ){
            $item = array_shift( $data );
            $dest = $dom->getElementById( $item->id );
            if ($dest==null) continue;
            $value = $item->value;
            if ( $item->type=="datafeeds" ) {
                $feedsList[]= $value;
                if ( $value !="" ) {
                    $file = new FileItem(array("id" => $item->value) );
                    $value  = self::$baseTemplates.$file->linkpath;
                } else
                    $value  = "inline";
            }
            if ( $item->property!="" ) {
                // this is JSON, need to load first
                $tmp = $dest->textContent;
                $json = json_decode( $tmp, true );
                
                if ( $item->type=="media" || $item->type=="animation" || $item->type=="image" || $item->type=="video" || $item->type=="audio") {
                    if ( $value==false || $value=="" ) {
                        $json = $this->setJSONProperty( $json, $item->property.".href" , $this->getJSONProperty( $json, $item->property.".defaultHref" ) );
                    } else {
                        $file = new FileItem(array("id" => $value ) );
                        $json = $this->setJSONProperty( $json, $item->property.".href", self::$baseTemplates.$file->linkpath );
                        $json = $this->setJSONProperty( $json, $item->property.".local", false );
                        $dur = $this->getJSONProperty( $json, $item->property.".dur" );

                        // replace args by ctor and fix it depending on the media type;
                        if ( $item->type!="media" ) {
                            $ctor_loc = substr( $item->property, "0", -4)."ctor";
                            $n = $file->type;
                            if ( $n!=="image" && $n!=="video" && $n!=="audio" )
                                $n = "animation";
                            if ( $n!==$item->type )
                                $json = $this->setJSONProperty( $json, $ctor_loc, $n );
                        }

                        if ( $file->type=="image" ) {
                            if ( $dur===null || $dur=="media" ) 
                                $json = $this->setJSONProperty( $json, $item->property.".dur", "0.987654321" );
                        } else {
                            if ( $dur=="0.987654321" ) 
                                $json = $this->setJSONProperty( $json, $item->property.".dur", "media" );
                        }
                    }
                } elseif ( $item->type=="choice" && $item->choice=="yesno" ) {
                    $json = $this->setJSONProperty( $json, $item->property, $value=="yes" );
                } elseif ( $value=="true" || $value=="false" ) {
                    $json = $this->setJSONProperty( $json, $item->property, $value=="true" );
                } else
                    $json = $this->setJSONProperty( $json, $item->property, $value );
                
                
                $dest->nodeValue = "";
                $dest->appendChild( $dom->createCDATASection ( json_encode($json) ) );
                
            } elseif ( $item->type=="text" || $item->type=="color" || $item->type=="choice" || $item->type=="datafeeds") {
                if ( $item->attrib=="" )
                    $dest->nodeValue = htmlspecialchars($value, ENT_NOQUOTES, 'UTF-8');
                else {
                    if ($item->attribns=="")
                        $dest->setAttribute( $item->attrib, $value  );
                    else
                        $dest->setAttributeNS( $item->attribns , $item->attrib, $value  );
                }
            } elseif ( $item->type=="rich" || $item->type=="textarea") {
                if ( $dest->localName=="g" ) {
                    for ( $text=$dest->firstChild; $text!=null; $text=$text->nextSibling )
                        if ( $text->localName=="textArea" ) $dest = $text; 
                }
                // clear all text content
                for ( $node=$dest->firstChild; $node!=null; $node=$next ){
                    $next=$node->nextSibling;
                    if ( $node->nodeType==XML_TEXT_NODE || ( $node->nodeType==XML_ELEMENT_NODE && ( $node->localName=='tbreak' || $node->localName=='tspan' ) ) )
                        $dest->removeChild ($node );
                }
                if ( $value!="" ) {
                    // cleanup HTML code
				    $value = htmlspecialchars($value, ENT_NOQUOTES, 'UTF-8');
                    // split the lines
                    $lines = explode("\n", $value);
                    $first = true;
                    foreach ( $lines as $line ) {
                        if ( !$first )
                            $dest->appendChild( $dom->createElement("tbreak") );
                        $dest->appendChild( $dom->createElement("tspan", str_replace("\r", "", $line) ) );
                        $first  = false;
                    }
                } 
            }elseif ( $item->type=="animation" || $item->type=="image" || $item->type=="video" || $item->type=="audio") {
            
                if ( $value==false || $value=="" ) {
                    $dest->setAttributeNS( "http://www.w3.org/1999/xlink", "href", $dest->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx", "default-href") );
                } else {
                    $file = new FileItem(array("id" => $value ) );
                    /*
                    // change the node name to matche the media. Not enabled so far because
                    // this may have many impact on the media duration and 
                    // nobody complained of the current behaviour so far
                    $n = $file->type;
                    if ( $n!=="image" && $n!=="video" && $n!=="audio" )
                        $n = "animation";
                    
                    if ( $dest->localName!=$n ) {
                        $dest = $this->renameMedia( $dest, $n );
                        if ($dest===false) continue;
                    }  
                     */                
                    $dest->setAttributeNS( "http://www.w3.org/1999/xlink", "href", self::$baseTemplates.$file->linkpath);
                    $dest->setAttributeNS("http://www.spinetix.com/namespace/1.0/spx", "local", "false" );
                }
            } 
        };
        if ( !empty($feedsList) ) {
            $oldfeedsList = array();
            $meta = $this->loadFeedMeta( $sources, $oldfeedsList );
            
            $this->addFeeds( $meta, $feedsList, $sources );
            $this->saveFeedMeta( $meta );
            
			$meta = $this->loadMeta();
			$meta['feeds']=$feedsList;
			$this->saveMeta( $meta );
        }
		// fixing the paths
        $destlink = self::$baseTemplates.$this->pathToLinkFolder();
		$medias = $dom->getElementsByTagName( "animation" );
		foreach ($medias as $media) {
			$local = $media->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx", "local" );
			if ( $local=="true" ) {
				$href = $media->getAttributeNS("http://www.spinetix.com/namespace/1.0/spx", "default-href");
				// this svg will be moved, need to change the reference to the new path
				$href = $destlink.$href;
				$media->setAttributeNS("http://www.w3.org/1999/xlink","href", $href );
			}
		}
        // fixing the path for json
        $tables = $dom->getElementsByTagNameNS("http://www.spinetix.com/namespace/1.0/spx", "json-array");
        foreach ($tables as $entry ) {
            $id = substr( $entry->getAttributeNS("http://www.w3.org/1999/xlink","href"), 1 );
            $table = $dom->getElementById( $id );
            if ( $table===null ) continue;
            $json = json_decode( $table->textContent, true );
            $changed = false;
            $idx = 0;
            foreach ($json as $media ) {
                if ( $media['ctor']=="animation" || $media['ctor']=="media" || $media['ctor']=="image" || $media['ctor']=="video" || $media['ctor']=="audio" ) {
                    if ( isset($media['args']['local']) && $media['args']['local'] ) {
                        $href = $media['args']['defaultHref'];
                        // this svg will be moved, need to change the reference to the new path
                        $href = $destlink.$href;
                        if ( $media['args']['href']!=$href ) {
                            $json[$idx]['args']['href'] = $href;
                            $changed = true;
                        }
                    }
                }
                $idx++;
            }
            if ( $changed ) {
                $table->nodeValue = "";
                $table->appendChild( $dom->createCDATASection ( json_encode($json) ) );
            }                
        }
        
        $this->_source=false;
        $this->_sourcename=false;
        return ( $this->saveSlide( $dom, $name )!==false );
        
    }
    
    function loadFeedMeta( &$sources=array(), &$feedsList=array() ) {
    
        $feeds = new Feeds( array('name'=>'dummy') );
        $meta = $feeds->loadMeta();
        
        $newmeta=array();
        $sources=array();
        $idx=0;
        foreach ( $meta as $metaname=>$value ) {
            if ( substr($metaname,0,5)!="slide" )
                $newmeta[$metaname]=$value; // copy the meta not for us
            else if ( $value['idslide']!=$this->id ){
                // this is another slide, is it using the same feeds ?
                foreach ( $value as $n=>$v ){
                    if ( substr($n,0,5)=="feeds")
                        $sources[$v][]=$value['idslide'];
                }
                $newmeta["slide".$idx]=$value; // copy the meta not for us
                $idx++;
            } else {
                foreach ( $value as $n=>$v )
                    if ( substr($n,0,5)=="feeds")
                        $feedsList[] = $v;
            }
        }
        
        return $newmeta;
    }
    function addFeeds( &$newmeta, $feedsList=array(), &$sources=array() ) {
        $idx=0;
        foreach ($newmeta as $name=>$value )
            if ( substr($name,0,5)=="slide" ) $idx++;
        
        $newmeta["slide".$idx]['idslide']=$this->id;
        
        foreach( $feedsList as $i=>$id ){
            $sources[$id ][]=$this->id;
            $newmeta["slide".$idx]["feeds".$i]=$id;
        }
    }
    
    function saveFeedMeta( $newmeta ) {
        // write our data
        $feeds = new Feeds( array('name'=>'dummy') );
        $feeds->saveMeta( $newmeta );
        
    }

    public function save () {
        
        $meta = $this->loadMeta( );
        
        $previews = array();
        
        if ( $this->_fields===false ) {
            return parent::save();
        } else {
            $data = $this->_fields;
           
            while ( count($data)>0 ) {
                $temp =  array_shift( $data );
                if ( $temp->type!='file' ) continue;
				
                $this->saveFile( dirname( $this->filepath )."/".$temp->id, $data );
                $previews[] = $temp->id;
            };
        }
        
        $meta['modified']=true;
		
		
		
		$meta['previews'] = array();
		foreach ($this->previews as $n=>$data ){
			foreach ( $data as $pos=>$val ){
				if ($val=="") continue;
				$meta['previews'][] = $val;
			}
		}
        if ( $this->enablepreview ) {
			//update the preview
			$this->createPreview( $previews, $meta );
		}
		
        $this->saveMeta( $meta );
        
        return true;
    }
	
	public function createPreview( $previews, $meta ) {

        $exe="cd /srv/raperca && raperca";
        if(PHP_OS == "WINNT")
            $exe = "C:\\svn\\genesis\\trunk\\device\\debug\\raperca.exe";
        
        $base = self::basenamepath( $this->getFilepath(), $path  );
        
        $base = mb_substr($path, strlen(self::$contentpath), mb_strlen($path, 'UTF-8'), 'UTF-8' );
        $where = self::$contentpath;
        
        if(PHP_OS !== "WINNT")
            $where = "'" . str_replace("'", "'\\''", $where) . "'";
        /*
        if ( $this->type=='layout')
            $file = "skin.svg";
        else
            $file = "template.svg";
        */
        $previews = array_reverse($previews);
        foreach ($previews as $file ) { 
            if ( $file == "skin.svg" || $file == "template.svg" )
                $option = "-xh"; // exact height
            else 
                $option = "";
            $file = $base."/".$file;
            if(PHP_OS !== "WINNT")
                $file = "'" . str_replace("'", "'\\''", $file) . "'";
            $cmd = "$exe -preview $option -d ".$where." -s 330x195 $file";
            exec( $cmd );
        }
        
        return;
        
        
        $newImage = imagecreatetruecolor(160, 90);
        imagefill( $newImage , 0, 0, imagecolorallocate( $newImage, 255, 255, 255 ) );
        
		// the source
		if ( !isset($meta['source']) )
			return; // cannot create previews
		$img = $meta['source']['previewfile'];;
		$info = getimagesize( $img );
		$image = imagecreatefrompng( $img );
		$height = 90;
        $width = $info[0]*$height/$info[1];
		if ($width>160) {
			$width=160;
			$height = $width*$info[1]/$info[0];
		}
		$offx = (160-$width)/2;
		$offy = (90-$height)/2;
		imagecopyresampled( $newImage, $image, $offx, $offy, 0, 0, $width, $height, $info[0], $info[1] );
		// the previews
		foreach( $previews as $pos=>$link ){
            
            if ($link=="") continue;
			$img = FileItem::getFileFromWeb($link);
			$info = getimagesize( $img );
			$image = imagecreatefrompng( $img );
			$p = explode(" ", $pos);
			$v = explode(" ", $this->viewBox);
			$x = $p[0]/$v[2]*$width+$offx;
			$y = $p[1]/$v[3]*$height+$offy;
			$w = $p[2]/$v[2]*$width;
			$h = $p[3]/$v[3]*$height;
			imagecopyresampled( $newImage, $image, $x, $y, 0, 0, $w, $h, $info[0], $info[1] );
		}
		imagepng( $newImage, $this->getFilepathPreview() );
	}
    public function delete () {
        $feedsList = array();
        $meta = $this->loadFeedMeta( $sources,  $feedsList );
        
        if ( parent::delete()===false ) return false;
        
        foreach ( $feedsList as $feedid ) {
            if (!isset( $sources[$feedid]) ){
                // we are the only user of this feed.
                $feed = new Feeds( array('id'=>$feedid) ); 
                $feed->delete();
            }
        }
        
        $this->saveFeedMeta( $meta  );
        
        return true;
    }
    public function copy () {
        
        $feedsList = array();
        $meta = $this->loadFeedMeta( $sources,  $feedsList );
        $this->addFeeds( $meta, $feedsList, $sources ); // add the orignal user
        if ( parent::copy()===false ) return false;
        $this->addFeeds( $meta, $feedsList, $sources ); // add the new user
        $this->saveFeedMeta( $meta );
        
        return true;
    }
    public function rename () {
    
        $feedsList = array();
        $meta = $this->loadFeedMeta( $sources,  $feedsList );
        if ( parent::rename()===false ) return false;
        $this->addFeeds( $meta, $feedsList, $sources ); // add the new user
        $this->saveFeedMeta( $meta, $feedsList, $sources );
        
        return true;
    }
    
    static function mapToFolder( $templates ) {
        $folders = array();
        foreach ($templates as $template ) {
            $dest = self::removeFolderName( $template->name );
            $folders[$dest][] = $template;
        }
        return $folders;
    }
    static function folders(){
        return array( "" => Yii::t('app',"Simple"),
                                "multi_" => Yii::t('app',"Advanced"),
                                "news_" => Yii::t('app',"RSS Feeds"),
                                "others_" => Yii::t('app',"Others"),
                                );
    }
    static function removeFolderName( &$template_name ) {
        $f = self::folders();
        $dest = $f[""];
		$rem="";
        foreach ( $f as $key => $name ) {
            $pos = strrpos( $template_name, $key );
            if ( $pos!==false && $pos==0 ) {
                $dest = $name;
                $rem = $key;
            }
        }
        $template_name = substr( $template_name, strlen($rem) );
        return $dest;
    }
}