<?php

function sortUsers($a, $b) {
	if ( $a->username=='admin' ) return -1;
	if ( $b->username=='admin' ) return 1;
    return strtolower($a->username)>strtolower($b->username);
}
    
class User extends CFormModel
{
    public static $passwordfile = "userpwd.txt";
	
    // list of possible role for the user. Each role must have it's own variable with the same name
    public static $existing_roles = array( "file", "program", "activate", "layout", "playlist", "feeds", "model" , "slide", "edit", "admin", "locked" );
	public static $meta_roles = array(
		'Scheduler' => array( "activate" ),
		'Editor' => array( "activate", "edit" ),
		'Creator' => array( "file", "program", "activate", "layout", "playlist", "slide", "edit"  ),
		'Administrator' => array( "file", "program", "activate", "layout", "playlist", "model", "slide", "edit", "admin" ),
	);
	public static $meta_roles_name = array();
	public $existing_lang;
    public $admin = 0;
    public $file = 0;
    public $playlist = 0;
    public $program = 0;
    public $_activate = 1;
    public $model = 0;
    public $slide = 0;
    public $layout = 0;
    public $feeds = 0;
    public $_edit = 0;
    public $locked = 0;
    
    public $username;
    
    public $password;
    public $repeat_password;
    public $old_password;
    public $new_password;
	
	public $language='auto';
    public $shownews=false;
    
    public $rememberMe=false;
    
    protected $encripted=false;
	
	protected $fplock=false;
	public function init() {
		$this->existing_lang = array( 
			"auto"=>Yii::t('app','Automatic'), 
			"ar"=>"العربية",
			"cs"=>"Česky",
			"da"=>"Dansk",
			"de"=>"Deutsch",
			"en"=>"English",
			"es"=>"Español",
			"fi"=>"Suomi",
			"fr"=>"Français",
			"he"=>"עִבְרִית",
			"hu"=>"Magyar",
			"id"=>"Bahasa Indonesia",
			"it"=>"Italiano",
			"ja"=>"日本語",
			"nl"=>"Dutch",
			"pl"=>"Polski",
			"ru"=>"Pусский",
			"se"=>"Svenska",
			"th"=>"ภาษาไทย",
			"zh-cn"=>"简体字",
			"zh-tw"=>"繁體字"
		);
		self::$meta_roles_name = array(
			'Scheduler' => Yii::t('app', 'Scheduler'),
			'Editor' =>  Yii::t('app', 'Editor'),
			'Creator' =>  Yii::t('app', 'Creator'),
			'Administrator' =>  Yii::t('app', 'Administrator'),
		);
		return parent::init();
	}
    /**
	 * @return array validation rules for model attributes.
	 */
	public function rules() {
		return array(
			array('username, password, new_password', 'length', 'max'=>35, 'min'=>3),
			//array('username', 'unique', 'caseSensitive'=>false, 'on' => 'register'),
			
			array('password', 'authenticatePass', 'on' => 'login'),
            array('username, rememberMe', 'safe', 'on' => 'login'),
            
			array('new_password', 'compare', 'compareAttribute'=>'repeat_password', 'on'=>'register, update, updateAdmin'),
			
            array('username, new_password, repeat_password', 'required', 'on' => 'register'),
            array('repeat_password', 'required', 'on' => 'update'),
			array('repeat_password', 'safe', 'on' => 'updateAdmin'),
			
            array('old_password', 'checkOldPassword', 'on' => 'update'),
			
			array('language, shownews', 'safe', 'on' => 'settings, update'),
            
			array('userRoles', 'required', 'on' => 'register, updateAdmin'),
			
            array(implode(",", self::$existing_roles), 'safe', 'on' => 'advanced'),
		);
	}
    
	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
			'username'=>Yii::t('app','Username'),
			'password'=>Yii::t('app','Password'),
			'repeat_password'=>Yii::t('app','Repeat password'),
			'old_password'=>Yii::t('app','Old password'),
			'new_password'=>Yii::t('app','New password'),
			'actions'=>Yii::t('app','Actions'),
			'language'=>Yii::t('app','Language'),
            'shownews'=>Yii::t('app','Get the latest news and tips from SpinetiX.'),
			
			'rememberMe'=>Yii::t('app','Remember me'),
            "admin"=>Yii::t('app','Manage user rights, backup and upload of layouts'),
            'file'=>Yii::t('app','Management of images, video, audio and hypermedia (Add, rename or delete)'),
            "model"=>Yii::t('app','Management of models (Add, rename or delete)'),
            "playlist"=>Yii::t('app','Modify playlists (Create, rename, delete or modify)'),
            "slide"=>Yii::t('app','Modify slides (Create, rename or delete slides only allowed if the user is allowed to modify the program)'),
            "program"=>Yii::t('app','Create and modify programs'),
            "activate"=>Yii::t('app','Allow the activation of saved programs'),
            "layout"=>Yii::t('app','Select and Modify the screen layout'),
            "feeds"=>Yii::t('app','Manage datafeeds (Create, modify structure, rename)'),
            "edit"=>Yii::t('app','Modify slides/datafeeds content'),
		);
	}
    public function setUserRoles( $role ) {
		if ( isset(User::$meta_roles[$role]) ) {
			foreach ( User::$existing_roles as $roles )
				$this->$roles = 0;
			foreach ( User::$meta_roles[$role] as $roles )
				$this->$roles = 1;
		}
    }
	
	public function getUserRoles(){
		$myRole="";
		foreach (User::$meta_roles as $name=>$roles ){
			$ok=true;
			foreach ( $roles as $role )
				if ($this->$role!=1)
					$ok=false;
			if ($ok)
				$myRole = $name;
				
		}
		return $myRole;
	}
    
	
    public function setEdit( $edit ) {
        $this->_edit=$edit;
    }
    public function setActivate( $act ) {
        $this->_activate=$act;
    }
    
    public function getEdit() {
        if ($this->slide) return true;
        return $this->_edit;
    }
    public function getActivate() {
        if ($this->program) return true;
        return $this->_activate;
    }
    
    public static function model() {
        $user = new User;
        return $user;
    }
    
    // static function to get one user
    public static function find( $username='' ) {
        $users = User::findAll( $username );
        if ( count($users)>=1 )
            return $users[0];
        else return NULL;
    }
    public static function clearAllsers() {
        if ( self::hasUsers() )
		    unlink (Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR.self::$passwordfile);
	}
	public static function hasUsers() {
		return file_exists(Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR.self::$passwordfile);
	}
    // static function to count the number of users
    public static function count( $username='' ) {
        $cnt = 0;
        if (file_exists(Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR.self::$passwordfile)) {
            $pfile = fopen(Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR.self::$passwordfile,"r");
            rewind($pfile);
        
            while (!feof($pfile)) {
                $line = fgets($pfile);
                
                $tmp = explode(':', $line);
                if ( count($tmp)>2 && $tmp[0]!="" ) {
                    //should be a more generic support of the conditions, but let's start with this
                    if ( $username=='' || $username==$tmp[0] )
                        $cnt++;
                }
            }
            fclose($pfile);
        } else {
            if ( $username=='' || $username=="admin" )
                $cnt++;
        }   
        return $cnt;
    }
    
    // static function to get all users
    public static function findAll( $username='' ) {
        $users =  array();
        
        if (file_exists(Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR.self::$passwordfile)) {
            $pfile = fopen(Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR.self::$passwordfile,"r");
            rewind($pfile);
        
            while (!feof($pfile)) {
                $line = fgets($pfile);
                
                $tmp = explode(':', $line);
                if ( count($tmp)>2 && $tmp[0]!="" ) {
                    $user = new User;
                    $user->username = $tmp[0];
                    $user->password = $tmp[1];
					if ( count($tmp)>3 && trim($tmp[3])!="")
						$user->language = trim($tmp[3]);
                    if ( count($tmp)>4 )
						$user->shownews = trim($tmp[4])=="1";
                    if ( count($tmp)>2 && trim($tmp[2])!="" ){
                        $tmp = explode(',',trim($tmp[2]));
                        foreach (self::$existing_roles as $r ) {
                            $user->$r = in_array($r, $tmp)?1:0;
                        }
                    }
                    $user->encripted = true;
                    //should be a more generic support of the conditions, but let's start with this
                    if ( $username=='' || $username==$user->username )
                        $users[] = $user;
                }
            }
            fclose($pfile);
        } else {
            $user = new User;
            $user->username = "admin";
            $user->password  = "admin";
            $user->setUserRoles('Administrator');
            $user->encryptPassword();
            if ( $username=='' || $username==$user->username )
                $users[] = $user;
        }   

        uasort($users, 'sortUsers' );
        
        return $users;
    }
    // saving an user
    public function save() {
        
        if (isset($this->new_password) && $this->new_password!=''){
            $this->password = $this->new_password;
            $this->encripted = false;
        }
            
        $this->encryptPassword();
        // load all users, check if the user exist, and save all users
		if ( !$this->lock() ) 
			return false;
        $users = User::findAll();
        $found=false;
        foreach ( $users as &$user ) {
            if ( $user->username == $this->username ){
                $found=true;
				
                $user = $this;
            }
        }
        if (!$found)
            $users[] = $this;
		if ( $this->scenario != "register" ) {
            Yii::app()->user->setLanguage( $this->language );
            Yii::app()->user->setShownews( $this->shownews );
        }
        $ret = self::saveUsers( $users );
		
		if ( !$this->unlock() )
			return false;
			
		return $ret;
    }
    // delete an user
    public function delete() {

        if ( $this->username=="admin" ) return false;
        // load all users, check if the user exist, and save all users
		if ( !$this->lock() ) 
			return false;
        $users = User::findAll();
        $found=false;
        foreach ( $users as &$user ) {
            if ( $user->username == $this->username ){
                $user->username = '';
                $found=true;
            }
        }
        if ( !$found ) return false;
        
        Yii::app()->user->deleteLastAction( $this->username );
         
		$ret = self::saveUsers( $users );
		
		if ( !$this->unlock() )
			return false;
			
		return $ret;
    }
	
    public static function saveUsers( $users ) {
        //save the file
		$name = Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR.self::$passwordfile;
		$tmpname = $name.uniqid();
        $pfile = fopen($tmpname,"w");
        if (!$pfile) return false;
        
        foreach ($users as $u) {
            if ( $u->username!="" ) {
                $roles="";
                $tmp = array();
                foreach ( self::$existing_roles as $r ) 
                    if ( $u->$r ) $tmp[] = $r;
                if (count($tmp)>0)
                    $roles = trim( implode(",", $tmp) );
				if ( $u->language=='auto' )
					fwrite($pfile, $u->username .":". $u->password .":". $roles ."::".($u->shownews?"1":"0")."\n");
				else
					fwrite($pfile, $u->username .":". $u->password .":". $roles .":".$u->language.":".($u->shownews?"1":"0")."\n");
            }
        }
        fclose($pfile);
        
		// rename tmp file
        if(PHP_OS == "WINNT")
            unlink($name);
		rename($tmpname, $name);
		// sync it
		exec('sync');
		
        return true;
    }
    
    function getRoles() {
        $roles = array();
        foreach (self::$existing_roles as $r)
            if ( $this->$r ) $roles[] = $r;
        return $roles;
    }
	/**
	 * Authenticates the password.
	 * This is the 'authenticatePass' validator as declared in rules().
	 */
	public function authenticatePass($attribute,$params) {
		
		if (!$this->hasErrors()) { // we only want to authenticate when no input errors
            
            $identity = new UserIdentity($this->username, md5($this->password) );
			$identity->authenticate();
			
			switch ($identity->errorCode) {
				case UserIdentity::ERROR_NONE:
					$duration = $this->rememberMe ? 3600*24*30 : 0; // 30 days
					
                    Yii::app()->user->login($identity, $duration);
                    // setting up the roles for this user now that it is logged in
                    Yii::app()->user->setRoles( $identity->user->getRoles() );
					Yii::app()->user->setLanguage( $identity->user->language );
                    Yii::app()->user->setShownews( $identity->user->shownews );
                   
					break;
					
				case UserIdentity::ERROR_USERNAME_INVALID:
					$this->addError('username',Yii::t('app','Username is incorrect.'));
					break;
								
				default: // UserIdentity::ERROR_PASSWORD_INVALID
					$this->addError('password',Yii::t('app','Password is incorrect.'));
					break;
			}
		}
	}
    
    public function checkOldPassword($attribute,$params) {
        if ( md5($this->old_password)!=$this->password) {
            $this->addError('password_old',Yii::t('app','Old password is incorrect.'));
        }
    }
	
    public function encryptPassword() {
        if (!$this->encripted)
            $this->password = md5($this->password);
        $this->encripted = true;
    }
	public function lock() {
		$name = Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR."pass.lock";
		if ( !file_exists($name) )
			file_put_contents($name, "");
			
		$this->fplock = fopen($name, "r+");
		if (!$this->fplock) return false;
		if ( !flock($this->fplock, LOCK_EX) )
			return false;
		return true;
	}
	public function unlock() {
		$name = Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR."pass.lock";
		if (!$this->fplock) return false;
		flock($this->fplock, LOCK_UN); // release the lock
		fclose($this->fplock);
		return true;
	}

}