<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"> 
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<meta name="language" content="en" />
<link rel="shortcut icon" href="<?php echo Yii::app()->request->baseUrl; ?>/css/images/favicon.ico" type="image/x-icon" />
<title><?php echo Yii::t('app',"SpinetiX Fusion"); ?></title>
</head>

<body>
<div id="page">

<div id="header">
<?php 
    echo CHtml::image( 'images/fusion.png', "Fusion", array('class'=>'main_logo') ); 
?>
</div> <!-- header -->

<div id="top-menu" > 

<?php 

Yii::app()->getClientScript()->registerCoreScript('jquery');

Yii::app()->getClientScript()->registerCssFile(Yii::app()->request->baseUrl."/css/main.css");
Yii::app()->getClientScript()->registerCssFile(Yii::app()->request->baseUrl."/css/thickbox.css");

Yii::app()->getClientScript()->registerScriptFile(Yii::app()->request->baseUrl."/scripts/jquery.watermark.js");
Yii::app()->getClientScript()->registerScriptFile(Yii::app()->request->baseUrl."/scripts/thickbox.js");



if ( !Yii::app()->user->isGuest && Yii::app()->user->activated ) {
    $this->widget('application.components.TopMenu',array(
        'title' => Yii::t('app', 'Manage' ),
        'items'=>array(
            array(  'label'=>Yii::t('app', 'Programs'), 
                    'title'=>Yii::t('app', 'Manage Programs'), 
                    'url'=>array('player/restore'),  
                    'visible'=>true,//Yii::app()->user->checkAccess("program") || Yii::app()->user->checkAccess("activate"),
                ),
            array(  'label'=>Yii::t('app', 'Slides'), 
                    'title'=>Yii::t('app', 'Manage Slides'), 
                    'url'=>array('slides/list'), 
                    'visible'=>true,//Yii::app()->user->checkAccess("slide") || Yii::app()->user->checkAccess("edit"),
                ),
            array(  'label'=>Yii::t('app', 'Playlists'), 
                    'title'=>Yii::t('app', 'Manage Playlists'), 
                    'url'=>array('playlist/list'), 
                    'visible'=>true,//Yii::app()->user->checkAccess("playlist") 
                ),
            array(  'label'=>Yii::t('app', 'Media'), 
                    'title'=>Yii::t('app', 'Manage Media'), 
                    'url'=>array('files/list') 
                ),
            array(  'label'=>Yii::t('app', 'Settings'), 
                    'title'=>Yii::t('app', 'Settings' ), 
                    'url'=>array('settings/settings')
                ),
        ),
    )); 
} else {
    $this->widget('application.components.TopMenu',array(
        'title' => Yii::t('app', "Welcome" ),
        'items'=>array(
            
        ),
    )); 
}

?>

</div> <!-- top-menu -->

<div id="content">
<?php echo $content; ?>
</div><!-- main_area -->


<?php 
echo CHtml::openTag('div',  array('id'=>'footer') );

LayoutHelper::openBorders();

echo CHtml::openTag('div',  array('class'=>'footer-content') );

if ( file_exists('/etc/spinetix-release') ) {
	$release = file_get_contents('/etc/spinetix-release');
	$vals=explode(" ", $release);
	$firmware = "x.x.x";
	$build = "x.x.x";
	if (count($vals)==6 ){
		$firmware = $vals[3];
		$build = $vals[5];
	}
	echo CHtml::tag("span", array('class'=>'firmware'), "v ".$firmware. " - ".$build);
}

echo CHtml::tag("span", array('class'=>'copyrights'), "Copyright &copy; SpinetiX AG. All Rights Reserved.");

echo CHtml::closeTag("div");

LayoutHelper::closeBorders();

echo CHtml::closeTag("div");

?>

</div> <!-- id="page" -->
</body>

</html>