<?php 

    $this->widget('UploadMedia',array( 	'dest'=>'files/upload', 
                                        'reload'=>"$('#SettingsTabs').tabs('load', $('#SettingsTabs').tabs('option', 'selected') );",
                                        'class'=>"top-button",
                                        'scriptOnly'=>true,
                                    ) );
    $this->widget('application.components.Tip');                                    
	
$script =<<<EOL
	function setMarks( p ) {
		$("input", p).each( function() {
			$(this).watermark($(this).attr('title'), {className: 'watermark'});
		});
	};
	function ajaxSubmitReplace( node, dest ) {
		var form = node.parents("form");
        form.fadeTo("fast", 0.2);
        tb_create_loader();
		$('.watermark', form).val("");
		jQuery.ajax({	'type':'POST',
						'url':form.attr("action"),
						'cache':false,
						'data':form.serialize(),
						'success':function(html){   if (dest!=null) 
                                                        dest.html(html); 
                                                    setMarks( dest ); 
                                                    tb_remove();
                                                }
					});
		return false;
	}
    function ajaxSubmitReload( node ) {
		var form = node.parents("form");
        form.fadeTo("fast", 0.2);
        tb_create_loader();
		$('.watermark', form).val("");
		jQuery.ajax({	'type':'POST',
						'url':form.attr("action"),
						'cache':false,
						'data':form.serialize(),
						'success':function(html){   location.reload( true ); }
					});
		return false;
	}
	function ajaxSubmitDelete( node ) {
		var toDelete = node.parent().parent().parent();
		var link = node.attr('href');
		jQuery.ajax({
			'url':link,
			'cache':false,
			'success':function(data, textStatus){ toDelete.fadeOut("slow") },
			'error':function(data, textStatus){ toDelete.fadeIn("fast") },
			'beforeSend':function(data, textStatus){ toDelete.fadeTo("fast", 0.5) }	
		});
	}
	function changeUser( id, node ) {
		$('#UsernameHidden').val( id );
		$('#UsernameShown').val( id ).attr('disabled', 'disabled');
		$('#AddUsers').hide();
		$('#UpdateUsers').show();
		$('#TitleNewUser').hide();
		$('#TitleChangeUser').show();
		
        $('#PasswordNewUser').remove();
        
		var link = node.attr('href');
		$('#FormUser').attr('action', link);
		
		var idx=0;
		node.parent().parent().children('.check').each( function(index) {
			var inp = $(this).children('input');
			if ( inp.attr('checked') )
				idx=index;
		});
		$('#UserRoles').children('.check').each( function(index) {
			if ( index==idx )
				$(this).children('input').attr('checked', 'checked');
			else
				$(this).children('input').attr('checked', '');
		});
	}
EOL;
	echo CHtml::script($script);

    $pages = array( ); 
	$selected = 0;
    $cur = 0;
    if ( $user ) {
        $pages[Yii::t('app','My Settings')] =array( 'content'=>$this->renderPartial( '/users/update', array('user'=>$user), true) ) ;
        $cur++;
    }
    
	if ( Yii::app()->user->checkAccess("layout") || Yii::app()->user->checkAccess("model") ){
		if ($page=='skin')
            $selected = $cur;
        $pages[Yii::t('app','Skins')] =array( 'ajax'=>CHtml::encode( CHtml::normalizeUrl( array("layout/list") ) ) ) ;
        $cur++;
    }
	if ( Yii::app()->user->checkAccess("model") ){
        if ($page=='templates')
            $selected = $cur;
        $pages[Yii::t('app','Templates')] =array( 'ajax'=>CHtml::encode( CHtml::normalizeUrl(array("files/media","type"=>"template") ) ) );
        $cur++;
    }
    if ( Yii::app()->user->checkAccess("admin") ){
        if ($page=='users')
            $selected = $cur;
		$pages[Yii::t('app','Users')] =array( 'ajax'=>CHtml::encode( CHtml::normalizeUrl( array("users/list") ) ) ) ;
        $cur++;
    }
	if ( Yii::app()->user->checkAccess("admin") ){
        if ($page=='backups')
            $selected = $cur;
		$pages[Yii::t('app','Backups')] =array( 'ajax'=>CHtml::encode( CHtml::normalizeUrl( array("backup/view") ) ) ) ;
        $cur++;
	}
	
	echo CHtml::openTag("div", array('class'=>"tabspage_header"));
	LayoutHelper::openBorders();
	echo CHtml::openTag("div", array( "class"=>"tabspage_header_inside" ) );
	
	echo CHtml::submitButton(Yii::t('app', 'Logout'), array( "class"=>  "top-button button",
															 "submit"=> array('users/logout'),
                                                             'title'=>Yii::t('app', 'Logout'),
                                                             'alt'=>Yii::t('app', 'Logout'),
															)
							);
	if ( isset( $error ) && $error!=null ) {
        echo CHtml::tag("div", array('class'=>'header_errror'), CHtml::errorSummary( $error ) );
    }
    
    echo CHtml::tag("h1", array( ), Yii::t('app',"Settings"));
	
   
	echo CHtml::closeTag("div" );
	LayoutHelper::closeBorders();
	echo CHtml::closeTag("div" );
	
	
	echo CHtml::openTag("div", array('class'=>"settings_section"));
	if ( Yii::app()->user->checkAccess("model") )
	    $this->widget('MediaSelect',array( 'type' => 'delscript' ) );
    else
        $this->widget('MediaSelect',array( 'type' => 'script' ) );
	
	$option =<<<EOL
{ dataFilter: function(result){ 
				if (result.substr(0,2)!='{\"') return result; 
				var data = $.parseJSON(result); 
				return "<div class='bottom-button' id='TemplateButtonArea' />" + createListAjax(data, data.nbMedia) + createTipAjax(data.tip);
			} 
}
EOL;
	
    $this->widget('CJuiTabsExt',array(
        'theme'=>'spxfusion',
        'tabs' => $pages,
        'id' => 'SettingsTabs',
		'callbacks'=>array( "load" => "function(event, ui) { 
                                            addButton('SkinButtonArea'); 
                                            addButton('TemplateButtonArea'); 
                                            addButton('BackupButtonArea', '".CHtml::normalizeUrl(array('backup/upload'))."', 'SystemBackup[file]');
                                            setMarks( $('#NewUser') ); 
                                            setMarks( $('#NewBackup') ); 
                                        }",
							'ajaxOptions'=> $option,
						),
        'options'=>array("selected"=>$selected),
        )
    ); 
    echo CHtml::closeTag("div" );


