/*
* jQuery RTE plugin 0.5.1 - create a rich text form for Mozilla, Opera, Safari and Internet Explorer
*
* Copyright (c) 2009 Batiste Bieler
* Distributed under the GPL Licenses.
* Distributed under the MIT License.
*/

// define the rte light plugin
(function($) {

if(typeof $.fn.rte === "undefined") {

    var defaults = {
        media_url: "",
        submit: false,
        content_css_url: "rte.css",
        edit_mode : true,
        height: 350,
        width: 500, 
        margin_left: "50px"
    };

    $.fn.rte = function(options) {

    $.fn.rte.html = function(iframe) {
        return iframe.contentWindow.document.getElementsByTagName("body")[0].innerHTML;
    };

    // build main options before element iteration
    var opts = $.extend(defaults, options);


        
    // iterate and construct the RTEs
    return this.each( function() {
        

        var textarea = $(this);
        textarea.attr( "style", "background:#FFFFFF;margin-left: 160px;" );
        var iframe;
        var element_id = textarea.attr("id");

        // enable design mode
        function enableDesignMode() {

            var content = textarea.val();

            // Mozilla needs this to display caret
            if($.trim(content)=='') {
                content = '<br />';
            }
            //we need to convert svg to html:
            content = content.replace(/<(\/*\s*)tspan([^>]*)>/g,"<$1span$2>"); //tspan => span
            content = content.replace(/font-style="italic" font-weight="bold"/g,"style='font-style: italic; font-weight: bold;'"); //tspan => span
            content = content.replace(/font-weight="bold"/g,"style='font-weight: bold;'"); //tspan => span
            content = content.replace(/font-style="italic"/g,"style='font-style: italic;'"); //tspan => span
            content = content.replace(/<tbreak\s*\/>\n?/g,"<br/>"); //tbreak => br
                     

            // already created? show/hide
            if(iframe) {
                textarea.hide();
                $(iframe).contents().find("body").html(content);
                $(iframe).show();
                $("#toolbar-" + element_id).remove();
                textarea.before(toolbar());
                return true;
            }

            // for compatibility reasons, need to be created this way
            iframe = document.createElement("iframe");
            iframe.frameBorder=1;
            iframe.marginwidth=5;
            iframe.width=opts.width;
            iframe.height=opts.height;
            if(textarea.attr('class'))
                iframe.className = textarea.attr('class');
            if(textarea.attr('id'))
                iframe.id = element_id;
            if(textarea.attr('name'))
                iframe.title = textarea.attr('name');
            iframe.style.marginLeft = opts.margin_left;            
            textarea.after(iframe);

            var css = "";
            if(opts.content_css_url) {
                css = "<link type='text/css' rel='stylesheet' href='" + opts.content_css_url + "' />";
            }
            var doctype="<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
            var doc = "<html xmlns='http://www.w3.org/1999/xhtml'><head>"+css+"</head><body class='frameBody'>"+content+"</body></html>";
            tryEnableDesignMode(doctype+doc, function() {
                $("#toolbar-" + element_id).remove();
                textarea.before(toolbar());
                // hide textarea
                textarea.hide();

            });

        }

        function tryEnableDesignMode(doc, callback) {
            if(!iframe) { return false; }

            try {
                iframe.contentWindow.document.open();
                iframe.contentWindow.document.write(doc);
                iframe.contentWindow.document.close();
            } catch(error) {
                //console.log(error);
            }
            if (document.contentEditable) {
                iframe.contentWindow.document.designMode = "On";
                callback();
                return true;
            }
            else if (document.designMode != null) {
                try {
                    iframe.contentWindow.document.designMode = "on";
                    callback();
                    return true;
                } catch (error) {
                    //console.log(error);
                }
            }
            setTimeout(function(){tryEnableDesignMode(doc, callback)}, 500);
            return false;
        }
        
        function changeItalicTag( str , tag) {
            var s=tag.length;
            while(1) {
                var pos = str.indexOf("<"+tag+">"); 
                if ( pos<0 ) return str;
                var pos2 = str.indexOf("</"+tag+">", pos); 
                if ( pos2<0 ) return str;
                str = str.substring(0, pos) + "<tspan style='font-style: italic'>" + str.substring(pos+s+2, pos2) + "</tspan>" + str.substring(pos2+s+3);
            }            
        }
        function changeBoldTag( str , tag) {
            var s=tag.length;
            while(1) {
                var pos = str.indexOf("<"+tag+">"); 
                if ( pos<0 ) return str;
                var pos2 = str.indexOf("</"+tag+">", pos);
                if ( pos2<0 ) return str;
                str = str.substring(0, pos) + "<tspan style='font-weight: bold'>"  + str.substring(pos+s+2, pos2) + "</tspan>" + str.substring(pos2+s+3);
            }            
        }
        
        function disableDesignMode(submit) {
            var content = $(iframe).contents().find("body").html();
            
            // for ie
            content = content.replace(/FONT-WEIGHT/g,"font-weight"); 
            content = content.replace(/FONT-STYLE/g,"font-style"); 
            content = changeItalicTag( content, "em" ) ;
            content = changeItalicTag( content, "EM" ) ;
            content = changeBoldTag( content, "strong" ) ;
            content = changeBoldTag( content, "STRONG" ) ;
            content = content.replace(/<p>\s*/gi,""); 
            content = content.replace(/<\/p>\s*/gi,"<tbreak/>"); 
            // for safari
            content = content.replace(/<div><br\/?><\/div>/gi,"<tbreak/>");
            content = content.replace(/<div>\n?/gi,"<tbreak/>"); 
            content = content.replace(/<\/div>\n?/gi,""); 
            content = changeItalicTag( content, "i" ) ;
            content = changeBoldTag( content , "b" ) ;
            
            //we need to convert html to svg:
            content = content.replace(/<(\/*\s*)span([^>]*)>/gi,"<$1tspan$2>"); //tspan => span
            content = content.replace(/<br\s*\/?>\s*/gi,"<tbreak/>"); //br => tbreak
            content = content.replace(/&nbsp;/g," "); //nbsp do not exist in svg
            
            //
            //
            //content = changeEMTag( content ) ;
            //content = changeSTRONGTag( content ) ;
            //content = content.replace(/<STRONG>(.*)<\/STRONG>/gi,"<tspan style='font-weight: bold'>$1</tspan>");
            
            
            if($(iframe).is(":visible")) {
                textarea.val(content);
            }

            if(submit !== true) {
                textarea.show();
                $(iframe).hide();
            }
        }
    
        // create toolbar and bind events to it's elements
        function toolbar() {
            if (navigator.userAgent.indexOf("Firefox")!=-1 || navigator.userAgent.indexOf("Chrome")!=-1 ) {
                var tb = $("<div class='rte-toolbar' id='toolbar-"+ element_id +"'><div>\
                        <a href='#' class='bold'><img src='"+opts.media_url+"bold.gif' alt='bold' /></a>\
                        <a href='#' class='italic'><img src='"+opts.media_url+"italic.gif' alt='italic' /></a>\
                        <a href='#' class='disable'><img src='"+opts.media_url+"close.gif' alt='close rte' /></a>\
                    </div></div>");
            } else {
                var tb = $("<div class='rte-toolbar' id='toolbar-"+ element_id +"'><div>\
                        <a href='#' class='disable'><img src='"+opts.media_url+"close.gif' alt='close rte' /></a>\
                    </div></div>");
            }

            $('.bold', tb).click(function(){ formatText('bold');return false; });
            $('.italic', tb).click(function(){ formatText('italic');return false; });
            $('.disable', tb).click(function() {
                disableDesignMode();
                var edm = $('<a class="rte-edm" href="#">Use rich text editor</a><label/>');
                tb.empty().append(edm);
                edm.click(function(e){
                    e.preventDefault();
                    enableDesignMode();
                    // remove, for good measure
                    $(this).remove();
                });
                return false;
            });

            
            $(iframe).parents('form').submit(function(){
                disableDesignMode(true);
            });
            if ( opts.submit!=false ) opts.submit.click(function(){  
                disableDesignMode( true ); 
            });

            return tb;
        };

        function getSelText( wnd )
        {
            var txt = '';
            if ( wnd.getSelection ){
                txt = wnd.getSelection();
            } else if ( wnd.document.getSelection ) {
                txt = wnd.document.getSelection();
            } else if ( wnd.document.selection ){
                txt = wnd.document.selection.createRange().text;
            } else return "";
            return txt;
        };
        
        function formatText(command, option) {
            iframe.contentWindow.focus();
            try{
                iframe.contentWindow.document.execCommand(command, false, option);
            }catch(e){
                //console.log(e)
            }
            iframe.contentWindow.focus();
        };

        
        function getSelectionElement() {
            if (iframe.contentWindow.document.selection) {
                // IE selections
                selection = iframe.contentWindow.document.selection;
                range = selection.createRange();
                try {
                    node = range.parentElement();
                }
                catch (e) {
                    return false;
                }
            } else {
                // Mozilla selections
                try {
                    selection = iframe.contentWindow.getSelection();
                    range = selection.getRangeAt(0);
                }
                catch(e){
                    return false;
                }
                node = range.commonAncestorContainer;
            }
            return node;
        };
        if ( opts.edit_mode==true ) {
            // enable design mode now
            enableDesignMode();
        } else {
            var edm = $('<div><a class="rte-edm" href="#">Use rich text editor</a></div>');
            textarea.before(edm);
            edm.click(function(e){
                e.preventDefault();
                enableDesignMode();
                // remove, for good measure
                $(this).remove();
            });
        }
        
        
    }); //return this.each
    
    }; // rte

} // if

})(jQuery);
