#!/bin/sh
#
# chkconfig: S 40 0
#
# Sets the system and RTC time based on an time offset file, if present.
#

# This must be performed after reading the date from the RTC (hwclock)
# and before the NTP daemon is started and before network is started,
# otherwise there are race conditions between NTP and us and we may
# end up with an unknown time and/or disabling the auto-update mode of
# NTP, even if it works in loopback mdoe from the system time without
# an external reference clock.

# Init script information
INIT_NAME=rcS

# The file where the time offset is stored
OFFSET_FILE=/var/spool/spxutils/dateadjust

init() {
    # Load init script configuration
    [ -f /etc/default/$INIT_NAME ] && . /etc/default/$INIT_NAME

    # Source the init script functions
    . /etc/init.d/init-functions

    case "$UTC" in
	no|"") GMT="--localtime" ;;
	yes)   GMT="--utc"       ;;
	*)     log_status_msg "$0: unknown UTC setting: \"$UTC\"" >&2 ;;
    esac
}

case "$1" in
    start|restart)
    if [ -f "$OFFSET_FILE" ]; then
	init
	log_status_msg "Setting date: " -n
	OFFSET="$(< "$OFFSET_FILE" )"
	rm -f "$OFFSET_FILE"
	if [ -f "$OFFSET_FILE" ]; then
	    log_failure_msg "failed removing offset file, cannot set date."
	    exit 1
	fi
	log_status_msg "system" -n
	date -s "$OFFSET" > /dev/null
	RET=$?
	if [ $RET -ne 0 ]; then
	    log_failure_msg " failed ($RET)."
	    exit 1
	fi
	log_status_msg ", RTC" -n
	hwclock $GMT --systohc
	RET=$?
	if [ $RET -ne 0 ]; then
	    log_failure_msg " failed ($RET)."
	    exit 1
	fi
	log_success_msg "."
    fi
    ;;
    stop|reload|force-reload)
    ;;
esac



