#!/bin/bash
#
#  Copyright 2006 by Texas Instruments Incorporated.
#  
#  Modifications (C) 2007 SpinetiX S.A.
#  
#  All rights reserved. Property of Texas Instruments Incorporated.
#  Restricted rights to use, duplicate or disclose this code are
#  granted through contract.
#  
#

#
# Function to load the hardware type into HARDWARE variable
#
function load_hardware
{
    local tag sep val
    HARDWARE=
    while read tag sep val; do
	if [ "$tag" = "Hardware" ]; then
	    HARDWARE="$val"
	    return 0
	fi
    done < /proc/cpuinfo
    echo "Could not find hardware type" >&2
    return 1
}

# Load hardware type
load_hardware || exit 1

if [ "$HARDWARE" = "ti8148evm" ] || [ "$HARDWARE" = "ikebana" ]; then

    grep -q '^ti81xxhdmi' /proc/modules && /sbin/rmmod ti81xxhdmi.ko 
    grep -q '^ti81xxvo' /proc/modules && /sbin/rmmod ti81xxvo.ko 
    grep -q '^vpss' /proc/modules && /sbin/rmmod vpss.ko 
    (./slaveloader list | grep -q "VPSS-M3 \[Running\]") && ./slaveloader shutdown VPSS-M3 > /dev/null
    grep -q '^syslink' /proc/modules && /sbin/rmmod syslink.ko 
    # Wait some time to correctly unload syslink. 5 sec seem to be enough.
    sleep 5

else

    grep -q '^dsplinkk' /proc/modules && /sbin/rmmod dsplinkk.ko 
    rm -f /dev/dsplink

fi

grep -q '^cmemk' /proc/modules && /sbin/rmmod cmemk.ko 
#
#  @(#) codec_engine_1_02 1,0,0,147 7-14-2006 ce-d14
#

