<?php


Yii::import('zii.widgets.jui.CJuiTabs');

/**
 * CJuiTabsExt displays a tabs widget, extension of CJuiTabs to support views
 *
 */
class CJuiTabsExt extends CJuiTabs
{

    /**
	 * @var array list of callbacks to be handled by the pugin.
	 */
    public $callbacks=array();
    /**
    * Generates the options for the jQuery widget
    *
    * @return string
    */
    protected function makeOptions()
    {
      $options = array();

      foreach ($this->callbacks as  $key=>$val) {
         $options['callback_'.$key] = $key;
      }

      $encodedOptions = CJavaScript::encode(array_merge($options, $this->options));

      foreach ($this->callbacks as $key=>$val) {
         $encodedOptions = str_replace("'callback_{$key}':'{$key}'", "{$key}: {$val}", $encodedOptions);
      }

      return $encodedOptions;
    }
	/**
	 * Run this widget.
	 * This method registers necessary javascript and renders the needed HTML code.
	 */
	public function run()
	{
		$id=$this->getId();
		$this->htmlOptions['id']=$id;

		echo CHtml::openTag($this->tagName,$this->htmlOptions)."\n";

		$tabsOut = "";
		$contentOut = "";
		$tabCount = 0;

		foreach($this->tabs as $title=>$content)
		{
			$tabId = (is_array($content) && isset($content['id']))?$content['id']:$id.'_tab_'.$tabCount++;

			if (!is_array($content)){
				$tabsOut .= strtr($this->headerTemplate, array('{title}'=>$title, '{url}'=>'#'.$tabId))."\n";
				$contentOut .= strtr($this->contentTemplate, array('{content}'=>$content,'{id}'=>$tabId))."\n";

			}elseif (isset($content['content'])){
				$tabsOut .= strtr($this->headerTemplate, array('{title}'=>$title, '{url}'=>'#'.$tabId))."\n";
				$contentOut .= strtr($this->contentTemplate, array('{content}'=>$content['content'],'{id}'=>$tabId))."\n";

			}elseif (isset($content['ajax'])){
				$tabsOut .= strtr($this->headerTemplate,array('{title}'=>$title, '{url}'=>CHtml::normalizeUrl($content['ajax'])))."\n";
			}elseif (isset($content['view'])){
				$tabsOut .= strtr($this->headerTemplate, array('{title}'=>$title, '{url}'=>'#'.$tabId))."\n";
                ob_start();
                $this->getController()->renderPartial($content['view'], $content['viewData']);
                $view_content = ob_get_contents();
                ob_end_clean();
                $contentOut .= strtr($this->contentTemplate, array('{content}'=>$view_content ,'{id}'=>$tabId))."\n";
			}elseif (isset($content['widget'])){
				$tabsOut .= strtr($this->headerTemplate, array('{title}'=>$title, '{url}'=>'#'.$tabId))."\n";
                ob_start();
                $content['widget']->init();
                $content['widget']->run();
                $widget_content = ob_get_contents();
                ob_end_clean();
				$contentOut .= strtr($this->contentTemplate, array('{content}'=>$widget_content ,'{id}'=>$tabId))."\n";
			}
		}
		echo "<ul>\n" . $tabsOut . "</ul>\n";
		echo $contentOut;

		echo CHtml::closeTag($this->tagName)."\n";

		$options=empty($this->options)&&empty($this->callbacks) ? '' : $this->makeOptions();
		Yii::app()->getClientScript()->registerScript(__CLASS__.'#'.$id,"jQuery('#{$id}').tabs($options);");
	}
}
