<?php


Yii::import('zii.widgets.jui.CJuiWidget');

/**
 * CJuiTabsExt displays a tabs widget, extension of CJuiTabs to support views
 *
 */
class HelpBox extends CJuiWidget
{

    /**
	 * @var string the name of the container element that contains the dialog. Defaults to 'div'.
	 */
	public $tagName='div';
    
    public $icon='error';
    
    public $helpTitle=false;
    
    public $helpContent='';
    
    public $clickTarget=null;
    /**
	 * @var array list of callbacks to be handled by the pugin.
	 */
    public $callbacks=array();
    /**
    * Generates the options for the jQuery widget
    *
    * @return string
    */
    protected function makeOptions()
    {
      $options = array();

      foreach ($this->callbacks as  $key=>$val) {
         $options['callback_'.$key] = $key;
      }

      $encodedOptions = CJavaScript::encode(array_merge($options, $this->options));

      foreach ($this->callbacks as $key=>$val) {
         $encodedOptions = str_replace("'callback_{$key}':'{$key}'", "{$key}: {$val}", $encodedOptions);
      }

      return $encodedOptions;
    }
	/**
	 * Run this widget.
	 * This method registers necessary javascript and renders the needed HTML code.
	 */
	public function run()
	{
		$id=$this->getId();
		$this->htmlOptions['id']=$id;
        if ( $this->helpTitle!==false )
            $this->htmlOptions['title']=$this->helpTitle;
        
        
        if ( $this->icon!== false ) {     
            $this->clickTarget = $id."_click";    
            echo CHtml::image("images/{$this->icon}.png", $this->icon , array('id'=>$this->clickTarget, 'title'=>'click for help', 'style'=>'vertical-align:bottom') );
        }
        
        if ( !isset( $this->options['autoOpen']) && $this->clickTarget!==null )
            $this->options['autoOpen'] = false;
        
		echo CHtml::tag($this->tagName, $this->htmlOptions,
                                        CHtml::tag("p", array(), $this->helpContent)
                        )."\n";

		
		$options=empty($this->options)&&empty($this->callbacks) ? '' : $this->makeOptions();
        $code = "jQuery('#{$id}').dialog($options); ";
        if ( $this->clickTarget!==null ){
            $target = $this->clickTarget;
            $code .="jQuery('#{$target}').click( function() { jQuery('#{$id}').dialog('open'); } ); ";
        }
		Yii::app()->getClientScript()->registerScript(__CLASS__.'#'.$id,$code);
	}
}
