<?php

/**
 * URLValidator class file.
 */

class SimpleURLValidator extends CValidator {

    /**
     * @var boolean whether the attribute value can be null or empty. Defaults to true,
     * meaning that if the attribute is empty, it is considered valid.
     */
    public $allowEmpty = true;

   /**
    * @var array list of URI schemes which should be considered valid. By default, http and https
    * are considered to be valid schemes.
    **/
    public $validSchemes=array('http','https');

    /**
     * Validates the attribute of the object.
     * If there is any error, the error message is added to the object.
     * @param CModel $object the object being validated
     * @param string $attribute the attribute being validated
     */
    protected function validateAttribute($object, $attribute) {
        $value = $object->$attribute;
        if ($this->allowEmpty && $this->isEmpty($value))
            return;
        /*
        if ( !filter_var($value, FILTER_VALIDATE_URL) ){
            $this->addError($object, $attribute, '{attribute} is not a valid URL.');
        }
        */
        
        if ( $this->validSchemes!==false ) {
            $matches = null;
            $scheme = '/^('.implode('|',$this->validSchemes).'):\/\/([^\/:]+)(?::\d)?\/?(.*)/';
            if ( !preg_match($scheme, $value, $matches ) ) {
                $this->addError($object, $attribute, "Scheme of {attribute} is not valid.");
                return false;
            }
            $host = $matches[2];
            if ( count($matches)>3 ) 
                $path = $matches[3];
            else
                $path = "";
            
            $valid_host = preg_match("/^([a-z\d](-*[a-z\d])*)(\.([a-z\d](-*[a-z\d])*))*\.?$/i", $host) //valid chars check
                          && strlen( $host ) < 254 //overall length check
                          && preg_match("/^[^\.]{1,63}(\.[^\.]{1,63})*\.?$/", $host); //length of each label
            if ( !$valid_host ) {
                $this->addError($object, $attribute, "Host of {attribute} is not valid.");
                return false;
            }
        } else {
            $path = "";
        }
        if ( preg_match("/[^\]\-[:\/?&#@*+,;=a-zA-z0-9._~%]/",$path ) ){
            $this->addError($object, $attribute, "Path of {attribute} is not valid.");
        }
        
        
    }

}