<?php


Yii::import('zii.widgets.jui.CJuiWidget');

/**
 * wizardItems displays items one by one with a next and previous button widget
 *
 */
class WizardItems extends CJuiWidget
{

    /**
	 * @var string the name of the container element that contains the dialog. Defaults to 'div'.
	 */
	public $tagName='div';
    
    public $contentTemplate = "<div id='{id}'>\n<h1>{title}</h1>\n<div class='content'>{content}</div>\n<div class='action nextitem'>{buttons}</div>\n</div>";
    
    public $button1Template = "";
    public $button2Template = "";
    public $button3Template = "";
    /**
	 * @var array list of panels (panel title=>panel content).
	 * Note that neither panel title nor panel content will be HTML-encoded.
	 */
	public $panels=array();
    
    public $button = array( "prev"=> "Previous", "next" => "Next", 'end' => "Finish" );
    
	/**
	 * Run this widget.
	 * This method registers necessary javascript and renders the needed HTML code.
	 */
	public function run()
	{
        if ( $this->button1Template=="" )
            $this->button1Template = CHtml::button("Next", array( 'class'=>'next button' ) );
        if ( $this->button2Template=="" )
            $this->button2Template = CHtml::button("Previous", array( 'class'=>'previous button' ) ) ." ". CHtml::button("Next", array( 'class'=>'next button' ) );
        if ( $this->button3Template=="" )
            $this->button3Template = CHtml::button("Previous", array( 'class'=>'previous button' ) ) ." ". CHtml::submitButton("Finish", array( 'class'=>'next button' ) );
    
		$id = $this->getId();
		$this->htmlOptions['id']=$id;

        $tabCount = 0;
		echo CHtml::openTag( $this->tagName, $this->htmlOptions) ."\n";
        
        $nbPanels = count( $this->panels );
        
        $idList = array();
        $script = "";
        $contentOut = "";
		foreach( $this->panels as $title=>$content ) {
        
			$tabId = (is_array($content) && isset($content['id']))?$content['id']:$id.'_tab_'.$tabCount;
            
            $idList[] = $tabId;
            
            if ( $tabCount==0 ) {
                $buttons = $this->button1Template;
            } else if ( $tabCount==$nbPanels-1 ) {
                $buttons = $this->button3Template;
            } else {
                $buttons = $this->button2Template;
            }
            $tabCount++;
            
			if ( !is_array($content) ){
				
                $contentOut .= strtr($this->contentTemplate, array('{title}'=>$title, '{content}'=>$content, '{id}'=>$tabId, '{buttons}'=>$buttons ) )."\n";
                
			} else {
                if ( isset( $content['button'] ) ){
                    $buttons = $content['button'];
                }
                if ( isset( $content['script'] ) ){
                    $script .= $content['script'] ."\n";
                }
                if ( isset( $content['enable'] ) ){
                    $script .= "$('#".$tabId."').find('.next').button('disable')" ."\n";
                    $script .= strtr($content['enable'] , array( '{this}'=>"$('#".$tabId."')", 
																 '{enable}'=>"$('#".$tabId."').find('.next').button('enable');",
																 '{disable}'=>"$('#".$tabId."').find('.next').button('disable');" 
																)) ."\n";
                }
                if (isset($content['content'])){

                    $contentOut .= strtr($this->contentTemplate, array('{title}'=>$title, '{content}'=>$content['content'],'{id}'=>$tabId, '{buttons}'=>$buttons ))."\n";

                } elseif (isset($content['view'])){
                    
                    ob_start();
                    $this->getController()->renderPartial($content['view'], $content['viewData']);
                    $view_content = ob_get_contents();
                    ob_end_clean();
                    $contentOut .= strtr($this->contentTemplate, array('{title}'=>$title, '{content}'=>$view_content ,'{id}'=>$tabId, '{buttons}'=>$buttons ))."\n";
                    
                }elseif (isset($content['widget'])){
                    
                    ob_start();
                    $content['widget']->init();
                    $content['widget']->run();
                    $widget_content = ob_get_contents();
                    ob_end_clean();
                    $contentOut .= strtr($this->contentTemplate, array('{title}'=>$title, '{content}'=>$widget_content ,'{id}'=>$tabId, '{buttons}'=>$buttons ))."\n";
                    
                }
            }            
		}
		echo $contentOut;
        
        echo CHtml::closeTag($this->tagName)."\n";
        
        
        for ($i=0; $i<count($idList); $i++ ) {
            $curId = $idList[$i];
            if ( $i>0 ) {
                $prevId = $idList[$i-1];
                $script .= "$('#".$curId."').find('.previous').click( function() { $('#".$curId."').hide(); $('#".$prevId."').show(); } );\n";
            }
            if ( $i<count($idList)-1 ) {
                $nextId = $idList[$i+1];
                $script .= "$('#".$curId."').find('.next').click( function() { $('#".$curId."').hide(); $('#".$nextId."').show(); } );\n";
            }
            if ( $i!=0 ) 
                $script .= "$('#".$curId."').hide();\n";
        }
        
        
        Yii::app()->getClientScript()->registerScript(__CLASS__.'#'.$id, $script );

	}
}
