<?php

require_once 'protected/utils/PullMode.php';


class AdminController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='display';

    public function filters()
    {
        return array(
            'wizard - wizard',            
        );
    }
    public function filterWizard( $filterChain ) {
        $wiz = new Wizard();
        if ( $wiz->getWelcome() && !Yii::app()->user->status->installationmode ){
            $this->redirect( array( "/info/wizard" ) );
        } else {
            $filterChain->run();
        }
    }
	/**
	 * Displays the login page
	 */
	public function actionDisplay()
	{
        
        $selected=0;
		$config = new PlayerConfig;
        $screen = new ScreenSettings;
        $power = new SerialConfig;
        $power->playerConf = $config;
        
        $calib = new TouchCalibration;
        $calib->playerConf = $config;
        
        $splash = new SplashScreen;
           
        $setup = false;
        if( isset($_POST['simple']) || isset($_POST['advanced']) || isset($_POST['vgapower']) || isset($_POST['others'])) {
            $config->setScenario( 'display'  );
			if ( isset($_POST['PlayerConfig']) )
				$config->setAttributes( $_POST['PlayerConfig'] );
            
            if ( isset($_POST['simple']) )
                $screen->setScenario( 'simple'  );
            elseif ( isset($_POST['vgapower']) ){
                $screen->setScenario( 'power'  );
                $selected = 1;
            } else {
                $screen->setScenario( 'display'  );
                $selected = 0;
            }
			if ( isset($_POST['others']) )
				$selected = 4;
				
			if ( isset($_POST['ScreenSettings']) )
				$screen->setAttributes( $_POST['ScreenSettings']);
            if ( $config->validate() && $screen->validate() ) {
                $config->saveConfig();
                if ( !isset($_POST['advanced']) || $_POST['advanced']=='Apply' ) {
                    $screen->save();
					// load the full config to display the page
					$screen->load();
                } else {
                    $setup = $screen->check();
                }
            }
            
                
        } else  {
            $screen->load();
        }
        
        if( isset($_POST['power']) ) {
            $power->setScenario( 'display'  );
            $power->setAttributes( $_POST['SerialConfig'] );
            if ( $power->validate() )
                $power->save();
            $selected = 1;
        } else {
            $power->load();
        }
        
        if( isset($_POST['interactivity']) ) {
            $config->setScenario( 'inter'  );
            $config->setAttributes( $_POST['PlayerConfig'] );
            if ( $config->validate() )
                $config->saveConfig();
            $selected = 2;            
        }
        
        if( isset($_POST['calibration']) || isset($_POST['reset'])) {
            $calib->setScenario( 'config'  );
            if ( isset($_POST['calibration']) )
                $calib->setAttributes( $_POST['TouchCalibration'] );
            else
                $calib->reset();
            if ( $calib->validate() )
                $calib->save();
            $selected = 2;
        } else {
            $calib->load();
            if ( isset($_POST['startcal']) ){
                $calib->startCalibration();
                $selected = 2;
            }
            if ( isset($_POST['stopcal']) ){
                $calib->stopCalibration();
                $selected = 2;
                
            }
            
            if ( $calib->isCalibrationOn() ){
                $selected = 2;
            } 
        }
        
        if ( isset($_POST['applyLogo']) ) {
            $splash->setScenario( 'setsplash'  );
            $splash->setAttributes( $_POST['SplashScreen'] );
            if ( $splash->validate() ) {
                $splash->BOOTIMG = CUploadedFile::getInstance($splash,'BOOTIMG');
                $splash->SHUTDOWNIMG = CUploadedFile::getInstance($splash,'SHUTDOWNIMG');
                $splash->FIRMUPDIMG = CUploadedFile::getInstance($splash,'FIRMUPDIMG');
                
                $splash->save();
            } else {
                $splash->load();
            }
            $selected = 3;
        } else {
            if (isset($_POST['resetLogo']) ) {
                $splash->reset();
                $selected = 3;
            }
            $splash->load();
            
        }
        
        $this->render('display',array(  'selected'=>$selected,
                                        'config'=> $config,
                                        'screen'=> $screen,
                                        'info' => $setup,
                                        'power' => $power,
                                        'calib' => $calib,
                                        'splash' => $splash
                                        ) );
    
	}
    public function actionNetwork()
	{
        $selected = 0;
        $network = new IPConfig;
        $config = new PlayerConfig;
        
        $modem3g = new Modem3G;
        $modem3g->load();
        
        $watchdog = new NetworkWatchdog;
        
        $proxy = new ProxyConfig;
        $snmp = new SNMPConfig;
        
        $credit = new CredentialsConfig;
        
		$ssl = new SSLConfig;

        
        if ( isset($_POST['network']) ) {
            if ( $_POST['IPConfig']['dhcp'] )
                $network->setScenario( 'dhcp'  );
            else
                $network->setScenario( 'fixip'  );
            $network->setAttributes( $_POST['IPConfig'] );
            if ( $network->validate() && $network->checkConfig(  ) )
                $network->save();
                
        } else {
            $network->load();
        }
        
        if ( isset($_POST['modem3g']) ) {
            $network->setScenario( 'modem3g'  );
            if ( $network->changedInterface($_POST['IPConfig']) ) {
                $network->setAttributes( $_POST['IPConfig'] );
                if ( $network->validate() )
                    $network->save();
            }
            
            $modem3g->setAttributes( $_POST['Modem3G'] );
            if ( $modem3g->isPINBlocked() ) {
                $modem->resetPIN();
            }
            if ( $modem3g->validate() ) 
                $modem3g->save();
        } 
        
        if ( isset($_POST['identification']) || isset($_POST['netapi']) || isset($_POST['https']) ) {
            $selected = 1;
            if ( isset($_POST['identification']) )
                $config->setScenario( 'id'  );
            elseif ( isset($_POST['netapi']) )
                $config->setScenario( 'netapi'  );
            else {
                $config->setScenario( 'https'  );
                $selected = 3;
            }
            $config->setAttributes( $_POST['PlayerConfig'] );
            if ( $config->validate()  ) {
                $config->saveConfig();
            }
        }
		
		if ( isset($_POST['upload']) ){
            $ssl->setScenario('upload');
            $ssl->setAttributes( $_POST['SSLConfig'] );
            if ( $ssl->validate() )
                $ssl->saveCertificate( CUploadedFile::getInstance($ssl,'uploadedfile') );
			$selected = 3;
        }
		
		if ( Yii::app()->request->isAjaxRequest && isset($_POST['target']) ){
			if ( $ssl->delete( $_POST['target'] ) )
				echo json_encode( array( 'success'=> true ) ) ;
			else
				echo json_encode( array( 'success'=> false ) ) ;
			return;
        }
        
        if ( isset($_POST['watchdog']) ) {
            $watchdog->setAttributes( $_POST['NetworkWatchdog'] );
            if ( $watchdog->validate() )
                $watchdog->save();
            $selected = 1;
        } else {
            $watchdog->load();
        }
        
        if ( isset($_POST['proxy']) ) {
            if ( $_POST['proxy']=='Apply' )
                $proxy->setAttributes( $_POST['ProxyConfig'] );
            else 
                $proxy->server="";
            if ( $proxy->validate() )
                $proxy->save();
            $selected = 4;
        } else {
            $proxy->load();
        }
        
        if ( isset($_POST['snmp']) ) {
            $snmp->access = $_POST['SNMPConfig']['access'];
            $snmp->setScenario($snmp->access);
            $snmp->setAttributes( $_POST['SNMPConfig'] );
            if ( $snmp->validate() )
                $snmp->save();
            $selected = 5;
        } else {
            $snmp->load();
        }
        
        if ( isset($_POST['credit']) ) {
            $allOk=true;
            if ( isset($_POST['Credentials']) )
                foreach ( $_POST['Credentials'] as $entry ) {
                    $server = new Credentials;
                    $server->setAttributes( $entry );
                    if ( !$server->discard() ) {
                        if ( !$server->validate() )
                            $allOk=false;
                        $credit->addCreditential($server);
                    }
                }
            if ( $allOk ) 
                $credit->save();
            $selected = 2;
        } else {
            $credit->load();
        }
        
        
        $this->render('network',array(  'selected' => $selected,
                                        'network'=>$network,
                                        'modem3g'=>$modem3g,
                                        'config'=>$config,
                                        'watchdog' => $watchdog,
                                        'proxy' => $proxy,
                                        'snmp'=>$snmp,
                                        'credit'=>$credit,
										'ssl'=>$ssl
                                        ) );
    }
    public function actionFormat()
    {
        $usbinf = new USBStorage;
        $usbinf->setAttributes( $_POST['USBStorage'] );
        if ( isset($_POST['USBStorage']['formatID']) && $_POST['USBStorage']['formatID']!="" ){
            $ret = array();				
            if ( $usbinf->formatOver( $_POST['USBStorage']['formatPID'] ) ){
                $ret['finished'] = true;
                if ( $usbinf->forceFormat ) {
                    $ret['forceFormat']=true;
                }
            }
            $ret['logs'] = str_replace("\n","<br/>", $usbinf->formatLogs( $_POST['USBStorage']['formatID'] ) );
            $ret['results'] = $usbinf->message;
                
            echo json_encode($ret);
            return;
        } else {
            $usbinf->formatStart();
            $over = $usbinf->formatOver();
            $ret = array( 	'id'=>$usbinf->getFormatID(),
                            'pid'=>$usbinf->getFormatPID(),
                            'logs'=>str_replace("\n","<br/>", $usbinf->formatLogs() ),
                            'results' => $usbinf->message,
                            'finished'=>$over
                        );
            
            echo json_encode($ret);
            return;
        }
    }
    public function actionPublish()
    {
        
        if ( !Yii::app()->request->isAjaxRequest || !isset($_POST['action']) )
            throw new CHttpException(404, "Page not found");
        
        if ( $_POST['action']=='publish' ){
            $usbinf = new USBStorage;
            $usbinf->setAttributes( $_POST['USBStorage'] );
            echo json_encode( array(
                'id' => $usbinf->copyFromUsb( )
            ) );
            return;
        }
        if ( $_POST['action']=='copy' ){
            $usbinf = new USBStorage;            
            $usbinf->setAttributes( $_POST['USBStorage'] );
            echo json_encode( array(
                'id' => $usbinf->copyToUsb( )
            ) );
            return;
        }
        if ( $_POST['action']=='status' ){
            if ( !isset($_POST['id']) )
                throw new CHttpException(500, "missing id");
            $pull = new PullMode;
            echo json_encode( $pull->getStatus( $_POST['id'] ) );
            return;
        }        
        throw new CHttpException(404, "Page not found");
    }
	public function actionContent() {
	
		$selected = 0;
		
		$fusion = new FusionSetup;
		
        $sources = new SourceConfig;
        $info = new USBStorageInfo;
        $webstorage = new WebStorage;
        $info->load();
        
        if ( isset($_POST['sources']) ) {
			$sources->setAttributes( $_POST['SourceConfig'] );
            if ( $sources->validate() )
                $sources->save();
			
        }else {
           $sources->load();
        }
        
        if ( isset($_POST['clear']) ) {
            // clear internal storage
            PlayerConfig::resetContent();
        }
        
        if (isset($_POST['clear_storage']))
            $webstorage->clear( ); 
        
        if ( isset($_POST['unmount']) && isset($info->storage[$_POST['index']]) ) {
            $info->storage[$_POST['index']]->setAttributes( $_POST['USBStorage'] );
            $info->storage[$_POST['index']]->unmount();
        }
        
		$pull = new PullModeConfig;
        if ( isset($_POST['upload']) ){
			$selected = 1;
            if ( $pull->download() )
                return; 
            
        }
        $hasError=false;
        if ( isset($_POST['pullmode']) || isset($_POST['logs']) ){
            $pull->load();
            
			$selected = 1;
            if ( isset($_POST['pullmode']) )
                $pull->setSelectMode($_POST['PullModeConfig']['selectMode']);
            $pull->setAttributes( $_POST['PullModeConfig'] );
            if ( $pull->validate() )
                $pull->save();
            else
                $hasError = true;
        }
        if ( !$hasError )
            $pull->load();
        
		
        $this->render('content',array(  'sources'=>$sources,
                                        'info'=>$info,
										'fusion'=>$fusion,
										'pull'=>$pull,
										'selected'=>$selected,
                                        'webstorage'=>$webstorage
                                    ) );
									
	}

    public function actionSecurity()
	{
        $security = new SecuritySettings;
        $security->load();
        if ( isset($_POST['security']) ){
            $security->setScenario($_POST['scenario']);
			if ( isset($_POST['SecuritySettings']) )
				$security->setAttributes( $_POST['SecuritySettings'] );
            $security->setUser( $_POST['Users'] );
            if ( $security->validate() )
                $security->save();
        }
        $this->render('security',array( 'security'=>$security ) );
        
        $security->reloadConfig();
    }
    public function actionTime()
	{
        $ntp = new NTPSettings;
        $time = new TimeSettings;
        $selected = 0;
        if ( isset($_POST['ntp']) ){
            if ( $_POST['NTPSettings']['active']==0 )
                $ntp->setScenario('manual');
            else {
                $ntp->setScenario('ntp');
                $ntp->loadTime();
            }
            $ntp->setAttributes( $_POST['NTPSettings'] );
            if ( $ntp->validate() )
                $ntp->save();
            
            $selected = 1;
        } else {
            $ntp->load();
        }
        
        if ( isset($_POST['timezone']) ){
        
            $time->setScenario('timezone');
            $time->setAttributes( $_POST['TimeSettings'] );
            
            if ( $time->validate() )
                $time->save();
            
        } 
        $time->load();
        
        if ( isset($_POST['refresh']) )
            $selected = 2;
        
        $this->render('time',array( 'selected' => $selected, 'ntp'=>$ntp, 'time'=>$time) );
    }
	
    public function actionIo()
	{
        $serial = new SerialConfig;
        $usb = new USBInfo;
        $config = new PlayerConfig;
        
        if( isset($_POST['usb']) ) {
            $config->setScenario( 'inter'  );
            $config->setAttributes( $_POST['PlayerConfig'] );
            if ( $config->validate() )
                $config->saveConfig();
            $usb->setAttributes( $_POST['USBInfo'] );
            if ( $usb->validate() )
                $usb->save();
        }else
            $usb->load();
         
        
        if ( isset($_POST['serial']) ){
            $serial->setScenario('io');
            $serial->setAttributes( $_POST['SerialConfig'] );
            if ( $serial->validate() )
                $serial->save();
        }else {
            $serial->load();
        }
        if ( isset($_POST['upload']) ){
            $serial->setScenario('upload');
            $serial->setAttributes( $_POST['SerialConfig'] );
            if ( $serial->validate() )
                $serial->saveFsm( CUploadedFile::getInstance($serial,'uploadedfile') );
        }
		
		if ( isset($_POST['delete']) ){
			$serial->setScenario('delete');
            $serial->setAttributes( $_POST['SerialConfig'] );
			if ( $serial->validate() )
				$serial->delete();
        }
		if ( isset($_POST['view']) ){
			$serial->setScenario('dump');
            $serial->setAttributes( $_POST['SerialConfig'] );
			
			if ( $serial->validate() )
				$serial->dump();
        } else
			$this->render('io',array( 
                'serial'=>$serial,
                'usb' => $usb,
                'config' => $config
            ) );
    }
    
    public function actionFirmware()
	{
        $licenses = new Licenses;
    
        $firmware = new FirmwareUpdate;
        $selected = 0;
        if ( Yii::app()->request->isAjaxRequest ) {
            $firmware->setScenario('update');
            if ( isset( $_GET['FirmwareUpdate'] ) )
                $firmware->setAttributes( $_GET['FirmwareUpdate'] );
            else // backward compatibility
                $firmware->setAttributes( $_POST['FirmwareUpdate'] );
            $this->renderPartial('firmware/log_content',array( 'firmware'=>$firmware ) );
            return;
        }
        if ( isset($_POST['update'])) {
            // start the firmware upgrade
            $firmware->setScenario('check');
            $firmware->setAttributes( $_POST['FirmwareUpdate'] );
            $firmware->startUpdate( );
        }
        
        if ( isset($_POST['reset']) )
            $firmware->resetUri();
        
        $firmware->load();
        $firmware->loadStatus();
        
        if ( isset($_POST['time']) || isset($_POST['uri'])){
            if ( isset($_POST['time']) )
                $firmware->setScenario('time');
            else
                $firmware->setScenario('uri');
            $firmware->setAttributes( $_POST['FirmwareUpdate'] );
            if ( $firmware->validate() )
                $firmware->save();
                
            $selected = 1;
        }
        
        if ( isset($_POST['clearLicenses']) ) {
            $licenses->clearLicenses();
            $selected = 3;
        }
        if ( isset($_POST['restoreLicenses']) ){
            $licenses->restoreLicenseKey();
            $selected = 3;
        }
            
        if ( isset($_POST['addKey']) ){
            $licenses->setScenario('addKey');
            $licenses->setAttributes( $_POST['Licenses'] );
            if ( $licenses->validate() )
                $licenses->registerLicenseKey();
            $selected = 3;
        }
        if ( isset($_POST['addFile']) ){
            $licenses->setScenario('addFile');
            $licenses->setAttributes( $_POST['Licenses'] );
            if ( $licenses->validate() )
                $licenses->registerLicenseFile();
            $selected = 3;
        }
        
        $this->render('firmware',array( 'firmware'=>$firmware, 'selected'=>$selected , 'licenses'=>$licenses ) );
    }
    public function actionMaintenance()
	{
        $job = new Maintenance;
        $fusion = new FusionSetup;
		$selected  = 0;
        if (isset( $_GET['tab'] ) )
            $selected = $_GET['tab'];
        if ( isset($_POST['reboot']) || isset($_GET['reboot']))
            $job->forcedReboot();
        if ( isset($_POST['rebootrecovery']) || isset($_GET['rebootrecovery']) )
            $job->forcedReboot( true);
        if ( isset($_POST['shutdown']) || isset($_GET['shutdown']))
            $job->shutdown();
			
        if (isset($_POST['start_ssh']))
            $job->manageSSH( true ); 
        if (isset($_POST['stop_ssh']))
            $job->manageSSH( false ); 
        
        if (isset($_POST['format_storage']))
            $job->formatStorage( ); 
            
        if (isset($_POST['reset_factory']))
            $job->resetFactory( ); 
            
        if (isset($_POST['resetcontent'])) {
			if ( $fusion->active )
				$fusion->disabling();
			$job->resetContent( ); 
			
		}
        if (isset($_POST['clear_logs']))
            $job->clearLogs( ); 
        if (isset($_POST['clear_cache']))
            $job->clearCache( ); 
        if (isset($_POST['clear_ntp'])){
            $job->clearNtp( ); 
        }
        if (isset($_POST['clear_streaming'])){
            $job->clearStreaming( ); 
            $selected = 2;
        }
            
        if ( isset($_POST['instalation_mode']) )
            $job->instalationMode( ); 
        if ( isset($_POST['stop_instalation_mode']) )
            $job->instalationMode( false ); 
        
        $config = new PlayerConfig;
        
        if( isset($_POST['player']) ) {
            $config->setScenario( 'player'  );
            $config->setAttributes( $_POST['PlayerConfig'] );
            
            if ( $config->validate()  ) {
                $config->saveConfig();
            }
            $selected = 2;
        } else 
            $config->loadStreamValues();
            
        if ( Yii::app()->user->info->model=='Sakura' ) {
			$hwd = new HardwareSetup;
			if ( isset($_POST['temp']) ){
				$hwd->setAttributes( $_POST['HardwareSetup'] );
				if ( $hwd->validate() )
					$hwd->save();
				$selected = 3;
			}else {
				$hwd->load();
			}
		} else
			$hwd=null;
        
        $backup = new ConfigBackup;
        if ( isset($_POST['upload_backup']) ){
            $backup->setScenario( 'upload' );
            $backup->setAttributes( $_POST['ConfigBackup'] );
            $file = CUploadedFile::getInstance($backup,'uploadedfile');
            if ( $backup->validate() && $file ) {
                $backup->applyBackupFile( $file->getTempName() );
            }
            $job = new Maintenance;
			if ( Yii::app()->user->info->model=='Sakura' ) {
                $selected  = 4;
            } else {
                $selected = 3;
            }
		}
		
        $logs = new LogsInfo;
        $logs->loadStreaming();
        
        $this->render('maintenance',array( 'maintenance'=>$job, 'fusion'=>$fusion, 'backup'=>$backup, 'hwd'=>$hwd, 'page'=>$selected , 'config'=>$config, 'logs'=>$logs  ) );
		
		$fusion->reloadConfig();
        $backup->reloadConfig();
    }
    
    public function actionReport()
	{
        $job = new Maintenance;
        $job->getReportFile( isset($_POST['extended']) || isset($_GET['extended']) );
    }
	
	public function actionBackup()
	{
        $backup = new ConfigBackup;
		if ( isset( $_POST['ConfigBackup'] ) )
			$backup->setAttributes( $_POST['ConfigBackup'] );
		if ( !$backup->dump() ) {
            throw new CHttpException(500, $backup->getError("uploadedfile"));
        }
    }

    public function actionFusion()
	{
        if (!Yii::app()->user->branding->fusion)
            throw new CHttpException(404, "Page not found");
        $setup = new FusionSetup;
        if ( isset($_POST['activate'])) {
			
			$sources = new SourceConfig;
			$sources->load();
			$sources->setAttributes( array('primaryType'=>'local') );
			$sources->save();
				
            $setup->active = true;          
            $setup->setAttributes( $_POST['FusionSetup'] );
			if ( $setup->validate() )
				$setup->save();
            
        } elseif ( isset($_POST['disable'])) {
            $setup->disabling();
        } elseif ( isset($_POST['FusionSetup']) ) {
            $setup->setAttributes( $_POST['FusionSetup'] );
			if ( $setup->validate() )
				$setup->save();
        }
        $this->render('fusion',array( 'setup'=>$setup ) );
		
		$setup->reloadConfig();
    }
}
