<?php

class CheckController extends CController
{
	var $debug = false;
	public function actionAlive()
	{
		if ( !Yii::app()->request->isAjaxRequest )
			throw new CHttpException(403 , "Direct access not allowed");
		
		echo json_encode( array( 'success'=>true ) );
	}
    public function actionNetwork()
	{
		if ( !Yii::app()->request->isAjaxRequest )
			throw new CHttpException(403 , "Direct access not allowed");
		
		$net = new IPCheck();
		
		$ret = $net->ping();
			
		if ( $ret==0 ) {
			echo json_encode( array( 'success'=>true ) );
		} else {
			echo json_encode( array( 'success'=>false,
									 'code' => $ret,
									 'reason' => $net->phrase)
							);
		}
	}
    public function actionFirmware()
	{
		if ( !Yii::app()->request->isAjaxRequest )
			throw new CHttpException(403 , "Direct access not allowed");
	
		
		if ( $this->debug ) {
			$nbUpdates = 10;
			$results = array(	'success'=>true,
								'updates'=>$nbUpdates );
			$results ['version'] = "x.x.x";
			echo json_encode( $results );
			return;
		}
        $firmware = new FirmwareUpdate;
        // start checking for the firmware
		$firmware->setScenario('check');
		$firmware->setAttributes( array( 'mode'=>'check')  );
		if ( $firmware->startUpdate( true ) ) {
            
            $logs_str = $firmware->getLog( );
            $nbUpdates = $firmware->getNbUpdates();
            
            $results = array( 'success'=>true,
                              'updates'=>$nbUpdates );
                              
            if ( $nbUpdates!=0 ){
                if ( $firmware->updater->update_info['type'] == 'FIRMWARE') {
                    $results['type'] = 'firmware';
                    $results['version'] = $firmware->updater->update_info['ver'];
                    $results['build'] = $firmware->updater->update_info['rel'];
                } elseif ( $firmware->updater->update_info['type'] == 'UPDATER') {
                    $results['type'] = 'updater';
                    $results['version'] = $firmware->updater->update_info['ver'];
                    $results['build'] = $firmware->updater->update_info['rel'];
                } else {
                    $results['type'] = 'minor components';
                }
            }
        } else {
             $results = array(  'success'=>false,
                                'reason'=>$firmware->updater->errorStr );
        }        
		echo json_encode( $results );
	}
	
	public function actionUpdate()
	{
		if ( !Yii::app()->request->isAjaxRequest )
			throw new CHttpException(403 , "Direct access not allowed");
		
			
		if ( $this->debug ) {
			$log_id = rand( 0, 10 );
			$results = array( 'success'=>true,
                              'id'=>$log_id );
			echo json_encode( $results );
			return;
		}
		
        $firmware = new FirmwareUpdate;
        // start checking for the firmware
		$firmware->setScenario('update');
		$firmware->setAttributes( array( 'mode'=>'update')  );
		if ( $firmware->startUpdate( false ) ) {
            $log_id = $firmware->log_id;
            
            $results = array( 'success'=>true,
                              'id'=>$log_id );
        } else {
             $results = array(  'success'=>false,
                                'reason'=>$firmware->updater->errorStr );
        }        
		echo json_encode( $results );
	}
	public function actionStatus()
	{
		if ( !Yii::app()->request->isAjaxRequest )
			throw new CHttpException(403 , "Direct access not allowed");
		
		if ( !isset( $_GET['id'] ) ) {
			$results = array( 'success'=>false,
                              'reason'=>'Missing id' );
			echo json_encode( $results );
			return;
		}
		
		if ( $this->debug ) {
			if ( intval($_GET['idx'])<2 ){
				$results = array( 'success'=>true, 'running'=>true );
			} else {
				$results = array( 'running'=>false );
				$results['success'] = true;
				$results['type'] = 'firmware';
				$results['version'] = "x.x.x";
				$results['build'] = "xxxxx";
			}
			echo json_encode( $results );
			return;
		}
		
        $firmware = new FirmwareUpdate;
        // start checking for the firmware
		$firmware->setScenario('update');
		$firmware->setAttributes( array( 'mode'=>'update', 'log_id'=>$_GET['id'] )  );
		$running = $firmware->isUpdateRunning();
		$logs_str = $firmware->getLog( );
		
		if ( $running ) {
			$results = array( 'success'=>true, 'running'=>true );
		} else {
			$results = array( 'running'=>false );
			if ( $firmware->updater->updater_status===false ){
				// update not running but log is not complete
				$status = $firmware->updater->getStatus();
				if ( $status=="READY"	)
					$results['success'] = true;
				elseif ( $status=="CORRUPTED" ) {
					$results['success'] = false;
					$results['reason'] = "Firmware is corrupted";
				} else {
					$results['success'] = false;
					$results['reason'] = "Unknown error, please check the logs";
				}
			} else {
				if ( $firmware->updater->updater_status=="OK")
					$results['success'] = true;
				else {
					$results['success'] = false;
					$results['reason'] = "Update failed, please check the logs";
				}
			}
			if ( $results['success'] ) {
				if ( $firmware->updater->update_info!==false ){
					if ( $firmware->updater->update_info['type'] == 'FIRMWARE') {
						$results['type'] = 'firmware';
						$results['version'] = $firmware->updater->update_info['ver'];
						$results['build'] = $firmware->updater->update_info['rel'];
					} elseif ( $firmware->updater->update_info['type'] == 'UPDATER') {
						$results['type'] = 'updater';
						$results['version'] = $firmware->updater->update_info['ver'];
						$results['build'] = $firmware->updater->update_info['rel'];
					} else {
						$results['type'] = 'minor components';
					}
				} else {
					$results['type'] = 'minor components';
				}
				$results['more'] = $firmware->updater->updater_fallback;	
			} 
		}
		echo json_encode( $results );
	}
}