<?php

class HardwareSetup extends CFormModel {

    public $max_temp=false;
	static $temps = array(""=>"Normal", "70"=>"Maximum" );
	
    public function rules() {
		return array(
			array('max_temp', 'in', 'range'=>array("", "70", "hot", "cold") ),
		);
	}
	public function attributeLabels()
	{
		return array(
			'max_temp'=>'Shutdown temperature',
		);
	}
	
	function loadTemp() {
		$cmd = "fw_printenv -n maxtemp";
		$last = exec( $cmd, $output, $code );
		
		if ( $code==0 )
			return trim($last);
		else 
			return ""; // default
	}
	function load() {
        $this->max_temp = $this->loadTemp();
    }
	function save() {
		$cmd = "fw_setenv maxtemp";
		if ( $this->max_temp=="70" || $this->max_temp=="hot" ){
			$this->max_temp = "70";
			$cmd .= " 70";
		}else 
			$this->max_temp="";
        $old = $this->loadTemp();
        if ( $old!=$this->max_temp ) {
            $last = exec( $cmd, $output, $code );
            if ( $code==0 )
                Yii::app()->user->tools->addReason("Temperature settings changed");
            else
                 $this->addError('max_temp',"Cannot write new temperature settings.");
        }
	}
}
