<?php

class Licenses extends CFormModel {

    public $licenseKey = false;
    public $licenseFile = false;
    public $licenses = null;
    
    protected $registration=null;
    protected $licenseFileName = "/etc/spinetix/licenses";
    protected $licenseInfoFile = "/var/run/raperca/licenses_info";
    
    var $featuremap = array("HMP"=>"Player", "INTER"=>"Interactivity", "MULTI"=>"Multiscreen", "P"=>"HW-Player");
	var $featureignore = array("A", "G", "H", "P" );
    
    public function init() {
        
        $this->registration = Yii::app()->user->branding->registration;
    }
    public function rules() {
		return array(
            array('licenseKey', 'checkLicenseFormat', 'on'=>'addKey'),
            array('licenseFile', 'file', 'types'=>'txt', 'on'=>'addFile'),
		);
	}

    public function attributeLabels()
	{
		return array(
            'licenseKeyIntro'=> "To add new licenses to the player, please enter your license key below. ".
                                "The ".Yii::app()->user->branding->product." must have access to the internet to be able to validate the license key.",
			'licenseKey'=>'License key',
            'licenseFileIntro'=>'If the '.Yii::app()->user->branding->product.' is not connected to the internet, you can use the manual registration procedure and upload the license file using the option below:',
            'licenseFile'=>'License file',
            'restoreLicense' =>"If you have already registered some license key for this player, you can retrieve them from the server using the following button.",
            'clearLicense' => "To clear all installed licenses, press the button below. Note that this will only remove the license from the player and not from the server."
		);
	}

    public function checkLicenseFormat( $attribute, $params ) {
        $key = $this->$attribute;
        
        if ( preg_match("/[0-9A-Z]{5}-[0-9A-Z]{5}-[0-9A-Z]{5}-[0-9A-Z]{5}-[0-9A-Z]{5}/", $key) )
            return;
        $this->addError($attribute, "License key format is not valid");
        
    }
    public function restoreLicenseKey() {
        $info = new BasicInfo;
        $mac = $info->mac;
        $mac = strtolower($mac);
        $license = file_get_contents($this->registration."?mac=$mac");
        if ($license===false){
            $this->addError("", "Cannot contact license server" );
        }elseif (substr($license,0,1)=="-") {
            // error returned
            $this->addError("", "License server returned: ".htmlentities(substr($license,1)) );
        } else {
            // all license are added to the default file
            file_put_contents( $this->licenseFileName , $license);
            Yii::app()->user->tools->addReason("License file modified");
        }
    }
    
    public function registerLicenseKey() {
        $info = new BasicInfo;
        $mac = $info->mac;
        $mac = strtolower($mac);
        $key = $this->licenseKey;
		$license = file_get_contents($this->registration."?mac=$mac&key=$key");
        if ($license===false)
            $this->addError("licenseKey", "Cannot contact license server (".$this->registration.")");
        elseif  (substr($license,0,1)=="-") {
			// error returned
			$this->addError("licenseKey", "License server returned: ".htmlentities(substr($license,1)));
		} else {
			// new license, we need to add it to the default file
			if ( file_exists( $this->licenseFileName ) )
                $lic = file_get_contents( $this->licenseFileName );
            else 
                $lic ="";
			file_put_contents( $this->licenseFileName , $license."\n".$lic);
			Yii::app()->user->tools->addReason("License file modified");
		}
    }
    
    public function registerLicenseFile() {
        if ( file_exists( $this->licenseFileName ) )
            $lic = file_get_contents( $this->licenseFileName );
        else 
            $lic ="";
        $new_license = file_get_contents(CUploadedFile::getInstance($this,'licenseFile')->getTempName());
        if ( $new_license!="" && $new_license!==false) {
            file_put_contents( $this->licenseFileName , $new_license."\n".$lic);
            Yii::app()->user->tools->addReason("License file modified");
        } else {
            $this->addError("licenseFile", "License file is not valid");
        }
    }
    
    public function clearLicenses() {
        unlink( $this->licenseFileName  );
        Yii::app()->user->tools->addReason("License file modified");
    }
    
    function loadLicenseInfo() {
        
        if ( $this->licenses!=null )
            return $this->licenses;
        
        $this->licenses = array();
        
        if ( file_exists($this->licenseInfoFile) )
            $licenseinfo=file_get_contents( $this->licenseInfoFile );
        else $licenseinfo=false;
        
        if ($licenseinfo!==false) {
            $domdoc = new DOMDocument;
            if ($domdoc->loadXML($licenseinfo)!==false) {
                
                $features=$domdoc->getElementsByTagName("feature");
                foreach ($features as $feat) {
                    $name = $feat->getElementsByTagName("name");
                    if (count($name)>0) {
                        $name = $name->item(0)->textContent;
                        $valid = $feat->getElementsByTagName("valid");
                        if (count($valid)>0) {
                            $valid = $valid->item(0)->textContent;
                            if ( $valid=="true" ) {
                                $info = array();
                                $exp = $feat->getElementsByTagName("expire");
                                if ( $exp->length>0 ) {
                                    $info['expire'] = $exp->item(0)->textContent;
                                } else {
                                    $info['expire'] = "never";
                                }
                                $exp = $feat->getElementsByTagName("source");
                                if ( $exp->length>0 ) {
                                    $info['source'] = $exp->item(0)->textContent;
                                }
                                $this->licenses[$name] = $info;
                            } else {
                                $this->licenses[$name] = false;
                            }
                        } else{
                            $this->licenses[$name] = false;
                        }
                    }
                }
            }
        } 
        
        return $this->licenses;
    }
    
    function convertLicenseToString( $lic, $val ) {
        $ret = array();
        if ( isset($this->featureignore[trim($lic)]) )
            return false;
        if ( isset($this->featuremap[trim($lic)]) )
			$lic = $this->featuremap[trim($lic)];
        
        $ret['name']= $lic;
        if ($val===false) {
            $ret['validity'] = "Not valid.";
        } else {
            if ( isset($val['exp]']) && $val['expire']!='never')
				$ret['validity'] = "Valid, will expire in ".date("j M Y.", $val['expire']);
			else
				$ret['validity'] = "Valid, no expiration date.";
            
            if ( isset($val['source']) )
                $ret['type'] = $val['source']." license. "; // software or hardware license
            else
                $ret['type'] = "";
        }        
        return $ret;
    }
    
    function onlineRegostrationEnabled() {
        return $this->registration!==null;
    }
    
    function hasSoftwareLicense() {
        return file_exists( $this->licenseFileName );
    }
}
