<?php

class AppenderConfig extends CModel {
    var $name;
    var $type;
    
    var $AllLoggers=false;
    var $ConversionPattern = "%d{y-MM-dd HH:mm:ss} %-5p %-20c - %m%n";
    var $Threshold="";
    
    var $File = "log/custom.log";
    var $MaxFileSize= "500KB";
    var $MaxBackupIndex= "4";
    var $Append= "true";
    var $BufferedIO= "true";
    var $Target= "SYSTEM_OUT";
    var $Port= "8080";
    
    
    var $priorityList = array(  ''=>"",
                                'trace'=>"Trace",
                                'debug'=>"Debug",
                                'info'=>"Info",
                                'warn'=>"Warning",
                                'error'=>"Error",
                                'fatal'=>"Fatal",);
                                
    var $appender=array(
                    "org.apache.log4j.RollingFileAppender"=>    array( "File", "MaxFileSize", "MaxBackupIndex"),
                    "org.apache.log4j.TelnetAppender" =>        array("Port"), 
                    "org.apache.log4j.FileAppender" =>          array("File", "Append", "BufferedIO"),
                    "org.apache.log4j.ConsoleAppender" =>       array("Target"), 
                    "org.apache.log4j.OutputDebugStringAppender" => array( ));
   
   var $appenderList = array(  "org.apache.log4j.RollingFileAppender" => "Rolling File",
                                "org.apache.log4j.TelnetAppender" => "Telnet",
                                "org.apache.log4j.FileAppender" => "File",
                                "org.apache.log4j.ConsoleAppender" => "Console",
                                "org.apache.log4j.OutputDebugStringAppender" => "Debug",);
    public function attributeNames() {
        return array("name", "type", "AllLoggers", "ConversionPattern", "Threshold", "File", 
                     "MaxFileSize", "MaxBackupIndex", "Append", "BufferedIO", "Target", "Port" );
    }
    
    public function rules() {
		$res = array(
            array( "name, type", 'required' ),
            array( "AllLoggers, ConversionPattern, Threshold, File, MaxFileSize, MaxBackupIndex, Append, BufferedIO, Target, Port", 'safe' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'name'=>'Name',
            'type'=>'Type',
            'AllLoggers'=>'Subsribe to all loggers',
            'ConversionPattern'=>'Format',
            'threshold'=>'Threshold',
            'File'=>'File',
            'MaxFileSize'=>'Max Size',
            'MaxBackupIndex'=>'Nb File',
            'Port'=>'Port',
            'Append'=>'Append',
            'BufferedIO'=>'Buffered',
            'Target'=>'Target',
		);
	}
    
    function addDom( $log, $root ) {
        if ( $this->name=="" || $this->type=="" ) return;
        $app=$log->createElement("appender","\n");
		$app=$root->appendChild($app);
		$app->setAttribute("name", $this->name);
		$app->setAttribute("class", $this->type);
        $data = $this->appender[$this->type];
        $data = array_merge($data, array("Threshold"=>"Threshold" ) );
		foreach( $data as $name => $pname ){
            $pval = $this->$pname;
            $param=$log->createElement("param");
            $param->setAttribute("name",$pname);
            $param->setAttribute("value",$pval);
            $app->appendChild($param);
			$app->appendChild($log->createTextNode("\n"));
		} 
        $layout=$log->createElement("layout","\n");
        $layout->setAttribute("class","org.apache.log4j.PatternLayout");
        $param=$log->createElement("param");
        $param->setAttribute("name", 'ConversionPattern' );
        $param->setAttribute("value",$this->ConversionPattern);
        $layout->appendChild($param);
        $app->appendChild($layout);

        $root->appendChild($log->createTextNode("\n"));
    }
    
    function readDom( $append ) {
        $this->name = $append->getAttribute("name");
		$this->type = $append->getAttribute("class");
		$params=$append->getElementsByTagName("param");
		foreach($params as $param){
            $name = $param->getAttribute("name");
            if ( in_array($name, $this->attributeNames() ) )
			    $this->$name=$param->getAttribute("value");
		}
    }
}

class LoggerConfig extends CModel {
    var $name;
    var $priority="";
    var $additivity=null;
    var $refs = array();
    
    public function attributeNames() {
        return array( "name", "priority", "additivity", "refs" );
    }
    
   public function attributeLabels()
	{
		return array(
            'priority'=>'Default Level',
    	);
	}
    function addDom( $log, $root ) {
    
        if ( $this->name=="" ) return;
        if ( $this->priority=="" && count($this->refs)==0 ) return; // nothing to configure
        
        $l=$log->createElement("logger","\n");
		$l=$root->appendChild($l);
		$l->setAttribute("name",$this->name);
        
        if ( $this->additivity!==null ) {
            $l->setAttribute("additivity",$this->additivity?"true":"false");
        }
        if ( $this->priority!="" ) {
            $priority=$log->createElement("priority");
            $priority->setAttribute("value",$this->priority);
            $l->appendChild($priority);
            $l->appendChild($log->createTextNode("\n"));
        }
        
		foreach ($this->refs as $ref=>$enabled ){
            if ( !$enabled ) continue;
            $app=$log->createElement("appender-ref");
            $app->setAttribute("ref",$ref);
            $l->appendChild($app);
			$l->appendChild($log->createTextNode("\n"));
		}
		$root->appendChild($log->createTextNode("\n"));
    }
    
    function readDom( $loggertag ) {
        
		$appenders=$loggertag->getElementsByTagName("appender-ref");
		foreach ($appenders as $append){
			$this->refs[ $append->getAttribute("ref") ] = 1;
		}
		
		$tags=$loggertag->getElementsByTagName("priority");
        foreach ($tags as $tag){
            $this->priority = $tag->getAttribute("value");
        }
			
		if ( $loggertag->hasAttribute("additivity") )
			$this->additivity = ($loggertag->getAttribute("additivity")=="true");
		$this->name = $loggertag->getAttribute("name");
        
        
    }
}

class LogConfig extends CFormModel {
	
    var $priorityList = array(  'trace'=>"Trace",
                                'debug'=>"Debug",
                                'info'=>"Info",
                                'warn'=>"Warning",
                                'error'=>"Error",
                                'fatal'=>"Fatal",);
                                
    var $loggernames=array(
            "player"=>1,
            "resource"=>array(  "read"=>1,
                                "write"=>1,
                                "manage"=>1,
                                "cache"=>1,
                                "prepro"=>1,
                                "fastcgi"=>1,
                                "net"=>1,
                                "media"=>1), 
            "svglib"=>array(    "media"=>array( "mplayer"=>1,
                                                "live555"=>1,
                                                "timing"=>1,
                                                "packet"=>1,
                                                "ffmpeg"=>1, 
                                                "flags"=>1,
                                                "sendpacket"=>1),
                                "fonts"=>1, 
                                "paint"=>array( "d3d9"=>1, 
                                                "ds8"=>1, 
                                                "oss"=>1, 
                                                "kado"=>1), 
                                "profiling"=>1,
                                "parse"=>1, 
                                "jscript"=>1, 
                                "multiscreen"=>1, 
                                "events"=>1, 
                                "rss"=>1), 
            "utils"=>array(     "thread"=>1,
                                "xml"=>1), 
            "config"=>1, 
            "reporting"=>1, 
            "display" => array( "directx"=>1,
                                "framebuffer"=>1,
                                "file"=>1,
                                "buffer"=>1,
                                "media"=>1,
                                "comportfsm"=>1,
                                "input"=>1,
                                "fonts"=>1,
                                "rendertime"=>1,
                                "render"=>1)
	);
    
    protected $config_name="/etc/raperca/spxconfig.xml";
    protected $logfilename="logconfig.xml";
    
    var $appenders = array();
    var $loggers = array();
    
    var $priority = 'info'; 
    var $custom = false;
    
    
    public function rules() {
		$res = array(
            array( "priority, custom", 'safe' ),
    	);
        return $res;
	}
    
    public function attributeLabels()
	{
		return array(
            'customOff'=>'Default configuration',
            'customOn'=>'Custom configuration',
    	);
	}
    
    public function checkTime( $attribute, $params  ) {
        if ( !preg_match('/(([01][0-9]|2[0-3]):[0-5][0-9]|24:00)/', $this->$attribute) ) {
            $this->addError( $attribute, "Time format is HH:MM (between 00:00 and 24:00)");
        }
    }
    
    
    
    function load() {
        
        //$fp = fopen("debug.log","w");
        $config = new DOMDocument;
        $concont=file_get_contents($this->config_name);
        $config->loadXML($concont);
        
        $logtag = $config->getElementsByTagName("log");
        $defaultlog=true;
        if ( $logtag->length>0 ){
            // we have a log file config, open it
            $this->logfilename=$logtag->item(0)->getAttribute("configFile");
            $this->custom=true;
        }

        if ( substr($this->logfilename,0,1)!='/' )
            $this->logfilename = realpath( dirname($this->config_name) ."/". $this->logfilename);
        
        $log=new DOMDocument;
        if ( !file_exists($this->logfilename) ) return;
	    $logcontent=file_get_contents($this->logfilename);
        
        if ( $logcontent=="" ) return;
        $log->loadXML($logcontent);
        
        //fwrite($fp, "Appenders:\n" );
        $appenders=$log->getElementsByTagName("appender");
        $this->appenders = array();
	    foreach ($appenders as $append){
            $app = new AppenderConfig;
            $app->readDom( $append );
            $this->appenders[$app->name] = $app;
            //fwrite($fp, print_r($app,true) );
        }
		$loggertags=$log->getElementsByTagName("logger");
        $this->loggers = array();
        foreach($loggertags as $loggertag){
            $logger = new LoggerConfig;
            $logger->readDom( $loggertag );
            $this->loggers[$logger->name] = $logger;
        }
        
        $roottag=$log->getElementsByTagName("root");
        if ( count($roottag)>0 ){
            $log_priority_elem=$roottag->item(0)->getElementsByTagName("priority");
            if ( count($log_priority_elem)>0 )
                $this->priority = $log_priority_elem->item(0)->getAttribute("value");
        
            $appenders=$roottag->item(0)->getElementsByTagName("appender-ref");
            foreach ($appenders as $append){
                $name = $append->getAttribute("ref");
                if ( array_key_exists($name, $this->appenders) )
                    $this->appenders[$name]->AllLoggers = true;;
            }
        }
    }
    
    function save() {
        $config = new DOMDocument;
        $concont=file_get_contents($this->config_name);
        $config->loadXML($concont);
        
        $logtag = $config->getElementsByTagName("log");
        $save  = false;
        if ( $logtag->length>0 ){
            // we have a log file config, open it
            if ( !$this->custom ) {
                $config->documentElement->removeChild($logtag->item(0));
                $save = true;
            } else {
                $this->logfilename=$logtag->item(0)->getAttribute("configFile");
            }
        } else {
            if ( $this->custom ) {
                $lognode=$config->createElement("log");
                $lognode->setAttribute("configFile",$this->logfilename);
                $config->documentElement->appendChild($lognode);
                $save = true;
            }
        }
        if ( substr($this->logfilename,0,1)!='/' )
            $this->logfilename = realpath( dirname($this->config_name) ."/". $this->logfilename);        
        
        // create the DOM
        $log=new DOMDocument;
        $root=$log->createElementNS("http://jakarta.apache.org/log4j/", "configuration");
        $root=$log->appendChild($root);
        $root->appendChild($log->createTextNode("\n"));
        foreach($this->appenders as $val){
            $val->addDom( $log, $root );
        }
        foreach($this->loggers as $val){
            $val->addDom( $log, $root );
        }
        
        // root
        $r=$log->createElement("root","\n");
        $priority=$log->createElement("priority");
        $priority->setAttribute("value",$this->priority);
        $r->appendChild($priority);
        $r->appendChild($log->createTextNode("\n"));
        foreach ($this->appenders as $val){
            if ( $val->name=="" || !$val->AllLoggers ) continue;
            $app=$log->createElement("appender-ref");
            $app->setAttribute( "ref", $val->name );
            $r->appendChild($app);
            $r->appendChild($log->createTextNode("\n"));
        }
        $root->appendChild($r);
        $root->appendChild($log->createTextNode("\n"));
        
        
        Yii::app()->user->tools->save_file( $this->logfilename, $log->saveXML(), true);
        if ( $save ) {
            Yii::app()->user->tools->save_file( $this->config_name, $config->saveXML() );
        }
        Yii::app()->user->tools->reconfig_player();
    }
    
}