<?php
include_once 'protected/utils/MaintenanceJobs.php';

class Maintenance extends CFormModel {
	
    static $report="/usr/sbin/spxreport";
    var $jobs;
	
    public function init() {
        parent::init();
        $this->jobs = new MaintenanceJobs;
    }
    public function rules() {
		$res = array(
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'title'=>'Network Credentials',
    	);
	}
    
    function getReportFile( $ext=false) {
	
		// create an XML backup of the config first
		$backup = new ConfigBackup;
		$backup->backupPassword = false;
		$fn = '/var/cache/raperca/spxbackup.xml';
        file_put_contents($fn, $backup->create() );
		
        $serial=Yii::app()->user->info->serial;
        return $this->jobs->getReportFile( $serial, $ext );
    }
    
    function forcedReboot( $recovery=false ) {
        if ( $recovery ) {
            Yii::app()->user->tools->addReason("diagnostic mode restart");
        } else {
            Yii::app()->user->tools->addReason("restart");
        }
        Yii::app()->user->tools->shutdown( true, $recovery );
    }
	function shutdown( ) {
        Yii::app()->user->tools->addReason("power-off");
        Yii::app()->user->tools->shutdown( true, false, false, true );
    }
    
    function checkSSH () {
		return $this->jobs->checkSSH ();
    }
    
    function manageSSH( $start=true ) {
		return $this->jobs->manageSSH( $start );
    }
    function resetFactory( ) {
        $this->jobs->resetFactory( );
        Yii::app()->user->tools->addReason("reset to factory default");
    }
    function formatStorage( ) {
        
        $this->jobs->formatStorage( );
        Yii::app()->user->tools->addReason("format internal storage");
        
    }
    function resetContent( ) {
		return $this->jobs->resetContent( );
    }
    
    function clearLogs( ) {
		$this->jobs->clearLogs( );
    }
    function clearCache( ) {
        if ($this->jobs->clearCache( )) {
            Yii::app()->user->tools->addReason("clearing player cache"); // cache cleanup will be finalized on restart
        } else {
            $this->addError("","Failed creating cache cleanup job");
        }
    }
    function clearNtp( ) {
        if ( $this->jobs->clearNtp( ) ) {
            Yii::app()->user->tools->addReason("clearing clock calibration"); 
        } else {
            $this->addError("","Failed creating clock calibration clear job");
        }
    }
    function clearStreaming( ) {
        $this->jobs->clearStreaming( );
    }
    function instalationMode( $enabled=true ) {
        if ( $enabled ){
            file_put_contents("/var/run/reboot-delayed","");
        }else {
            if ( !file_exists("/var/run/reboot-pending") )
                unlink("/var/run/reboot-delayed");
            else 
                $this->addError("","Cannot disable installation mode. Changes are pending.");
        }
    }
    
}
