<?php
class NetworkWatchdog extends CFormModel {
	
    public $nwfile="/etc/default/ifwatchdog";
    
    var $maxTimeNoAddr=null;
    var $minTimeKeepAddr=null;
    
    protected $nwTimes = array( 'maxTimeNoAddr' => 'MAX_TIME_NO_ADDR',
                                'minTimeKeepAddr' => 'MIN_TIME_KEEP_ADDR');
    
    public function rules() {
		$res = array(
            array( "maxTimeNoAddr, minTimeKeepAddr", 'checkTime' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'maxTimeNoAddr'=>'Maximum time the unit may stay without an IP address',
            'minTimeKeepAddr'=>'Minimum time an IP address must stay assigned',
		);
	}
    function checkTime( $attribute ) {
        $t = Yii::app()->user->tools->timestr_to_secs( $this->$attribute );
        if ( $t===false ) {
            $this->addError($attribute, "Invalid time format");
        }
    }
    function load() {
        $nwconf=file_get_contents( $this->nwfile );
        foreach ($this->nwTimes as $var => $nwItem) {
            if (preg_match("/^\s*$nwItem=(\d+)/m", $nwconf, $matches)) {
                $this->$var = Yii::app()->user->tools->secs_to_timestr($matches[1]);
            } else {
                $this->$var = Yii::app()->user->tools->secs_to_timestr(0);
            }
        }
        
    }
    
    function save() {
        $nwconf = file_get_contents($this->nwfile);
        $changed = FALSE;
        
        foreach ( $this->nwTimes as $var => $nwItem ) {
            if( $this->$var!==null ) {
                $t = Yii::app()->user->tools->timestr_to_secs( $this->$var );
                if ( $t < 0 || $t===false )
                    $t = 0;
                $changed = true;
                $nwconf = preg_replace("/^\s*#?\s*$nwItem=.*/m", "$nwItem=$t", $nwconf, -1, $count);
                if ( $count == 0 )
                    $nwconf .= "\n$nwItem=$t\n";
            }
        }
        if ( $changed  && !$this->hasErrors() ) {
            Yii::app()->user->tools->save_file($this->nwfile, $nwconf);
            Yii::app()->user->tools->addReason( 'Network watchdog settings change' );
        }
    }
}