<?php
function maskErrors() {}

class PlayerConfig extends CFormModel {
	
    protected $conf=array(  "_deviceName"    => array("reporting", "deviceName"),
                            "_screenId"      => array("multiscreen", "screenId"),
                            
                            "_NetAPIEnabled" => array("interactivity", "remoteClientsEnabled"),
                            "_sharedVarPort" => array("interactivity", "sharedVarPort"),
                            
                            "_overscan"      => array("svgrender", "overScanMargin"),
                            "_orientation"   => array("svgrender", "screenOrientation"),
                            "_mute"         => array("svglib", "mute"),
                            "_audioPowerSave"        => array("svgrender", "audioPowerSave"),
        
                            "_events"        => array("interactivity", "allowEvents"),
                            "_usbIOAPI"        => array("interactivity", "allowUSBIOAPI"),
                            "_latency"       => array("svgrender", "maxLatency"),
                            "_interlatency"  => array("svgrender", "interactLatency"),
                            
                            "_https_useDefaultCA"  => array("https", "useDefaultCA"),
                            
                            "profiling"  => array("svglib", "profiling"),
                            "fps"  => array("svglib", "fps"),
                            "cachegroup"  => array("svglib", "cachegroup"),
                            "timestamp"  => array("svglib", "timestamp"),
                            "update"  => array("svgrender", "update-fps"),
                            "skip"  => array("svgrender", "hurry-up"),
                            "step"  => array("svgrender", "minStepFactor"),
                            "debugstream"  => array("svgrender", "capture-stream"),
                            
                            "checkStart"  => array("cacheManager", "checkStart"),
                            "cleanStart"  => array("cacheManager", "cleanStart"),
                            "cleanExit"  => array("cacheManager", "cleanExit"),
                            "maxFile"  => array("cacheManager", "maxFile"),
                            "minFreeSpace"  => array("cacheManager", "minFreeSpace"),
                            "maxFileAge"  => array("cacheManager", "maxFileAge"),
                            "maxFileSize"  => array("cacheManager", "maxFileSize"),
                            //"maxThreads"  => array("cacheManager", "maxThreads"),
                            //"checkPeriod"  => array("cacheManager", "checkPeriod"),
                            
                            "LMFactor"  => array("cache", "LMFactor"),
                            "maxDuration"  => array("cache", "maxDuration"),
                            "maxDurationFile"  => array("cache", "maxDurationFile"),
                            "minDuration"  => array("cache", "minDuration"),
                            "errorDuration"  => array("cache", "errorDuration"),
                            "errorDurationFile"  => array("cache", "errorDurationFile"),
                            
        );
        
    public $latencies=array("0.25"=>"250ms", "0.5"=>"500ms", "1"=>"1000ms", "1.5"=>"1500ms" );
    
    public $orientationsList=array( "horizontal"=>"Horizontal",
                                "rotateRight"=>"Rotate 90 Right",
                                "rotateLeft"=>"Rotate 90 Left",
                                "rotate180"=>"Rotate 180",
                                "flipVert"=>"Flip Vertical",
                                "flipHor"=>"Flip Horizontal");
    public $orientationsListWizard=array( "horizontal"=>"Horizontal",
                                "rotateRight"=>"Vertical",
                                );
								
    public $configName="/etc/raperca/spxconfig.xml";
    protected $_deviceName=null;
    protected $_screenId=null;
    
    protected $_NetAPIEnabled=null;
    protected $_sharedVarPort=null;
    
    protected $_overscan=null;
    protected $_orientation=null;
    
    protected $_events=null;
    protected $_usbIOAPI=null;
    protected $_interlatency=null;
    protected $_latency=null;
    
    protected $_mute=null;
    var $_audioPowerSave = null;
    
    protected $_https_useDefaultCA=null;
    
    protected $_proxyURI=null;
   
    var $backupMode = false;   
   
    var $profiling=null;
    var $fps=null;
    var $cachegroup=null;
    var $timestamp=null;
    var $update=null;
    var $skip=null;
    var $step=null;
    var $debugstream=null;
    
    var $LMFactor;
    var $maxDuration;
    var $maxDurationFile;
    var $minDuration;
    var $errorDuration;
    var $errorDurationFile;

    var $checkStart;
    var $cleanStart;
    var $cleanExit;
    var $maxFile;
    var $minFreeSpace;
    var $maxFileAge;
    var $maxFileSize;
    
    public $domdoc=null;
    
    protected $errstr ;
    public function init() {
        parent::init();
        $this->errstr = " Please try again, reset the device to factory default or contact ".Yii::app()->user->branding->email;
    }
    public function rules() {
		$res = array(
            array( "overscan", 'numerical', 'on'=>'display, wizard', 
                    'min'=>0, 'max'=>5, 'allowEmpty'=>false ),
            array( "orientation", 'in', 'on'=>'display, wizard', 
                   'range'=>array("horizontal", "rotateRight", "rotateLeft", 
                           "rotate180", "flipVert", "flipHor"), 'allowEmpty'=>false ),
            array( "audio, audioPowerSave", 'safe', 'on'=>'display, wizard' ),
            array( 'events, usbIOAPI, interlatency', 'safe', 'on'=>'inter' ),
            array( 'latency', 'in', 'on'=>'inter', 
                    'range'=>array( '1.5', '1', '0.5', '0.25' ), 
                    'allowEmpty'=>false ),
            array( 'deviceName', 'checkNames', 'on'=>'id, wizard' ),
            array( 'screenId', 'type', 'type'=>'string', 'on'=>'id, wizard' ),
            array( 'NetAPIEnabled', 'safe', 'on'=>'netapi' ),
            array( 'HTTPSUseDefaultCA', 'safe', 'on'=>'https' ),
            array( 'sharedVarPort', 'numerical', 'on'=>'netapi', 'min'=>1025, 'allowEmpty'=>false ),
            array( "profiling, fps, cachegroup, timestamp, update, skip, step, debugstream", 'safe', 'on'=>'player' ),
            array( "LMFactor, maxDuration, maxDurationFile, minDuration, errorDuration, errorDurationFile", 'safe', 'on'=>'cache' ),
            array( "checkStart, cleanStart, cleanExit, maxFile, minFreeSpace, maxFileAge, maxFileSize", 'safe', 'on'=>'cache' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'deviceName'=>'Device Name',
            'screenId'=>'Multiscreen ID',
            'overscan'=>'Overscan percentage',
            'orientation'=>'Screen orientation',
            'audio'=>'Enable audio output',
            'audioPowerSave' => 'Disable audio when screen is turned off',
            'events'=>'Enable events',
            'usbIOAPI'=>'Enable USB I/O API',
            'latency'=>'Maximum rendering latency',
            'interlatency'=>'Reduce latency to 60ms when events are received',
            'NetAPIEnabled' => 'Enable API server using port',
            'netAPIEnabled' => 'Enable network API',
            'sharedVarPort' => 'Port',
            "profiling"  => "Profiling",
            "fps"  => "Show fps",
            "cachegroup"  => "Debug cache group",
            "timestamp"  => "Show timestamp",
            "update"  => "Update FPS",
            "skip"  => "Skip frames",
            "step"  => "Minimum Step Factor",
            "debugstream"  => "Capture stream packets",
            
            "HTTPSUseDefaultCA" => "Enable full verification of HTTPS certificates", 
            
            "checkStart"  => "Check cache on start (on|off)",
            "cleanStart"  => "Clean cache on startup (on|off)",
            "cleanExit"  => "Delete cache on exit (on|off)",
            "maxFile"  => "Maximum number of cached files (0-...)",
            "minFreeSpace"  => "Minimum free space (0.00-1.00)",
            "maxFileAge"  => "Maximum age of cached files (in sec)",
            "maxFileSize"  => "Maximum size for one file (KB, MB)",
            
            "LMFactor"  => "LM-factor (0.0-1.0)",
            "maxDuration"  => "Maximum cache time (sec)",
            "maxDurationFile"  => "Maximum cache time for files (sec)",
            "minDuration"  => "Minimum cache time (sec)",
            "errorDuration"  => "Missing files check interval (sec)",
            "errorDurationFile"  => "Missing local files check interval (sec)",
		);
	}
    
    static function resetContent() {
        exec('/etc/raperca/resetcontent --internal');
    }
    
    public function checkNames( $attribute ){
        $value = $this->$attribute;
        
        if ( preg_match('/[^\w\d-]/', $value) || count($value)>63 || $value[0]=="-" || $value[count($value)-1]=="-" ) {
			$this->addError($attribute, "Device name ('".htmlspecialchars($value)."') is not valid. The name may contain only ASCII letters, digits and the hyphen");
            return false;
		}
        return true;
    }
    
    public function loadConfig() {
        if ( $this->domdoc!==null ) return true; // allready loaded
        
        if ( !file_exists( $this->configName ) ) {
            if ( !$this->hasErrors() )
                $this->addError('file',"Cannot find the config file.".$this->errstr);
            return false;
        }
        $spxconf=file_get_contents($this->configName);
        if (!$spxconf || $spxconf=="") {
            if ( !$this->hasErrors() )
                $this->addError('file',"Config file is empty.".$this->errstr);
            return false;
        }
        $this->domdoc = new DOMDocument;
		$this->domdoc->preserveWhiteSpace = false;
        $this->domdoc->formatOutput = true;
        
        set_error_handler('maskErrors'); // make sure no errors are generated when trying to load the xml doc
        if ( !$this->domdoc->loadXML($spxconf) ) {
            if ( !$this->hasErrors() )
                $this->addError('file',"Cannot parse the config file.".$this->errstr);
            $this->domdoc = null;
            
            restore_error_handler();
            return false;
        }
        restore_error_handler();

        return true;
    }
    
    public function saveConfig( $save = false ) {
        
        if ( $this->domdoc===null && !$this->loadConfig() ) {   
            return false;
        }
        
        foreach ( $this->conf as $var => $loc ) {
            
            if ( $this->$var!==null ) {
                
                if ( isset($loc[2]) ) {
                    $nodeName  = $loc[0];
                    $nodeName2 = $loc[1];
                    $attribute = $loc[2];
                } else {
                    $nodeName = $loc[0];
                    $nodeName2 = null;
                    $attribute= $loc[1];
                }
                $node = $this->domdoc->getElementsByTagName( $nodeName );
                if ($node->length==0){
                    $node = $this->domdoc->createElement( $nodeName );
                    $this->domdoc->documentElement->appendChild($node);
                } else 
                    $node = $node->item(0);
                
                if ( $nodeName2!==null ) {
                    $basenode = $node;
                    for ( $n2 = $node ->firstElementChild; $n2!=null; $n2 = $n2->nextSibling ) {
                        if ( $n2->localName == $nodeName2 ) break;
                    }
                    $node = $n2;
                    $nodeName = $nodeName2;
                } else {
                    $basenode = $this->domdoc->documentElement;
                }
                if ( $attribute===null ) {
                    if ( $node===null )
                        $old = "";
                    else
                        $old = $node->textContent;
                    if ( $this->$var!=$old) {
                        if ( $node===null ) {
                            $node = $this->domdoc->createElement( $nodeName );
                            $basenode->appendChild($node);
                        }
                        $node->textContent = $this->$var;
                        $save = true;        
                    }
                } else {
                    $old = $node->getAttribute($attribute);
                    if ( $this->$var!=$old) {
                        $node->setAttribute($attribute, $this->$var);
                        $save = true;        
                    }
                }
            }
        }
        if ( $save ) {
            Yii::app()->user->tools->save_file( $this->configName, $this->domdoc->saveXML() );
            Yii::app()->user->tools->reconfig_player();
            
            if ( $this->debugstream!==null ) {
                Yii::app()->user->tools->restart_content();
            }
            
            if ( $this->_NetAPIEnabled!==null || 
                 $this->_sharedVarPort !=null ) {
                Yii::app()->user->tools->addReason("nework api config change");
            }
            if ( $this->_events!==null ) {
                Yii::app()->user->tools->addReason("interactivity config change");
            }
            if ( $this->_usbIOAPI!==null ) {
                Yii::app()->user->tools->addReason("USB I/O API config change");
            }
            if ( $this->_https_useDefaultCA!==null ) {
                Yii::app()->user->tools->addReason("HTTPS certificates config change");
                
                // must also save this for the uploader
                $pull = new PullModeConfig;
                $pull->load();
                $pull->https_useDefaultCA = $this->_https_useDefaultCA=="true";
                $pull->save();
            }
        }
        
        
        if ( $this->_deviceName!==null ) {
            Yii::app()->user->tools->reload_mdns();
            if ( ! Yii::app()->user->tools->setSafeModeData("devname", $this->_deviceName, FALSE) )
		        $this->addError('deviceName',"Failed saving device name for recovery console, please try again.");
        }
        return $save;
    }
    
    public function readConfigItem(&$var, $nodeName, $attribute ) {
        if ( $this->domdoc===null && !$this->loadConfig() ) return false;
      
        $node=$this->domdoc->getElementsByTagName( $nodeName );
        if ($node->length==1){
            $node=$node->item(0);
            if ( $attribute===null )
                $var=$node->textContent;
            else
                $var=$node->getAttribute( $attribute );
        } else
            $var = ""; 
        return true;
    }
    public function getVar( $name, $default="", $prefix="_" ) {
        $var = $prefix.$name;
        if ( $this->$var===null ){
            if ( isset( $this->conf[$var][2] ) ){
                $nodeName = $this->conf[$var][1];
                $attribute = $this->conf[$var][2];
            } else {
                $nodeName = $this->conf[$var][0];
                $attribute = $this->conf[$var][1];
            }
            if ( !$this->readConfigItem( $this->$var, $nodeName, $attribute ) ) {
                if ( !$this->hasErrors() )
                    $this->addError($name, "Cannot read configuration file" );
                return "error";
            }
            if ( $this->$var=="" ) $this->$var=$default;
        } 
        return $this->$var;
    }
    
    public function getDeviceName() {
        if ($this->backupMode){
            $name = $this->getVar( "deviceName", "" );
            if ( $name == Yii::app()->user->info->serial )            
                return "";
            return $name;
        } else
            return $this->getVar( "deviceName", Yii::app()->user->info->serial );
    }
    public function setDeviceName( $deviceName ) {
        $this->_deviceName = $deviceName;
    }
    
    public function getScreenId() {
        if ($this->backupMode){
            $name = $this->getVar( "screenId", "" );
            if ( $name == Yii::app()->user->info->serial )            
                return "";
            return $name;
        } else
            return $this->getVar( "screenId", Yii::app()->user->info->serial );
    }
    public function setScreenId( $screenId ) {
        $this->_screenId = $screenId;
    }
    
    public function getNetAPIEnabled() {
        if ( $this->getVar( "NetAPIEnabled", "false" )=="true") return true;
        else return false;
    }
    public function setNetAPIEnabled( $val ) {
        $this->_NetAPIEnabled = $val?"true":"false";
    }
    
    public function getHTTPSUseDefaultCA() {
        if ( $this->getVar( "https_useDefaultCA", "true" )=="true") return true;
        else return false;
    }
    public function setHTTPSUseDefaultCA( $val ) {
        $this->_https_useDefaultCA = $val?"true":"false";
    }
    
    public function getsharedVarPort() {
        return $this->getVar( "sharedVarPort", 1234 );
    }
    public function setsharedVarPort( $val ) {
        $this->_sharedVarPort = $val;
    }
    
    public function getOverscan() {
        return $this->getVar( "overscan", 3 );
    }
    public function setOverscan( $overscan ) {
        $this->_overscan = $overscan;
    }
    
    public function getOrientation() {
        return $this->getVar( "orientation", 'horizontal' );
    }
    public function setOrientation( $orientation ) {
        $this->_orientation = $orientation;
    }
    public function getAudio() {
        if ( $this->getVar("mute")=="off" ) return true;
        else return false;
    }
    public function setAudio( $audio ) {
        $this->_mute = $audio?"off":"on";
    }
    public function getAudioPowerSave() {
        if ( $this->getVar("audioPowerSave", 'off')=="on" ) return true;
        else return false;
    }
    public function setAudioPowerSave( $audioPowerSave ) {
        $this->_audioPowerSave = $audioPowerSave?"on":"off";
    }
    public function getEvents() {
        $ev = $this->getVar("events");
        if ( $ev=="false" || $ev=="off" ) return false;
        else return true;
    }
    public function setEvents( $events ) {
        $this->_events = $events?"on":"off";
    }
    public function getUsbIOAPI() {
        $ev = $this->getVar("usbIOAPI", "off");
        if ( $ev=="false" || $ev=="off" ) return false;
        else return true;
    }
    public function setUsbIOAPI( $usbIOAPI ) {
        $this->_usbIOAPI = $usbIOAPI?"on":"off";
    }
    public function getLatency() {
        $lat = $this->getVar( "latency", "1.5" );
        if (substr($lat,-2)=="ms") $lat=strval(intval(substr($lat,0,-2))/1000);
        if (substr($lat,-1)=="s") $lat=substr($lat,0,-1);
        return $lat;
    }
    public function setLatency( $latency ) {
        $this->_latency = $latency;
    }
    public function getInterLatency() {
        $ilat = $this->getVar("interlatency", "0.06" );
        if ($ilat=="0.06" || $ilat=="60ms" ) return true;
        else return false;
    }
    public function setInterLatency( $latency ) {
        $this->_interlatency = $latency?"0.06":"1.5";
    }

    
    function loadAdvValues() {
        $this->getVar("profiling", "off", "" );
        $this->getVar("fps", "off", "" );
        $this->getVar("cachegroup", "off", "" );
        $this->getVar("timestamp", "off", "" );
        $this->getVar("update", "on", "" );
        $this->getVar("skip", "on", "" );
        $this->getVar("step", 1, "" );
    }
    
    function loadStreamValues() {
        $this->getVar("debugstream", "off", "" );
    }
    
    function loadCacheValues() {
        $this->getVar("checkStart", "on", "" );
        $this->getVar("cleanStart", "off", "" );
        $this->getVar("cleanExit", "off", "" );
        $this->getVar("maxFile", "2000", "" );
        $this->getVar("minFreeSpace", "0.3", "" );
        $this->getVar("maxFileAge", "86400s", "" );
        $this->getVar("maxFileSize", "512KB", "" );
        
        
        $this->getVar("LMFactor", "0.10", "" );
        $this->getVar("maxDuration", "7200s", "" );
        $this->getVar("maxDurationFile", "30s", "" );
        $this->getVar("minDuration", "10s", "" );
        $this->getVar("errorDuration", "300s", "" );
        $this->getVar("errorDurationFile", "30s", "" );
        
    }
}