<?php
class PullModeConfig extends CFormModel {
	
	const PULL_DISABLED  	= "disabled";
	const PULL_STATIC     	= "static";
	const PULL_FILE     	= "file";
	const PULL_REMOTE     	= "remote";
	
    protected $config_name='/etc/raperca/uploaderconf.xml';
    protected $uploadercal="/etc/raperca/uploader.ics";
    
    protected $logconf="/etc/raperca/uploaderlog.xml";
    
    var $selectMode=null;
    
    var $enable_project=0;
    var $project_source="";
    var $hourProj = 0;
    var $minProj = 30;
    var $enable_log= false;
    var $log_source="";
    var $hourLog = 0;
    var $minLog = 30;
    var $log_type='alllogs';
    
	var $enable_rpc=0;
    var $concentrator="";
	var $polling="60s";
	var $notification_only=false;
	
    var $icalfile="";
    var $icsfile;
    
    var $backup = false;
    
    var $uri="";
    
    var $checktime = "24h";
    
    var $priority=null;
    
    var $https_useDefaultCA=null;
    
    var $priorityList = array(  'trace'=>"Trace",
                                'debug'=>"Debug",
                                'info'=>"Info",
                                'warn'=>"Warning",
                                'error'=>"Error",
                                'fatal'=>"Fatal",);
    
    public function rules() {
		$res = array(
            array( "enable_project, timeProj", 'safe', 'on'=>'manual' ),
            array( "hourProj", 'numerical', 'min'=>0, 'max'=>23, 
                'integerOnly'=>true, 'allowEmpty'=>false,
                'on'=>'manual' ),
            array( "minProj", 'numerical', 'min'=>0, 'max'=>59, 
                'integerOnly'=>true, 'allowEmpty'=>false,
                'on'=>'manual' ),            
            array( "enable_log, timeLog", 'safe', 'on'=>'manual' ),
            array( "hourLog", 'numerical', 'min'=>0, 'max'=>23, 
                'integerOnly'=>true, 'allowEmpty'=>false,
                'on'=>'manual' ),
            array( "minLog", 'numerical', 'min'=>0, 'max'=>59, 
                'integerOnly'=>true, 'allowEmpty'=>false,
                'on'=>'manual' ),
            array( "log_type", 'in', 'range'=>array( "accounting", "alllogs" ),
                'allowEmpty'=>false,
                'on'=>'manual' ),
			array( "enable_rpc, notification_only", 'safe', 'on'=>'manual' ),
            array( "polling", 'checkTime', 'on'=>'manual' ),
			
			array( "project_source, log_source, concentrator", 'SimpleURLValidator', 'on'=>'manual' ),
			array( "project_source, log_source, concentrator", 'emptyselect', 'on'=>'manual' ),
            
            array( "icalfile", 'file', 'types'=>'ics', 'on'=>'file', 'allowEmpty' => true ),
            
            array( "icsfile", 'checkICS', 'on'=>'file_inline' ),
            
            array( "icalSourceHref", 'safe', 'on'=>'remote' ),
            array( "checktime", 'checkTime', 'on'=>'remote' ),
            array( "uri", 'SimpleURLValidator', 'on'=>'remote' ),
            array( "priority", 'safe' ),
            
            array( "selectMode", 'checkSelectMode' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
        $labels = array(
            'selectMode' => "Settings",
            'mode_dis'=>'Disabled',
            'mode_manual'=>'Manual settings',
            'mode_file'=>'From uploaded iCalendar file (ics)',
            'mode_remote'=>'From remote iCalendar file (ics)',
            'enable_project'=>'Automatically upload project to the '.Yii::app()->user->branding->product,
            'enable_log'=>'Automatically upload logs from the '.Yii::app()->user->branding->product,
			'enable_rpc'=>'Enable RPC concentrator',
            'concentrator'=>'Concentrator uri',
			'polling'=>'Polling interval',
			'notification_only'=>'Notification only',
			'project_source'=>'Project source',
            'hourProj'=>'Time',
            'log_source'=>'Log destination',
            'hourLog'=>'Time',
            'log_type'=>'Accounting logs only',
            'logs_accounting'=>'Accounting logs only',
            'logs_all'=>'All logs',
            'icalfile'=>'Schedule file',
            'icalSourceHref'=>'Schedule uri',
            'checktime'=>'Check calendar every',
            'uri'=>"Schedule uri",
            'priority'=>'Log level',
		);
        if ( $this->hasFusionRestrictions() ) {
            $labels['enable_project'] = 'Automatically upload project to the '.Yii::app()->user->branding->product.'\'s /publish folder';
        }
        return $labels;
	}
    function checkTime( $attribute ) {
        $t = Yii::app()->user->tools->timestr_to_secs( $this->$attribute );
        if ( $t===false || $t<=0 ) {
            $this->addError($attribute, "Invalid time format");
        }
    }
    function checkICS( $attribute ) {
        $val = $this->$attribute;
        if ( empty($val) ){
            $this->addError($attribute, "Must provide an ICS file");
            return false;
        }
        if ( strpos($val, "BEGIN:VCALENDAR")=== false || 
                strpos($val, "END:VCALENDAR")=== false ){
            $this->addError($attribute, "Not a valid ICS file");
            return false;
        }        
    }
    function checkSelectMode() {
        switch ($this->selectMode) {
            case PullModeConfig::PULL_STATIC: 
                if ( !$this->enable_project && !$this->enable_log && !$this->enable_rpc ) {
                    $this->addError('selectMode', 'Must select at least one of the following options: project, logs or concentrator');
                }
                break;
            case PullModeConfig::PULL_FILE: 
                                            
                break;
            case PullModeConfig::PULL_REMOTE: $this->setScenario('remote'); 
                if ( empty($this->uri) ){
                    $this->addError('icalSourceHref', 'Schedule uri cannot be blanck');                    
                }
                break;            
        }
    }
    function formatTime( $h, $m ) {
        if ( intval($h, 10)<10 )
            $h = "0".intval($h, 10);
        if ( intval($m, 10)<10 )
            $m = "0".intval($m, 10);
        return "$h:$m";
    }
    function getTimeProj (){
        return $this->formatTime( $this->hourProj, $this->minProj );
    }
    function setTimeProj ( $time ){
        $times = explode(":", $time);
        if ( count($times==2) && is_numeric($times[0]) && is_numeric($times[1])  ){
            $this->hourProj = intval($times[0], 10 );
            $this->minProj = intval($times[1], 10 );
        } else {
            $this->hourProj = $time;
            $this->minProj = "";
        }
    }
    function getTimeLog (){
        return $this->formatTime( $this->hourLog, $this->minLog );
    }
    function hasFusionRestrictions () {
        $fusion = new FusionSetup;
        return $fusion->active;
    }
    
    function setTimeLog( $time ){
        $times = explode(":", $time);
        if ( count($times==2) && is_numeric($times[0]) && is_numeric($times[1]) ){
            $this->hourLog = intval($times[0], 10);
            $this->minLog = intval($times[1], 10);
        } else {
            $this->hourLog = $time;
            $this->minLog = "";
        }
    }
    function setSelectMode( $mode ) {
        $this->selectMode = $mode;
        switch ($mode) {
            case PullModeConfig::PULL_DISABLED: 
                $this->setScenario('disabled'); break;
            case PullModeConfig::PULL_STATIC: 
                $this->setScenario('manual'); 
                $this->enable_project = false;
                $this->project_source = "";
                $this->hourProj = 0;
                $this->minProj = 30;
                $this->enable_log = false;
                $this->log_source = "";
                $this->hourLog = 0;
                $this->minLog = 30;
                $this->log_type='alllogs';
                $this->enable_rpc = false;
                $this->concentrator = "";
                $this->polling="60s";
                $this->notification_only=false;
                break;
            case PullModeConfig::PULL_FILE: 
                if ($this->backup)
                    $this->setScenario('file_inline'); 
                else
                    $this->setScenario('file'); 
                break;
            case PullModeConfig::PULL_REMOTE:
                $this->setScenario('remote'); 
                $this->uri="";
                $this->checktime = "24h";
                break;
            default: 
                $this->addError('selectMode', 'Mode not supported');
        }
    }
    function setIcalSourceHref( $href ) {
        $this->uri=preg_replace("@\[serial\]@",Yii::app()->user->info->serial, $href);
    }
    function getIcalSourceHref() {
        return preg_replace("@".Yii::app()->user->info->serial."@","[serial]", $this->uri);
    }
    
    function load()
    {
        $spxNS = 'http://www.spinetix.com/namespace/1.0/spxconf';
        $xlinkNS = 'http://www.w3.org/1999/xlink';


        $config = new DOMDocument;
        $config->loadXML(file_get_contents($this->config_name));
        $this->selectMode = PullModeConfig::PULL_DISABLED;
        
        
        $schedule=$config->getElementsByTagName("schedule");
        if ($schedule->length>0) {
            $link=$schedule->item(0)->getAttributeNS($xlinkNS,"href");
            if ( $link=="uploader.ics" || $link==$this->uploadercal ) {
                $this->selectMode = PullModeConfig::PULL_FILE;
            } else {
                $this->selectMode = PullModeConfig::PULL_REMOTE;
                $this->uri=$link;
                $checktime = $schedule->item(0)->getAttribute("check");
                if ($checktime=="") 
                    $this->checktime = "24h";
                else {
                    $this->checktime = Yii::app()->user->tools->secs_to_timestr($checktime);
                }
            }
        } else {
            // manual
            $proj=$config->getElementsByTagName("action");
            foreach ($proj as $action) {
                $name=$action->getAttribute("summary");
                if ($name=='publish') {
                    $this->enable_project = 1;
                    $this->project_source=$action->getAttributeNS($xlinkNS,"href");
                    $time = $action->getAttribute("time");
                    $this->hourProj=floor($time/3600);
                    $this->minProj=floor(($time-$this->hourProj*3600)/60);
                    $this->selectMode = PullModeConfig::PULL_STATIC;
                }
                if ($name=='upload') {
                    $this->enable_log = 1;
                    $this->log_source=$action->getAttributeNS($xlinkNS,"href");
                    $time = $action->getAttribute("time");
                    $this->hourLog=floor($time/3600);
                    $this->minLog=floor(($time-$this->hourLog*3600)/60);
                    $this->log_type=$action->getAttribute("type");
                    $this->selectMode = PullModeConfig::PULL_STATIC;
                }
				if ($name=='rpc') {
                    $this->enable_rpc = 1;
                    $this->concentrator=$action->getAttributeNS($xlinkNS,"href");
                    if ( $action->hasAttribute("pooling" ) ) // backward compatibility
                        $this->polling = Yii::app()->user->tools->secs_to_timestr( $action->getAttribute("pooling") );
                    else
                        $this->polling = Yii::app()->user->tools->secs_to_timestr( $action->getAttribute("polling") );
					$this->notification_only=$action->getAttribute("notification")=="true";
                    $this->selectMode = PullModeConfig::PULL_STATIC;
                }
            }
        }
        $https_configs=$config->getElementsByTagName("https");
        foreach ($https_configs as $https) {
            if ( $https->getAttribute("useDefaultCA")=='false' )
                $this->https_useDefaultCA = false;
            else
                $this->https_useDefaultCA = true;
        }
        
        $logconfig = new DOMDocument;
        $logconfig->loadXML(file_get_contents($this->logconf));
        $priority=$logconfig->getElementsByTagName("priority");
        if ( $priority->length>0 )
            $this->priority = $priority->item(0)->getAttribute("value");
    }

    function save()
    {
        $spxNS = 'http://www.spinetix.com/namespace/1.0/spxconf';
        $xlinkNS = 'http://www.w3.org/1999/xlink';

        if ( $this->selectMode!=null ) {
            $config = new DOMDocument;
			$config->preserveWhiteSpace = false;
			$config->formatOutput = true;
            $main=$config->appendChild($config->createElementNS($spxNS,'uploader'));
            
            if ( $this->https_useDefaultCA !== null ) {
                $https = $main->appendChild( $config->createElementNS($spxNS,'https') );
                if ( $this->https_useDefaultCA ) {
                    $https->setAttribute( "useDefaultCA", 'true' );
                } else {
                    $https->setAttribute( "useDefaultCA", 'false' );
                }
            }
            switch ( $this->selectMode ) {
                case PullModeConfig::PULL_DISABLED:// disabled
                    $proj=$main->appendChild($config->createElementNS($spxNS,'disabled'));
                break;
                case PullModeConfig::PULL_STATIC:// manual setting
                    $saveTime=-1;
                    if ( $this->enable_project ){
                        $proj=$main->appendChild($config->createElementNS($spxNS,'action'));
                        $proj->setAttribute("summary", 'publish');
                        $proj->setAttribute("guid", uniqid() );
                        $proj->setAttributeNS($xlinkNS,"xlink:href", $this->project_source);
                        $saveTime = $this->hourProj*3600+$this->minProj*60;
                        $proj->setAttribute("time", $saveTime);
                        if ( $this->hasFusionRestrictions() ) {
                            $desc=$proj->appendChild($config->createElementNS($spxNS,'desc'));
                            $desc->appendChild($config->createTextNode("-dest publish"));    
                        }
                    }
                    if ( $this->enable_log ){
                        $proj=$main->appendChild($config->createElementNS($spxNS,'action'));
                        $proj->setAttribute("summary", 'upload');
                        $proj->setAttribute("guid", uniqid() );
                        $proj->setAttributeNS($xlinkNS,"xlink:href", $this->log_source);
                        $saveTime2 = $this->hourLog*3600+$this->minLog*60;
                        $proj->setAttribute("time", $saveTime2);
                        
                                                
                        if ( $this->log_type==='accounting' ) {
                            $proj->setAttribute("type", 'accounting');
                            $desc=$proj->appendChild($config->createElementNS($spxNS,'desc'));
                            $desc->appendChild($config->createTextNode("-accounting"));
                        } else {
                            $proj->setAttribute("type", 'alllogs');
                            $desc=$proj->appendChild($config->createElementNS($spxNS,'desc'));
                            $desc->appendChild($config->createTextNode("-logs"));
                        }
                    }
					if ( $this->enable_rpc ){
                        $proj=$main->appendChild($config->createElementNS($spxNS,'action'));
                        $proj->setAttribute("summary", 'rpc');
                        $proj->setAttribute("guid", uniqid() );
                        $proj->setAttributeNS($xlinkNS,"xlink:href", $this->concentrator);
                        $polling_interval = Yii::app()->user->tools->timestr_to_secs( $this->polling );
						
                        $proj->setAttribute("polling", $polling_interval);
						$proj->setAttribute("notification", $this->notification_only?"true":"false");
                        $desc=$proj->appendChild($config->createElementNS($spxNS,'desc'));
						$txt = "-polling " . $polling_interval;
						if ( $this->notification_only ) 
							$txt .= "\n-notification";
						// We create one event valid for 24h.
						$proj->setAttribute("time", 0);
						$proj->setAttribute("end", 24*3600 );
                        $desc->appendChild( $config->createTextNode( $txt ) );
                    }
                break;
                case PullModeConfig::PULL_FILE:// file
                    if ( $this->scenario == 'file_inline' ){
                        $this->setSchedule( $this->icsfile );
                    } else if ( $this->scenario != 'fusion' ){
                        $obj = CUploadedFile::getInstance($this,'icalfile');
                        if ( $obj ) {
                            if( !$obj->saveAs( $this->uploadercal ) ) {
                                $this->addError('uploadercal', 'Saving the ics file failed');
                            }
                        }
                    }
                    $proj=$main->appendChild($config->createElementNS($spxNS,'schedule'));
                    $proj->setAttributeNS($xlinkNS,"xlink:href", "uploader.ics");
                break;
                case PullModeConfig::PULL_REMOTE:// remote
                    $proj=$main->appendChild($config->createElementNS($spxNS,'schedule'));
                    
                    $proj->setAttributeNS($xlinkNS,"xlink:href", $this->uri);
                    $time = Yii::app()->user->tools->timestr_to_secs($this->checktime);
                    if ( $time===false )
                        $this->addError("checktime", "Invalid time format");
                    if ( $time<10 ) {
                        $time = 10;
                        $this->checktime = "10s";
                    }
                    $proj->setAttribute("check", $time);
                break;
            }    
            
            if ( !$this->hasErrors() ){
                Yii::app()->user->tools->save_file($this->config_name,$config->saveXML());
                exec('/etc/init.d/uploader reload');
		    }
        }
        
            
        if ( $this->priority!=null ) {
            $logconfig = new DOMDocument;
			$logconfig->preserveWhiteSpace = false;
			$logconfig->formatOutput = true;
            $logconfig->loadXML(file_get_contents($this->logconf));
            $priority=$logconfig->getElementsByTagName("priority");
            if ( $priority->length>0) {
                $priority->item(0)->setAttribute("value",$this->priority);
                Yii::app()->user->tools->save_file($this->logconf, $logconfig->saveXML());
                exec('/etc/init.d/uploader reload');
            }else 
                $this->setError('priority', 'Cannot save priority');
            
        }        
    }
    function setSchedule( $cnt ) {
        file_put_contents( $this->uploadercal, $cnt );
    }
    function getSchedule() {
        return file_get_contents($this->uploadercal);
    }
    function download() {
        if (file_exists($this->uploadercal) ){
            header("Content-type: text/calendar");
            header('Content-Disposition: attachment; filename="pullmode.ics"');
	        echo file_get_contents($this->uploadercal);
            return true;            
        } else {
            return false;
        }
    }
	function emptyselect( $attribute,$params ) {
		if ( ( $attribute=='project_source' && $this->project_source=="" && $this->enable_project) ||
			 ( $attribute=='log_source' && $this->log_source=="" && $this->enable_log) ||
			 ( $attribute=='concentrator' && $this->concentrator=="" && $this->enable_rpc) ){
			// error
			$this->addError($attribute, $this->getAttributeLabel($attribute).' cannot be blanck.' );
		}		
	}
}