<?php

require_once dirname(__FILE__).'/../utils/MainInfo.php';

class ScreenInfo extends CModel {
	
    var $resolution;
    var $refresh;
    var $aspect;
    var $monitors;
    var $powersave;
    
    
    public function attributeNames() {
        return array("resolution", "refresh", "aspect", "monitors" );
    }
    public function safeAttributes() {
        return array();
    }
    public function load() {
        $info = new ScreenInfoBasics();
        $info->load();
        $this->resolution = $info->resolution;
        $this->refresh = $info->refresh;
        $this->aspect = $info->aspect;
        $this->monitors = $info->monitors;
        $this->powersave = $info->powersave;        
    }
    function getAspectRatio() {
        if ( count( $this->monitors ) ==0 )
            return "16:9";    
        $result = $this->monitors[0];
		if ( isset($result['width']) && $result['width']!="" && 
             isset($result['height']) && $result['height']!="" ) {
			$ar = floatval($result['width'])/floatval($result['height']);
			if ( $ar <1.4 ) 
				return "4:3";
			else if ( $ar<1.7 )
				return "16:10";
			else
				return "16:9";
		}
        if ( isset($result['aspectRatio']) && 
             ( $result['aspectRatio']=="4:3" || $result['aspectRatio']=="16:10" || $result['aspectRatio']=="16:9" ) )
			return $result['aspectRatio'];
		return "16:9";
	}
}