<?php

require_once 'protected/utils/SecurityJobs.php';


class SecuritySettings extends CFormModel {

    public $admin ;
    public $content ;
    public $monitoring ;
    
    public $fusion = false ;
    
    public $protectedAdmin;
    public $protectedContent;
    public $protectedMonitoring;
    
    protected $users=null;
    
    protected $job;
    
    public function init() {
        parent::init();
        $this->admin = new Users;
        $this->content = new Users;
        $this->monitoring = new Users;
        $this->job = new SecurityJobs();
    }
    public function rules() {
		return array(
            array('admin', 'checkOldPass', 'on'=>'admin'),
            array('fusion', 'safe', 'on'=>'admin'),
            array('protectedContent', 'safe', 'on'=>'content' ),
            array('protectedMonitoring', 'safe', 'on'=>'monitoring' ),
		);
	}

    public function attributeLabels()
	{
		return array(
			'protectedContent'=>'Password protected',
            'protectedMonitoring'=>'Password protected',
            'fusion'=>'Use same password for Fusion admin user',
		);
	}

    public function checkOldPass( $attribute, $params ) {
    
        $spxpass_user=array('content'   => SecurityJobs::$contentdigest,
                            'monitoring'=> SecurityJobs::$logdigest,
    	                    'admin'     => SecurityJobs::$admindigest);
        if ( !$this->protectedAdmin ) return;
        
        if ( $this->users===null)
            $this->users = $this->job->getUsers(  );

        $curuser=$this->job->getUser($this->users, $this->$attribute->username, $spxpass_user[$this->$attribute->username]);
        if ( $curuser===false ) return;
        $setpass = $curuser['pass'];
        if ($this->job->use_digest){
            $p=md5( $curuser['user'].":".$curuser['digest'].":".$this->$attribute->old_pass) ;
        }else{
            $p=$this->job->crypt_apr1_md5( $this->$attribute->old_pass, $setpass );
        }
        if ( $p!=$setpass ){
            $this->$attribute->addError("old_pass", "Old password is incorrect, please verify");
        }
    }

    public function validate(  ) {
        $which = $this->getScenario();
        if ( !$this->$which->validate() )
            return false;
        if ( !parent::validate() )
            return false;
        
        return !$this->$which->hasErrors();
    }
    
    function setUser( $user ) {
        $which = $this->getScenario();
        $this->$which->setScenario( $this->getScenario() );
        $this->$which->setAttributes( $user );
    }
    
    function load() {
        $this->protectedAdmin = $this->job->isProtected('admin');
        $this->protectedContent = $this->job->isProtected('content'); 
        $this->protectedMonitoring = $this->job->isProtected('monitoring');
    }
    
    function save() {
    
        
        if ( $this->users===null)
            $this->users = $this->job->getUsers(  );
        
        foreach( $this->job->spxpass_realm as $user => $digests ) {
            if ( $this->$user->new_pass!==false  && $this->$user->new_pass!="" ) {
                foreach ( $digests as $digest )
                    $this->job->addUser($this->users, $this->$user->username, $digest, $this->$user->new_pass);
            }
        }
        $ret = $this->job->saveUsers( $this->users );
        if ( $ret!==true )
            $this->$attribute->addError("", $ret );
        
        if ( $this->admin->new_pass!==false ) {
            $this->protectedAdmin = $this->admin->new_pass!=""; 
            if ( $this->protectedAdmin )
                $ret = $this->job->setAccess( 'admin' );
            else
                $ret = $this->job->clearAccess( 'admin' );
            if ( $ret!==true )
                $this->$attribute->addError("protectedAdmin", $ret);

                // also create Fusion password
                $fusion = new FusionSetup;
                if ( $this->fusion && $this->admin->new_pass!="" )
                    $fusion->setAdminPassword( $this->admin->new_pass );
                else
                    $fusion->setAdminPassword( false );
            
        }
        
        if ( $this->content->new_pass!==false ) {
            if ( $this->job->getUser($this->users, 'content', SecurityJobs::$contentdigest)===false )
                $this->protectedContent = false;
            if ( $this->protectedContent ) 
                $ret = $this->job->setAccess( 'content' );
            else 
                $ret = $this->job->clearAccess( 'content' );
            if ( $ret!==true )
                $this->$attribute->addError("protectedContent", $ret); 
        }
        
        if ( $this->monitoring->new_pass!==false ) {
            if ( $this->job->getUser($this->users, 'monitoring', SecurityJobs::$logdigest)===false )
                $this->protectedMonitoring = false;
            if ( $this->protectedMonitoring ) 
                $ret = $this->job->setAccess( 'monitoring' );
            else
                $ret = $this->job->clearAccess( 'monitoring' );
            if ( $ret!==true )
                $this->$attribute->addError("protectedMonitoring", $ret); 
            
        }
    }
    
    function getNeedreload() {
        return $this->job->needreload;
    }
    
    function reloadConfig() {
        if ($this->job->needreload) {
            # Push everything to http server before reloading the server's config
            ob_flush();
            flush();
            # This must be at the very end, otherwise apache graceful restart
            # may still close the connection to the FastCGI server process running
            # this script.
            exec('/etc/init.d/apache reload < /dev/null > /dev/null 2> /dev/null &');
        }
            
    }    
}
