<?php


class SourceConfig extends CFormModel {
	
    var $mediaMountFile="/etc/default/media-mount";
    protected $primary = "spx://localserver/index.svg";
    protected $secondary = "spx://localserver/index.svg";
    
    protected $src = array(
        'local' => "spx://localserver/index.svg",
        'usb' => "spx://usb/index.svg",
        'fusion' => "spx://fusion/index.svg"
    );
    
    var $useUSB = null;
    var $newInterface = false;
    var $sourceTypeList = array(
        "local"=>"Local Storage", 
        'remote'=>"Network Project"
    );
    
    var $sourceTypeList2 = array(
        "local"=>"Local Storage", 
        'remote'=>"Network Project",
        'usb'=>"USB Drive",
        'fusion'=>"Fusion"
    );
    var $playerConf = null;
    
    var $message="";
    
    public function rules() {
		$res = array(
            array( "primarySrc, secondarySrc", 'SimpleURLValidator' ),
            array( "primaryType, secondaryType, useUSB", 'safe' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
        if ( $this->newInterface ) {
            return array(
                'primaryType'=>'Primary source',
                'secondaryType'=>'Fallback source',
                'primarySrc'=>'Server address',
                'secondarySrc'=>'Server address',
                'useUSB' => 'Set Local Storage to USB storage device when available',
            );
        }
		return array(
            'primarySrc'=>'Primary source',
            'secondarySrc'=>'Fallback source',
            'useUSB' => 'Set Local Storage to USB storage device when available',
            
            'title' => 'Content Sources',
            'desc' => 'The player will start with the primary source. If it is not available, the fallback will be used. ',
		);
	}
    function validate( ) {
    
        $ret = parent::validate();
        
        if ( $this->getPrimaryType() == 'remote' && $this->primary=="" ){
            $this->addError("primarySrc", $this->getAttributeLabel("primarySrc")." cannot be empty");
            $ret=false;
        }
        if ( $this->getSecondaryType() == 'remote' && $this->secondary=="" ){
            $this->addError("secondarySrc", $this->getAttributeLabel("secondarySrc")." cannot be empty");
            $ret=false;
            
        }
        
        return $ret;
    }
    
    function getErrors( $attribute=NULL ) {
        if ( $this->playerConf!==null ) 
            return array_merge( parent::getErrors( $attribute ), $this->playerConf->getErrors( $attribute  ) );
        else 
            return parent::getErrors( $attribute );
    }
    
    function getPrimarySrc( ) {
        foreach ( $this->src as $link ){
            if ( $this->primary == $link )
                return "";
        }
        return $this->primary;
    }
    function getSecondarySrc( ) {
        foreach ( $this->src as $link ){
            if ( $this->secondary == $link )
                return "";
        }
        return $this->secondary;        
    }
    
    function setPrimarySrc( $href ) {
        if ( $href == "" ){
            $href = "local";            
        } 
        foreach ( $this->src as $type=>$link ){
            if ( $href == $type ){
                $this->primary = $link;
                return;
            }
        }
        $this->primary = $href;
    }
    function setSecondarySrc( $href ) {
        if ( $href == "" ){
            $href = "local";            
        } 
        foreach ( $this->src as $type=>$link ){
            if ( $href == $type ){
                $this->secondary = $link;
                return;
            }
        }
        $this->secondary = $href;   
    }
    
	function getPrimaryType( ) {
        foreach ( $this->src as $type=>$link ){
            if ( $this->primary==$link )
                return $type;
        }
        return "remote";        
    }
    function setPrimaryType( $type ) {
        if ( isset($this->src[$type]) )
            $this->primary = $this->src[$type];        
    }
    
    function getSecondaryType( ) {
        foreach ( $this->src as $type=>$link ){
            if ( $this->secondary==$link )
                return $type;
        }
        return "remote";
    }
    function setSecondaryType( $type ) {
        if ( isset($this->src[$type]) )
            $this->secondary = $this->src[$type];
    }
   
	function load( ) {
        $svgNS = 'http://www.w3.org/2000/svg';
        $xlinkNS = 'http://www.w3.org/1999/xlink';
        if ( $this->playerConf===null ) $this->playerConf = new PlayerConfig;
        if ( !$this->playerConf->loadConfig() ) return false;
        
        $config = $this->playerConf->domdoc;
        
        $sources=array();
		$animations = $config->getElementsByTagNameNS($svgNS,'animation');
        $max = 0;
        foreach ($animations as $anim){
        
            $p = $anim->getAttribute("priority");
            $sources[ $anim->getAttribute("priority") ] =$anim->getAttributeNS($xlinkNS,"href");
        }
        krsort ( $sources );
        $final = array();
        foreach ( $sources as $src ) {
            if ( substr( $src ,0, 10)=="project://" ) {
                $name = substr( $src, 10 );
                foreach ($config->getElementsByTagName('virtualHost') as $node ) 
                    if ( $node->getAttribute("host") == substr($src, 0, -10)) {
                        $src = $node->getAttributeNS($xlinkNS, "href");
                    }
            } else if ( substr( $src ,0, 16)=="spx://AutoServer" ) {
                $name = substr( $src, 6 );
                foreach ($config->getElementsByTagName('virtualHost') as $node ) 
                    if ( $node->getAttribute("host") == substr($src, 0, -10) ) { // must remove the index.svg
                        $src = $node->getAttributeNS($xlinkNS, "href");
                    }
            } 
                
            $final[]= $src;
        }
        $this->primary = $final[0];
        $this->secondary = $final[1];
        
                
        
        // usb
        $mediaMount=file_get_contents( $this->mediaMountFile );
        if (preg_match("/INTERNAL_USB_STORAGE=(.*)/",$mediaMount,$matches))
	        $this->useUSB=$matches[1]=='yes';
	}
	
	function save( ) {
        $svgNS = 'http://www.w3.org/2000/svg';
        $xlinkNS = 'http://www.w3.org/1999/xlink';
        
        if ( $this->playerConf===null ) $this->playerConf = new PlayerConfig;
        if ( !$this->playerConf->loadConfig() ) return false;
        $config = $this->playerConf->domdoc;
        
        // clean old sources
        $mediaSources=$config->getElementsByTagNameNS($svgNS,'animation');
        $mediaSourcesList=array();
        foreach ($mediaSources as $mediaSource) $mediaSourcesList[]=$mediaSource;
        foreach ($mediaSourcesList as $mediaSource) $mediaSource->parentNode->removeChild($mediaSource);

        $parent=$config->getElementsByTagName('sources');
        if ($parent->length<1) $parent=$config->appendChild($source->createElement('sources'));
        else $parent=$parent->item(0);
        
        $input = array();
        $input[]=$this->primary;
        $input[]=$this->secondary;
        
        $project = array();
        
        $maxSource = count($input);
        
        $idx=0;
        foreach( $input as $source ) {
            $animation=$config->createElementNS($svgNS,'svg:animation');
            if ( substr($source, 0, 3)!="spx" ){
                $tmp = "AutoServer$idx-".rand(0,99);
                if ( substr($source, -1)!='/' ) {
                    // must fix it, we assume the user just forgot the /
                    if ( substr($source, -9)=='index.svg' )
                        $source = substr($source, 0, -9 );
                    else
                        $source = $source ."/";
                }
                $project[$tmp] = $source;
                
                $source = "spx://".$tmp."/index.svg";
            }
            $animation->setAttributeNS($xlinkNS,"xlink:href", $source);
            $animation->setAttribute("priority", $maxSource-$idx);
            $animation->setAttribute("xml:id", "animation_".$idx);
            $parent->appendChild($animation);
            //$parent->appendChild($config->createTextNode("\n"));
            $idx++;
        }        
        
        // clean old autoserver
        $mediaSources=$config->getElementsByTagName('virtualHost');
        $mediaSourcesList=array();
        foreach ($mediaSources as $mediaSource) $mediaSourcesList[]=$mediaSource;
        foreach ($mediaSourcesList as $mediaSource) {
            if ( substr($mediaSource->getAttribute("host"), 0, 20)=="project://AutoServer" )
                $mediaSource->parentNode->removeChild($mediaSource);
            if ( substr($mediaSource->getAttribute("host"), 0, 16)=="spx://AutoServer" )
                $mediaSource->parentNode->removeChild($mediaSource);
        }
        
        $parent=$config->getElementsByTagName('resource');
        if ($parent->length<1) $parent=$config->appendChild($config->createElement('resource'));
        else $parent=$parent->item(0);
        foreach( $project as $proj=>$source ) {
            $vHost=$config->createElement('virtualHost');
			$vHost->setAttribute("host", "spx://".$proj);
			$vHost->setAttributeNS($xlinkNS,"xlink:href", $source );
            $vHost->setAttribute("xml:id", $proj);
			$parent->appendChild($vHost);
            //$parent->appendChild($config->createTextNode("\n"));
        }
       
        $this->playerConf->saveConfig( true );
        
        //usb
        if ( $this->useUSB!==null ) {
            $mediaMount=file_get_contents($this->mediaMountFile);
            
            $skip = false;
            if (preg_match("/INTERNAL_USB_STORAGE=(.*)/",$mediaMount,$matches)) {
	            if ( $matches[1]=='yes' && $this->useUSB )
                    $skip  = true;
                if ( $matches[1]!='yes' && !$this->useUSB )
                    $skip  = true;
                
            }
            if ( !$skip ) {
                if ( $this->useUSB ) {
                    $mediaMount=preg_replace("/INTERNAL_USB_STORAGE=.*/","INTERNAL_USB_STORAGE=yes", $mediaMount);
                    $this->message = "<h2>Status:</h2>";
                    $this->message .= "Unplug and replug attached USB storage devices, if any, for the change to take effect. Alternatively you may restart the system for the changes to take effect.<br/><br/>";
                } else {
                    $mediaMount=preg_replace("/INTERNAL_USB_STORAGE=.*/","INTERNAL_USB_STORAGE=no", $mediaMount);
                }
                Yii::app()->user->tools->save_file($this->mediaMountFile, $mediaMount);
            }
        }
	}

}