<?php
class TimeSettings extends CFormModel {
	
    var $tzarea='Etc';
    var $tzcity=null;
    var $link=null;
	private $path = "/usr/share/zoneinfo/";
    private $phpini = "/etc/php.d/timezone.ini";
    
    var $tzmap=array("Africa" => "Africa", "America" => "America", "US" => "US time zones", "Canada" => "Canada time zones",
                 "Asia" => "Asia", "Atlantic" => "Atlantic Ocean", "Australia" => "Australia", "Europe" => "Europe",
                 "Indian" => "Indian Ocean", "Pacific" => "Pacific Ocean", "Etc" => "GMT Offset");
             
    
    /**
	 * @return array validation rules for model attributes.
	 */
	public function rules() {
		return array(
			array('link,shortlink', 'checkLink', 'on'=>'timezone'),            
		);
	}
    
    public function attributeLabels()
	{
		return array(
            'tzcity'=>'Use this interface for the network: ',
            'time'=>'Local time',
            'link'=>'Time Zone',        
    	);
	}
    
    public function checkLink( $attribute ){
        $value = $this->link;
        if ( empty($value) || !file_exists( $this->path.$value ) ){
            $this->addError($attribute, "Timezone ('".htmlspecialchars($value)."') is not valid.");
            return false;
		}
        return true;
    }
    
    function getShortlink(){
		return $this->tzarea."/".$this->tzcity;
	}
	function setShortlink( $link ){
		$this->link = $link;
	}
    
    function load() {
        
		$this->link = date_default_timezone_get();
        $inf = split( "/", $this->link, 2 );
		
        if ( count($inf)>=2 ) {
			$this->tzarea = $inf[0];
			$this->tzcity = $inf[1];
		} else {
			$this->addError('link', "Timezone info not found");
		}
	
    }
    
    function getTimeZoneString() {
        if ( $this->tzarea=="Etc" )
            return "GMT".date("P");
        else
            return $this->tzarea."/".$this->tzcity." GMT".date("P");
    }
    function getTimezones( $select2 = false ) {
        
        $filelist = "zone.tab";
		$list = explode("\n", file_get_contents($this->path.$filelist));
		$timezones = array();
		foreach( $list as $line ) {
			if (strlen($line)==0 || $line[0]=="#" ) continue;
			$data = explode("\t", trim($line), 4);
			if ( count($data)<3 ) continue;
			$tz = explode("/", $data[2], 3);
            $name = "";
			if ( count($data)==4 ){
                if ( substr( $data[3],0,6)=="Moscow" )
                    $data[3] = substr( $data[3],12 );
				if ( count($tz)>2 ) {				
                    if ( strpos($data[3], $tz[2])===false )
					    $name = $tz[1]." : ".$tz[2]." (".$data[3].")";
                    else
                        $name = $tz[1]." : ".$data[3];
				} else {
                    if ( strpos($data[3], $tz[1])===false )
					    $name = $tz[1]." (".$data[3].")";
                    else
                        $name = $data[3];
                }
                if ( strlen( $name ) > 30 )
                    $name = ""; // reset the name without the comment when to total string is too long
			} 
            if ( $name=="" ) {
				if ( count($tz)>2 )				
					$name = $tz[1]." : ".$tz[2];
				else
					$name = $tz[1];
			}			
            if ( $select2 ) {
                $timezones[ $tz[0] ][ $data[2] ] = $name;
            } else {
                $timezones[ $tz[0] ][ $name ] = $data[2];
            }
		}		
		// must add GMT offsets
		for( $i= -12; $i<=14; $i++ ) {
			$timezones[ 'Etc' ][ "GMT".($i<0?$i:($i>0?"+".$i:"")) ] = "Etc/GMT".($i<0?"+".(-$i):($i>0?-$i:""));
		}
		foreach ($timezones as $name=>$val ) {
			natsort( $timezones[$name] );
		}
        
        return $timezones;
    }
    
    function save() {
		// check the link
		if ( strpos($this->link, ".")===false && file_exists( $this->path.$this->link ) ) {
            
            if ( date_default_timezone_get() != $this->link ) {
			    Yii::app()->user->tools->save_symlink( $this->path.$this->link, "/etc/localtime" );
			    Yii::app()->user->tools->addReason("Timezone changed");
                
                $phpsetup = file_get_contents( $this->phpini );
                if ( $phpsetup == "" ) {
                    $phpsetup = "date.timezone = \"".$this->link."\"";
                } else {
                    $phpsetup = preg_replace("/^date.timezone =.*/m","date.timezone = \"".$this->link."\"",$phpsetup);
                }
                file_put_contents( $this->phpini, $phpsetup );
                
                date_default_timezone_set( $this->link );
            }
		} else 
			$this->addError('link', "Invalid timezone link");
    }    
}