<?php
class USBInfo extends CModel {
	
	protected $devicelist=null;
    
    public $extendedUSB = true;
    
    public function attributeNames() {
        return array("devices", "extendedUSB");
    }
    public function rules() {
		$res = array(
            array( "extendedUSB", 'safe'),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'extendedUSB'=>'Support large number of USB devices',
		);
	}
    public function getDevices() {
        if ( $this->devicelist===null ) {
            $this->devicelist = array();
            
            if ( !file_exists('/proc/bus/usb/devices') ) return $this->devicelist;
            $bufr = file_get_contents('/proc/bus/usb/devices');
            
            $bufe = explode("\n", $bufr);
            
            $usbList=array();
            $devnum = 0;
            foreach( $bufe as $buf ) {
                if (preg_match('/^T/', $buf)) {
                    $devnum += 1;
                    $usbList[$devnum] = "";
                } elseif (preg_match('/^S:/', $buf)) {
                    list($key, $value) = split(': ', $buf, 2);
                    list($key, $value2) = split('=', $value, 2);
                    if (trim($key) != "SerialNumber" && trim($key) != "Manufacturer") {
                        $usbList[$devnum] .= " " . trim($value2);
                    }
                } 
            }

            foreach ($usbList as $usbname){
                $usb=preg_replace("/USB/i",'',$usbname);
                if (!strpos($usb,"Hub") && !strpos($usb,"EHCI") && !strpos($usb,"UHCI") && strlen($usb)>1){ // do not print the hubs
                    $this->devicelist[] = htmlspecialchars($usb);
                }
            }
        }
        return $this->devicelist;
    }
    
    public function save() {
        // save the value of $this->extendedUSB; 0 or 1
        
        $mainexargs = trim(shell_exec('fw_printenv -n mainexargs'));
        if (preg_match('/musb_hdrc\.sched_intr_ep=([\S]*)/',
                       $mainexargs, $matches) == 1) {
            if (strlen($matches[1]) && !!$matches[1] == !!$this->extendedUSB)
                return; // same value as already present
            $mainexargs = preg_replace('/musb_hdrc\.sched_intr_ep=[\S]*[\s]*/', '',
                                       $mainexargs);
            if ($mainexargs === null) {
                $this->addError("extendedUSB", "Failed modifying value in settings.\n");
                return;
            }
        } else {
            if ( $this->extendedUSB )
                return; // this is the default setting
        }
        if ($mainexargs)
            $mainexargs .= " ";
        $mainexargs .= "musb_hdrc.sched_intr_ep=" .
            ($this->extendedUSB ? "1" : "0");

        exec('fw_setenv mainexargs ' . escapeshellarg($mainexargs), $out, $ret);
        if ($ret) {
            $this->addError( "extendedUSB", "Failed saving new settings.");
            return;
        }

        Yii::app()->user->tools->addReason("USB settings changed");
    }

    public function load() {
        $this->extendedUSB = 1; // default value

        $mainexargs = shell_exec('fw_printenv -n mainexargs');
        if (preg_match('/musb_hdrc\.sched_intr_ep=([\S]+)/',
                       $mainexargs, $matches) != 1)
            return;
        $this->extendedUSB = ($matches[1] != 0);
    }
}
