<?php

require_once 'protected/utils/PullMode.php';

class USBStorage extends CModel {
	
	var $size;
    var $device_node;
    var $sysfs_device_path;
    var $writable=null;
    private $_usages = array();
    private $_user_available = false;
    
    var $message;
    
    var $forceFormat=false;
    var $forceUnmount=false;
    
	protected $format_id="";
	protected $format_pid="";

    static $usedForName = array(    '/srv/raperca/content'=>'Local Storage', 
                                    '/srv/raperca/capture'=>'Streaming Captures', 
                                    '/var/lib/updater/mnt-usb-updates'=>'Updates');
    static $userPathPrefix = "/srv/raperca/";
    
                                
    public function attributeLabels()
	{
		return array(
            'size'=>'Storage size',
            'usedFor'=>'Used for',
            'writable'=>'Writable',
     	);
	}
    
    public function attributeNames() {
        return array("size, path, usedFor, writable, mountedkey");
    }
    public function rules() {
		$res = array(
            array( "device_node, sysfs_device_path, forceFormat, forceUnmount", "safe"),
    	);
        return $res;
	}
    
    public function getSizeMBytes() {
        return floor($this->size/2048);
    }
    
    public function addMountLocation($path, $mopts) {
        if (isset(self::$usedForName[$path])) {
            $this->_usages[] = self::$usedForName[$path];
            if (strncmp($path, self::$userPathPrefix,
                        strlen(self::$userPathPrefix)) == 0)
                $this->_user_available = true;
        }
        # parse mount options to determine if rw or ro
        $opts = explode(',', $mopts);
        $this->writable = "1"; # abscence of option means rw
        foreach ($opts as $opt) {
            if ($opt == "rw")
                $this->writable = "1";
            elseif ($opt == "ro")
                $this->writable = "0";
        }
    }

    public function getUsedFor() {
        if (empty($this->_usages))
            return 'Not currently in use';
        return join(", ", $this->_usages);
    }
    public function isUsed() {
        return ! empty($this->_usages);
    }
    function isFusionContent() {
        $idx = $this->getIndex();
        if ( file_exists( "/media/usb$idx/.spx-mount" ) ){            
            return file_exists( "/media/usb$idx/content/.fusion_enabled");
        } else {
            return file_exists( "/media/usb$idx/.fusion_enabled");
        }
    }
    public function isUserAvailable() {
        return $this->_user_available;
    }
    public function getIndex() {
		return substr( $this->sysfs_device_path, -1 );
	}
    public function getWritableStr() {
        return $this->writable?"yes":"no";
    }
	public function getFormatID() {
		return $this->format_id;
	}
	public function getFormatPID() {
		return $this->format_pid;
	}
	public function getErrorStr() {
		return $this->final_string;
	}
    public function formatStart() {
		$dest=escapeshellarg( $this->sysfs_device_path );
		$flag="";
		$forced=$this->forceFormat;
		if ($forced) $flag="-f";
		do {
			$this->format_id = uniqid();
			$format_log = "/var/tmp/content-format-" . $this->format_id . ".log";
            
			$format_log_file = fopen($format_log, 'xb');
		} while ($format_log_file === FALSE);
		fclose($format_log_file);
		$this->format_pid = exec("nohup /usr/lib/raperca/content-format $flag $dest </dev/null > /dev/null 2> ".$format_log." & echo $!", $format_out, $format_ret);
	}
	public function formatLogs( $format_id="") {
		$formatMsg=array(
			0 => "Format Success<br/><br/>Unplug and replug the formatted USB storage device for the change to take effect. Alternatively you may restart the system for the change to take effect.", 
			1 => "USB storage not formated", 
			2 => "USB storage is read only", 
			3 => "USB storage ".($this->forceFormat?"is":"may be")." being accessed",
			4 => "USB storage timeout waiting for other process to release writting lock",
			8 => "USB storage failed; filesystem is corrupted",
			9 => "USB storage failed; filesystem is corrupted");
			
		if ( $format_id!="" )
			$this->format_id = $format_id;
		$format_log = "/var/tmp/content-format-" . $this->format_id . ".log";
		if ( file_exists( $format_log ) ) {
			$cnt = file_get_contents( $format_log );
			
		} else {
			$cnt=1;
		}
        if ( preg_match("@EXIT: (\d)@", $cnt, $matches) ){
            $this->message .= $formatMsg[ intval($matches[1]) ];
            if ( $ret!=0 )
                $this->addError( "", $formatMsg[$ret] );
            if ( $ret==3 )
                $this->forceFormat = true;
            unlink( $format_log );
        } else {
            $this->message = "Formating in progress"; 
        }
		if ( $cnt==1 ) return false;
		return $cnt;
		
	}
	
	public function formatOver( $format_pid="") {
		if ( $format_pid!="" )
			$this->format_pid = $format_pid;
		
		if ( !isset($_ENV['OS']) || $_ENV['OS']!='Windows_NT' ) {
            return !posix_kill($this->format_pid, 0);
        } 
		
        return true;
	}
	
    public function unmount() {
        
        $unmountMsg=array(
                0 => "Success, USB storage device can be removed", 
                1 => "USB storage device not disconnected", 
                2 => "USB storage device is being accessed", 
                3 => "Success, USB storage device can be removed");
        
        
        $dest=escapeshellarg($this->device_node);
        $this->message ="<h3>Status:</h3>";
        $this->message .="<div>Disconnecting USB storage: <br/>"; 
        
        $flag="";
        if ( $this->forceUnmount ) $flag="-f";
        $unmount=exec("/usr/lib/raperca/usb-remove $flag $dest", $out, $ret);
        
        foreach ($out as $str) 
            $this->message .= $str . "<br/>";
        
        if ( $ret==0 || $ret==3) {
            $this->message .= $unmountMsg[$ret]."<br/>\n";
            $this->_usages = array();
            $this->_user_available = false;
        } elseif ( $ret==2) {
            $this->message .= $unmountMsg[$ret]."<br/>\n";
        } else
            $this->addError( "", $unmountMsg[$ret] );
        $this->message .= "</div>\n";
        if ($ret==2){
            $this->forceUnmount = true;
        }
        
    }
    function getContentUri(  ) {
        $idx = $this->getIndex();
        if ( file_exists( "/media/usb$idx/.spx-mount" ) ){            
            return "/media/usb$idx/content";
        } else
            return "/media/usb$idx/";
    
    }
    function copyFromUsb( ) {
        $pull = new PullMode();
        
        $id = $pull->createEvent( "publish", $this->getContentUri( ), 3600,
            array(
                "-preview"
            )
        );
        
        return $id;
    }
    function copyToUsb( ) {
        $pull = new PullMode();
        $id = $pull->createEvent( "publish", "/srv/.shadow-raperca/content/", 3600,
            array(
                "-preview"
            )
        );
        /*
        $id = $pull->createEvent( "publish", "/srv/.shadow-raperca/content/", 3600, 
            array(
                "-server ".$this->getContentUri( )
            ) );
        */
        return $id;
    }    
}
