<?php

class Wizard extends CFormModel {

    protected $ccconfig="/etc/spinetix/configured";
    
    public function rules() {
		$res = array(
            array ( "active", 'safe' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
        $labels = array(
            'active'=>'Use '.Yii::app()->user->branding->maintitle.' wizard',
            );
        return $labels;
	}
    function getWelcome() {
		if ( !file_exists( $this->ccconfig ) )
			return true;
    }
    function getActive() {
		if ( $this->getWelcome() )
			return true;

		$config = file_get_contents( $this->ccconfig);
        
        if ( preg_match("/^\s*WIZARD=(.*)/m", $config, $matches ) )  {
            return $matches[1] != 0;
        }
        
    }
    function setActive( $useWizard=false ) {
		
        if ( $this->getWelcome() ) {
            $config = "";
        } else {
        	$config = file_get_contents( $this->ccconfig );
            if ( preg_match("/^\s*WIZARD=(.*)/m", $config, $matches ) )  {
                if ( ( $matches[1] == 1 && $useWizard ) || ( $matches[1] == 0 && !$useWizard  ) ){
                    return; // nothing changed, don't write anything
                }
            }
        }            
        
        $str = "WIZARD=".( ($useWizard===true || $useWizard==="true" || $useWizard==1) ?"1":"0");
        
		if ( preg_match("/^\s*WIZARD=/m", $config, $matches ) ) {
            $config = preg_replace( "/^\s*WIZARD=.*/m", $str, $config );
        } else
            $config = $str."\n" . $config;
        	
		file_put_contents( $this->ccconfig,  $config );
    }
}
