<?php

$spxsNS = 'http://www.spinetix.com/namespace/1.0/spxstatus';
$spxsP = 'spxs';

require_once "/usr/share/resources/default/interface/branding.php"; // branding info

// Serial number
function getInfoSerial( &$serial, &$model, &$hardware ) {
	$serial="[undefined]";
	$cpuinfo=file_get_contents("/proc/cpuinfo");
	if (preg_match("/Serial\s+:\s+(\S+)/",$cpuinfo,$match))
		$serial=$match[1];
	
	$model = "Bonsai";
	if (preg_match("/Hardware\W+:\s+(\w+)/",$cpuinfo,$match)){
		$model = $match[1];
	}
	$hardware = "x.x/x.x";
	if (preg_match("/Revision\W+:\s+(\w+)/",$cpuinfo,$match)){
		if ( $model=='Bonsai') {
			$val=hexdec($match[1]);
			$valc= floor($val/65536);
			$core = floor($valc/256).".".($valc % 256);
			$valc= $val % 65536;
			$carier = floor($valc/256).".".($valc % 256);
			$hardware= $core."/".$carier ;
		} else {
			$val=hexdec($match[1]);
			$valc= $val % 65536;
			$carier = floor($valc/256).".".($valc % 256);
			$hardware= $carier ;
		}
	}
}
function getInfoModel() {
	global $product;
	return $product;
}

function getStorageSizes( $model ) {

    if ( $model=="Bonsai" ) 
        $name = "mmcblk0";
    else 
        $name = "hda";
    if ( !file_exists( "/proc/partitions" ) ){
        return array();
    }
    $disk = file_get_contents("/proc/partitions");
    $devs = explode("\n", $disk );
    
    $sizes = array();
    foreach ( $devs as $dev ) {
        $data = preg_split("/[\s]+/", $dev );
        if ( count($data==5) && $data[4]==$name ) {
            $sdata = array( "location"=>"internal", "size"=> $data[3], "unit" => "KiB" );
            $sizes[] = $sdata;
        }
    }
    return $sizes;
}

function getInfoSafeMode() {
	return file_exists("/var/run/raperca.safe");
}

function getInfoUpTime() {
	$uptime=file_get_contents("/proc/uptime");
	$uptime=explode(" ",$uptime);
	return $uptime[0];
}

function getInfoIpv6( ) {
    $ipcmd = shell_exec('ip -o -f inet6 addr show eth0');
	preg_match_all("@^\d+:\s*\S+\s+.*\binet6\s+([0-9a-fA-F:]+)@m", $ipcmd, $matches, PREG_SET_ORDER);
    $addrs = array();
	foreach ($matches as $idx => $value) {
        $addrs[] = $value[1];
    }
    return $addrs;
}

function getInfoIp( &$ip, &$ipprefix, &$iptype) {
	$ipcmd=shell_exec('ip -o -f inet addr show');
	preg_match_all("@^\d+:\s*(\S+)\s+.*\binet\s+([\d.]+)(?:/(\d+)|\s+)@m", $ipcmd, $matches, PREG_SET_ORDER);

	# Multidimensional array. Each IP
    # address gets a row, and each row has three entries: the IP
    # address, prefix length, interface type (e.g., 'ethernet',
    # 'modem') and the interface name (e.g., 'eth0', 'ppp0'). The "main"
    # address is returned in the first row. The loopback interface
    # is not returned.
	$addrs = array();
	foreach ($matches as $idx => $value) {
		$iface = $value[1];
		$addr = $value[2];
		$plen = $value[3];

		if ( ! $plen )
			$plen = 32;

		$order = 0; // to order the addresses by decreasing importance

		// add n in [0-99] to ordering to keep ordering if all other
		// ordering criteria are equal
		$order += $idx;

		if ( strncmp($iface, 'eth', 3) == 0 )
			$type = 'ethernet';
		elseif ( strncmp($iface, 'ppp', 3) == 0 )
			$type = 'modem';
		elseif ( $iface == 'lo' )
			$type = 'loopback';
		if ( $iface == 'lo' )
			continue;

		// add n*100 to order for interface type (n in [0,9])
		if ( $type == 'modem' )
			$order += 100;
		elseif ( $type == 'ethernet' )
			$order += 800;
		else
			$order += 900;

		// add n*1000 to order for address class (n in [0,9])
		if (strncmp($addr, '169.254', 7) == 0 )
			$order += 8000; // link-local
		if (strncmp($addr, '127.', 4) == 0 )
			$order += 9000; // host-local

		$addrs[$order] = array($addr, $plen, $type, $iface);
	}

	// apply the ordering
	ksort($addrs);
	$addr = reset($addrs);
	if ($addr) {
		$ip=$addr[0];
		$ipprefix=$addr[1];
		$iptype=ucfirst($addr[2]);
	} else if ( PHP_OS == "WINNT" ){ 
        $ip = "169.254.0.xxx";
		$ipprefix = 32;
		$iptype= "Ethernet";
    } else {
		$ip = "[not found]";
		$ipprefix = "";
		$iptype= "Unknown";
	}
	return $addrs;
}
function getInfoMac () {
	if( PHP_OS == "WINNT" ){
		return "00:1D:50:00:00:XX";
	} else {
		$info=`ifconfig eth0`;
		$macp=strpos($info,"HWaddr ");
		if ($macp===false) 
			return "[not found]";
		$macp=$macp+strlen("HWaddr ");
		return substr($info, $macp, strpos($info," ",$macp)-$macp);
	}            
}
function getInfoHostname() {
	return trim(file_get_contents("/etc/hostname"));
}  
function getUBootVersion() {
    return shell_exec("LC_ALL=C tr -c '[ -~]' '\n' < /dev/mtd0 | grep 'U-Boot [0-9]' | head -n 1");
}  


function getInfoFirmware( &$firmware, &$build ) {
	$release = file_get_contents('/etc/spinetix-release');
	$vals=explode(" ", $release);
	if (count($vals)==6 ){
		$firmware = $vals[3];
		$build = $vals[5];
	} else {
		$firmware = "[not found]";
		$build = "";
	}
}

function getInfoFirmwareCorrupted(){
	return trim(file_get_contents("/var/lib/updater/status"))==="CORRUPTED";
}

function getInfoTemperature () {
	$ret = array();
	$temp = file_get_contents("/sys/class/hwmon/hwmon0/device/temp1_input");
	if ( $temp=="" )
		$ret['temp'] = "[not found]";
	else
		$ret['temp'] = intval($temp)/1000;
	
	$temp = file_get_contents("/sys/class/hwmon/hwmon0/device/temp1_max_alarm");
	if ( trim( $temp) =="1")
		$ret['max']= true;
	else
		$ret['max']= false;
	$temp = file_get_contents("/sys/class/hwmon/hwmon0/device/temp1_crit_alarm");
	if ( trim( $temp) =="1")
		$ret['crit']= true;
	else
		$ret['crit']= false;
	
	return $ret;
}

function getDiskInfo( $path ) {
    $data = exec('df -B 1048576 -P '.$path);

    $spaces=preg_split( "@\s+@", $data );

    $info = array();
    if ( count($spaces)>=4) {
        $info['free']  =$spaces[3];
        $info['used'] = $spaces[2];
        $info['tot'] = $spaces[1];
    } else if ( file_exists($path) ){
        $info['free'] = floor(disk_free_space($path)/1024/1024);
        $info['tot'] = floor(disk_total_space($path)/1024/1024);
        
        $info['used'] = $info['tot']-$info['free'];
        
    } else {
        $info['free'] = "unknown";
        $info['used'] = "unknown";
        $info['tot'] = "unknown";
    }
    $info["unit"] = "Mbytes";
    return $info;
}

class ipconfigBasics{
	const NET_ETHERNET = "ethernet";
	const NET_MODEM = "modem";
	var $netiface=self::NET_ETHERNET;
	var $dhcp=1;
	var $address="";
	var $netmask="";
	var $gateway="";
	var $hostname="";

	var $startTag="# START-spxsysconfig DO NOT REMOVE THE START AND END TAGS";
	var $endTag="# END-spxsysconfig";
	var $fname="/etc/network/interfaces";
	function mask($adr,$msk){
		$a=ip2long($adr);
		$m=ip2long($msk);
		return long2ip($a & $m);
	}
	function broad($adr,$msk){
		$a=ip2long($adr);
		$m=ip2long($msk);
		
		return long2ip(($a & $m)+(~$m));
	}

	function load(){
		 // get the config
		$interface=file_get_contents($this->fname);
		if (!isset($interface) && $interface) {
            return "Warning: cannot read configuration file";
        }
	
		$start=strpos($interface,$this->startTag);
		$end=strpos($interface,$this->endTag);
		if ($start===false || $end===false) {
            return "Warning: configuration file is incomplete";
        }

		// should look for first auto interface to be
		// consistent with ifwatchdog
		$str1="auto ";
		$iface=strpos($interface,$str1, $start);
		$iface+=strlen($str1);
		$line_end=strpos($interface,"\n",$iface);
		$ifname = substr($interface,$iface,$line_end-$iface);

		if ($ifname == "ppp0") 
			$this->netiface = self::NET_MODEM;
		else
			$this->netiface = self::NET_ETHERNET;

		$str1="iface $ifname inet ";
		$iface=strpos($interface,$str1, $start);
		$iface+=strlen($str1);
		$conf=substr($interface,$iface,$end-$iface);
		$vals=explode ("\n",$conf);	
		
		if (trim($vals[0])=="dhcp"){
			$this->dhcp=1;
			foreach ($vals as $name){
				if (!(($n=strpos($name,"hostname "))===false)){
					$this->hostname=trim(substr($name, strlen("hostname ")));
				}
			}
		}elseif (trim($vals[0])=="static"){
			$this->dhcp=0;
			foreach ($vals as $name){
				if (!(($n=strpos($name,"address "))===false)){
					$this->address=trim(substr($name, strlen("address")+$n));
				}elseif (!(($n=strpos($name,"netmask "))===false)){
					$this->netmask=trim(substr($name, strlen("netmask")+$n));
				}elseif (!(($n=strpos($name,"gateway "))===false)){
					$this->gateway=trim(substr($name, strlen("gateway")+$n));
				}
			}
		}elseif (trim($vals[0])=="ppp"){
			// nothing else to read, we always use the same ppp config
		} else {
            return "Warning: unknown inet state: '".$vals[0]."'"; 
        }
        return true;
	}
    
}

class dnsconfigBasics{
	var $nameserver1="";
	var $nameserver2="";
	var $nameserver3="";
	var $search="";
	var $domain="";
	var $fname="/etc/network/resolv.conf.static";
	function load(){
		$dns=file_get_contents($this->fname);
		$tmp=$dns;
		$i=1;
		$pos=strpos($tmp,"nameserver");
		while (!($pos===false)){
			$pos+=strlen("nameserver");
			$name="nameserver".$i; 
			$i++;
			$this->$name=trim(substr($tmp,$pos,strpos($tmp,"\n",$pos)-$pos));
			$tmp=substr($tmp,strpos($tmp,"\n",$pos));
			$pos=strpos($tmp,"nameserver");
		}
			
		if (!($pos===false)) 
		$pos=strpos($dns,"search ");
		if (!($pos===false)) {$pos+=strlen("search "); $this->search=trim(substr($dns,$pos,strpos($dns,"\n",$pos)-$pos));}
		$pos=strpos($dns,"domain ");
		if (!($pos===false)) {$pos+=strlen("domain "); $this->domain=trim(substr($dns,$pos,strpos($dns,"\n",$pos)-$pos));}
	}
}

class ScreenInfoBasics {
    var $width;
    var $height;
    var $resolution;
    var $refresh;
    var $aspect;
    var $monitors;
    var $powersave;
    
    # Returns the location of the video out sysfs, with a trailing slash
    static function sysfs_vout_device() {
        if (file_exists('/sys/class/x-display/disp0/device')) {
            return '/sys/class/x-display/disp0/device/';
        } else {
            return '/sys/class/graphics/fb0/device/';
        }
    }
    
    public function load() {
        $dir = self::sysfs_vout_device();
        
        if ( file_exists($dir . "vid_mode") ) {
            $vidmod=file_get_contents( $dir . "vid_mode");
            $sets=explode ("=",$vidmod);
            if (count($sets)==2){
                $vals=explode (" ",trim($sets[1]));
                if (count($vals)>=11){
                    if ($vals[11]=="0:0") $vals[11]="[auto]";
                    if ($vals[11]=="x:x") $vals[11]="[unknown]";
                    $this->width = htmlspecialchars( trim($vals[0]) );
                    $this->height = htmlspecialchars( trim($vals[1]) );
                    $this->resolution = $this->width."x".$this->height;
                    $this->refresh = htmlspecialchars($vals[2]);
                    $this->aspect = htmlspecialchars($vals[11]);
                }
            }
        } else {
            $this->resolution = "unknown";
            $this->refresh = "unknown";
            $this->aspect = "unknown";
        }
        
        $dpm_state = file_get_contents($dir . "dpm_state");
        $this->powersave = $dpm_state[0]=="0"?"on":"off";
        
        
        $this->monitors = array();
        $content=scandir( $dir );
        foreach($content as $path){
            if ( strncmp($path,"out",3) == 0 && file_exists("$dir$path/name") ){
                $data=array("mon_powered","mon_manufacturer","mon_prod_id", 
                            "mon_name","mon_serial_no", "mon_width",
                            "mon_height","mon_underscan","mon_audio",
                            "mon_pict_ar","link_type" );
                if ( file_exists( "$dir$path/name"  ) )
                    $type = trim( file_get_contents( "$dir$path/name" ) );
                else
                    $type = "unknonw";
                if ( file_exists( "$dir$path/mon_present"  ) )
                    $mon_present = file_get_contents( "$dir$path/mon_present" );
                else 
                    $mon_present = 0;
                $scinfo = array( 'type' => $type );
                if ( $mon_present == 1 ) {
                    $result = array();
                    foreach ($data as $d){
                        $file = $dir.$path."/$d";
                        if ( file_exists( $file ) )
                            $result[$d] = trim( file_get_contents($file) );
                        else
                            $result[$d] = "";
                    }
                    if ( $result['mon_manufacturer'] != "" || $result['mon_name'] != "") {
                        $scinfo['manufacturer'] = $result['mon_manufacturer'];
                        $scinfo['productID'] = $result['mon_prod_id'];
                        $scinfo['name'] = $result['mon_name'];
                        $scinfo['serial'] = $result['mon_serial_no'];
                    }
                    if ( $result['mon_powered'] != "" ) 
                        $scinfo['powered'] = $result['mon_powered']==0 ? "off" : "on";
                    else 
                        $scinfo['powered'] = "unknown";

                    if ( $result['mon_pict_ar'] == "" || $result['mon_pict_ar'] == "x:x") 
                        $result['mon_pict_ar']="unknown";
                    if ( $result['mon_width'] != "" && $result['mon_height'] != "" ) {
                        $scinfo['width'] = $result['mon_width'];
                        $scinfo['height'] = $result['mon_height'];
                        $scinfo['aspectRatio'] = $result['mon_pict_ar'];
                    }
                    $scinfo['link'] = $result['link_type'];
                    
                    if ( $result['mon_underscan'] === "0" ) 
                        $scinfo['underscan']  ="unsupported"; 
                    else 
                        $scinfo['underscan']="supported";
                }
                $this->monitors[ ] = $scinfo;
            }
        }
    }

}

function net_mask_to_prefix($netmask)
{
    $length = 0;
    $vals = explode('.', $netmask);
    if ( count($vals) != 4 )
        return false;
    $expect_zero = false;
    foreach ($vals as $val) {
        if ( ! is_numeric($val) || $val < 0 || $val > 255 )
            return false;
        if ($expect_zero) {
            if ($val != 0)
                return false;
            else
                continue;
        }
        switch ($val) {
        case 255:
            $length += 8; break;
        case 254:
            $length += 7; break;
        case 252:
            $length += 6; break;
        case 248:
            $length += 5; break;
        case 240:
            $length += 4; break;
        case 224:
            $length += 3; break;
        case 192:
            $length += 2; break;
        case 128:
            $length += 1; break;
        case 0:
            $length += 0; break;
        default:
            return false;
        }
        if ($val != 255)
            $expect_zero = true;
    }
    return $length;
}
class Parselogfile {
    
    protected $file;
    protected $leftover = "";
    protected $lines = array();
    
    function open( $logFile ) {
        $this->file = fopen($logFile, 'r');
        // go to the end of the file
        fseek($this->file, 0, SEEK_END);
    }
    function close(  ) {
        fclose( $this->file );
    }
    function readLine( $targets=array(), $blockSize = 1024 ){
        $data = "";
        
        do{
            // need to know whether we can actually go back
            // $block_size bytes
            $canRead = $blockSize;
            if( ftell($this->file) < $blockSize){
                $canRead = ftell($this->file);
            }
            
            // go back as many bytes as we can
            // read them to $data and then move the file pointer
            // back to where we were.
            fseek($this->file, -$canRead, SEEK_CUR);
            $data = fread($this->file, $canRead);
            $data .= $this->leftover;
            fseek($this->file, -$canRead, SEEK_CUR);

            // split lines by \n. Then reverse them,
            // now the last line is most likely not a complete
            // line which is why we do not directly add it, but
            // append it to the data read the next time.
            $splitData = array_reverse( explode("\n", $data) );         
            if( $canRead == $blockSize ){
                $this->leftover = $splitData[count($splitData) - 1];            
                $newLines = array_slice($splitData, 0, -1);                            
            } else {
                $newLines[] = $this->leftover;
                $this->leftover = "";
            }
            $this->lines = array_merge($this->lines, $newLines);
            
            //print_r( $targets );
            // check if the lines contains the target
            foreach( $this->lines as $idx=>$line ) {
                unset( $this->lines[$idx] );
                if ( count($targets) == 0 ){
                    return $line;                    
                } else {
                    foreach ( $targets as $target) {
                        if ( strpos( $line, $target) !== false ){
                            return $line;                            
                        }
                    }
                }
            }
        } while( $canRead == $blockSize );
        
        return false;
    }
    
}

class ParseSyslog extends Parselogfile {
    protected $logFile = "/var/log/syslog";
    
    var $readSocType = false;
    function open( $logFile ) {
        parent::open( $this->logFile );        
    }
    
    function readReboot( ){
        $reason = "";   
        
        $SOCType = "kernel: SoC reset type";
        $watchdog = "shutting down the system because of error";
        $user = "init: Switching to runlevel:";
        
        $content = "file /dev/raperca/progress was not changed";
        $crash = "pinging process";
        $exit = "cannot open /var/run";
        
        $interface = "user initiated shutdown";
        $button = "kernel: Starting reboot from push button";
        $updater = "rebooting for upgrades to take full effect";
        $safemode = "raperca-safe-mode: safe mode rebooting automatically";
        
        if ( $this->readSocType === false ) {
            $resetType = $this->readLine( array( $SOCType ) );
        } else {
            $resetType = $this->readSocType;
            $this->readSocType = false;            
        }
        $typeMatch = array();
        if ( $resetType !== false && preg_match( "/SoC reset type\s+0x\d+\s+\((\w+)/", $resetType, $typeMatch) ){
            // we found a reason 
            $reason = $typeMatch[1];            
        }

        if ( $reason == "" ){
            // we should open the rotated backup, but for the time being, we just say we don't know            
            return "unknown";
        }
        
        // find the cause of the reboot
        $reasonLine = $this->readLine( array( 
            $SOCType,
            $user,
            $watchdog,
            $interface
        ) );
        if ( $reasonLine === false || strpos( $reasonLine, $SOCType) !== false ){
            $this->readSocType = $reasonLine;
            return $reason; // no more info
        }
        
        if ( strpos( $reasonLine, $watchdog) !== false ){
            // reboot because of the watchdog
            $watchdogLine = $this->readLine( array( 
                $content,
                $crash,
                $exit,
                $SOCType
            ) );
            if ( $watchdogLine === false || strpos( $watchdogLine, $SOCType) !== false ){
                $this->readSocType = $watchdogLine;
                return $reason; // no more info
            }
            
            if ( strpos( $watchdogLine, "hwwatchdog") !== false ){
                // the hwwatchdog is gone, this normally means that the temperature is too high
                // we may go further to check using the hwwatchdog logs
                return "temperature";
            } else if ( strpos( $watchdogLine, $crash) !== false 
                || strpos( $watchdogLine, $exit) !== false )
                return "crash";
            else if ( strpos( $watchdogLine, $content) !== false )
                return "content";
            else
                return $reason;
        } else if ( strpos( $reasonLine, $user) !== false ){
            // reboot following user action
            $userLine = $this->readLine( array( 
                $interface,
                $button,
                $updater,
                $safemode,
                $SOCType
            ) );
            if ( $userLine === false || strpos( $userLine, $SOCType) !== false ){
                $this->readSocType = $userLine;
                return $reason; // no more info
            }
            
            if ( strpos( $userLine, $updater ) !== false ){
                return "updater";
            } else if ( strpos( $userLine, $button ) !== false ){
                return "button";
            } else if ( strpos( $userLine, $safemode ) !== false ){
                return "safemode";
            } else {
                if ( strpos( $userLine, "rpc" ) !== false )
                    return "rpc";
                else
                    return "interface";
            }
        } else if ( strpos( $reasonLine, $interface) !== false ){
            if ( strpos( $userLine, "rpc" ) !== false )
                return "rpc";
            else
                return "interface";
        }
        
        
        return $reason; // no more info
    }    
    static function getRebootReason() {
        $syslog = new ParseSyslog();
        $syslog->open();
        $reason = $syslog->readReboot();
        $syslog->close();
        return $reason;
    }
}

class ParseLogs extends Parselogfile {
    protected $logFile = "/srv/raperca/log/player.log";
    protected $syslogFile = "/var/log/syslog";
        
    protected $logger;
    
    function open( $logger ) {
        if ( $logger === "temperature" ){
            parent::open( $this->syslogFile );
            $this->logger = $logger;
        } else {
            parent::open( $this->logFile );
            $this->logger = $logger;
        }
    }
    function readLines( $time, $blockSize = 512 ){        
        $lastTime = strtotime( date("d-m-Y H:i:s") );
        if ( $time !== true ){
            if ( substr($time,0,1) == "-" ){
                $offset = explode( ":", substr($time,1) );
                
                $mintime = $lastTime - 3600*floatval( $offset[0] );
                if ( count($offset)>1 )
                    $mintime -= 60*floatval( $offset[1] );
                if ( count($offset)>2 )
                    $mintime -= floatval( $offset[2] );                                                
            } else {
                $mintime = strtotime( $time );
                
            }
        }
        
        $retLines = array();        
        do {
            $line = parent::readLine( array( $this->logger ), $blockSize );
            
            if ( $line === false )
                return $retLines;
            if ( $time === true ){
                $retLines[] = $line;
                break;
            } else {
                $date = explode(" ", $line, 4);
                if ( strlen( $date[0] ) <= 6 ) // syslog format for date
                    $lineTime = strtotime( $date[2] );
                else // log4cxx format for date
                    $lineTime = strtotime( $date[1] );
                if ( $lineTime > $lastTime )
                    break; // time is going backward
                
                if ( $lineTime < $mintime ){                    
                    break;
                } else {
                    $retLines[] = $line;
                }
                
                $lastTime = $lineTime;
            }
            
        } while( count($retLines)<100 );
        
        
        return $retLines;
    }
    
    
    function readStats( $time=false ) {
        $this->open( "spx.stats" );
        $lines = $this->readLines( $time );
        $stats = array();
        
        foreach ( $lines as $line ){
            $pattern =  "/(\S+\s\S+)\s+INFO\s+\S+\s+-\s+".
                        "(\d+:\d+:\d+) Period: 60s Pic:\s*(\d+) ".
                        "Usage:\s+(\d+)% \(([\d\s\|)]*)\) \(([\d\s\/)]*)\) ".
                        "Peak:\s+(\d+)ms Buffers:\s*([\d\.]+)ms \(min\s*(\d+)ms\) ".
                        "FPS Drop:\s*(\d+)% \(([\d\s\/)]*)\) ".
                        "Peak drop:\s*(\d+)% \(([\d\s\/)]*)\)/";
            $matches = array();
            if ( preg_match($pattern, $line, $matches) ) {
                $date = explode("-", $matches[1]); 
                $time = substr( $date[2], 0, 4)."-".$date[1]."-".$date[0]."T".substr( $date[2], 5);
                $cpu = explode("|",$matches[5]);
                $result = array(
                    'time' => $time,
                    'render' => $matches[2],
                    'pictures' => intval( $matches[3] ),
                    'usage' => array(
                        'average' => intval( $matches[4] ),
                        'arm' => intval( $cpu[0] ),
                        'dsp' => intval( $cpu[1] ),
                        'max' => array_map('intval', explode("/",$matches[6]) )
                    ),
                    'peak' => intval( $matches[7] ),
                    'buffers' => array(
                        'average' => floatval( $matches[8] ),
                        'min' => intval( $matches[9] ),
                    ),
                    'dropFPS' => array(
                        'average' => intval( $matches[10] ),
                        'max' => array_map('intval', explode("/",$matches[11]) ),
                    ),
                    'dropPeak' => array(
                        'average' => intval( $matches[12] ),
                        'max' => array_map('intval', explode("/",$matches[13]) ),
                    )                    
                );
                $stats[] = $result;
            }
        }
        $this->close( );
        return $stats;
    }
    function readErrors( $time=false ) {
        $this->open( "spx.content" );
        $lines = $this->readLines( $time );
        $stats = array();
        $names = array(
            "101" => "JavaScript Exception",
            "102" => "Local file not found",
            "103" => "Rendering error",
            "104" => "Media out of specs",
            "105" => "Parsing/Decoding error",
            "106" => "Network error",
            "999" => "Others",
        );
        foreach ( $lines as $line ){
            $pattern =  "/(\S+\s\S+)\s+WARN\s+\S+\s+-\s*(\d+)\s(\S*)\s(.*)/";
            $matches = array();
            if ( preg_match($pattern, $line, $matches) ) {  
                $date = explode("-", $matches[1]); 
                $time = substr( $date[2], 0, 4)."-".$date[1]."-".$date[0]."T".substr( $date[2], 5);
                $result = array(
                    'time' => $time,
                    'code' => intval( $matches[2] ) ,
                    'source' => $matches[3],
                    'custom' => trim($matches[4])
                );
                if ( isset($names[$matches[2]]) )
                    $result['desc'] = $names[$matches[2]];
                $stats[] = $result;
            }
        }
        $this->close( );
        return $stats;
    }
    
    function readTemperature( $time=false ) {
        $this->open( "temperature" );
        $lines = $this->readLines( $time );
        $temps = array();
        foreach ( $lines as $line ){
            $pattern =  "/(\S+\s\S+\s\S+)\s+\S+\shwwatchdog\[\d+\]:\s+temperature\s+=\s+([\d\.]+)/";
            $matches = array();
            if ( preg_match($pattern, $line, $matches) ) {  
                $timestamp = strtotime( $matches[1] ); 
                $time = date("Y-m-d\TH:i:s", $timestamp );                
                $result = array(
                    'time' => $time,
                    'C' => floatval( $matches[2] ) ,
                    'F' => (9/5)*floatval( $matches[2] )+32
                );
                $temps[] = $result;
            }
        }
        $this->close( );
        return $temps;
    }
}