<?php
class MaintenanceJobs{
	
    static $report="/usr/sbin/spxreport";
    static $boot_config="/boot-config";
    
	static function bootID() {
		$idfn = "/var/cache/raperca/www/docs/boot-id";
		return trim( file_get_contents( $idfn ) );
	}

    static function saveSymlink($target, $link) {
        if ( PHP_OS == "WINNT" ) {
            if ($target[0]=='/')
                copy( $target, $link );
            else
                copy( dirname($link)."/".$target, $link );
            file_put_contents($link.".link", $target);
            return true;
        }
        if ( ! symlink($target, $link) ) {
            unlink($link);
            if ( ! symlink($target, $link) ) {
                return "Cannot save settings- File: $link as symlink to ($target)";
            }
        }
        exec('sync');
        return true;
    }
    
    static function saveFile($name, $data, $secret=false, $group='raperca', $ignore_empty=true) {
        if ($data=="" && $ignore_empty) return true;

        if ( PHP_OS == "WINNT" ) {
            if ( file_put_contents( $name, $data ) === false ){
                return 'Cannot save settings- File: ($name).<br/>Data: '.htmlspecialchars($data);
            }
            return true;
        }
        $fname=tempnam(dirname($name), basename($name));
        if (file_put_contents($fname,$data)===FALSE){
            return 'Cannot save settings- File: ($name).<br/>Data: '.htmlspecialchars($data);
        }else{
            if (!$secret) {
                chmod($fname, 0644);
            } else {
                chmod($fname, $group ? 0640 : 0600);
                if ($group)
                     chgrp($fname, $group);
            }
            exec('sync');
            if ( rename($fname, $name) ){
                exec('sync');
                return true;
            } else {
                unlink($fname);
                return "Cannot save settings- File: ($name).<br/>Data: ".htmlspecialchars($data);
            }
        }
        return true;
    }
    
    // Copies the given source file or data data to the destination file
    // under the failsafe-data filesystem. If srcdata is FALSE the
    // destination file is removed instead. If isfile is true srcdata is a
    // file name, otherwise it is the data to copy. Returns false if the
    // failsafe-data data could not be updated.
    static function setSafeModeData($dstfile, $srcdata, $isfile = TRUE){
        if ( PHP_OS == "WINNT" ) return true;
        $out="";
        $status="";
        if ($srcdata) {
            if ($isfile) {
                $args = "copy " . escapeshellarg($dstfile) . " " . escapeshellarg($srcdata);
            } else {
                $args = "set " . escapeshellarg($dstfile) . " " . escapeshellarg($srcdata);
            }
        } else {
            $args = "remove " . escapeshellarg($dstfile);
        }

        exec("failsafe-data " . $args, $out, $status);
        return ($status == 0);
    } 
    
    
    function getReportFile( $serial, $ext=false) {
        
		header("Content-type: application/x-gzip");
        if ( $ext )
            header('Content-Disposition: attachment; filename="spxreport-ext-'.$serial.'.tar.gz"');
        else
            header('Content-Disposition: attachment; filename="spxreport-'.$serial.'.tar.gz"');
        
        if ( PHP_OS == "WINNT" ) {
            echo file_get_contents( "C:\srv\spxreport.tar.gz");            
        } else if ( $ext ){
            passthru("/usr/sbin/spxreport -x", $ret);
        } else { 
            passthru("/usr/sbin/spxreport", $ret);
        }
    }
    
    function checkSSH () {
        $ret = -1;
        if ( PHP_OS == "WINNT" ) {
            if ( file_exists( "/srv/ssh") && file_get_contents( "/srv/ssh" ) == "start" )
                $ret = 0;
        } else {
            exec('/etc/init.d/ssh-delayed status', $dummy, $ret);
        }
        return $ret==0;
    }
    
    function manageSSH( $start=true ) {
        if ( PHP_OS == "WINNT" ) {
            file_put_contents( "/srv/ssh", $start?"start":"stop");
            sleep( 3 );
        }
        if ( $start ) {
           exec('/etc/init.d/ssh-delayed start');
        } else {
           exec('/etc/init.d/ssh-delayed stop'); 
        }
    }
    function resetFactory( ) {
		syslog(LOG_NOTICE, 'requested reset to factory defaults' );
        $actions = "";
        if ( file_exists( self::$boot_config ) )
            $actions = file_get_contents(self::$boot_config);
        $actions .= "reset\n";
        
        return file_put_contents(self::$boot_config, $actions);
    }
    function formatStorage( ) {
		syslog(LOG_NOTICE, 'requested to format storage' );
        $actions = "";
        if ( file_exists( self::$boot_config) )
            $actions = file_get_contents(self::$boot_config);
        $actions .= "format\n";
        
        return file_put_contents(self::$boot_config, $actions);
    }
    function resetContent( ) {
		syslog(LOG_NOTICE, 'resetting content to default' );
        exec('/etc/raperca/resetcontent');
    }
    
    function clearLogs( ) {
		syslog(LOG_NOTICE, 'clearing logs in /srv/raperca/log/' );
        if ( PHP_OS == "WINNT" ) {
            return;
        }
        exec('rm -rf /srv/raperca/log/*');
        
        $pid = trim(file_get_contents('/var/run/raperca.pid'));
        posix_kill($pid, SIGUSR1 );
        
        $pid = trim(file_get_contents('/var/run/uploader.pid'));
        posix_kill($pid, SIGUSR1 );
        
    }
    function clearStreaming( ) {
		syslog(LOG_NOTICE, 'clearing streaming captures' );
        exec('rm -rf /srv/raperca/capture/*');
    }
    function clearCache( ) {
		syslog(LOG_NOTICE, 'requesting to clean cache' );
        if (touch('/var/spool/raperca/clean-cache')) {
            exec('sync'); // make sure the clean-cache file is on stable storage
            return true;
        } else {
            return false;
        }
    }
    function clearNtp( ) {
		syslog(LOG_NOTICE, 'requesting to reset NTP data' );
        return touch('/var/spool/spxutils/ntpreset');
    }
	
    // Returns TRUE on success and an error string on failure
	static function shutdown( $msg, $recovery=false, $delay=false, $halt=false ) {
        $opt = $halt ? "-h" : "-r";
        if ( $msg == "" ) $msg="user initiated shutdown : unknown reason";
		
		if ( $delay==false ) {
			exec('exec shutdown ' . escapeshellarg($opt) . ' now 2>&1',
                 $out, $ret);
            if ($ret > 1)
                return "failed to spawn shutdown command";
            elseif ($ret != 0)
                return "a shutdown or restart is already in progress";
        } else {
            // the shutdown command requires a + to prefix a delay (in minutes)
            $delay = '+' . $delay;
            $pid = file_get_contents('/var/run/shutdown.pid');
            if ($pid !== FALSE) {
                $pid = trim($pid);
                if ( is_numeric($pid) && posix_kill($pid, 0) ) {
                    return "a shutdown or restart is already in progress";
                }
            }
			exec("exec shutdown " . escapeshellarg($opt) . " " .
                 escapeshellarg($delay) . " &> /dev/null < /dev/null &",
                 $out, $ret);
            if ($ret != 0)
                return "failed to spawn shutdown command";
        }
		if ( $recovery )
			exec('/etc/init.d/bootcount noreset; echo 100 > /proc/bootcount');
		syslog(LOG_NOTICE, $msg );
        return TRUE;
    }
}
