<?php

include_once dirname(__FILE__).'/MaintenanceJobs.php';

class SecurityJobs{

    var $use_digest=true; # WARNING: only digesty auth supported by protection files!
    
    
    var $passfile="/etc/raperca/htpasswd"; # referred in pro files directly!
    static $admprotfile="/etc/apache/conf.d/95-raperca-adm-prot.conf";
    static $contprotfile="/etc/apache/conf.d/95-raperca-cont-prot.conf";
    static $logprotfile="/etc/apache/conf.d/95-raperca-log-prot.conf";
    
    protected $pass_conf_name="/etc/raperca/spxpasswd.xml";    
    
    # WARNING: cannot change $admindigest since the name is also hardcoded
    # in the failsafe (a.k.a. recovery, diagnostics) mode.
    static $admindigest="Administrative Area";
    static $contentdigest="Content Area";
    static $logdigest="Monitoring Area";
    
    var $spxpass_url=array( 'content' => 'http://localhost:81/',
		                    'monitoring' => 'http://localhost/',
		                    'admin' => 'http://localhost/');
    
    var $spxpass_realm;
    var $spxpass_mendatory_realm;
    
    var $needreload = false;
    
    function __construct() {
       $this->spxpass_mendatory_realm=array(
                'content'   => array( self::$contentdigest ) ,
                'monitoring'=> array( self::$logdigest ),
                'admin'     => array( self::$admindigest, self::$contentdigest, self::$logdigest ) 
       );
       $this->spxpass_realm = $this->spxpass_mendatory_realm;
       $this->spxpass_realm['content'][] = self::$admindigest;
       $this->spxpass_realm['monitoring'][] = self::$admindigest;       
   }
    function getUsers( ){
        
        $users=array();
        
        if ( file_exists($this->passfile) ){
            $passwords=file_get_contents($this->passfile);
            $passwords=explode("\n",$passwords);
            
            foreach ($passwords as $line){
                if ($this->use_digest){
                    if (ereg("(.*)(:)(.*)(:)(.*)", $line, $passelements)){
                        $users[]=array('user'=>$passelements[1], 'pass'=>$passelements[5], 'digest'=>$passelements[3]);
                    }
                }else{
                    if (ereg("(.*)(:)(.*)", $line, $passelements) && strpos($passelements[1],":")==false){
                        $users[]=array('user'=>$passelements[1], 'pass'=>$passelements[3]);
                    }
                }
            }
        }
        return $users;
    }
    
    static function getRandomString( $length ) {
        $res = "";
      
        if ( PHP_OS == "WINNT" ) {
            $pr_bits = "";
            for ($i=0; $i<$length; $i++)
                $pr_bits .= chr(mt_rand(0,255)); // this is not good, but just for testing on Windows OS
        } else {
            $fp = fopen('/dev/urandom','rb');
            if ($fp !== FALSE) {
                $pr_bits = fread($fp,$length);
                fclose($fp);
            }
        }
        $res = strtr(base64_encode($pr_bits), array("/"=>"", "+"=>"") );
        return substr( $res, 0, $length );
        
    }
    
    function saveUsers( $users ){
        
        $spxpass_user=array('content'   =>self::$contentdigest,
                            'monitoring'=>self::$logdigest,
    		                'admin'     =>self::$admindigest);
                            
        $xlinkNS = 'http://www.w3.org/1999/xlink';
        
        $pass_config = new DOMDocument;
        if ( file_exists($this->pass_conf_name) )
            $pass_config->loadXML(file_get_contents($this->pass_conf_name));
        $parent=$pass_config->getElementsByTagName('credits');
        if ($parent->length<1) $parent=$pass_config->appendChild($pass_config->createElement('credits'));
        else $parent=$parent->item(0);
        
        $str="";
        
        // add a random password for the uploader to be able to access the content, the logs and the interface
        $username = 'uploader';
        $pass = "";
        $cred = $pass_config->getElementById("admin");
        if ( $cred ) {
            $pass = $cred->getAttribute("password");
        }
        if ( $pass=="" )
            $pass = self::getRandomString(16);
   
        foreach ( $spxpass_user as $name=>$digest ){
           $this->addUser( $users, $username, $digest, $pass );
        }
        
        foreach($users as $user){
            if ( $user ){
                if ($this->use_digest){
                    $str.=$user['user'].":".$user['digest'].":".$user['pass']."\n";	
                }else{
                    $str.=$user['user'].":".$user['pass']."\n";
                }
            }
        }
        
        if ( empty($str) ){
            if ( file_exists( $this->passfile) )
                unlink( $this->passfile );
            return true;
        } else {
            $ret = MaintenanceJobs::saveFile( $this->passfile, $str );
            
            // save data in the XML file also        
            if ( $ret===true ) {    
                $id_set = array("admin"=>'http://localhost/', "content"=>'http://localhost:81/', "admin2"=>'http://127.0.0.1/', "content2"=>'http://127.0.0.1:81/');
                foreach ($id_set as $id=>$dest ) {
                    $cred=$pass_config->getElementById($id);
                    if ( !$cred ) {
                        $cred=$pass_config->createElement('creditentials');
                        $parent->appendChild($cred);
                    } 
                    $cred->setAttribute("username", $username);
                    $cred->setAttribute("password", $pass);
                    $cred->setAttributeNS($xlinkNS,"xlink:href", $dest);
                    $cred->setAttribute("xml:id", $id);
                } 
                $ret = MaintenanceJobs::saveFile($this->pass_conf_name, $pass_config->saveXML(), true);
        
            }
	    return $ret;
        }
        
    }
    function clearUser( &$users, $name ) {
        foreach ( $users as $idx => $user ){
            if ( $user['user'] == $name )
                $users[$idx] = false;
        }
    }
    function getUser($users, $name, $digest, &$idx=0){
        $curuser=false;
        foreach($users as $idx=>$user){
            if ($user['user']==$name && (!isset($user['digest']) || $user['digest']==$digest) ) {
                $curuser=$user;
                break;
            }
        }
        return $curuser;
    }
    function addUser(&$users, $name, $digest, $newpass, $encripted=false){
        $spxpass_user=array('content'   =>self::$contentdigest,
                            'monitoring'=>self::$logdigest,
    		                'admin'     =>self::$admindigest);
        if ( $digest === false ) {            
            $digest = $spxpass_user[$name];
            if ( $digest != self::$admindigest ){
                $this->addUser( $users, $name, self::$admindigest, $newpass, $encripted );
            }
        }
        $idx=-1;
	    $curuser=$this->getUser($users,$name,$digest,$idx);

        if ( $newpass=="" ){
            if ( $idx>=0 )
                $users[$idx]=false;
        } else {
            if (!$curuser){
                $curuser = array();
                $curuser['user']=$name;
                $curuser['digest']=$digest;
                $idx=-1;
            } 
            if ( $encripted ) {
                $curuser['pass'] = $newpass;
            } else {
                $curuser['clearpass']=$newpass;
                if ( $this->use_digest ){
                    $curuser['pass'] = md5($curuser['user'].":".$curuser['digest'].":".$newpass);
                }else{
                    $curuser['pass'] = $this->crypt_apr1_md5($newpass); 
                }
            }
            if ($idx>=0)
                $users[$idx]=$curuser;
            else
                $users[]=$curuser;
        }
    }
    
    function setAccess( $user ){
        $spxpass_user=array('content'   =>self::$contprotfile,
                            'monitoring'=>self::$logprotfile,
    		                'admin'     =>self::$admprotfile);
        
        if ( !isset($spxpass_user[$user]) )
            return true;
        if ( $this->isProtected( $user ) )
            return true;
        
        $protfile = $spxpass_user[$user];
        MaintenanceJobs::saveSymlink( basename($protfile).".tmpl", $protfile );
        $this->needreload = true;
        if ( $user=='admin' ) {
            if ( !MaintenanceJobs::setSafeModeData("htpasswd", $this->passfile ) )
                return "Failed setting password for recovery console, please set again.";
        }
        return true;
    }
    function clearAccess( $user ){
        $spxpass_user=array('content'   =>self::$contprotfile,
                            'monitoring'=>self::$logprotfile,
    		                'admin'     =>self::$admprotfile);
        if ( !isset($spxpass_user[$user]) )
            return true;
        if ( !$this->isProtected( $user ) )
            return true;
            
        $protfile = $spxpass_user[$user];
        
        if ( file_exists( $protfile ) ){
            unlink($protfile);
            exec('sync'); // make sure data is commited before returning
            $this->needreload = true;
        }
        
        if ( $user=='admin' ) {
            if ( !MaintenanceJobs::setSafeModeData("htpasswd", FALSE) )
                return "Failed clearing admin password for recovery console, please set again.";
        }
        return true;
    }
    
    function isProtected( $user ) {
        $spxpass_user=array('content'   =>self::$contprotfile,
                            'monitoring'=>self::$logprotfile,
    		                'admin'     =>self::$admprotfile);
        
        if ( isset($spxpass_user[$user]) )
            return file_exists($spxpass_user[$user]);
            
        return false;
    }
    
    function crypt_apr1_md5($plainpasswd, $salt="") {
        if ($salt=="")
            $salt = substr(str_shuffle("abcdefghijklmnopqrstuvwxyz0123456789"), 0, 8);
        else 
            $salt = substr($salt,6,8);
     
        $len = strlen($plainpasswd);
        $text = $plainpasswd.'$apr1$'.$salt;
        $bin = pack("H32", md5($plainpasswd.$salt.$plainpasswd));
        for($i = $len; $i > 0; $i -= 16) { $text .= substr($bin, 0, min(16, $i)); }
        for($i = $len; $i > 0; $i >>= 1) { $text .= ($i & 1) ? chr(0) : $plainpasswd{0}; }
        $bin = pack("H32", md5($text));
        for($i = 0; $i < 1000; $i++) {
            $new = ($i & 1) ? $plainpasswd : $bin;
            if ($i % 3) $new .= $salt;
            if ($i % 7) $new .= $plainpasswd;
            $new .= ($i & 1) ? $bin : $plainpasswd;
            $bin = pack("H32", md5($new));
        }
        $tmp="";
        for ($i = 0; $i < 5; $i++) {
            $k = $i + 6;
            $j = $i + 12;
            if ($j == 16) $j = 5;
            $tmp = $bin[$i].$bin[$k].$bin[$j].$tmp;
        }
        $tmp = chr(0).chr(0).$bin[11].$tmp;
        $tmp = strtr(strrev(substr(base64_encode($tmp), 2)),
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",
        "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        return "$"."apr1"."$".$salt."$".$tmp;
    }
    
    
}
