<?php

/*
 * This script is run on package update, from a boot script on the
 * first reboot after an update, *before* the HTTP service is started.
 * Note that stdout and stderr go to the console, not a browser. 
 *
 * Put here any complex operations that are required after a package
 * update. As much as possible the operations should only be performed
 * if necessary, so that minimal system modification is done.
 *
 * The operations in here should also be idempotent, running them more
 * than once should have no ill effects, as this may happen under some
 * circusmtances after an update (think power loss at just the wrong
 * moment).
 */

include_once dirname(__FILE__).'/SecurityJobs.php';

/* Make sure the random, local-only, "updater" passwords to access the
 * password protected admin interface and RPC service are present.
 * These are required as of firmware 2.2.5 and are added when the user
 * sets up a password, but are missing when password protection was
 * set up with a 2.2.4 or earlier firmware and then the firmware
 * updated.
 */

function createUpdaterPasswords()
{
    $job = new SecurityJobs;
    $user = $job->getUsers();
    if ( count($user) == 0 )
        return; // system is not password protected
    foreach ( $user as $u ) {
        if ( $u['user'] == 'uploader' )
            return; // uploader user already present
    }
    echo "creating local updater passwords... ";
    // there is some password protection but the random uploader
    // password is not present, saving the user passwords will add
    // them
    $job->saveUsers( $user );
    echo "done\n";
}

createUpdaterPasswords();

