<?php

class Updater {

    protected $pid_file="/var/lock/updater";
    protected static $statusFileName='/var/lib/updater/status';
    protected static $stateFileName='/var/lib/updater/update-state';
    
    protected $logFileName='/var/log/updater/lastlog';
    
    
    var $update_pid=false;
    var $update_id=false;
    
    var $nb_updates = false;
    var $update_info = false;
    var $updater_fallback = false;
    var $updater_mode = "check";
    var $updater_status = false;
    
    var $product;
    var $email;
    
    var $errorStr="";
    
    function startUpdate( $checkOnly=true, $source="", $max_wait_time=-1, $block=false, $test=false ) {
    
        $flag="";
        if ( !$block ) $flag.="-b ";
        if ($checkOnly) $flag.="-n ";
        if ( $test ) $flag.="-N ";
        if ( $source=="usb" ) {
            $flag.='--repo=local-usb ';
            $mount=file_get_contents("/proc/mounts");
            $mounts=explode("\n",$mount);
            $usbContent=false;
            $usbUpdate=false;
            foreach ($mounts as $mount){
                $info=preg_split("/\s/",$mount);
                if (count($info)>2){
                    if ($info[1]=='/srv/raperca/content') $usbContent=true;
                    if ($info[1]=='/var/lib/updater/mnt-usb-updates') $usbUpdate=true;
                }
            }
            if (!$usbUpdate){
                if ($usbContent) $this->errorStr = "USB storage is used as Local Storage.";
                else $this->errorStr = "No USB storage Found.";
                return false;
            }elseif (!file_exists("/var/lib/updater/mnt-usb-updates/repodata")){
                $this->errorStr = "USB storage found but folder <strong>/updates</strong> does not contain update data.";
                return false;
            }
        }
        else if ( $source!="" && $source!="default" )
            $flag.="--repo=base --repo-url=base:".escapeshellarg($source)." ";
        
        do {
            $this->update_id = uniqid();
            $updater_log = $this->getLogFileName( $this->update_id );
            $updater_log_file = fopen($updater_log, 'xb');
        } while ($updater_log_file === FALSE);

        fclose($updater_log_file);
        if ( PHP_OS == "WINNT" ) {
            $str = "/usr/sbin/updater $flag >$updater_log";
        } else {
            $str = "/usr/sbin/updater --log-to-stderr --lock-timeout=2 --max-wait-time=$max_wait_time $flag --log-to=" . $updater_log." 2>&1";
        }
        exec($str, $updater_out, $updater_ret);
        if ( PHP_OS == "WINNT" ) {
            $updater_out = explode( "\n", file_get_contents($updater_log ) );
        }
        if ( $updater_ret==0 ) {
            // success
            if ( $block ) 
                return true;
            foreach ($updater_out as $line )
                if (preg_match("/---\s+BACKGROUND PID\s+([^-]+)\s+---/", $line, $matches)) {
                    $this->update_pid = $matches[1];
                    $this->errorStr=$str;
                    return true;
                }
            $this->errorStr="Cannot find PID of updater.";
        } else {
			syslog(LOG_NOTICE, "updater failed with error ($updater_ret). command: " . $str);
            if ($updater_ret==1){
                if ( $checkOnly )
                    $this->errorStr="Check for update failed. Please check the logs for more details.";
                else
                    $this->errorStr="Update failed. Please check the logs for more details.";
            } elseif ($updater_ret==2)
	            $this->errorStr="Fatal error during update. ".
								"The ".$this->product." might not be usable anymore. ".
								"Reboot in diagnostic mode to re-install the firmware from a firmware package. ".
								"Contact support <a href='mailto:".$this->email."' >".$this->email."</a> if you require assistance.";		
            elseif ($updater_ret!=0)
	            $this->errorStr="Failed starting update process. ".
								"The most probable cause is that the device is shutting down. ".
								"Please wait before trying to reload the page to see if this solves the problem. ".
								"Contact support <a href='mailto:".$this->email."' >".$this->email."</a> if you require assistance.";
        }
        if ( file_exists($updater_log) )
            unlink( $updater_log );
        
        return false;
        
    }

    function parseLog( $lines) {
        foreach ($lines as $line ) {
            if (strstr($line,"UPDATE(S) ---")){
                $vals=explode(" ",$line);
                if (count($vals)>3) 
                    $this->nb_updates=$vals[2];
            } elseif (preg_match("/---\s+(FIRMWARE|UPDATER)\s+([^-]+)-([^-]+)\s+---/", $line, $matches)) {
                $this->update_info['type'] = $matches[1];
                $this->update_info['ver'] = $matches[2];
                $this->update_info['rel'] = $matches[3];
            } elseif (preg_match("/---\s+RETRY UPDATER ONLY\s+---/", $line)) {
                $this->updater_fallback = true;
            } elseif (preg_match("/---\s+(BACKGROUND PID|MODE|EXIT)\s+([^-]+)\s+---/", $line, $matches)) {
                if ( $matches[1]=="BACKGROUND PID" )
                    $this->update_pid = $matches[2];
                elseif ( $matches[1]=="MODE" )
                    $this->updater_mode = $matches[2];
                else
                    $this->updater_status = $matches[2];
            } 
        }

    }
    
    function getLastLog() {
    
        if ( file_exists($this->logFileName) )
            return explode("\n", file_get_contents($this->logFileName) );
        else
            return false;
    }
    
    function getLastLogTime() {
        if ( file_exists($this->logFileName) )
            return filemtime($this->logFileName);
        else 
            return false;
    }
    
    
    function getLog( $id ) {
    
        $this->update_id = $id;
        $name = $this->getLogFileName( $id );
        if ( file_exists($name) ) {
            return explode("\n", file_get_contents($name) );
        } else
            return false;
    }
    
    function cleanUp( $id=false ) {
        if ( $id===false )
            $id = $this->update_id;
        if ( $this->update_pid===false || ($id!=$this->update_id) ) {
            $this->parseLog( $this->getLog( $id ) );
        }
        if ( $this->update_pid===false ) 
            return false;
            
        if ( $this->isUpdateRunning( $this->update_pid ) ) return false; // cannot cleanup
        
        $name = $this->getLogFileName( $id );
        if ( file_exists($name) )
            unlink( $name );

        return true;
    }
    
    function getLogFileName( $id ) {
        return "/var/tmp/updater-" . $id . ".log";
    }
    
    function checkPID( $pid ) {
        if ( !isset($_ENV['OS']) || $_ENV['OS']!='Windows_NT' ) {
            return posix_kill($pid, 0);
        } 
        return false;
    }
    
    static function getStatus() {
        $status=trim(file_get_contents(self::$statusFileName));
        if ($status=="") $status='READY';
        return $status;
    }
    
    static function isUpdateInProgress() {
        $status = self::getStatus();
        if ( $status=="UPDATING" || $status=="PKGSDONE" || $status=="REBOOTING" )
            return true;
        return false;
    }
    
    function isUpdateRunning( $pid=false ) {
    
        if (isset($_ENV['OS']) && $_ENV['OS']=='Windows_NT') return false;
        
        if ( $pid===false ){
            if ( !file_exists( $this->pid_file ) )
                return false;
            $pid = file_get_contents($this->pid_file);
            if ( $pid===false) return false;
            $pid = trim($pid);
        }
        if ( !file_exists( "/proc/$pid/exe" ) ) 
            return false;
        $exec = readlink( "/proc/$pid/exe" );
        if ( $exec===false) 
            return false;
        
        if ( substr($exec, -8)!="/updater" ) 
            return false;

        return $this->checkPID( $pid );
    }
    static function getState() {        
        $state = "COMPLETE";
        if ( file_exists( self::$stateFileName ) ) {
            $state = trim( file_get_contents( self::$stateFileName ) );
        }
        if ( $state == "" )
            $state = "COMPLETE";
        return $state;
    }
    function fastNoUpdateCheck() {
        if ( file_exists( self::$stateFileName ) ) {
            $mtime = filemtime( self::$stateFileName );
            $now = time();
            if ( $mtime>$now-3600*24 && $mtime<$now && $this->getState()=="COMPLETE" )
                return true;
        }
        return false;
    }
}
