<?php 

$disabled = false;

Yii::app()->getClientScript()->registerCoreScript('jquery');

echo CHtml::tag("h2", array(), "Content Pull Scheduling") ."\n";
echo CHtml::errorSummary( $pull )  ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form("", "post", array('enctype'=>'multipart/form-data'));


echo CHtml::openTag( "table" );

echo CHtml::openTag( "tr" );
$opt = array('value'=>PullModeConfig::PULL_DISABLED, 'uncheckValue'=>null, 'onclick'=>'selectCurrentMode($(this).val())');
if ( $disabled ) $opt['disabled']='disabled';
echo CHtml::tag( "td", array( 'colspan'=>2), 
                        CHtml::activeRadioButton($pull, 'selectMode', $opt ) ." ".
                        $pull->getAttributeLabel('mode_dis') );
echo CHtml::closeTag( "tr" );


echo CHtml::openTag( "tr" );
$opt = array('value'=>PullModeConfig::PULL_STATIC, 'uncheckValue'=>null, 'onclick'=>'selectCurrentMode($(this).val())');
if ( $disabled ) $opt['disabled']='disabled';
echo CHtml::tag( "td", array( 'colspan'=>2), 
                        CHtml::activeRadioButton($pull, 'selectMode', $opt ) ." ".
                        $pull->getAttributeLabel('mode_manual') );
echo CHtml::closeTag( "tr" );

$h = array();
for ($i=0; $i<10; $i++)
    $h[$i]="0".$i;
for ($i=10; $i<24; $i++)
    $h[$i]=$i;

$m = array();
$m[0]="00";
$m[5]="05";
for ($i=10; $i<60; $i+=5)
    $m[$i]=$i;
    
$tdoptions = array( 'style'=>'width: 10%' );
echo CHtml::openTag( "tr" );
echo CHtml::tag( "td", $tdoptions);
echo CHtml::openTag( "td");
echo CHtml::activeCheckBox($pull, "enable_project", array('id'=>'UploadProject', 'onclick'=>'enableProject(0)') ) . " " . $pull->getAttributeLabel('enable_project');
echo CHtml::openTag( "table" );
$options = array('class'=>'mode0_proj', 'size'=>50);
$options2 = array('class'=>'mode0_proj');
echo CHtml::tag( "tr", array(), CHtml::tag("td", array(), CHtml::activeLabel($pull, "project_source") . " : " )  . 
                                CHtml::tag("td", array(), CHtml::activeTextField($pull, "project_source", $options )  )
                                );
echo CHtml::tag( "tr", array(), CHtml::tag("td", array(), CHtml::activeLabel($pull, "hourProj") . " : " ) .
                                CHtml::tag("td", array(), CHtml::activeDropDownList($pull, "hourProj", $h, $options2 ) ." ".
                                                          CHtml::activeDropDownList($pull, "minProj", $m, $options2 ) )
    
                                );
echo CHtml::closeTag( "table" );
$options = array('class'=>'mode0_log', 'size'=>49);
$options2 = array('class'=>'mode0_log');
echo CHtml::activeCheckBox($pull, "enable_log", array('id'=>'UploadLogs', 'onclick'=>'enableLogs(0)') ) . " " . $pull->getAttributeLabel('enable_log');
echo CHtml::openTag( "table" );
echo CHtml::tag( "tr", array(), CHtml::tag("td", array(), CHtml::activeLabel($pull, "log_source") . " : " )  . 
                                CHtml::tag("td", array(), CHtml::activeTextField($pull, "log_source", $options )  )
                                );
echo CHtml::tag( "tr", array(), CHtml::tag("td", array(), CHtml::activeLabel($pull, "hourLog") . " : " ) .
                                CHtml::tag("td", array(), CHtml::activeDropDownList($pull, "hourLog", $h, $options2 ) ." ".
                                                          CHtml::activeDropDownList($pull, "minLog", $m, $options2 ) )
    
                                );
echo CHtml::tag( "tr", array(), CHtml::tag("td") .
                                CHtml::tag("td", array(), CHtml::activeRadioButton($pull, "log_type", array_merge($options2, array('value'=>'accounting', 'uncheckValue'=>null ) ) ) .
                                                          $pull->getAttributeLabel('logs_accounting') .
                                                          CHtml::activeRadioButton($pull, "log_type", array_merge($options2, array('value'=>'alllogs', 'uncheckValue'=>null ) ) ).
                                                          $pull->getAttributeLabel('logs_all')
                                                          )
                                );
echo CHtml::closeTag( "table" );
if ( Yii::app()->user->branding->vendor=="SpinetiX" ) {
	echo CHtml::activeCheckBox($pull, "enable_rpc", array('id'=>'EnableRPC', 'onclick'=>'enableRPC(0)') ) . " " . $pull->getAttributeLabel('enable_rpc');
	echo CHtml::openTag( "table" );
	$options = array('class'=>'mode0_rpc', 'size'=>48);
	$options2 = array('class'=>'mode0_rpc');
	echo CHtml::tag( "tr", array(), CHtml::tag("td", array(), CHtml::activeLabel($pull, "concentrator") . " : " )  . 
									CHtml::tag("td", array(), CHtml::activeTextField($pull, "concentrator", $options )  )
									);
	echo CHtml::tag( "tr", array(), CHtml::tag("td", array(), CHtml::activeLabel($pull, "polling") . " : " )  . 
									CHtml::tag("td", array(), CHtml::activeTextField($pull, "polling", $options2 )  )
									);
	echo CHtml::tag( "tr", array(), CHtml::tag("td") .
									CHtml::tag("td", array(), 	CHtml::activeCheckBox($pull, "notification_only", $options2 ) . " " . 
																CHtml::activeLabel($pull, "notification_only")
												) );
	echo CHtml::closeTag( "table" );
}
echo CHtml::openTag( "td");
echo CHtml::closeTag( "td" );
echo CHtml::closeTag( "tr" );

echo CHtml::openTag( "tr" );
$opt = array('value'=>PullModeConfig::PULL_FILE, 'uncheckValue'=>null, 'onclick'=>'selectCurrentMode($(this).val())');
if ( $disabled ) $opt['disabled']='disabled';
echo CHtml::tag( "td", array( 'colspan'=>2), 
                        CHtml::activeRadioButton($pull, 'selectMode', $opt ) ." ".
                        $pull->getAttributeLabel('mode_file') );
echo CHtml::closeTag( "tr" );
echo CHtml::openTag( "tr" );
echo CHtml::tag( "td", $tdoptions);
echo CHtml::tag( "td", array(), CHtml::activeLabel($pull, 'icalfile' ) . " : " .
                                CHtml::activeFileField($pull, "icalfile", array('size'=>40, 'id'=>'ScheduleFile') ) );
echo CHtml::closeTag( "tr" );
if ($pull->selectMode==PullModeConfig::PULL_FILE) {
	echo "<tr><td/><td>".CHtml::submitButton("See current schedule", array('name'=>'upload') )."</td></tr>\n";
}


echo CHtml::openTag( "tr" );
$opt = array('value'=>PullModeConfig::PULL_REMOTE, 'uncheckValue'=>null, 'onclick'=>'selectCurrentMode($(this).val())');
if ( $disabled ) $opt['disabled']='disabled';
echo CHtml::tag( "td", array( 'colspan'=>2), 
                        CHtml::activeRadioButton($pull, 'selectMode', $opt ) ." ".
                        $pull->getAttributeLabel('mode_remote') );
echo CHtml::closeTag( "tr" );
echo CHtml::openTag( "tr" );
echo CHtml::tag( "td", $tdoptions);
echo CHtml::tag( "td", array(), CHtml::activeLabel($pull, 'icalSourceHref' ) . " : " .
                                CHtml::activeTextField($pull, "icalSourceHref", array('size'=>51, 'id'=>'ScheduleRemote') ) ."<br/>".
                                CHtml::activeLabel($pull, 'checktime' ) . " : " .
                                CHtml::activeTextField($pull, "checktime", array('size'=>10, 'id'=>'ScheduleCheck') ) ."<br/>".
                                "The following format can be used to specify a time: 24h, 30m, 10s." ."<br/><br/>".
                                "Use '[serial]' in the URI to use the serial number of the ".Yii::app()->user->branding->product ."<br/>".
                                CHtml::activeTextField($pull, "uri", array('size'=>65, 'disabled'=>'disabled') ) 
                                );
echo CHtml::closeTag( "tr" );


echo CHtml::closeTag( "table" );

$opt = array('name'=>'pullmode');
if ( $disabled ) $opt['disabled']='disabled';
echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Apply", $opt ) );


echo CHtml::endForm();
echo CHtml::closeTag("div");
if ( Yii::app()->user->advancedMode() ) {
    echo CHtml::tag("h2", array(), "Log settings") ."\n";
    echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form();
    echo CHtml::tag( "div", array('class'=>'simple'), CHtml::activeLabel($pull, 'priority' ) .
                                                     CHtml::activeDropDownList($pull, "priority", $pull->priorityList ) );
    echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Apply", array('name'=>'logs') ) );
    echo CHtml::endForm() . CHtml::closeTag("div");
}
?>
<script type="text/javascript">//<![CDATA[

function selectCurrentMode(mode)
{
	$("#UploadProject").prop( "disabled",  mode!="<?php echo PullModeConfig::PULL_STATIC; ?>" );
    enableProject( mode!="<?php echo PullModeConfig::PULL_STATIC; ?>" );
	
    $("#UploadLogs").prop( "disabled",  mode!="<?php echo PullModeConfig::PULL_STATIC; ?>" );
	enableLogs( mode!="<?php echo PullModeConfig::PULL_STATIC; ?>" );
<?php if ( Yii::app()->user->branding->vendor=="SpinetiX" ) {	?>
    $("#EnableRPC").prop( "disabled",  mode!="<?php echo PullModeConfig::PULL_STATIC; ?>" );	
	enableRPC( mode!="<?php echo PullModeConfig::PULL_STATIC; ?>" );
<?php }	?>	
    $("#ScheduleFile").prop( "disabled",  mode!="<?php echo PullModeConfig::PULL_FILE; ?>" );
	
	$("#ScheduleRemote").prop( "disabled",  mode!="<?php echo PullModeConfig::PULL_REMOTE; ?>" );
	$("#ScheduleCheck").prop( "disabled",  mode!="<?php echo PullModeConfig::PULL_REMOTE; ?>" );	
}

function enableProject(mode)
{
    var checked = $('#UploadProject').prop('checked');
	if ( mode || !checked )
        $('.mode0_proj').prop('disabled', true);
    else
        $('.mode0_proj').prop('disabled', false);
}

function enableLogs(mode)
{
    var checked = $('#UploadLogs').prop('checked');
	if ( mode || !checked )
        $('.mode0_log').prop('disabled', true);
    else
        $('.mode0_log').prop('disabled', false);
}
function enableRPC(mode)
{
    var checked = $('#EnableRPC').prop('checked');
	if (mode || !checked )
        $('.mode0_rpc').prop('disabled', true);
    else
        $('.mode0_rpc').prop('disabled', false);
}
<?php
echo "selectCurrentMode('$pull->selectMode');\n";
?>
//]]></script>
