<?php 

echo CHtml::tag("h2", array(), "Display Power Save") ."\n";
echo CHtml::errorSummary( $power )  ."\n";

    
echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();

$options = array( 'onclick'=>'enableMonPower()' );
echo CHtml::tag("tr", array(), CHtml::tag("td", array( 'colspan'=>4 ),"Toggle the power save features of screens connected via VGA or DVI"))."\n";

$options['id']='PowerSaveId';
print "<table>\n";
print "<tr><td>\n";
echo CHtml::activeCheckBox($power, "enablePowerSave", $options);
print "</td><td colspan='3'>";
echo CHtml::activeLabel($power, "enablePowerSave" );
echo "</td></tr>\n";

if ( !$power->enablePowerSave )
    $options['disabled']='disabled';
$options['id']='ControlMonPower';    

echo CHtml::tag("tr", array(), 	CHtml::tag("td") . 
								CHtml::tag("td", array( 'colspan'=>3 ),	"Use the option bellow to use basic power on / power off schedule. "
																	   ."For more complex schedule, use PowerOn and PowerOff commands in the SVG content."))."\n";

print "<tr><td/><td>\n";
echo CHtml::activeCheckBox($power, "fixedMonPower", $options);
print "</td><td colspan='2' >";
echo CHtml::activeLabel($power, "fixedMonPower");
print "</td></tr>\n";

if ( !$power->fixedMonPower )
    $options['disabled']='disabled';
    
unset($options['onclick']);

$options['id']='ControlMonPowerOn';    
print "<tr><td/><td/><td>";
echo CHtml::activeLabel($power, "onTime");
print "</td><td>";
echo CHtml::activeTextField($power, "onTime", $options);
print "</td></tr>\n";
$options['id']='ControlMonPowerOff';    
print "<tr><td/><td/><td>";
echo CHtml::activeLabel($power, "offTime");
print "</td><td>";
echo CHtml::activeTextField($power, "offTime", $options);
print "</td></tr>\n";



print "</table>\n";

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'power') );
echo CHtml::closeTag("div");

echo CHtml::endForm();
echo CHtml::closeTag("div");

echo CHtml::tag("h2", array(), "Device Power Save") ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();

echo CHtml::openTag("div", array( 'class'=>'simple') );
echo CHtml::activeLabel($screen, "power");
echo CHtml::activeDropDownList($screen, "power", $screen->power_mode_vga);
echo CHtml::closeTag("div");

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'vgapower') );
echo CHtml::closeTag("div");

echo CHtml::endForm();
echo CHtml::closeTag("div");
?>
<script type="text/javascript">//<![CDATA[

function enableMonPower()
{
	var iPowerSave=document.getElementById("PowerSaveId");
	var iControlMonPower=document.getElementById("ControlMonPower");
	
	iControlMonPower.disabled = !iPowerSave.checked;
	
	document.getElementById("ControlMonPowerOn").disabled=(!iPowerSave.checked || !iControlMonPower.checked);
	document.getElementById("ControlMonPowerOff").disabled=(!iPowerSave.checked || !iControlMonPower.checked);
}

//]]></script>
