<?php 

echo CHtml::tag("h2", array(), "Licenses Info") ."\n";

echo CHtml::errorSummary( $licenses )  ."\n";

echo CHtml::openTag("table");
foreach ( $licenses->loadLicenseInfo() as $lic=>$val ){
    $str = $licenses->convertLicenseToString( $lic, $val );
    echo CHtml::tag("tr", array(),  CHtml::tag("td", array(), CHtml::encode($str['name']) ).
                                    CHtml::tag("td", array(), CHtml::encode($str['type']) ).  
                                    CHtml::tag("td", array(), CHtml::encode($str['validity']) )
                    );    
}
echo CHtml::closeTag("table");

echo CHtml::tag("h2", array(), "Update Licenses") ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form("", "post", array('enctype'=>'multipart/form-data'));
    
if ( $licenses->onlineRegostrationEnabled() ) { 
    

    echo CHtml::openTag("div", array("class"=>"simple") );
    echo $licenses->getAttributeLabel("licenseKeyIntro");
    echo CHtml::closeTag("div");
    
    echo CHtml::openTag("div", array("class"=>"simple") );
    echo CHtml::activeLabel($licenses, 'licenseKey');
    echo CHtml::activeTextField($licenses, 'licenseKey', array('size'=>40) );
    echo CHtml::closeTag("div");
    
    echo CHtml::openTag("div", array( 'class'=>'action') );
    echo CHtml::submitButton("Add license key", array('name'=>'addKey') );
    echo CHtml::closeTag("div" );
    
    echo CHtml::openTag("div", array("class"=>"simple space") );
    echo $licenses->getAttributeLabel("restoreLicense")."<br/>\n";
    echo CHtml::closeTag("div");
    
    echo CHtml::openTag("div", array( 'class'=>'action') );
    echo CHtml::submitButton("Update licenses", array('name'=>'restoreLicenses') );
    echo CHtml::closeTag("div" );
    
    
}

echo CHtml::openTag("div", array("class"=>"space") );
echo $licenses->getAttributeLabel('licenseFileIntro')."<br/>\n";
echo CHtml::activeFileField($licenses, 'licenseFile', array('size'=>40) );
echo CHtml::closeTag("div");

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Upload license file", array('name'=>'addFile') );
echo CHtml::closeTag("div" );
    

if ( $licenses->hasSoftwareLicense() ) {
    echo CHtml::openTag("div", array("class"=>"simple space") );
    echo $licenses->getAttributeLabel("clearLicense") ."<br/>\n";
    echo CHtml::closeTag("div");
    
    echo CHtml::openTag("div", array( 'class'=>'action') );
    echo CHtml::submitButton("Clear licenses", array('name'=>'clearLicenses') );
    echo CHtml::closeTag("div" );
}


echo CHtml::endForm();
echo CHtml::closeTag("div" );

