<?php


$logs_str = $firmware->getLog( );
$nbUpdates = $firmware->getNbUpdates();
$running = $firmware->isUpdateRunning();

if ( !$running )
    echo "<!--- Stop refresh --->";
    
echo CHtml::tag("h2", array(), "Update log" . CHtml::link("[show]", "#", array('id'=>'hide_log', 'class'=>'right') ) );
echo CHtml::openTag("pre", array("class"=>"logs") );
foreach( $logs_str as $line ) {
    $p=0;
    do{
        echo CHtml::encode( substr( $line, $p, 75 ) ) . Chtml::tag("br");    
        $p += 75;
    } while ( strlen($line)>$p );
    
    
}
echo CHtml::closeTag("pre" );
echo CHtml::tag("br");

if ( $running ){

    if ( $firmware->mode=='check'){
        echo CHtml::tag("h2", array(), "Checking for updates") ."\n";
        echo CHtml::tag("div", array(), "This operation might take some time." );
    } else {
        echo CHtml::tag("h2", array(), "Updates in progress") ."\n";
        echo "This operation might take some time. <br/>\n";
        echo "The ".Yii::app()->user->branding->product." will restart automatically at the end of the update process. <br/>\n";
        echo "<strong>Do not un-plug the device during the update.</strong><br/>\n";
    }
    
     // show progress bar
    echo CHtml::tag("br");
    echo CHtml::image("images/loadingAnimation.gif", "Loading..." );
    echo CHtml::tag("br");
    echo CHtml::tag("br");
} else {
    if ( $firmware->mode=='check'){
        echo CHtml::tag("h2", array(), "Updates checked") ."\n";
    } else {
        echo CHtml::tag("h2", array(), "Updates finished") ."\n";
       
    }
}



if ( $firmware->mode=='check' ) {
    if ( $nbUpdates!==false ) {
        // we have some info about the firmware
        if ($nbUpdates==0){
            echo CHtml::tag("h3", array(), "No updates available");
            echo CHtml::openTag("div", array( 'class'=>'action') );
            echo CHtml::submitButton("OK", array('name'=>'cancel') ) ." ";
            echo CHtml::closeTag("div" );
        } else {
            echo CHtml::tag("h3", array(), CHtml::encode($nbUpdates) . " updates available");
            if ( $firmware->updater->update_info['type'] == 'FIRMWARE') {
                echo "Updating now would install firmware version ". CHtml::encode( $firmware->updater->update_info['ver'] ) .
                     " (build " . CHtml::encode( $firmware->updater->update_info['rel']) .  ")\n";
            } elseif ( $firmware->updater->update_info['type'] == 'UPDATER') {
                echo "Updating now would install updater version " .CHtml::encode( $firmware->updater->update_info['ver'] ) .
                     " (build " . CHtml::encode( $firmware->updater->update_info['rel']) .  "), which is required to perform other updates.\n";
            } else {
                echo "Update would only install some minor components.\n";
            }
            
            echo CHtml::openTag("div", array( 'class'=>'action') );
            echo CHtml::activeHiddenField($firmware, "updatesource");
            echo CHtml::activeHiddenField($firmware, "mode", array('value'=>"update") );
            
            if ( $firmware->updater->updater_status=="OK")
                echo CHtml::submitButton("Update Now", array('name'=>'update') ) ." ";
            else 
                echo CHtml::tag("h3", array(), "Check for update failed") . "<br/>";    
            echo CHtml::submitButton("Cancel", array('name'=>'cancel') ) ." ";
            echo CHtml::closeTag("div" );
        }
    } elseif ( !$running ) {
        echo CHtml::tag("h3", array(), "Update check failed");    
        echo "Please check the logs for more details.";
        echo CHtml::openTag("div", array( 'class'=>'action space') );
        echo CHtml::submitButton("Cancel", array('name'=>'cancel') ) ." ";
        echo CHtml::closeTag("div" );
    }
} else {
    // update
    if ( !$running ) {
        if ( $firmware->updater->updater_status=="OK") {
            
			if ( $firmware->updater->update_info['type'] == 'FIRMWARE') {
                echo "Installed firmware version ". CHtml::encode( $firmware->updater->update_info['ver'] ) .
                     " (build " . CHtml::encode( $firmware->updater->update_info['rel']) .  ")\n";
            } elseif ( $firmware->updater->update_info['type'] == 'UPDATER') {
                echo "Installed updater version " .CHtml::encode( $firmware->updater->update_info['ver'] ) .
                     " (build " . CHtml::encode( $firmware->updater->update_info['rel']) .  "), which is required to perform other updates.\n";
            } else {
                echo "Installed some minor components.\n";
            }
			echo CHtml::openTag("div", array( 'id'=>'WaitingForBoot') );
			echo "The ".Yii::app()->user->branding->product." will restart automatically. <br/>\n";
            echo "<strong>Do not un-plug the device.</strong><br/>\n";
			echo "<!--- Device reboot --->";
            echo CHtml::closeTag("div" );
			
			echo CHtml::openTag("div", array( 'id'=>'NextStep') );
			
            if ( $firmware->updater->updater_fallback ) {
                echo "<br/>\n";
                echo "Other updates are still awaiting installation, please check ".
                       "for updates again and perform an update if any are proposed ".
                       "in order to have an up to date firmware.\n";
				echo "<!--- More update --->";
                echo CHtml::openTag("div", array( 'class'=>'action') );
                echo CHtml::activeHiddenField($firmware, "updatesource");
                echo CHtml::activeHiddenField($firmware, "mode", array('value'=>"check") );
                echo CHtml::submitButton("Check for Update", array('name'=>'update') ) ." ";
                echo CHtml::submitButton("Cancel", array('name'=>'cancel') ) ." ";
                echo CHtml::closeTag("div" );
            } else {
                echo CHtml::openTag("div", array( 'class'=>'action') );
                echo CHtml::submitButton("OK", array('name'=>'cancel') ) ." ";
                echo CHtml::closeTag("div" );
            }
			echo CHtml::closeTag("div" );
        } else {
            echo CHtml::tag("h3", array(), "Update failed");    
            echo "Please check the update log for more details.<br/>\n";
             
            echo CHtml::openTag("div", array( 'class'=>'action space') );
            echo CHtml::submitButton("Cancel", array('name'=>'cancel') ) ." ";
            echo CHtml::closeTag("div" );
        }
    } 
}
