<?php 

Yii::app()->getClientScript()->registerCoreScript('jquery');

echo CHtml::tag("h2", array(), "USB Settings") ."\n";

echo CHtml::errorSummary( array( $usb, $config ) )  ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();

echo CHtml::openTag("div", array("class"=>"space") );
echo CHtml::activeCheckBox($usb, "extendedUSB");
echo CHtml::activeLabel($usb, "extendedUSB");
echo CHtml::closeTag("div" );

echo CHtml::openTag("div", array("class"=>"space")  );
echo CHtml::activeCheckBox($config, "usbIOAPI");
echo CHtml::activeLabel($config, "usbIOAPI");
echo CHtml::closeTag("div" );

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'usb') );
echo CHtml::closeTag("div" );

echo CHtml::endForm();
echo CHtml::closeTag("div" );

echo CHtml::tag("h2", array(), "Serial port settings") ."\n";
echo CHtml::errorSummary( $serial )  ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();
echo CHtml::openTag("table");

echo CHtml::openTag("tr");
echo CHtml::tag("td", array(), 
    CHtml::activeCheckBox($serial, "enableSerial", array( 'onclick'=>'enableSerial()', 'id'=>'EnableSerial') ) . " " .
    CHtml::activeLabel($serial, "enableSerial")
);
echo CHtml::closeTag("tr");

$options = array( 'class'=>'com_settings', 'style' => "width: 80px;");
echo CHtml::openTag("tr");
echo CHtml::tag("td", array( 'style' => "width: 227px;" ), CHtml::activeLabel($serial, "baudRate") );
echo CHtml::tag("td", array(), CHtml::activeDropDownList($serial, "baudRate", $serial->toList('baudRate'),$options) );
echo CHtml::closeTag("tr");

echo CHtml::openTag("tr");
echo CHtml::tag("td", array(), CHtml::activeLabel($serial, "byteSize") );
echo CHtml::tag("td", array(), CHtml::activeDropDownList($serial, "byteSize", $serial->toList('byteSize'),$options) );
echo CHtml::closeTag("tr");

echo CHtml::openTag("tr");
echo CHtml::tag("td", array(), CHtml::activeLabel($serial, "parity") );
echo CHtml::tag("td", array(), CHtml::activeDropDownList($serial, "parity", $serial->toList('parity'),$options) );
echo CHtml::closeTag("tr");

echo CHtml::openTag("tr");
echo CHtml::tag("td", array(), CHtml::activeLabel($serial, "stopBits") );
echo CHtml::tag("td", array(), CHtml::activeDropDownList($serial, "stopBits", $serial->toList('stopBits'),$options) );
echo CHtml::closeTag("tr");

echo CHtml::closeTag("table");

//echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'serial', 'class' => 'right button') );
//echo CHtml::closeTag("div");
echo CHtml::tag("div", array( 'class'=>'action'), " " );
echo CHtml::endForm();
echo CHtml::closeTag("div");


echo CHtml::tag("h2", array(), "I/O Automation") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();
if ( !isset($options) )
	$options = array();
echo CHtml::activeHiddenField($serial, "enablePowerSave", $options);

echo CHtml::openTag("table");
echo CHtml::openTag("tr");
echo CHtml::tag("td", array('colspan'=>2), CHtml::activeLabel($serial, "href")." : ");
echo CHtml::tag("td", array(), CHtml::activeDropDownList($serial, "href", $serial->getFileList(), array('onchange'=>'enableComPort()', 'id'=>'EnableComPort')));
echo CHtml::closeTag("tr");


$options = array( 'onclick'=>'enableMonPower()', 'id'=>'ControlMonPower', 'class'=>'com_port', 'uncheckValue'=>null );
echo CHtml::openTag("tr");
echo CHtml::tag("td", array(),  CHtml::activeHiddenField($serial, "fixedMonPower", array('value'=>0, 'class'=>'com_port') ). 
                                CHtml::activeCheckBox($serial, "fixedMonPower", $options) );
echo CHtml::tag("td", array(), CHtml::activeLabel($serial, "fixedMonPower") );
echo CHtml::closeTag("tr");

$options = array( 'class'=>'mon_power', 'size'=>6);
echo CHtml::openTag("tr");
echo CHtml::tag("td");
echo CHtml::tag("td", array(), CHtml::activeLabel($serial, "onTime") );
echo CHtml::tag("td", array(), CHtml::activeTextField($serial, "onTime", $options) );
echo CHtml::closeTag("tr");
echo CHtml::openTag("tr");
echo CHtml::tag("td");
echo CHtml::tag("td", array(), CHtml::activeLabel($serial, "offTime") );
echo CHtml::tag("td", array(), CHtml::activeTextField($serial, "offTime", $options) );
echo CHtml::closeTag("tr");





echo CHtml::closeTag("table");

//echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'serial', 'class' => 'right button') );
//echo CHtml::closeTag("div");
echo CHtml::tag("div", array( 'class'=>'action'), " " );
echo CHtml::endForm();
echo CHtml::closeTag("div");

echo CHtml::tag("h2", array(), "Upload Protocol File") ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") ). "\n" ;
echo CHtml::form("", "post", array('enctype'=>'multipart/form-data')). "\n" ;

echo CHtml::tag("div", array( 'class'=>'simple'), CHtml::activeFileField($serial, "uploadedfile", array('size'=>50) ) .
												  CHtml::submitButton("Upload", array('name'=>'upload', 'class' => 'right button' ) )). "\n" ;


echo CHtml::endForm(). "\n"  . CHtml::closeTag("div") ;

$list =  $serial->getFileList( false );
if ( count($list)>0 ) {
	echo CHtml::tag("h2", array(), "Manage Protocol File") ."\n";

	echo CHtml::openTag("div", array("class"=>"yiiForm") ). "\n" ;
	echo CHtml::form("", "post", array('enctype'=>'multipart/form-data')). "\n" ;

	echo CHtml::tag("div", array( 'class'=>'simple'), CHtml::activeLabel($serial, "target") . 
													  CHtml::activeDropDownList($serial, "target", $list, array( 'style' => "width: 158px;" ) )  . 
													  CHtml::submitButton("View", array('name'=>'view', 'class'=>" button") ) . 
													  CHtml::submitButton("Delete", array('name'=>'delete', 'class'=>"right button") )
												);

	echo CHtml::endForm(). "\n"  . CHtml::closeTag("div") ;
}

?>
<script type="text/javascript">//<![CDATA[
function enableSerial()
{
	var iEnableSerial = document.getElementById("EnableSerial");
    if ( !iEnableSerial.checked )
        $('.com_settings').attr( "disabled", "disabled" );
    else
        $('.com_settings').removeAttr( "disabled" );    
};
enableSerial();

function enableComPort()
{
	var iEnableComPort=document.getElementById("EnableComPort");
    if ( iEnableComPort.selectedIndex===0 )
        $('.com_port').attr( "disabled", "disabled" );
    else
        $('.com_port').removeAttr( "disabled" );
    if ( iEnableComPort.selectedIndex===0 ) {
        $('.mon_power').attr("disabled","disabled"); 
        document.getElementById("ControlMonPower").checked = false;
    }else {
        enableMonPower();
    }
};
function enableMonPower()
{
	var iControlMonPower=document.getElementById("ControlMonPower");
    if ( !iControlMonPower.checked )
        $('.mon_power').attr("disabled","disabled");
    else
        $('.mon_power').removeAttr("disabled");
};

enableComPort();

//]]></script>
