<?php 

echo CHtml::errorSummary( $maintenance )  ."\n";

echo CHtml::tag("h2", array(), "System Restart") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form();
echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Restart Now", array('name'=>'reboot') ) );
echo CHtml::endForm() . CHtml::closeTag("div" );

echo CHtml::tag("h2", array(), "System Shutdown") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") );
if ( Yii::app()->user->info->model=='Sakura' ){
    $txt = "pressing the push button or physically disconnecting and reconnecting the device from electrical power.";	
} else {
    $txt = "physically disconnecting and reconnecting the device from electrical power.";
}
echo CHtml::tag("div", array("class"=>"simple space"),  "Warning: after shutdown the device can only be restarted by ".$txt );
echo CHtml::tag("div", array( 'class'=>'action'), CHtml::button("Shutdown Now", array('name'=>'shutdown', 'id'=>'shutdown') ) );

$this->widget('HelpBox', array('helpTitle'=>"Warning", 
                                                'helpContent'=>"After shutdown the device can only be restarted by ".$txt."<br/><br/>".
                                                                "Are you sure you want to shutdown?",
                                                'theme'=>'cupertino',
                                                'icon' => false,
                                                'clickTarget' => 'shutdown',
                                                'options' => array('width'=>400,
                                                                   'modal'=> true,
                                                                   'height' => 260,
                                                                ),
                                                'callbacks' => array(
                                                                   'buttons' => "{ Yes: function() { window.open('".CHtml::normalizeUrl(array('admin/maintenance', 'shutdown'=>true ))."','_self'); }, No: function() { $( this ).dialog( 'close' ); } }"
                                                                )
                                    )
                    );
					
echo CHtml::closeTag("div" );

echo CHtml::tag("h2", array(), "Restore Default Content") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form();
echo CHtml::tag("div", array("class"=>"simple space"),  "Pressing 'Restore Default Content' will remove all content from the local storage and replace it by the factory default content.");
$option = array('name'=>'resetcontent');
if ( $fusion->active ) {
	echo CHtml::tag("div", array("class"=>"simple space"),  "Warning: restoring the default content will also disable Fusion.");
}
echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Restore Default Content", $option ) );
echo CHtml::endForm() . CHtml::closeTag("div" );

echo CHtml::tag("h2", array(), "Reset to Factory Default") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form();
echo CHtml::tag("div", array("class"=>"simple space"),  "Pressing 'Reset to Factory Default' will restore all the settings of the ".Yii::app()->user->branding->product." to their initial factory values.");
echo CHtml::tag("div", array("class"=>"simple space"),  "It will also remove all content from the local storage and replace it by the factory default content.");
echo CHtml::tag("div", array( 'class'=>'action'),   CHtml::submitButton("Reset to Factory Default", array('name'=>'reset_factory') ) ." " );
echo CHtml::endForm() . CHtml::closeTag("div" );


echo CHtml::tag("h2", array(), "Reporting") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form( array("admin/report") );
echo CHtml::tag("div", array("class"=>"simple space"),  "Before contacting ".Yii::app()->user->branding->vendor." support team ".
                                                        "(<a href='mailto://".Yii::app()->user->branding->email."'>".Yii::app()->user->branding->email."</a>), ".
                                                        "please generate a status report with all display attached to the ".Yii::app()->user->branding->product.".\n");
echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Get Report", array('name'=>'report') ) );
echo CHtml::endForm() . CHtml::closeTag("div" );

