<?php 

echo CHtml::tag("h2", array(), "Network Settings") ."\n";

echo CHtml::errorSummary( $network )  ."\n";
echo CHtml::errorSummary( $modem )  ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();

echo "<table id='IfaceTable'>\n";

echo "<tr><td>";
echo CHtml::activeLabel($network, "netiface");
echo "</td><td>\n";
echo CHtml::activeDropDownList($network, "netiface", $network->netifaceSelect, array('onchange'=>'changeIface()', 'id'=>'IfaceSelect') );
print("</td></tr>\n");

echo "</table>\n";


if ( $network->netiface==IPConfig::NET_ETHERNET)
    $options = array( 'id'=>'IpTable' );
else 
    $options = array( 'id'=>'IpTable', 'style'=>'display: none;' );

echo CHtml::openTag('div',  $options);
echo CHtml::openTag('table');

echo "<tr><td>" . "DHCP" . "</td><td>";
echo CHtml::activeRadioButton($network, "dhcp", array( 'value'=>1, 'uncheckValue'=>null, 'onclick'=>'useDHCP(true)' ) );
echo "</td></tr>\n";

echo "<tr><td>" . "Static" . "</td><td>";
echo CHtml::activeRadioButton($network, "dhcp", array( 'value'=>0, 'uncheckValue'=>null, 'onclick'=>'useDHCP(false)' ) );
echo "</td></tr>\n";

$options = array( 'size'=>30, 'class'=>'fixed_ip');
if ($network->dhcp) 
    $options['disabled']='disabled';

echo "<tr><td/><td>";
echo CHtml::activeLabel($network, "address");
echo "</td><td>";
echo CHtml::activeTextField($network, "address", $options );
echo " e.g., 192.168.1.10</td></tr>\n";

echo "<tr><td/><td>";
echo CHtml::activeLabel($network, "netmask");
echo "</td><td>";
echo CHtml::activeTextField($network, "netmask", $options );
echo " e.g., 255.255.255.0</td></tr>\n";
 
echo "<tr><td/><td>";
echo CHtml::activeLabel($network, "gateway");
echo "</td><td>";
echo CHtml::activeTextField($network, "gateway", $options );
echo " e.g., 192.168.1.1</td></tr>\n";

print ("<tr><td/><td>DNS:</td></tr>\n");

echo "<tr><td/><td>";
echo CHtml::activeLabel($network, "nameserver1");
echo "</td><td>";
echo CHtml::activeTextField($network, "nameserver1", $options );
echo " e.g., 192.168.1.1</td></tr>\n";

echo "<tr><td/><td>";
echo CHtml::activeLabel($network, "nameserver2");
echo "</td><td>";
echo CHtml::activeTextField($network, "nameserver2", $options );
echo "</td></tr>\n";

echo "<tr><td/><td>";
echo CHtml::activeLabel($network, "nameserver3");
echo "</td><td>";
echo CHtml::activeTextField($network, "nameserver3", $options );
echo "</td></tr>\n";

echo "<tr><td/><td>";
echo CHtml::activeLabel($network, "domain");
echo "</td><td>";
echo CHtml::activeTextField($network, "domain", $options );
echo "</td></tr>\n";

echo CHtml::closeTag('table');

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'network') );
echo CHtml::closeTag("div")."\n";

echo CHtml::closeTag('div')."\n";

// 3G
if ( $network->netiface==IPConfig::NET_MODEM)
    $options = array('id'=>'ModemTable');
else 
    $options = array( 'style'=>'display: none;', 'id'=>'ModemTable' );
    
echo CHtml::openTag('div',  $options);
echo CHtml::openTag('table' );

if ( $modem->isPINBlocked() ) {
    print("<tr><td colspan='2'>\n");
    echo "<b>Warning</b>: the modem's SIM card is locked because it was initialized with an incorrect PIN too many times. ";
    echo "The PIN needs to be reset using the PUK: type in the new PIN along with the PUK in the form below and click apply. ";
    echo "Type the PUK carefully as entering an incorrect PUK too many times in a row will permanently lock the SIM card. ";
    echo "The PUK is not saved, only the new PIN.\n";
    print("</td></tr>");
}

$modem->updateStatus();
echo "<tr valign='baseline'><td>";
echo CHtml::activeLabel($modem, "statusstring");
echo "</td><td>";
echo $modem->statusstring;
echo "</td></tr>\n";


echo "<tr valign='baseline'><td>";
echo CHtml::activeLabel($modem, "simple");

echo "</td>\n<td>";
echo CHtml::activeRadioButton($modem, "simple", array( 'value'=>'1', 'uncheckValue'=>null, 'onclick'=>'configSimple(true)' ) ) . "Simple\n";
echo CHtml::activeRadioButton($modem, "simple", array( 'value'=>'0', 'uncheckValue'=>null, 'onclick'=>'configSimple(false)' ) ) . "Advanced\n";
echo "</td><tr/>";

foreach ($modem->getFormNames() as $fname) {
    if ( ! $modem->isFieldActive($fname) )
        continue;
    $options = array( 'valign'=>'baseline');
    
    if ( $modem->isSimpleOnly($fname) ) 
        $options['class'] = "cfgsimple";
    
    if ( $modem->isAdvancedOnly($fname) ) 
        $options['class'] =" cfgadvanced";
    
    echo CHtml::openTag("tr", $options );
    
	print("<td>" . ucfirst($modem->getFieldDesc($fname)) . ":</td>");
    print("<td>");
    
    $fval = $modem->getField($fname);
    if ($modem->isChoiceField($fname)) {
        echo CHtml::dropDownList( CHtml::activeName($modem, $fname), $fval, $modem->getFieldChoices($fname) );
    } else {
        //echo CHtml::ActivetextField( $modem, $fname, array( 'size'=>'45', 'value'=>htmlspecialchars($fval) ) );
        echo CHtml::ActivetextField( $modem, $fname, array( 'size'=>'45', 'value'=>$fval ) );
        $fhelp = $modem->getFieldHelp($fname);
        if (isset($fhelp)) {
            print("<br/>\n");
            print($fhelp);
        }
    }
    print("</td></tr>\n");
    
}

print("<tr><td colspan='2'>\n");
print("The PIN number, if required, is passed to the modem when it is plugged or the HMP reboots. Note that an incorrect PIN will lock the modem, so check it is typed correctly.\n");
print("</td></tr>");
print("<tr><td colspan='2' class='cfgadvanced'>\n");
print("The init strings are used to initialize the modem and enter the data communication parameters.\n");
print("To use a specific APN instead of the subscriber's default enter '&nbsp;AT +CGDCONT=<i>&lt;cid&gt;</i>,\"IP\",\"<i>&lt;apn&gt;</i>\"&nbsp;' as an init string, ");
print("where <i>&lt;cid&gt;</i> is the context ID (usually 1) and <i>&lt;apn&gt;</i> is the desired APN, and enter '&nbsp;*99**1*<i>&lt;cid&gt;</i>#&nbsp;' as the dial string.<br/>\n");
print("</td></tr>\n<tr>");
print("<tr><td colspan='2' class='cfgadvanced'>\n");
print("Contact your telecommunications operator for more details.\n");
print("</td></tr>\n");

echo CHtml::closeTag('table')."\n";

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'modem3g') );
echo CHtml::closeTag("div")."\n";

echo CHtml::closeTag('div')."\n";

echo CHtml::endForm();
echo CHtml::closeTag("div")."\n";

?>
<script type="text/javascript">//<![CDATA[

function useDHCP(enabled)
{
    if ( enabled )
        $('.fixed_ip').attr( "disabled", "disabled" );
    else
        $('.fixed_ip').removeAttr( "disabled" );
}
function useIface(iface)
{
	var display_ip;
	var display_modem;
	if (iface == <?php echo '"' . ipconfig::NET_ETHERNET . '"' ?>) {
		display_ip = "";
		display_modem = "none";
	} else {
		display_ip = "none";
		display_modem = "";
	}
	document.getElementById("IpTable").style.display = display_ip;
	document.getElementById("ModemTable").style.display = display_modem;
}
function changeIface()
{
    var selector = document.getElementById("IfaceSelect");
    useIface(selector.options[selector.selectedIndex].value);
}
function configSimple( enabled )
{
	
    $('.cfgsimple').css("display",enabled?"":"none");
    $('.cfgadvanced').css("display",enabled?"none":"");
    
}
<?php
    if ( $modem->simple )
        echo "configSimple(true);\n";
    else
        echo "configSimple(false);\n";
?>

//]]></script>