<?php 
echo CHtml::tag("h2", array(), "NTP Statistics") ."\n";




echo "<table cellpadding='3'>\n";
echo "<tr>";
echo    "<th align='left'>Server IP</th>\n" .
        "<th align='right'>Stratum</th>\n" .
        "<th align='right'>Status</th>\n" .
        "<th align='right'>Reach</th>\n" .
        "<th align='right'>Time offset</th>\n" .
        "<th align='right'>Delay</th>\n" .
        "<th align='right'>Dispersion</th>\n" .
        "<th align='right'>Poll interval</th>\n";
echo "</tr>";

foreach ( $ntp->stats as $server ){
    echo "<tr>\n";
    echo CHtml::tag("td", array( 'align'=>'left' ), $server['server_ip'] );
    echo CHtml::tag("td", array( 'align'=>'right' ), $server['stratum'] );
    echo CHtml::tag("td", array( 'align'=>'right' ), $server['status'] );
    echo CHtml::tag("td", array( 'align'=>'right' ), $server['reach']. " %" );
    echo CHtml::tag("td", array( 'align'=>'right' ), $server['offset'] );
    echo CHtml::tag("td", array( 'align'=>'right' ), $server['delay'] );
    echo CHtml::tag("td", array( 'align'=>'right' ), $server['dispersion'] );
    echo CHtml::tag("td", array( 'align'=>'right' ), $server['poll']." s" );
    echo "</tr>\n";
}
echo "</table>\n";

echo $ntp->message;


if ($nr_servers >= 0 && $nr_servers < $ntp->nr_servers) {
    if ($nr_servers == 0) {
        echo CHtml::openTag('div', array('class'=>'space') ) . "Note: the table shows no servers,\n";
    } else {
        echo CHtml::openTag('div', array('class'=>'space') ) . "Note: the table shows fewer servers than what are configured,\n";
    }
    echo "probably due to network name(s) which cannot be resolved to IP addresses. " .
		  "The cause can be a mistyped server name, a retired server name or an " .
		  "unreachable DNS server. Please check your NTP and network configuration. " .
		  "If the failure is transient the system will recover in a few hours ".
		  "without the need for any user intervention.";
    echo CHtml::closeTag("div");
}

echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Refresh", array('name'=>'refresh') );
echo CHtml::closeTag("div");


echo CHtml::endForm();
echo CHtml::closeTag("div");